/*===---- arm_sve.h - ARM SVE intrinsics -----------------------------------===
 *
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __ARM_SVE_H
#define __ARM_SVE_H

#if !defined(__LITTLE_ENDIAN__)
#error "Big endian is currently not supported for arm_sve.h"
#endif
#include <stdint.h>

#ifdef  __cplusplus
extern "C" {
#else
#include <stdbool.h>
#endif

typedef __fp16 float16_t;
typedef float float32_t;
typedef double float64_t;
typedef __SVInt8_t svint8_t;
typedef __SVInt16_t svint16_t;
typedef __SVInt32_t svint32_t;
typedef __SVInt64_t svint64_t;
typedef __SVUint8_t svuint8_t;
typedef __SVUint16_t svuint16_t;
typedef __SVUint32_t svuint32_t;
typedef __SVUint64_t svuint64_t;
typedef __SVFloat16_t svfloat16_t;

typedef __SVBfloat16_t svbfloat16_t;
#include <arm_bf16.h>
#include <arm_vector_types.h>
typedef __SVMfloat8_t svmfloat8_t;

typedef __SVFloat32_t svfloat32_t;
typedef __SVFloat64_t svfloat64_t;
typedef __clang_svint8x2_t svint8x2_t;
typedef __clang_svint16x2_t svint16x2_t;
typedef __clang_svint32x2_t svint32x2_t;
typedef __clang_svint64x2_t svint64x2_t;
typedef __clang_svuint8x2_t svuint8x2_t;
typedef __clang_svuint16x2_t svuint16x2_t;
typedef __clang_svuint32x2_t svuint32x2_t;
typedef __clang_svuint64x2_t svuint64x2_t;
typedef __clang_svfloat16x2_t svfloat16x2_t;
typedef __clang_svfloat32x2_t svfloat32x2_t;
typedef __clang_svfloat64x2_t svfloat64x2_t;
typedef __clang_svint8x3_t svint8x3_t;
typedef __clang_svint16x3_t svint16x3_t;
typedef __clang_svint32x3_t svint32x3_t;
typedef __clang_svint64x3_t svint64x3_t;
typedef __clang_svuint8x3_t svuint8x3_t;
typedef __clang_svuint16x3_t svuint16x3_t;
typedef __clang_svuint32x3_t svuint32x3_t;
typedef __clang_svuint64x3_t svuint64x3_t;
typedef __clang_svfloat16x3_t svfloat16x3_t;
typedef __clang_svfloat32x3_t svfloat32x3_t;
typedef __clang_svfloat64x3_t svfloat64x3_t;
typedef __clang_svint8x4_t svint8x4_t;
typedef __clang_svint16x4_t svint16x4_t;
typedef __clang_svint32x4_t svint32x4_t;
typedef __clang_svint64x4_t svint64x4_t;
typedef __clang_svuint8x4_t svuint8x4_t;
typedef __clang_svuint16x4_t svuint16x4_t;
typedef __clang_svuint32x4_t svuint32x4_t;
typedef __clang_svuint64x4_t svuint64x4_t;
typedef __clang_svfloat16x4_t svfloat16x4_t;
typedef __clang_svfloat32x4_t svfloat32x4_t;
typedef __clang_svfloat64x4_t svfloat64x4_t;
typedef __SVBool_t  svbool_t;
typedef __clang_svboolx2_t  svboolx2_t;
typedef __clang_svboolx4_t  svboolx4_t;

typedef __clang_svbfloat16x2_t svbfloat16x2_t;
typedef __clang_svbfloat16x3_t svbfloat16x3_t;
typedef __clang_svbfloat16x4_t svbfloat16x4_t;
typedef __clang_svmfloat8x2_t svmfloat8x2_t;
typedef __clang_svmfloat8x3_t svmfloat8x3_t;
typedef __clang_svmfloat8x4_t svmfloat8x4_t;
typedef __SVCount_t svcount_t;

enum svpattern
{
  SV_POW2 = 0,
  SV_VL1 = 1,
  SV_VL2 = 2,
  SV_VL3 = 3,
  SV_VL4 = 4,
  SV_VL5 = 5,
  SV_VL6 = 6,
  SV_VL7 = 7,
  SV_VL8 = 8,
  SV_VL16 = 9,
  SV_VL32 = 10,
  SV_VL64 = 11,
  SV_VL128 = 12,
  SV_VL256 = 13,
  SV_MUL4 = 29,
  SV_MUL3 = 30,
  SV_ALL = 31
};

enum svprfop
{
  SV_PLDL1KEEP = 0,
  SV_PLDL1STRM = 1,
  SV_PLDL2KEEP = 2,
  SV_PLDL2STRM = 3,
  SV_PLDL3KEEP = 4,
  SV_PLDL3STRM = 5,
  SV_PSTL1KEEP = 8,
  SV_PSTL1STRM = 9,
  SV_PSTL2KEEP = 10,
  SV_PSTL2STRM = 11,
  SV_PSTL3KEEP = 12,
  SV_PSTL3STRM = 13
};

/* Function attributes */
#define __ai static __inline__ __attribute__((__always_inline__, __nodebug__))

#define __aio static __inline__ __attribute__((__always_inline__, __nodebug__, __overloadable__))

__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8)))
svint8_t svreinterpret_s8_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8)))
svint8_t svreinterpret_s8_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8)))
svint8_t svreinterpret_s8_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16)))
svint8_t svreinterpret_s8_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16)))
svint8_t svreinterpret_s8_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32)))
svint8_t svreinterpret_s8_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32)))
svint8_t svreinterpret_s8_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64)))
svint8_t svreinterpret_s8_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64)))
svint8_t svreinterpret_s8_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16)))
svint8_t svreinterpret_s8_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16)))
svint8_t svreinterpret_s8_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32)))
svint8_t svreinterpret_s8_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64)))
svint8_t svreinterpret_s8_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8)))
svuint8_t svreinterpret_u8_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8)))
svuint8_t svreinterpret_u8_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8)))
svuint8_t svreinterpret_u8_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16)))
svuint8_t svreinterpret_u8_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16)))
svuint8_t svreinterpret_u8_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32)))
svuint8_t svreinterpret_u8_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32)))
svuint8_t svreinterpret_u8_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64)))
svuint8_t svreinterpret_u8_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64)))
svuint8_t svreinterpret_u8_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16)))
svuint8_t svreinterpret_u8_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16)))
svuint8_t svreinterpret_u8_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32)))
svuint8_t svreinterpret_u8_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64)))
svuint8_t svreinterpret_u8_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8)))
svmfloat8_t svreinterpret_mf8_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8)))
svmfloat8_t svreinterpret_mf8_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8)))
svmfloat8_t svreinterpret_mf8_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16)))
svmfloat8_t svreinterpret_mf8_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16)))
svmfloat8_t svreinterpret_mf8_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32)))
svmfloat8_t svreinterpret_mf8_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32)))
svmfloat8_t svreinterpret_mf8_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64)))
svmfloat8_t svreinterpret_mf8_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64)))
svmfloat8_t svreinterpret_mf8_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16)))
svmfloat8_t svreinterpret_mf8_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16)))
svmfloat8_t svreinterpret_mf8_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32)))
svmfloat8_t svreinterpret_mf8_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64)))
svmfloat8_t svreinterpret_mf8_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8)))
svint16_t svreinterpret_s16_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8)))
svint16_t svreinterpret_s16_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8)))
svint16_t svreinterpret_s16_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16)))
svint16_t svreinterpret_s16_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16)))
svint16_t svreinterpret_s16_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32)))
svint16_t svreinterpret_s16_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32)))
svint16_t svreinterpret_s16_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64)))
svint16_t svreinterpret_s16_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64)))
svint16_t svreinterpret_s16_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16)))
svint16_t svreinterpret_s16_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16)))
svint16_t svreinterpret_s16_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32)))
svint16_t svreinterpret_s16_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64)))
svint16_t svreinterpret_s16_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8)))
svuint16_t svreinterpret_u16_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8)))
svuint16_t svreinterpret_u16_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8)))
svuint16_t svreinterpret_u16_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16)))
svuint16_t svreinterpret_u16_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16)))
svuint16_t svreinterpret_u16_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32)))
svuint16_t svreinterpret_u16_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32)))
svuint16_t svreinterpret_u16_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64)))
svuint16_t svreinterpret_u16_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64)))
svuint16_t svreinterpret_u16_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16)))
svuint16_t svreinterpret_u16_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16)))
svuint16_t svreinterpret_u16_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32)))
svuint16_t svreinterpret_u16_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64)))
svuint16_t svreinterpret_u16_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8)))
svint32_t svreinterpret_s32_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8)))
svint32_t svreinterpret_s32_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8)))
svint32_t svreinterpret_s32_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16)))
svint32_t svreinterpret_s32_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16)))
svint32_t svreinterpret_s32_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32)))
svint32_t svreinterpret_s32_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32)))
svint32_t svreinterpret_s32_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64)))
svint32_t svreinterpret_s32_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64)))
svint32_t svreinterpret_s32_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16)))
svint32_t svreinterpret_s32_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16)))
svint32_t svreinterpret_s32_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32)))
svint32_t svreinterpret_s32_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64)))
svint32_t svreinterpret_s32_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8)))
svuint32_t svreinterpret_u32_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8)))
svuint32_t svreinterpret_u32_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8)))
svuint32_t svreinterpret_u32_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16)))
svuint32_t svreinterpret_u32_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16)))
svuint32_t svreinterpret_u32_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32)))
svuint32_t svreinterpret_u32_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32)))
svuint32_t svreinterpret_u32_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64)))
svuint32_t svreinterpret_u32_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64)))
svuint32_t svreinterpret_u32_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16)))
svuint32_t svreinterpret_u32_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16)))
svuint32_t svreinterpret_u32_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32)))
svuint32_t svreinterpret_u32_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64)))
svuint32_t svreinterpret_u32_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8)))
svint64_t svreinterpret_s64_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8)))
svint64_t svreinterpret_s64_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8)))
svint64_t svreinterpret_s64_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16)))
svint64_t svreinterpret_s64_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16)))
svint64_t svreinterpret_s64_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32)))
svint64_t svreinterpret_s64_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32)))
svint64_t svreinterpret_s64_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64)))
svint64_t svreinterpret_s64_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64)))
svint64_t svreinterpret_s64_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16)))
svint64_t svreinterpret_s64_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16)))
svint64_t svreinterpret_s64_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32)))
svint64_t svreinterpret_s64_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64)))
svint64_t svreinterpret_s64_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8)))
svuint64_t svreinterpret_u64_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8)))
svuint64_t svreinterpret_u64_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8)))
svuint64_t svreinterpret_u64_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16)))
svuint64_t svreinterpret_u64_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16)))
svuint64_t svreinterpret_u64_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32)))
svuint64_t svreinterpret_u64_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32)))
svuint64_t svreinterpret_u64_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64)))
svuint64_t svreinterpret_u64_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64)))
svuint64_t svreinterpret_u64_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16)))
svuint64_t svreinterpret_u64_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16)))
svuint64_t svreinterpret_u64_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32)))
svuint64_t svreinterpret_u64_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64)))
svuint64_t svreinterpret_u64_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8)))
svfloat16_t svreinterpret_f16_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8)))
svfloat16_t svreinterpret_f16_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8)))
svfloat16_t svreinterpret_f16_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16)))
svfloat16_t svreinterpret_f16_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16)))
svfloat16_t svreinterpret_f16_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32)))
svfloat16_t svreinterpret_f16_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32)))
svfloat16_t svreinterpret_f16_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64)))
svfloat16_t svreinterpret_f16_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64)))
svfloat16_t svreinterpret_f16_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16)))
svfloat16_t svreinterpret_f16_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16)))
svfloat16_t svreinterpret_f16_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32)))
svfloat16_t svreinterpret_f16_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64)))
svfloat16_t svreinterpret_f16_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8)))
svbfloat16_t svreinterpret_bf16_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8)))
svbfloat16_t svreinterpret_bf16_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8)))
svbfloat16_t svreinterpret_bf16_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16)))
svbfloat16_t svreinterpret_bf16_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16)))
svbfloat16_t svreinterpret_bf16_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32)))
svbfloat16_t svreinterpret_bf16_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32)))
svbfloat16_t svreinterpret_bf16_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64)))
svbfloat16_t svreinterpret_bf16_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64)))
svbfloat16_t svreinterpret_bf16_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16)))
svbfloat16_t svreinterpret_bf16_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16)))
svbfloat16_t svreinterpret_bf16_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32)))
svbfloat16_t svreinterpret_bf16_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64)))
svbfloat16_t svreinterpret_bf16_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8)))
svfloat32_t svreinterpret_f32_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8)))
svfloat32_t svreinterpret_f32_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8)))
svfloat32_t svreinterpret_f32_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16)))
svfloat32_t svreinterpret_f32_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16)))
svfloat32_t svreinterpret_f32_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32)))
svfloat32_t svreinterpret_f32_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32)))
svfloat32_t svreinterpret_f32_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64)))
svfloat32_t svreinterpret_f32_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64)))
svfloat32_t svreinterpret_f32_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16)))
svfloat32_t svreinterpret_f32_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16)))
svfloat32_t svreinterpret_f32_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32)))
svfloat32_t svreinterpret_f32_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64)))
svfloat32_t svreinterpret_f32_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8)))
svfloat64_t svreinterpret_f64_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8)))
svfloat64_t svreinterpret_f64_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8)))
svfloat64_t svreinterpret_f64_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16)))
svfloat64_t svreinterpret_f64_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16)))
svfloat64_t svreinterpret_f64_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32)))
svfloat64_t svreinterpret_f64_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32)))
svfloat64_t svreinterpret_f64_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64)))
svfloat64_t svreinterpret_f64_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64)))
svfloat64_t svreinterpret_f64_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16)))
svfloat64_t svreinterpret_f64_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16)))
svfloat64_t svreinterpret_f64_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32)))
svfloat64_t svreinterpret_f64_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64)))
svfloat64_t svreinterpret_f64_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8)))
svint8_t svreinterpret_s8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8)))
svint8_t svreinterpret_s8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8)))
svint8_t svreinterpret_s8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16)))
svint8_t svreinterpret_s8(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16)))
svint8_t svreinterpret_s8(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32)))
svint8_t svreinterpret_s8(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32)))
svint8_t svreinterpret_s8(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64)))
svint8_t svreinterpret_s8(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64)))
svint8_t svreinterpret_s8(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16)))
svint8_t svreinterpret_s8(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16)))
svint8_t svreinterpret_s8(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32)))
svint8_t svreinterpret_s8(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64)))
svint8_t svreinterpret_s8(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8)))
svuint8_t svreinterpret_u8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8)))
svuint8_t svreinterpret_u8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8)))
svuint8_t svreinterpret_u8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16)))
svuint8_t svreinterpret_u8(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16)))
svuint8_t svreinterpret_u8(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32)))
svuint8_t svreinterpret_u8(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32)))
svuint8_t svreinterpret_u8(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64)))
svuint8_t svreinterpret_u8(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64)))
svuint8_t svreinterpret_u8(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16)))
svuint8_t svreinterpret_u8(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16)))
svuint8_t svreinterpret_u8(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32)))
svuint8_t svreinterpret_u8(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64)))
svuint8_t svreinterpret_u8(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8)))
svmfloat8_t svreinterpret_mf8(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8)))
svmfloat8_t svreinterpret_mf8(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8)))
svmfloat8_t svreinterpret_mf8(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16)))
svmfloat8_t svreinterpret_mf8(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16)))
svmfloat8_t svreinterpret_mf8(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32)))
svmfloat8_t svreinterpret_mf8(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32)))
svmfloat8_t svreinterpret_mf8(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64)))
svmfloat8_t svreinterpret_mf8(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64)))
svmfloat8_t svreinterpret_mf8(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16)))
svmfloat8_t svreinterpret_mf8(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16)))
svmfloat8_t svreinterpret_mf8(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32)))
svmfloat8_t svreinterpret_mf8(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64)))
svmfloat8_t svreinterpret_mf8(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8)))
svint16_t svreinterpret_s16(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8)))
svint16_t svreinterpret_s16(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8)))
svint16_t svreinterpret_s16(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16)))
svint16_t svreinterpret_s16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16)))
svint16_t svreinterpret_s16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32)))
svint16_t svreinterpret_s16(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32)))
svint16_t svreinterpret_s16(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64)))
svint16_t svreinterpret_s16(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64)))
svint16_t svreinterpret_s16(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16)))
svint16_t svreinterpret_s16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16)))
svint16_t svreinterpret_s16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32)))
svint16_t svreinterpret_s16(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64)))
svint16_t svreinterpret_s16(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8)))
svuint16_t svreinterpret_u16(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8)))
svuint16_t svreinterpret_u16(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8)))
svuint16_t svreinterpret_u16(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16)))
svuint16_t svreinterpret_u16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16)))
svuint16_t svreinterpret_u16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32)))
svuint16_t svreinterpret_u16(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32)))
svuint16_t svreinterpret_u16(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64)))
svuint16_t svreinterpret_u16(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64)))
svuint16_t svreinterpret_u16(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16)))
svuint16_t svreinterpret_u16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16)))
svuint16_t svreinterpret_u16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32)))
svuint16_t svreinterpret_u16(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64)))
svuint16_t svreinterpret_u16(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8)))
svint32_t svreinterpret_s32(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8)))
svint32_t svreinterpret_s32(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8)))
svint32_t svreinterpret_s32(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16)))
svint32_t svreinterpret_s32(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16)))
svint32_t svreinterpret_s32(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32)))
svint32_t svreinterpret_s32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32)))
svint32_t svreinterpret_s32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64)))
svint32_t svreinterpret_s32(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64)))
svint32_t svreinterpret_s32(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16)))
svint32_t svreinterpret_s32(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16)))
svint32_t svreinterpret_s32(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32)))
svint32_t svreinterpret_s32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64)))
svint32_t svreinterpret_s32(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8)))
svuint32_t svreinterpret_u32(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8)))
svuint32_t svreinterpret_u32(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8)))
svuint32_t svreinterpret_u32(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16)))
svuint32_t svreinterpret_u32(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16)))
svuint32_t svreinterpret_u32(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32)))
svuint32_t svreinterpret_u32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32)))
svuint32_t svreinterpret_u32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64)))
svuint32_t svreinterpret_u32(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64)))
svuint32_t svreinterpret_u32(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16)))
svuint32_t svreinterpret_u32(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16)))
svuint32_t svreinterpret_u32(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32)))
svuint32_t svreinterpret_u32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64)))
svuint32_t svreinterpret_u32(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8)))
svint64_t svreinterpret_s64(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8)))
svint64_t svreinterpret_s64(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8)))
svint64_t svreinterpret_s64(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16)))
svint64_t svreinterpret_s64(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16)))
svint64_t svreinterpret_s64(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32)))
svint64_t svreinterpret_s64(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32)))
svint64_t svreinterpret_s64(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64)))
svint64_t svreinterpret_s64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64)))
svint64_t svreinterpret_s64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16)))
svint64_t svreinterpret_s64(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16)))
svint64_t svreinterpret_s64(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32)))
svint64_t svreinterpret_s64(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64)))
svint64_t svreinterpret_s64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8)))
svuint64_t svreinterpret_u64(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8)))
svuint64_t svreinterpret_u64(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8)))
svuint64_t svreinterpret_u64(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16)))
svuint64_t svreinterpret_u64(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16)))
svuint64_t svreinterpret_u64(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32)))
svuint64_t svreinterpret_u64(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32)))
svuint64_t svreinterpret_u64(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64)))
svuint64_t svreinterpret_u64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64)))
svuint64_t svreinterpret_u64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16)))
svuint64_t svreinterpret_u64(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16)))
svuint64_t svreinterpret_u64(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32)))
svuint64_t svreinterpret_u64(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64)))
svuint64_t svreinterpret_u64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8)))
svfloat16_t svreinterpret_f16(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8)))
svfloat16_t svreinterpret_f16(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8)))
svfloat16_t svreinterpret_f16(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16)))
svfloat16_t svreinterpret_f16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16)))
svfloat16_t svreinterpret_f16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32)))
svfloat16_t svreinterpret_f16(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32)))
svfloat16_t svreinterpret_f16(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64)))
svfloat16_t svreinterpret_f16(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64)))
svfloat16_t svreinterpret_f16(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16)))
svfloat16_t svreinterpret_f16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16)))
svfloat16_t svreinterpret_f16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32)))
svfloat16_t svreinterpret_f16(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64)))
svfloat16_t svreinterpret_f16(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8)))
svbfloat16_t svreinterpret_bf16(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8)))
svbfloat16_t svreinterpret_bf16(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8)))
svbfloat16_t svreinterpret_bf16(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16)))
svbfloat16_t svreinterpret_bf16(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16)))
svbfloat16_t svreinterpret_bf16(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32)))
svbfloat16_t svreinterpret_bf16(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32)))
svbfloat16_t svreinterpret_bf16(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64)))
svbfloat16_t svreinterpret_bf16(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64)))
svbfloat16_t svreinterpret_bf16(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16)))
svbfloat16_t svreinterpret_bf16(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16)))
svbfloat16_t svreinterpret_bf16(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32)))
svbfloat16_t svreinterpret_bf16(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64)))
svbfloat16_t svreinterpret_bf16(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8)))
svfloat32_t svreinterpret_f32(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8)))
svfloat32_t svreinterpret_f32(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8)))
svfloat32_t svreinterpret_f32(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16)))
svfloat32_t svreinterpret_f32(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16)))
svfloat32_t svreinterpret_f32(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32)))
svfloat32_t svreinterpret_f32(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32)))
svfloat32_t svreinterpret_f32(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64)))
svfloat32_t svreinterpret_f32(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64)))
svfloat32_t svreinterpret_f32(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16)))
svfloat32_t svreinterpret_f32(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16)))
svfloat32_t svreinterpret_f32(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32)))
svfloat32_t svreinterpret_f32(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64)))
svfloat32_t svreinterpret_f32(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8)))
svfloat64_t svreinterpret_f64(svint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8)))
svfloat64_t svreinterpret_f64(svuint8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8)))
svfloat64_t svreinterpret_f64(svmfloat8_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16)))
svfloat64_t svreinterpret_f64(svint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16)))
svfloat64_t svreinterpret_f64(svuint16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32)))
svfloat64_t svreinterpret_f64(svint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32)))
svfloat64_t svreinterpret_f64(svuint32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64)))
svfloat64_t svreinterpret_f64(svint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64)))
svfloat64_t svreinterpret_f64(svuint64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16)))
svfloat64_t svreinterpret_f64(svfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16)))
svfloat64_t svreinterpret_f64(svbfloat16_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32)))
svfloat64_t svreinterpret_f64(svfloat32_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64)))
svfloat64_t svreinterpret_f64(svfloat64_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x2)))
svint8x2_t svreinterpret_s8_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x2)))
svint8x2_t svreinterpret_s8_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x2)))
svint8x2_t svreinterpret_s8_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x2)))
svint8x2_t svreinterpret_s8_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x2)))
svint8x2_t svreinterpret_s8_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x2)))
svint8x2_t svreinterpret_s8_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x2)))
svint8x2_t svreinterpret_s8_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x2)))
svint8x2_t svreinterpret_s8_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x2)))
svint8x2_t svreinterpret_s8_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x2)))
svint8x2_t svreinterpret_s8_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x2)))
svint8x2_t svreinterpret_s8_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x2)))
svint8x2_t svreinterpret_s8_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x2)))
svint8x2_t svreinterpret_s8_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x2)))
svuint8x2_t svreinterpret_u8_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x2)))
svuint8x2_t svreinterpret_u8_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x2)))
svuint8x2_t svreinterpret_u8_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x2)))
svuint8x2_t svreinterpret_u8_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x2)))
svuint8x2_t svreinterpret_u8_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x2)))
svuint8x2_t svreinterpret_u8_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x2)))
svuint8x2_t svreinterpret_u8_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x2)))
svuint8x2_t svreinterpret_u8_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x2)))
svuint8x2_t svreinterpret_u8_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x2)))
svuint8x2_t svreinterpret_u8_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x2)))
svuint8x2_t svreinterpret_u8_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x2)))
svuint8x2_t svreinterpret_u8_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x2)))
svuint8x2_t svreinterpret_u8_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x2)))
svmfloat8x2_t svreinterpret_mf8_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x2)))
svmfloat8x2_t svreinterpret_mf8_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x2)))
svmfloat8x2_t svreinterpret_mf8_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x2)))
svmfloat8x2_t svreinterpret_mf8_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x2)))
svmfloat8x2_t svreinterpret_mf8_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x2)))
svmfloat8x2_t svreinterpret_mf8_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x2)))
svmfloat8x2_t svreinterpret_mf8_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x2)))
svmfloat8x2_t svreinterpret_mf8_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x2)))
svmfloat8x2_t svreinterpret_mf8_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x2)))
svmfloat8x2_t svreinterpret_mf8_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x2)))
svmfloat8x2_t svreinterpret_mf8_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x2)))
svmfloat8x2_t svreinterpret_mf8_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x2)))
svmfloat8x2_t svreinterpret_mf8_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x2)))
svint16x2_t svreinterpret_s16_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x2)))
svint16x2_t svreinterpret_s16_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x2)))
svint16x2_t svreinterpret_s16_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x2)))
svint16x2_t svreinterpret_s16_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x2)))
svint16x2_t svreinterpret_s16_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x2)))
svint16x2_t svreinterpret_s16_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x2)))
svint16x2_t svreinterpret_s16_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x2)))
svint16x2_t svreinterpret_s16_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x2)))
svint16x2_t svreinterpret_s16_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x2)))
svint16x2_t svreinterpret_s16_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x2)))
svint16x2_t svreinterpret_s16_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x2)))
svint16x2_t svreinterpret_s16_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x2)))
svint16x2_t svreinterpret_s16_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x2)))
svuint16x2_t svreinterpret_u16_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x2)))
svuint16x2_t svreinterpret_u16_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x2)))
svuint16x2_t svreinterpret_u16_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x2)))
svuint16x2_t svreinterpret_u16_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x2)))
svuint16x2_t svreinterpret_u16_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x2)))
svuint16x2_t svreinterpret_u16_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x2)))
svuint16x2_t svreinterpret_u16_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x2)))
svuint16x2_t svreinterpret_u16_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x2)))
svuint16x2_t svreinterpret_u16_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x2)))
svuint16x2_t svreinterpret_u16_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x2)))
svuint16x2_t svreinterpret_u16_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x2)))
svuint16x2_t svreinterpret_u16_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x2)))
svuint16x2_t svreinterpret_u16_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x2)))
svint32x2_t svreinterpret_s32_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x2)))
svint32x2_t svreinterpret_s32_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x2)))
svint32x2_t svreinterpret_s32_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x2)))
svint32x2_t svreinterpret_s32_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x2)))
svint32x2_t svreinterpret_s32_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x2)))
svint32x2_t svreinterpret_s32_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x2)))
svint32x2_t svreinterpret_s32_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x2)))
svint32x2_t svreinterpret_s32_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x2)))
svint32x2_t svreinterpret_s32_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x2)))
svint32x2_t svreinterpret_s32_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x2)))
svint32x2_t svreinterpret_s32_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x2)))
svint32x2_t svreinterpret_s32_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x2)))
svint32x2_t svreinterpret_s32_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x2)))
svuint32x2_t svreinterpret_u32_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x2)))
svuint32x2_t svreinterpret_u32_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x2)))
svuint32x2_t svreinterpret_u32_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x2)))
svuint32x2_t svreinterpret_u32_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x2)))
svuint32x2_t svreinterpret_u32_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x2)))
svuint32x2_t svreinterpret_u32_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x2)))
svuint32x2_t svreinterpret_u32_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x2)))
svuint32x2_t svreinterpret_u32_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x2)))
svuint32x2_t svreinterpret_u32_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x2)))
svuint32x2_t svreinterpret_u32_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x2)))
svuint32x2_t svreinterpret_u32_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x2)))
svuint32x2_t svreinterpret_u32_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x2)))
svuint32x2_t svreinterpret_u32_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x2)))
svint64x2_t svreinterpret_s64_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x2)))
svint64x2_t svreinterpret_s64_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x2)))
svint64x2_t svreinterpret_s64_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x2)))
svint64x2_t svreinterpret_s64_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x2)))
svint64x2_t svreinterpret_s64_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x2)))
svint64x2_t svreinterpret_s64_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x2)))
svint64x2_t svreinterpret_s64_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x2)))
svint64x2_t svreinterpret_s64_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x2)))
svint64x2_t svreinterpret_s64_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x2)))
svint64x2_t svreinterpret_s64_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x2)))
svint64x2_t svreinterpret_s64_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x2)))
svint64x2_t svreinterpret_s64_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x2)))
svint64x2_t svreinterpret_s64_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x2)))
svuint64x2_t svreinterpret_u64_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x2)))
svuint64x2_t svreinterpret_u64_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x2)))
svuint64x2_t svreinterpret_u64_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x2)))
svuint64x2_t svreinterpret_u64_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x2)))
svuint64x2_t svreinterpret_u64_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x2)))
svuint64x2_t svreinterpret_u64_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x2)))
svuint64x2_t svreinterpret_u64_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x2)))
svuint64x2_t svreinterpret_u64_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x2)))
svuint64x2_t svreinterpret_u64_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x2)))
svuint64x2_t svreinterpret_u64_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x2)))
svuint64x2_t svreinterpret_u64_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x2)))
svuint64x2_t svreinterpret_u64_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x2)))
svuint64x2_t svreinterpret_u64_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x2)))
svfloat16x2_t svreinterpret_f16_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x2)))
svfloat16x2_t svreinterpret_f16_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x2)))
svfloat16x2_t svreinterpret_f16_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x2)))
svfloat16x2_t svreinterpret_f16_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x2)))
svfloat16x2_t svreinterpret_f16_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x2)))
svfloat16x2_t svreinterpret_f16_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x2)))
svfloat16x2_t svreinterpret_f16_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x2)))
svfloat16x2_t svreinterpret_f16_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x2)))
svfloat16x2_t svreinterpret_f16_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x2)))
svfloat16x2_t svreinterpret_f16_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x2)))
svfloat16x2_t svreinterpret_f16_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x2)))
svfloat16x2_t svreinterpret_f16_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x2)))
svfloat16x2_t svreinterpret_f16_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x2)))
svbfloat16x2_t svreinterpret_bf16_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x2)))
svbfloat16x2_t svreinterpret_bf16_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x2)))
svbfloat16x2_t svreinterpret_bf16_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x2)))
svbfloat16x2_t svreinterpret_bf16_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x2)))
svbfloat16x2_t svreinterpret_bf16_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x2)))
svbfloat16x2_t svreinterpret_bf16_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x2)))
svbfloat16x2_t svreinterpret_bf16_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x2)))
svbfloat16x2_t svreinterpret_bf16_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x2)))
svbfloat16x2_t svreinterpret_bf16_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x2)))
svbfloat16x2_t svreinterpret_bf16_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x2)))
svbfloat16x2_t svreinterpret_bf16_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x2)))
svbfloat16x2_t svreinterpret_bf16_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x2)))
svbfloat16x2_t svreinterpret_bf16_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x2)))
svfloat32x2_t svreinterpret_f32_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x2)))
svfloat32x2_t svreinterpret_f32_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x2)))
svfloat32x2_t svreinterpret_f32_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x2)))
svfloat32x2_t svreinterpret_f32_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x2)))
svfloat32x2_t svreinterpret_f32_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x2)))
svfloat32x2_t svreinterpret_f32_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x2)))
svfloat32x2_t svreinterpret_f32_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x2)))
svfloat32x2_t svreinterpret_f32_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x2)))
svfloat32x2_t svreinterpret_f32_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x2)))
svfloat32x2_t svreinterpret_f32_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x2)))
svfloat32x2_t svreinterpret_f32_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x2)))
svfloat32x2_t svreinterpret_f32_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x2)))
svfloat32x2_t svreinterpret_f32_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x2)))
svfloat64x2_t svreinterpret_f64_s8_x2(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x2)))
svfloat64x2_t svreinterpret_f64_u8_x2(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x2)))
svfloat64x2_t svreinterpret_f64_mf8_x2(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x2)))
svfloat64x2_t svreinterpret_f64_s16_x2(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x2)))
svfloat64x2_t svreinterpret_f64_u16_x2(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x2)))
svfloat64x2_t svreinterpret_f64_s32_x2(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x2)))
svfloat64x2_t svreinterpret_f64_u32_x2(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x2)))
svfloat64x2_t svreinterpret_f64_s64_x2(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x2)))
svfloat64x2_t svreinterpret_f64_u64_x2(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x2)))
svfloat64x2_t svreinterpret_f64_f16_x2(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x2)))
svfloat64x2_t svreinterpret_f64_bf16_x2(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x2)))
svfloat64x2_t svreinterpret_f64_f32_x2(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x2)))
svfloat64x2_t svreinterpret_f64_f64_x2(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x2)))
svint8x2_t svreinterpret_s8(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x2)))
svint8x2_t svreinterpret_s8(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x2)))
svint8x2_t svreinterpret_s8(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x2)))
svint8x2_t svreinterpret_s8(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x2)))
svint8x2_t svreinterpret_s8(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x2)))
svint8x2_t svreinterpret_s8(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x2)))
svint8x2_t svreinterpret_s8(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x2)))
svint8x2_t svreinterpret_s8(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x2)))
svint8x2_t svreinterpret_s8(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x2)))
svint8x2_t svreinterpret_s8(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x2)))
svint8x2_t svreinterpret_s8(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x2)))
svint8x2_t svreinterpret_s8(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x2)))
svint8x2_t svreinterpret_s8(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x2)))
svuint8x2_t svreinterpret_u8(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x2)))
svuint8x2_t svreinterpret_u8(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x2)))
svuint8x2_t svreinterpret_u8(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x2)))
svuint8x2_t svreinterpret_u8(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x2)))
svuint8x2_t svreinterpret_u8(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x2)))
svuint8x2_t svreinterpret_u8(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x2)))
svuint8x2_t svreinterpret_u8(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x2)))
svuint8x2_t svreinterpret_u8(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x2)))
svuint8x2_t svreinterpret_u8(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x2)))
svuint8x2_t svreinterpret_u8(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x2)))
svuint8x2_t svreinterpret_u8(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x2)))
svuint8x2_t svreinterpret_u8(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x2)))
svuint8x2_t svreinterpret_u8(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x2)))
svmfloat8x2_t svreinterpret_mf8(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x2)))
svmfloat8x2_t svreinterpret_mf8(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x2)))
svmfloat8x2_t svreinterpret_mf8(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x2)))
svmfloat8x2_t svreinterpret_mf8(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x2)))
svmfloat8x2_t svreinterpret_mf8(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x2)))
svmfloat8x2_t svreinterpret_mf8(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x2)))
svmfloat8x2_t svreinterpret_mf8(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x2)))
svmfloat8x2_t svreinterpret_mf8(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x2)))
svmfloat8x2_t svreinterpret_mf8(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x2)))
svmfloat8x2_t svreinterpret_mf8(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x2)))
svmfloat8x2_t svreinterpret_mf8(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x2)))
svmfloat8x2_t svreinterpret_mf8(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x2)))
svmfloat8x2_t svreinterpret_mf8(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x2)))
svint16x2_t svreinterpret_s16(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x2)))
svint16x2_t svreinterpret_s16(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x2)))
svint16x2_t svreinterpret_s16(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x2)))
svint16x2_t svreinterpret_s16(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x2)))
svint16x2_t svreinterpret_s16(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x2)))
svint16x2_t svreinterpret_s16(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x2)))
svint16x2_t svreinterpret_s16(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x2)))
svint16x2_t svreinterpret_s16(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x2)))
svint16x2_t svreinterpret_s16(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x2)))
svint16x2_t svreinterpret_s16(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x2)))
svint16x2_t svreinterpret_s16(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x2)))
svint16x2_t svreinterpret_s16(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x2)))
svint16x2_t svreinterpret_s16(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x2)))
svuint16x2_t svreinterpret_u16(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x2)))
svuint16x2_t svreinterpret_u16(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x2)))
svuint16x2_t svreinterpret_u16(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x2)))
svuint16x2_t svreinterpret_u16(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x2)))
svuint16x2_t svreinterpret_u16(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x2)))
svuint16x2_t svreinterpret_u16(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x2)))
svuint16x2_t svreinterpret_u16(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x2)))
svuint16x2_t svreinterpret_u16(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x2)))
svuint16x2_t svreinterpret_u16(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x2)))
svuint16x2_t svreinterpret_u16(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x2)))
svuint16x2_t svreinterpret_u16(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x2)))
svuint16x2_t svreinterpret_u16(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x2)))
svuint16x2_t svreinterpret_u16(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x2)))
svint32x2_t svreinterpret_s32(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x2)))
svint32x2_t svreinterpret_s32(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x2)))
svint32x2_t svreinterpret_s32(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x2)))
svint32x2_t svreinterpret_s32(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x2)))
svint32x2_t svreinterpret_s32(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x2)))
svint32x2_t svreinterpret_s32(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x2)))
svint32x2_t svreinterpret_s32(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x2)))
svint32x2_t svreinterpret_s32(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x2)))
svint32x2_t svreinterpret_s32(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x2)))
svint32x2_t svreinterpret_s32(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x2)))
svint32x2_t svreinterpret_s32(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x2)))
svint32x2_t svreinterpret_s32(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x2)))
svint32x2_t svreinterpret_s32(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x2)))
svuint32x2_t svreinterpret_u32(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x2)))
svuint32x2_t svreinterpret_u32(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x2)))
svuint32x2_t svreinterpret_u32(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x2)))
svuint32x2_t svreinterpret_u32(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x2)))
svuint32x2_t svreinterpret_u32(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x2)))
svuint32x2_t svreinterpret_u32(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x2)))
svuint32x2_t svreinterpret_u32(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x2)))
svuint32x2_t svreinterpret_u32(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x2)))
svuint32x2_t svreinterpret_u32(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x2)))
svuint32x2_t svreinterpret_u32(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x2)))
svuint32x2_t svreinterpret_u32(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x2)))
svuint32x2_t svreinterpret_u32(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x2)))
svuint32x2_t svreinterpret_u32(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x2)))
svint64x2_t svreinterpret_s64(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x2)))
svint64x2_t svreinterpret_s64(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x2)))
svint64x2_t svreinterpret_s64(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x2)))
svint64x2_t svreinterpret_s64(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x2)))
svint64x2_t svreinterpret_s64(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x2)))
svint64x2_t svreinterpret_s64(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x2)))
svint64x2_t svreinterpret_s64(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x2)))
svint64x2_t svreinterpret_s64(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x2)))
svint64x2_t svreinterpret_s64(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x2)))
svint64x2_t svreinterpret_s64(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x2)))
svint64x2_t svreinterpret_s64(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x2)))
svint64x2_t svreinterpret_s64(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x2)))
svint64x2_t svreinterpret_s64(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x2)))
svuint64x2_t svreinterpret_u64(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x2)))
svuint64x2_t svreinterpret_u64(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x2)))
svuint64x2_t svreinterpret_u64(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x2)))
svuint64x2_t svreinterpret_u64(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x2)))
svuint64x2_t svreinterpret_u64(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x2)))
svuint64x2_t svreinterpret_u64(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x2)))
svuint64x2_t svreinterpret_u64(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x2)))
svuint64x2_t svreinterpret_u64(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x2)))
svuint64x2_t svreinterpret_u64(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x2)))
svuint64x2_t svreinterpret_u64(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x2)))
svuint64x2_t svreinterpret_u64(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x2)))
svuint64x2_t svreinterpret_u64(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x2)))
svuint64x2_t svreinterpret_u64(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x2)))
svfloat16x2_t svreinterpret_f16(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x2)))
svfloat16x2_t svreinterpret_f16(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x2)))
svfloat16x2_t svreinterpret_f16(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x2)))
svfloat16x2_t svreinterpret_f16(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x2)))
svfloat16x2_t svreinterpret_f16(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x2)))
svfloat16x2_t svreinterpret_f16(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x2)))
svfloat16x2_t svreinterpret_f16(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x2)))
svfloat16x2_t svreinterpret_f16(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x2)))
svfloat16x2_t svreinterpret_f16(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x2)))
svfloat16x2_t svreinterpret_f16(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x2)))
svfloat16x2_t svreinterpret_f16(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x2)))
svfloat16x2_t svreinterpret_f16(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x2)))
svfloat16x2_t svreinterpret_f16(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x2)))
svbfloat16x2_t svreinterpret_bf16(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x2)))
svbfloat16x2_t svreinterpret_bf16(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x2)))
svbfloat16x2_t svreinterpret_bf16(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x2)))
svbfloat16x2_t svreinterpret_bf16(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x2)))
svbfloat16x2_t svreinterpret_bf16(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x2)))
svbfloat16x2_t svreinterpret_bf16(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x2)))
svbfloat16x2_t svreinterpret_bf16(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x2)))
svbfloat16x2_t svreinterpret_bf16(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x2)))
svbfloat16x2_t svreinterpret_bf16(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x2)))
svbfloat16x2_t svreinterpret_bf16(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x2)))
svbfloat16x2_t svreinterpret_bf16(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x2)))
svbfloat16x2_t svreinterpret_bf16(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x2)))
svbfloat16x2_t svreinterpret_bf16(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x2)))
svfloat32x2_t svreinterpret_f32(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x2)))
svfloat32x2_t svreinterpret_f32(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x2)))
svfloat32x2_t svreinterpret_f32(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x2)))
svfloat32x2_t svreinterpret_f32(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x2)))
svfloat32x2_t svreinterpret_f32(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x2)))
svfloat32x2_t svreinterpret_f32(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x2)))
svfloat32x2_t svreinterpret_f32(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x2)))
svfloat32x2_t svreinterpret_f32(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x2)))
svfloat32x2_t svreinterpret_f32(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x2)))
svfloat32x2_t svreinterpret_f32(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x2)))
svfloat32x2_t svreinterpret_f32(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x2)))
svfloat32x2_t svreinterpret_f32(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x2)))
svfloat32x2_t svreinterpret_f32(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x2)))
svfloat64x2_t svreinterpret_f64(svint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x2)))
svfloat64x2_t svreinterpret_f64(svuint8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x2)))
svfloat64x2_t svreinterpret_f64(svmfloat8x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x2)))
svfloat64x2_t svreinterpret_f64(svint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x2)))
svfloat64x2_t svreinterpret_f64(svuint16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x2)))
svfloat64x2_t svreinterpret_f64(svint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x2)))
svfloat64x2_t svreinterpret_f64(svuint32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x2)))
svfloat64x2_t svreinterpret_f64(svint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x2)))
svfloat64x2_t svreinterpret_f64(svuint64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x2)))
svfloat64x2_t svreinterpret_f64(svfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x2)))
svfloat64x2_t svreinterpret_f64(svbfloat16x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x2)))
svfloat64x2_t svreinterpret_f64(svfloat32x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x2)))
svfloat64x2_t svreinterpret_f64(svfloat64x2_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x3)))
svint8x3_t svreinterpret_s8_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x3)))
svint8x3_t svreinterpret_s8_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x3)))
svint8x3_t svreinterpret_s8_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x3)))
svint8x3_t svreinterpret_s8_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x3)))
svint8x3_t svreinterpret_s8_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x3)))
svint8x3_t svreinterpret_s8_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x3)))
svint8x3_t svreinterpret_s8_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x3)))
svint8x3_t svreinterpret_s8_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x3)))
svint8x3_t svreinterpret_s8_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x3)))
svint8x3_t svreinterpret_s8_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x3)))
svint8x3_t svreinterpret_s8_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x3)))
svint8x3_t svreinterpret_s8_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x3)))
svint8x3_t svreinterpret_s8_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x3)))
svuint8x3_t svreinterpret_u8_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x3)))
svuint8x3_t svreinterpret_u8_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x3)))
svuint8x3_t svreinterpret_u8_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x3)))
svuint8x3_t svreinterpret_u8_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x3)))
svuint8x3_t svreinterpret_u8_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x3)))
svuint8x3_t svreinterpret_u8_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x3)))
svuint8x3_t svreinterpret_u8_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x3)))
svuint8x3_t svreinterpret_u8_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x3)))
svuint8x3_t svreinterpret_u8_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x3)))
svuint8x3_t svreinterpret_u8_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x3)))
svuint8x3_t svreinterpret_u8_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x3)))
svuint8x3_t svreinterpret_u8_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x3)))
svuint8x3_t svreinterpret_u8_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x3)))
svmfloat8x3_t svreinterpret_mf8_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x3)))
svmfloat8x3_t svreinterpret_mf8_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x3)))
svmfloat8x3_t svreinterpret_mf8_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x3)))
svmfloat8x3_t svreinterpret_mf8_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x3)))
svmfloat8x3_t svreinterpret_mf8_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x3)))
svmfloat8x3_t svreinterpret_mf8_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x3)))
svmfloat8x3_t svreinterpret_mf8_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x3)))
svmfloat8x3_t svreinterpret_mf8_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x3)))
svmfloat8x3_t svreinterpret_mf8_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x3)))
svmfloat8x3_t svreinterpret_mf8_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x3)))
svmfloat8x3_t svreinterpret_mf8_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x3)))
svmfloat8x3_t svreinterpret_mf8_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x3)))
svmfloat8x3_t svreinterpret_mf8_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x3)))
svint16x3_t svreinterpret_s16_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x3)))
svint16x3_t svreinterpret_s16_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x3)))
svint16x3_t svreinterpret_s16_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x3)))
svint16x3_t svreinterpret_s16_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x3)))
svint16x3_t svreinterpret_s16_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x3)))
svint16x3_t svreinterpret_s16_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x3)))
svint16x3_t svreinterpret_s16_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x3)))
svint16x3_t svreinterpret_s16_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x3)))
svint16x3_t svreinterpret_s16_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x3)))
svint16x3_t svreinterpret_s16_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x3)))
svint16x3_t svreinterpret_s16_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x3)))
svint16x3_t svreinterpret_s16_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x3)))
svint16x3_t svreinterpret_s16_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x3)))
svuint16x3_t svreinterpret_u16_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x3)))
svuint16x3_t svreinterpret_u16_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x3)))
svuint16x3_t svreinterpret_u16_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x3)))
svuint16x3_t svreinterpret_u16_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x3)))
svuint16x3_t svreinterpret_u16_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x3)))
svuint16x3_t svreinterpret_u16_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x3)))
svuint16x3_t svreinterpret_u16_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x3)))
svuint16x3_t svreinterpret_u16_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x3)))
svuint16x3_t svreinterpret_u16_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x3)))
svuint16x3_t svreinterpret_u16_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x3)))
svuint16x3_t svreinterpret_u16_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x3)))
svuint16x3_t svreinterpret_u16_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x3)))
svuint16x3_t svreinterpret_u16_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x3)))
svint32x3_t svreinterpret_s32_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x3)))
svint32x3_t svreinterpret_s32_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x3)))
svint32x3_t svreinterpret_s32_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x3)))
svint32x3_t svreinterpret_s32_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x3)))
svint32x3_t svreinterpret_s32_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x3)))
svint32x3_t svreinterpret_s32_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x3)))
svint32x3_t svreinterpret_s32_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x3)))
svint32x3_t svreinterpret_s32_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x3)))
svint32x3_t svreinterpret_s32_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x3)))
svint32x3_t svreinterpret_s32_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x3)))
svint32x3_t svreinterpret_s32_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x3)))
svint32x3_t svreinterpret_s32_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x3)))
svint32x3_t svreinterpret_s32_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x3)))
svuint32x3_t svreinterpret_u32_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x3)))
svuint32x3_t svreinterpret_u32_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x3)))
svuint32x3_t svreinterpret_u32_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x3)))
svuint32x3_t svreinterpret_u32_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x3)))
svuint32x3_t svreinterpret_u32_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x3)))
svuint32x3_t svreinterpret_u32_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x3)))
svuint32x3_t svreinterpret_u32_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x3)))
svuint32x3_t svreinterpret_u32_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x3)))
svuint32x3_t svreinterpret_u32_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x3)))
svuint32x3_t svreinterpret_u32_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x3)))
svuint32x3_t svreinterpret_u32_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x3)))
svuint32x3_t svreinterpret_u32_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x3)))
svuint32x3_t svreinterpret_u32_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x3)))
svint64x3_t svreinterpret_s64_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x3)))
svint64x3_t svreinterpret_s64_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x3)))
svint64x3_t svreinterpret_s64_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x3)))
svint64x3_t svreinterpret_s64_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x3)))
svint64x3_t svreinterpret_s64_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x3)))
svint64x3_t svreinterpret_s64_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x3)))
svint64x3_t svreinterpret_s64_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x3)))
svint64x3_t svreinterpret_s64_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x3)))
svint64x3_t svreinterpret_s64_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x3)))
svint64x3_t svreinterpret_s64_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x3)))
svint64x3_t svreinterpret_s64_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x3)))
svint64x3_t svreinterpret_s64_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x3)))
svint64x3_t svreinterpret_s64_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x3)))
svuint64x3_t svreinterpret_u64_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x3)))
svuint64x3_t svreinterpret_u64_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x3)))
svuint64x3_t svreinterpret_u64_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x3)))
svuint64x3_t svreinterpret_u64_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x3)))
svuint64x3_t svreinterpret_u64_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x3)))
svuint64x3_t svreinterpret_u64_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x3)))
svuint64x3_t svreinterpret_u64_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x3)))
svuint64x3_t svreinterpret_u64_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x3)))
svuint64x3_t svreinterpret_u64_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x3)))
svuint64x3_t svreinterpret_u64_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x3)))
svuint64x3_t svreinterpret_u64_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x3)))
svuint64x3_t svreinterpret_u64_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x3)))
svuint64x3_t svreinterpret_u64_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x3)))
svfloat16x3_t svreinterpret_f16_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x3)))
svfloat16x3_t svreinterpret_f16_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x3)))
svfloat16x3_t svreinterpret_f16_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x3)))
svfloat16x3_t svreinterpret_f16_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x3)))
svfloat16x3_t svreinterpret_f16_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x3)))
svfloat16x3_t svreinterpret_f16_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x3)))
svfloat16x3_t svreinterpret_f16_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x3)))
svfloat16x3_t svreinterpret_f16_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x3)))
svfloat16x3_t svreinterpret_f16_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x3)))
svfloat16x3_t svreinterpret_f16_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x3)))
svfloat16x3_t svreinterpret_f16_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x3)))
svfloat16x3_t svreinterpret_f16_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x3)))
svfloat16x3_t svreinterpret_f16_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x3)))
svbfloat16x3_t svreinterpret_bf16_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x3)))
svbfloat16x3_t svreinterpret_bf16_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x3)))
svbfloat16x3_t svreinterpret_bf16_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x3)))
svbfloat16x3_t svreinterpret_bf16_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x3)))
svbfloat16x3_t svreinterpret_bf16_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x3)))
svbfloat16x3_t svreinterpret_bf16_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x3)))
svbfloat16x3_t svreinterpret_bf16_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x3)))
svbfloat16x3_t svreinterpret_bf16_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x3)))
svbfloat16x3_t svreinterpret_bf16_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x3)))
svbfloat16x3_t svreinterpret_bf16_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x3)))
svbfloat16x3_t svreinterpret_bf16_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x3)))
svbfloat16x3_t svreinterpret_bf16_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x3)))
svbfloat16x3_t svreinterpret_bf16_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x3)))
svfloat32x3_t svreinterpret_f32_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x3)))
svfloat32x3_t svreinterpret_f32_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x3)))
svfloat32x3_t svreinterpret_f32_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x3)))
svfloat32x3_t svreinterpret_f32_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x3)))
svfloat32x3_t svreinterpret_f32_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x3)))
svfloat32x3_t svreinterpret_f32_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x3)))
svfloat32x3_t svreinterpret_f32_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x3)))
svfloat32x3_t svreinterpret_f32_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x3)))
svfloat32x3_t svreinterpret_f32_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x3)))
svfloat32x3_t svreinterpret_f32_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x3)))
svfloat32x3_t svreinterpret_f32_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x3)))
svfloat32x3_t svreinterpret_f32_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x3)))
svfloat32x3_t svreinterpret_f32_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x3)))
svfloat64x3_t svreinterpret_f64_s8_x3(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x3)))
svfloat64x3_t svreinterpret_f64_u8_x3(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x3)))
svfloat64x3_t svreinterpret_f64_mf8_x3(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x3)))
svfloat64x3_t svreinterpret_f64_s16_x3(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x3)))
svfloat64x3_t svreinterpret_f64_u16_x3(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x3)))
svfloat64x3_t svreinterpret_f64_s32_x3(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x3)))
svfloat64x3_t svreinterpret_f64_u32_x3(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x3)))
svfloat64x3_t svreinterpret_f64_s64_x3(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x3)))
svfloat64x3_t svreinterpret_f64_u64_x3(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x3)))
svfloat64x3_t svreinterpret_f64_f16_x3(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x3)))
svfloat64x3_t svreinterpret_f64_bf16_x3(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x3)))
svfloat64x3_t svreinterpret_f64_f32_x3(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x3)))
svfloat64x3_t svreinterpret_f64_f64_x3(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x3)))
svint8x3_t svreinterpret_s8(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x3)))
svint8x3_t svreinterpret_s8(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x3)))
svint8x3_t svreinterpret_s8(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x3)))
svint8x3_t svreinterpret_s8(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x3)))
svint8x3_t svreinterpret_s8(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x3)))
svint8x3_t svreinterpret_s8(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x3)))
svint8x3_t svreinterpret_s8(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x3)))
svint8x3_t svreinterpret_s8(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x3)))
svint8x3_t svreinterpret_s8(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x3)))
svint8x3_t svreinterpret_s8(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x3)))
svint8x3_t svreinterpret_s8(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x3)))
svint8x3_t svreinterpret_s8(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x3)))
svint8x3_t svreinterpret_s8(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x3)))
svuint8x3_t svreinterpret_u8(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x3)))
svuint8x3_t svreinterpret_u8(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x3)))
svuint8x3_t svreinterpret_u8(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x3)))
svuint8x3_t svreinterpret_u8(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x3)))
svuint8x3_t svreinterpret_u8(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x3)))
svuint8x3_t svreinterpret_u8(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x3)))
svuint8x3_t svreinterpret_u8(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x3)))
svuint8x3_t svreinterpret_u8(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x3)))
svuint8x3_t svreinterpret_u8(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x3)))
svuint8x3_t svreinterpret_u8(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x3)))
svuint8x3_t svreinterpret_u8(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x3)))
svuint8x3_t svreinterpret_u8(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x3)))
svuint8x3_t svreinterpret_u8(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x3)))
svmfloat8x3_t svreinterpret_mf8(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x3)))
svmfloat8x3_t svreinterpret_mf8(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x3)))
svmfloat8x3_t svreinterpret_mf8(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x3)))
svmfloat8x3_t svreinterpret_mf8(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x3)))
svmfloat8x3_t svreinterpret_mf8(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x3)))
svmfloat8x3_t svreinterpret_mf8(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x3)))
svmfloat8x3_t svreinterpret_mf8(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x3)))
svmfloat8x3_t svreinterpret_mf8(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x3)))
svmfloat8x3_t svreinterpret_mf8(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x3)))
svmfloat8x3_t svreinterpret_mf8(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x3)))
svmfloat8x3_t svreinterpret_mf8(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x3)))
svmfloat8x3_t svreinterpret_mf8(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x3)))
svmfloat8x3_t svreinterpret_mf8(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x3)))
svint16x3_t svreinterpret_s16(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x3)))
svint16x3_t svreinterpret_s16(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x3)))
svint16x3_t svreinterpret_s16(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x3)))
svint16x3_t svreinterpret_s16(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x3)))
svint16x3_t svreinterpret_s16(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x3)))
svint16x3_t svreinterpret_s16(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x3)))
svint16x3_t svreinterpret_s16(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x3)))
svint16x3_t svreinterpret_s16(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x3)))
svint16x3_t svreinterpret_s16(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x3)))
svint16x3_t svreinterpret_s16(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x3)))
svint16x3_t svreinterpret_s16(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x3)))
svint16x3_t svreinterpret_s16(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x3)))
svint16x3_t svreinterpret_s16(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x3)))
svuint16x3_t svreinterpret_u16(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x3)))
svuint16x3_t svreinterpret_u16(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x3)))
svuint16x3_t svreinterpret_u16(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x3)))
svuint16x3_t svreinterpret_u16(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x3)))
svuint16x3_t svreinterpret_u16(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x3)))
svuint16x3_t svreinterpret_u16(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x3)))
svuint16x3_t svreinterpret_u16(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x3)))
svuint16x3_t svreinterpret_u16(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x3)))
svuint16x3_t svreinterpret_u16(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x3)))
svuint16x3_t svreinterpret_u16(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x3)))
svuint16x3_t svreinterpret_u16(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x3)))
svuint16x3_t svreinterpret_u16(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x3)))
svuint16x3_t svreinterpret_u16(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x3)))
svint32x3_t svreinterpret_s32(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x3)))
svint32x3_t svreinterpret_s32(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x3)))
svint32x3_t svreinterpret_s32(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x3)))
svint32x3_t svreinterpret_s32(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x3)))
svint32x3_t svreinterpret_s32(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x3)))
svint32x3_t svreinterpret_s32(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x3)))
svint32x3_t svreinterpret_s32(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x3)))
svint32x3_t svreinterpret_s32(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x3)))
svint32x3_t svreinterpret_s32(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x3)))
svint32x3_t svreinterpret_s32(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x3)))
svint32x3_t svreinterpret_s32(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x3)))
svint32x3_t svreinterpret_s32(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x3)))
svint32x3_t svreinterpret_s32(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x3)))
svuint32x3_t svreinterpret_u32(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x3)))
svuint32x3_t svreinterpret_u32(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x3)))
svuint32x3_t svreinterpret_u32(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x3)))
svuint32x3_t svreinterpret_u32(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x3)))
svuint32x3_t svreinterpret_u32(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x3)))
svuint32x3_t svreinterpret_u32(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x3)))
svuint32x3_t svreinterpret_u32(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x3)))
svuint32x3_t svreinterpret_u32(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x3)))
svuint32x3_t svreinterpret_u32(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x3)))
svuint32x3_t svreinterpret_u32(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x3)))
svuint32x3_t svreinterpret_u32(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x3)))
svuint32x3_t svreinterpret_u32(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x3)))
svuint32x3_t svreinterpret_u32(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x3)))
svint64x3_t svreinterpret_s64(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x3)))
svint64x3_t svreinterpret_s64(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x3)))
svint64x3_t svreinterpret_s64(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x3)))
svint64x3_t svreinterpret_s64(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x3)))
svint64x3_t svreinterpret_s64(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x3)))
svint64x3_t svreinterpret_s64(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x3)))
svint64x3_t svreinterpret_s64(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x3)))
svint64x3_t svreinterpret_s64(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x3)))
svint64x3_t svreinterpret_s64(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x3)))
svint64x3_t svreinterpret_s64(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x3)))
svint64x3_t svreinterpret_s64(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x3)))
svint64x3_t svreinterpret_s64(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x3)))
svint64x3_t svreinterpret_s64(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x3)))
svuint64x3_t svreinterpret_u64(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x3)))
svuint64x3_t svreinterpret_u64(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x3)))
svuint64x3_t svreinterpret_u64(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x3)))
svuint64x3_t svreinterpret_u64(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x3)))
svuint64x3_t svreinterpret_u64(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x3)))
svuint64x3_t svreinterpret_u64(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x3)))
svuint64x3_t svreinterpret_u64(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x3)))
svuint64x3_t svreinterpret_u64(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x3)))
svuint64x3_t svreinterpret_u64(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x3)))
svuint64x3_t svreinterpret_u64(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x3)))
svuint64x3_t svreinterpret_u64(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x3)))
svuint64x3_t svreinterpret_u64(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x3)))
svuint64x3_t svreinterpret_u64(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x3)))
svfloat16x3_t svreinterpret_f16(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x3)))
svfloat16x3_t svreinterpret_f16(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x3)))
svfloat16x3_t svreinterpret_f16(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x3)))
svfloat16x3_t svreinterpret_f16(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x3)))
svfloat16x3_t svreinterpret_f16(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x3)))
svfloat16x3_t svreinterpret_f16(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x3)))
svfloat16x3_t svreinterpret_f16(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x3)))
svfloat16x3_t svreinterpret_f16(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x3)))
svfloat16x3_t svreinterpret_f16(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x3)))
svfloat16x3_t svreinterpret_f16(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x3)))
svfloat16x3_t svreinterpret_f16(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x3)))
svfloat16x3_t svreinterpret_f16(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x3)))
svfloat16x3_t svreinterpret_f16(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x3)))
svbfloat16x3_t svreinterpret_bf16(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x3)))
svbfloat16x3_t svreinterpret_bf16(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x3)))
svbfloat16x3_t svreinterpret_bf16(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x3)))
svbfloat16x3_t svreinterpret_bf16(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x3)))
svbfloat16x3_t svreinterpret_bf16(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x3)))
svbfloat16x3_t svreinterpret_bf16(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x3)))
svbfloat16x3_t svreinterpret_bf16(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x3)))
svbfloat16x3_t svreinterpret_bf16(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x3)))
svbfloat16x3_t svreinterpret_bf16(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x3)))
svbfloat16x3_t svreinterpret_bf16(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x3)))
svbfloat16x3_t svreinterpret_bf16(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x3)))
svbfloat16x3_t svreinterpret_bf16(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x3)))
svbfloat16x3_t svreinterpret_bf16(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x3)))
svfloat32x3_t svreinterpret_f32(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x3)))
svfloat32x3_t svreinterpret_f32(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x3)))
svfloat32x3_t svreinterpret_f32(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x3)))
svfloat32x3_t svreinterpret_f32(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x3)))
svfloat32x3_t svreinterpret_f32(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x3)))
svfloat32x3_t svreinterpret_f32(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x3)))
svfloat32x3_t svreinterpret_f32(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x3)))
svfloat32x3_t svreinterpret_f32(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x3)))
svfloat32x3_t svreinterpret_f32(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x3)))
svfloat32x3_t svreinterpret_f32(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x3)))
svfloat32x3_t svreinterpret_f32(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x3)))
svfloat32x3_t svreinterpret_f32(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x3)))
svfloat32x3_t svreinterpret_f32(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x3)))
svfloat64x3_t svreinterpret_f64(svint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x3)))
svfloat64x3_t svreinterpret_f64(svuint8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x3)))
svfloat64x3_t svreinterpret_f64(svmfloat8x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x3)))
svfloat64x3_t svreinterpret_f64(svint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x3)))
svfloat64x3_t svreinterpret_f64(svuint16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x3)))
svfloat64x3_t svreinterpret_f64(svint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x3)))
svfloat64x3_t svreinterpret_f64(svuint32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x3)))
svfloat64x3_t svreinterpret_f64(svint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x3)))
svfloat64x3_t svreinterpret_f64(svuint64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x3)))
svfloat64x3_t svreinterpret_f64(svfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x3)))
svfloat64x3_t svreinterpret_f64(svbfloat16x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x3)))
svfloat64x3_t svreinterpret_f64(svfloat32x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x3)))
svfloat64x3_t svreinterpret_f64(svfloat64x3_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x4)))
svint8x4_t svreinterpret_s8_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x4)))
svint8x4_t svreinterpret_s8_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x4)))
svint8x4_t svreinterpret_s8_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x4)))
svint8x4_t svreinterpret_s8_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x4)))
svint8x4_t svreinterpret_s8_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x4)))
svint8x4_t svreinterpret_s8_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x4)))
svint8x4_t svreinterpret_s8_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x4)))
svint8x4_t svreinterpret_s8_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x4)))
svint8x4_t svreinterpret_s8_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x4)))
svint8x4_t svreinterpret_s8_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x4)))
svint8x4_t svreinterpret_s8_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x4)))
svint8x4_t svreinterpret_s8_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x4)))
svint8x4_t svreinterpret_s8_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x4)))
svuint8x4_t svreinterpret_u8_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x4)))
svuint8x4_t svreinterpret_u8_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x4)))
svuint8x4_t svreinterpret_u8_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x4)))
svuint8x4_t svreinterpret_u8_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x4)))
svuint8x4_t svreinterpret_u8_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x4)))
svuint8x4_t svreinterpret_u8_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x4)))
svuint8x4_t svreinterpret_u8_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x4)))
svuint8x4_t svreinterpret_u8_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x4)))
svuint8x4_t svreinterpret_u8_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x4)))
svuint8x4_t svreinterpret_u8_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x4)))
svuint8x4_t svreinterpret_u8_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x4)))
svuint8x4_t svreinterpret_u8_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x4)))
svuint8x4_t svreinterpret_u8_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x4)))
svmfloat8x4_t svreinterpret_mf8_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x4)))
svmfloat8x4_t svreinterpret_mf8_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x4)))
svmfloat8x4_t svreinterpret_mf8_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x4)))
svmfloat8x4_t svreinterpret_mf8_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x4)))
svmfloat8x4_t svreinterpret_mf8_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x4)))
svmfloat8x4_t svreinterpret_mf8_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x4)))
svmfloat8x4_t svreinterpret_mf8_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x4)))
svmfloat8x4_t svreinterpret_mf8_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x4)))
svmfloat8x4_t svreinterpret_mf8_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x4)))
svmfloat8x4_t svreinterpret_mf8_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x4)))
svmfloat8x4_t svreinterpret_mf8_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x4)))
svmfloat8x4_t svreinterpret_mf8_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x4)))
svmfloat8x4_t svreinterpret_mf8_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x4)))
svint16x4_t svreinterpret_s16_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x4)))
svint16x4_t svreinterpret_s16_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x4)))
svint16x4_t svreinterpret_s16_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x4)))
svint16x4_t svreinterpret_s16_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x4)))
svint16x4_t svreinterpret_s16_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x4)))
svint16x4_t svreinterpret_s16_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x4)))
svint16x4_t svreinterpret_s16_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x4)))
svint16x4_t svreinterpret_s16_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x4)))
svint16x4_t svreinterpret_s16_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x4)))
svint16x4_t svreinterpret_s16_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x4)))
svint16x4_t svreinterpret_s16_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x4)))
svint16x4_t svreinterpret_s16_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x4)))
svint16x4_t svreinterpret_s16_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x4)))
svuint16x4_t svreinterpret_u16_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x4)))
svuint16x4_t svreinterpret_u16_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x4)))
svuint16x4_t svreinterpret_u16_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x4)))
svuint16x4_t svreinterpret_u16_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x4)))
svuint16x4_t svreinterpret_u16_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x4)))
svuint16x4_t svreinterpret_u16_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x4)))
svuint16x4_t svreinterpret_u16_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x4)))
svuint16x4_t svreinterpret_u16_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x4)))
svuint16x4_t svreinterpret_u16_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x4)))
svuint16x4_t svreinterpret_u16_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x4)))
svuint16x4_t svreinterpret_u16_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x4)))
svuint16x4_t svreinterpret_u16_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x4)))
svuint16x4_t svreinterpret_u16_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x4)))
svint32x4_t svreinterpret_s32_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x4)))
svint32x4_t svreinterpret_s32_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x4)))
svint32x4_t svreinterpret_s32_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x4)))
svint32x4_t svreinterpret_s32_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x4)))
svint32x4_t svreinterpret_s32_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x4)))
svint32x4_t svreinterpret_s32_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x4)))
svint32x4_t svreinterpret_s32_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x4)))
svint32x4_t svreinterpret_s32_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x4)))
svint32x4_t svreinterpret_s32_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x4)))
svint32x4_t svreinterpret_s32_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x4)))
svint32x4_t svreinterpret_s32_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x4)))
svint32x4_t svreinterpret_s32_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x4)))
svint32x4_t svreinterpret_s32_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x4)))
svuint32x4_t svreinterpret_u32_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x4)))
svuint32x4_t svreinterpret_u32_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x4)))
svuint32x4_t svreinterpret_u32_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x4)))
svuint32x4_t svreinterpret_u32_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x4)))
svuint32x4_t svreinterpret_u32_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x4)))
svuint32x4_t svreinterpret_u32_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x4)))
svuint32x4_t svreinterpret_u32_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x4)))
svuint32x4_t svreinterpret_u32_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x4)))
svuint32x4_t svreinterpret_u32_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x4)))
svuint32x4_t svreinterpret_u32_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x4)))
svuint32x4_t svreinterpret_u32_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x4)))
svuint32x4_t svreinterpret_u32_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x4)))
svuint32x4_t svreinterpret_u32_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x4)))
svint64x4_t svreinterpret_s64_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x4)))
svint64x4_t svreinterpret_s64_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x4)))
svint64x4_t svreinterpret_s64_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x4)))
svint64x4_t svreinterpret_s64_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x4)))
svint64x4_t svreinterpret_s64_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x4)))
svint64x4_t svreinterpret_s64_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x4)))
svint64x4_t svreinterpret_s64_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x4)))
svint64x4_t svreinterpret_s64_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x4)))
svint64x4_t svreinterpret_s64_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x4)))
svint64x4_t svreinterpret_s64_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x4)))
svint64x4_t svreinterpret_s64_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x4)))
svint64x4_t svreinterpret_s64_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x4)))
svint64x4_t svreinterpret_s64_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x4)))
svuint64x4_t svreinterpret_u64_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x4)))
svuint64x4_t svreinterpret_u64_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x4)))
svuint64x4_t svreinterpret_u64_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x4)))
svuint64x4_t svreinterpret_u64_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x4)))
svuint64x4_t svreinterpret_u64_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x4)))
svuint64x4_t svreinterpret_u64_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x4)))
svuint64x4_t svreinterpret_u64_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x4)))
svuint64x4_t svreinterpret_u64_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x4)))
svuint64x4_t svreinterpret_u64_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x4)))
svuint64x4_t svreinterpret_u64_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x4)))
svuint64x4_t svreinterpret_u64_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x4)))
svuint64x4_t svreinterpret_u64_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x4)))
svuint64x4_t svreinterpret_u64_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x4)))
svfloat16x4_t svreinterpret_f16_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x4)))
svfloat16x4_t svreinterpret_f16_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x4)))
svfloat16x4_t svreinterpret_f16_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x4)))
svfloat16x4_t svreinterpret_f16_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x4)))
svfloat16x4_t svreinterpret_f16_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x4)))
svfloat16x4_t svreinterpret_f16_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x4)))
svfloat16x4_t svreinterpret_f16_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x4)))
svfloat16x4_t svreinterpret_f16_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x4)))
svfloat16x4_t svreinterpret_f16_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x4)))
svfloat16x4_t svreinterpret_f16_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x4)))
svfloat16x4_t svreinterpret_f16_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x4)))
svfloat16x4_t svreinterpret_f16_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x4)))
svfloat16x4_t svreinterpret_f16_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x4)))
svbfloat16x4_t svreinterpret_bf16_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x4)))
svbfloat16x4_t svreinterpret_bf16_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x4)))
svbfloat16x4_t svreinterpret_bf16_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x4)))
svbfloat16x4_t svreinterpret_bf16_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x4)))
svbfloat16x4_t svreinterpret_bf16_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x4)))
svbfloat16x4_t svreinterpret_bf16_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x4)))
svbfloat16x4_t svreinterpret_bf16_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x4)))
svbfloat16x4_t svreinterpret_bf16_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x4)))
svbfloat16x4_t svreinterpret_bf16_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x4)))
svbfloat16x4_t svreinterpret_bf16_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x4)))
svbfloat16x4_t svreinterpret_bf16_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x4)))
svbfloat16x4_t svreinterpret_bf16_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x4)))
svbfloat16x4_t svreinterpret_bf16_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x4)))
svfloat32x4_t svreinterpret_f32_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x4)))
svfloat32x4_t svreinterpret_f32_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x4)))
svfloat32x4_t svreinterpret_f32_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x4)))
svfloat32x4_t svreinterpret_f32_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x4)))
svfloat32x4_t svreinterpret_f32_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x4)))
svfloat32x4_t svreinterpret_f32_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x4)))
svfloat32x4_t svreinterpret_f32_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x4)))
svfloat32x4_t svreinterpret_f32_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x4)))
svfloat32x4_t svreinterpret_f32_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x4)))
svfloat32x4_t svreinterpret_f32_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x4)))
svfloat32x4_t svreinterpret_f32_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x4)))
svfloat32x4_t svreinterpret_f32_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x4)))
svfloat32x4_t svreinterpret_f32_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x4)))
svfloat64x4_t svreinterpret_f64_s8_x4(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x4)))
svfloat64x4_t svreinterpret_f64_u8_x4(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x4)))
svfloat64x4_t svreinterpret_f64_mf8_x4(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x4)))
svfloat64x4_t svreinterpret_f64_s16_x4(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x4)))
svfloat64x4_t svreinterpret_f64_u16_x4(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x4)))
svfloat64x4_t svreinterpret_f64_s32_x4(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x4)))
svfloat64x4_t svreinterpret_f64_u32_x4(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x4)))
svfloat64x4_t svreinterpret_f64_s64_x4(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x4)))
svfloat64x4_t svreinterpret_f64_u64_x4(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x4)))
svfloat64x4_t svreinterpret_f64_f16_x4(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x4)))
svfloat64x4_t svreinterpret_f64_bf16_x4(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x4)))
svfloat64x4_t svreinterpret_f64_f32_x4(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x4)))
svfloat64x4_t svreinterpret_f64_f64_x4(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s8_x4)))
svint8x4_t svreinterpret_s8(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u8_x4)))
svint8x4_t svreinterpret_s8(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_mf8_x4)))
svint8x4_t svreinterpret_s8(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s16_x4)))
svint8x4_t svreinterpret_s8(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u16_x4)))
svint8x4_t svreinterpret_s8(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s32_x4)))
svint8x4_t svreinterpret_s8(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u32_x4)))
svint8x4_t svreinterpret_s8(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_s64_x4)))
svint8x4_t svreinterpret_s8(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_u64_x4)))
svint8x4_t svreinterpret_s8(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f16_x4)))
svint8x4_t svreinterpret_s8(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_bf16_x4)))
svint8x4_t svreinterpret_s8(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f32_x4)))
svint8x4_t svreinterpret_s8(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s8_f64_x4)))
svint8x4_t svreinterpret_s8(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s8_x4)))
svuint8x4_t svreinterpret_u8(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u8_x4)))
svuint8x4_t svreinterpret_u8(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_mf8_x4)))
svuint8x4_t svreinterpret_u8(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s16_x4)))
svuint8x4_t svreinterpret_u8(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u16_x4)))
svuint8x4_t svreinterpret_u8(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s32_x4)))
svuint8x4_t svreinterpret_u8(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u32_x4)))
svuint8x4_t svreinterpret_u8(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_s64_x4)))
svuint8x4_t svreinterpret_u8(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_u64_x4)))
svuint8x4_t svreinterpret_u8(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f16_x4)))
svuint8x4_t svreinterpret_u8(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_bf16_x4)))
svuint8x4_t svreinterpret_u8(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f32_x4)))
svuint8x4_t svreinterpret_u8(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u8_f64_x4)))
svuint8x4_t svreinterpret_u8(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s8_x4)))
svmfloat8x4_t svreinterpret_mf8(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u8_x4)))
svmfloat8x4_t svreinterpret_mf8(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_mf8_x4)))
svmfloat8x4_t svreinterpret_mf8(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s16_x4)))
svmfloat8x4_t svreinterpret_mf8(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u16_x4)))
svmfloat8x4_t svreinterpret_mf8(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s32_x4)))
svmfloat8x4_t svreinterpret_mf8(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u32_x4)))
svmfloat8x4_t svreinterpret_mf8(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_s64_x4)))
svmfloat8x4_t svreinterpret_mf8(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_u64_x4)))
svmfloat8x4_t svreinterpret_mf8(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f16_x4)))
svmfloat8x4_t svreinterpret_mf8(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_bf16_x4)))
svmfloat8x4_t svreinterpret_mf8(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f32_x4)))
svmfloat8x4_t svreinterpret_mf8(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_mf8_f64_x4)))
svmfloat8x4_t svreinterpret_mf8(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s8_x4)))
svint16x4_t svreinterpret_s16(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u8_x4)))
svint16x4_t svreinterpret_s16(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_mf8_x4)))
svint16x4_t svreinterpret_s16(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s16_x4)))
svint16x4_t svreinterpret_s16(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u16_x4)))
svint16x4_t svreinterpret_s16(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s32_x4)))
svint16x4_t svreinterpret_s16(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u32_x4)))
svint16x4_t svreinterpret_s16(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_s64_x4)))
svint16x4_t svreinterpret_s16(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_u64_x4)))
svint16x4_t svreinterpret_s16(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f16_x4)))
svint16x4_t svreinterpret_s16(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_bf16_x4)))
svint16x4_t svreinterpret_s16(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f32_x4)))
svint16x4_t svreinterpret_s16(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s16_f64_x4)))
svint16x4_t svreinterpret_s16(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s8_x4)))
svuint16x4_t svreinterpret_u16(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u8_x4)))
svuint16x4_t svreinterpret_u16(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_mf8_x4)))
svuint16x4_t svreinterpret_u16(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s16_x4)))
svuint16x4_t svreinterpret_u16(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u16_x4)))
svuint16x4_t svreinterpret_u16(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s32_x4)))
svuint16x4_t svreinterpret_u16(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u32_x4)))
svuint16x4_t svreinterpret_u16(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_s64_x4)))
svuint16x4_t svreinterpret_u16(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_u64_x4)))
svuint16x4_t svreinterpret_u16(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f16_x4)))
svuint16x4_t svreinterpret_u16(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_bf16_x4)))
svuint16x4_t svreinterpret_u16(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f32_x4)))
svuint16x4_t svreinterpret_u16(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u16_f64_x4)))
svuint16x4_t svreinterpret_u16(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s8_x4)))
svint32x4_t svreinterpret_s32(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u8_x4)))
svint32x4_t svreinterpret_s32(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_mf8_x4)))
svint32x4_t svreinterpret_s32(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s16_x4)))
svint32x4_t svreinterpret_s32(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u16_x4)))
svint32x4_t svreinterpret_s32(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s32_x4)))
svint32x4_t svreinterpret_s32(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u32_x4)))
svint32x4_t svreinterpret_s32(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_s64_x4)))
svint32x4_t svreinterpret_s32(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_u64_x4)))
svint32x4_t svreinterpret_s32(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f16_x4)))
svint32x4_t svreinterpret_s32(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_bf16_x4)))
svint32x4_t svreinterpret_s32(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f32_x4)))
svint32x4_t svreinterpret_s32(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s32_f64_x4)))
svint32x4_t svreinterpret_s32(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s8_x4)))
svuint32x4_t svreinterpret_u32(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u8_x4)))
svuint32x4_t svreinterpret_u32(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_mf8_x4)))
svuint32x4_t svreinterpret_u32(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s16_x4)))
svuint32x4_t svreinterpret_u32(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u16_x4)))
svuint32x4_t svreinterpret_u32(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s32_x4)))
svuint32x4_t svreinterpret_u32(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u32_x4)))
svuint32x4_t svreinterpret_u32(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_s64_x4)))
svuint32x4_t svreinterpret_u32(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_u64_x4)))
svuint32x4_t svreinterpret_u32(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f16_x4)))
svuint32x4_t svreinterpret_u32(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_bf16_x4)))
svuint32x4_t svreinterpret_u32(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f32_x4)))
svuint32x4_t svreinterpret_u32(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u32_f64_x4)))
svuint32x4_t svreinterpret_u32(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s8_x4)))
svint64x4_t svreinterpret_s64(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u8_x4)))
svint64x4_t svreinterpret_s64(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_mf8_x4)))
svint64x4_t svreinterpret_s64(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s16_x4)))
svint64x4_t svreinterpret_s64(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u16_x4)))
svint64x4_t svreinterpret_s64(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s32_x4)))
svint64x4_t svreinterpret_s64(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u32_x4)))
svint64x4_t svreinterpret_s64(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_s64_x4)))
svint64x4_t svreinterpret_s64(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_u64_x4)))
svint64x4_t svreinterpret_s64(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f16_x4)))
svint64x4_t svreinterpret_s64(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_bf16_x4)))
svint64x4_t svreinterpret_s64(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f32_x4)))
svint64x4_t svreinterpret_s64(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_s64_f64_x4)))
svint64x4_t svreinterpret_s64(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s8_x4)))
svuint64x4_t svreinterpret_u64(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u8_x4)))
svuint64x4_t svreinterpret_u64(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_mf8_x4)))
svuint64x4_t svreinterpret_u64(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s16_x4)))
svuint64x4_t svreinterpret_u64(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u16_x4)))
svuint64x4_t svreinterpret_u64(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s32_x4)))
svuint64x4_t svreinterpret_u64(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u32_x4)))
svuint64x4_t svreinterpret_u64(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_s64_x4)))
svuint64x4_t svreinterpret_u64(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_u64_x4)))
svuint64x4_t svreinterpret_u64(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f16_x4)))
svuint64x4_t svreinterpret_u64(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_bf16_x4)))
svuint64x4_t svreinterpret_u64(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f32_x4)))
svuint64x4_t svreinterpret_u64(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_u64_f64_x4)))
svuint64x4_t svreinterpret_u64(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s8_x4)))
svfloat16x4_t svreinterpret_f16(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u8_x4)))
svfloat16x4_t svreinterpret_f16(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_mf8_x4)))
svfloat16x4_t svreinterpret_f16(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s16_x4)))
svfloat16x4_t svreinterpret_f16(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u16_x4)))
svfloat16x4_t svreinterpret_f16(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s32_x4)))
svfloat16x4_t svreinterpret_f16(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u32_x4)))
svfloat16x4_t svreinterpret_f16(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_s64_x4)))
svfloat16x4_t svreinterpret_f16(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_u64_x4)))
svfloat16x4_t svreinterpret_f16(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f16_x4)))
svfloat16x4_t svreinterpret_f16(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_bf16_x4)))
svfloat16x4_t svreinterpret_f16(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f32_x4)))
svfloat16x4_t svreinterpret_f16(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f16_f64_x4)))
svfloat16x4_t svreinterpret_f16(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s8_x4)))
svbfloat16x4_t svreinterpret_bf16(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u8_x4)))
svbfloat16x4_t svreinterpret_bf16(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_mf8_x4)))
svbfloat16x4_t svreinterpret_bf16(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s16_x4)))
svbfloat16x4_t svreinterpret_bf16(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u16_x4)))
svbfloat16x4_t svreinterpret_bf16(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s32_x4)))
svbfloat16x4_t svreinterpret_bf16(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u32_x4)))
svbfloat16x4_t svreinterpret_bf16(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_s64_x4)))
svbfloat16x4_t svreinterpret_bf16(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_u64_x4)))
svbfloat16x4_t svreinterpret_bf16(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f16_x4)))
svbfloat16x4_t svreinterpret_bf16(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_bf16_x4)))
svbfloat16x4_t svreinterpret_bf16(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f32_x4)))
svbfloat16x4_t svreinterpret_bf16(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_bf16_f64_x4)))
svbfloat16x4_t svreinterpret_bf16(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s8_x4)))
svfloat32x4_t svreinterpret_f32(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u8_x4)))
svfloat32x4_t svreinterpret_f32(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_mf8_x4)))
svfloat32x4_t svreinterpret_f32(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s16_x4)))
svfloat32x4_t svreinterpret_f32(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u16_x4)))
svfloat32x4_t svreinterpret_f32(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s32_x4)))
svfloat32x4_t svreinterpret_f32(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u32_x4)))
svfloat32x4_t svreinterpret_f32(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_s64_x4)))
svfloat32x4_t svreinterpret_f32(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_u64_x4)))
svfloat32x4_t svreinterpret_f32(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f16_x4)))
svfloat32x4_t svreinterpret_f32(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_bf16_x4)))
svfloat32x4_t svreinterpret_f32(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f32_x4)))
svfloat32x4_t svreinterpret_f32(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f32_f64_x4)))
svfloat32x4_t svreinterpret_f32(svfloat64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s8_x4)))
svfloat64x4_t svreinterpret_f64(svint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u8_x4)))
svfloat64x4_t svreinterpret_f64(svuint8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_mf8_x4)))
svfloat64x4_t svreinterpret_f64(svmfloat8x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s16_x4)))
svfloat64x4_t svreinterpret_f64(svint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u16_x4)))
svfloat64x4_t svreinterpret_f64(svuint16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s32_x4)))
svfloat64x4_t svreinterpret_f64(svint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u32_x4)))
svfloat64x4_t svreinterpret_f64(svuint32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_s64_x4)))
svfloat64x4_t svreinterpret_f64(svint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_u64_x4)))
svfloat64x4_t svreinterpret_f64(svuint64x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f16_x4)))
svfloat64x4_t svreinterpret_f64(svfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_bf16_x4)))
svfloat64x4_t svreinterpret_f64(svbfloat16x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f32_x4)))
svfloat64x4_t svreinterpret_f64(svfloat32x4_t op);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_reinterpret_f64_f64_x4)))
svfloat64x4_t svreinterpret_f64(svfloat64x4_t op);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_x2)))
svfloat32x2_t svcvt_f32_f16_x2(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl_f32_f16_x2)))
svfloat32x2_t svcvtl_f32_f16_x2(svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_f16_x2)))
svfloat32x2_t svcvt_f32(svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl_f32_f16_x2)))
svfloat32x2_t svcvtl_f32(svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x2)))
svuint8x2_t svadd_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x2)))
svuint32x2_t svadd_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x2)))
svuint64x2_t svadd_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x2)))
svuint16x2_t svadd_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x2)))
svint8x2_t svadd_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x2)))
svint32x2_t svadd_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x2)))
svint64x2_t svadd_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x2)))
svint16x2_t svadd_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x4)))
svuint8x4_t svadd_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x4)))
svuint32x4_t svadd_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x4)))
svuint64x4_t svadd_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x4)))
svuint16x4_t svadd_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x4)))
svint8x4_t svadd_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x4)))
svint32x4_t svadd_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x4)))
svint64x4_t svadd_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x4)))
svint16x4_t svadd_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x2)))
svfloat64x2_t svclamp_single_f64_x2(svfloat64x2_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x2)))
svfloat32x2_t svclamp_single_f32_x2(svfloat32x2_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x2)))
svfloat16x2_t svclamp_single_f16_x2(svfloat16x2_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x2)))
svint8x2_t svclamp_single_s8_x2(svint8x2_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x2)))
svint32x2_t svclamp_single_s32_x2(svint32x2_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x2)))
svint64x2_t svclamp_single_s64_x2(svint64x2_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x2)))
svint16x2_t svclamp_single_s16_x2(svint16x2_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x2)))
svuint8x2_t svclamp_single_u8_x2(svuint8x2_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x2)))
svuint32x2_t svclamp_single_u32_x2(svuint32x2_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x2)))
svuint64x2_t svclamp_single_u64_x2(svuint64x2_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x2)))
svuint16x2_t svclamp_single_u16_x2(svuint16x2_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x4)))
svfloat64x4_t svclamp_single_f64_x4(svfloat64x4_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x4)))
svfloat32x4_t svclamp_single_f32_x4(svfloat32x4_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x4)))
svfloat16x4_t svclamp_single_f16_x4(svfloat16x4_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x4)))
svint8x4_t svclamp_single_s8_x4(svint8x4_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x4)))
svint32x4_t svclamp_single_s32_x4(svint32x4_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x4)))
svint64x4_t svclamp_single_s64_x4(svint64x4_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x4)))
svint16x4_t svclamp_single_s16_x4(svint16x4_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x4)))
svuint8x4_t svclamp_single_u8_x4(svuint8x4_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x4)))
svuint32x4_t svclamp_single_u32_x4(svuint32x4_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x4)))
svuint64x4_t svclamp_single_u64_x4(svuint64x4_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x4)))
svuint16x4_t svclamp_single_u16_x4(svuint16x4_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x2)))
svbfloat16_t svcvt_bf16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x2)))
svfloat16_t svcvt_f16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x2)))
svint32x2_t svcvt_s32_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x2)))
svuint32x2_t svcvt_u32_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x4)))
svint32x4_t svcvt_s32_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x4)))
svuint32x4_t svcvt_u32_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x2)))
svfloat32x2_t svcvt_f32_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x4)))
svfloat32x4_t svcvt_f32_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x2)))
svfloat32x2_t svcvt_f32_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x4)))
svfloat32x4_t svcvt_f32_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_bf16_f32_x2)))
svbfloat16_t svcvtn_bf16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_f16_f32_x2)))
svfloat16_t svcvtn_f16_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x2)))
svfloat64x2_t svmax_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x2)))
svfloat32x2_t svmax_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x2)))
svfloat16x2_t svmax_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x2)))
svint8x2_t svmax_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x2)))
svint32x2_t svmax_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x2)))
svint64x2_t svmax_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x2)))
svint16x2_t svmax_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x2)))
svuint8x2_t svmax_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x2)))
svuint32x2_t svmax_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x2)))
svuint64x2_t svmax_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x2)))
svuint16x2_t svmax_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x4)))
svfloat64x4_t svmax_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x4)))
svfloat32x4_t svmax_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x4)))
svfloat16x4_t svmax_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x4)))
svint8x4_t svmax_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x4)))
svint32x4_t svmax_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x4)))
svint64x4_t svmax_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x4)))
svint16x4_t svmax_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x4)))
svuint8x4_t svmax_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x4)))
svuint32x4_t svmax_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x4)))
svuint64x4_t svmax_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x4)))
svuint16x4_t svmax_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x2)))
svfloat64x2_t svmax_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x2)))
svfloat32x2_t svmax_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x2)))
svfloat16x2_t svmax_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x2)))
svint8x2_t svmax_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x2)))
svint32x2_t svmax_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x2)))
svint64x2_t svmax_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x2)))
svint16x2_t svmax_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x2)))
svuint8x2_t svmax_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x2)))
svuint32x2_t svmax_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x2)))
svuint64x2_t svmax_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x2)))
svuint16x2_t svmax_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x4)))
svfloat64x4_t svmax_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x4)))
svfloat32x4_t svmax_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x4)))
svfloat16x4_t svmax_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x4)))
svint8x4_t svmax_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x4)))
svint32x4_t svmax_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x4)))
svint64x4_t svmax_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x4)))
svint16x4_t svmax_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x4)))
svuint8x4_t svmax_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x4)))
svuint32x4_t svmax_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x4)))
svuint64x4_t svmax_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x4)))
svuint16x4_t svmax_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x2)))
svfloat64x2_t svmaxnm_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x2)))
svfloat32x2_t svmaxnm_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x2)))
svfloat16x2_t svmaxnm_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x4)))
svfloat64x4_t svmaxnm_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x4)))
svfloat32x4_t svmaxnm_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x4)))
svfloat16x4_t svmaxnm_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x2)))
svfloat64x2_t svmaxnm_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x2)))
svfloat32x2_t svmaxnm_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x2)))
svfloat16x2_t svmaxnm_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x4)))
svfloat64x4_t svmaxnm_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x4)))
svfloat32x4_t svmaxnm_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x4)))
svfloat16x4_t svmaxnm_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x2)))
svfloat64x2_t svmin_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x2)))
svfloat32x2_t svmin_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x2)))
svfloat16x2_t svmin_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x2)))
svint8x2_t svmin_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x2)))
svint32x2_t svmin_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x2)))
svint64x2_t svmin_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x2)))
svint16x2_t svmin_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x2)))
svuint8x2_t svmin_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x2)))
svuint32x2_t svmin_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x2)))
svuint64x2_t svmin_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x2)))
svuint16x2_t svmin_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x4)))
svfloat64x4_t svmin_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x4)))
svfloat32x4_t svmin_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x4)))
svfloat16x4_t svmin_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x4)))
svint8x4_t svmin_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x4)))
svint32x4_t svmin_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x4)))
svint64x4_t svmin_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x4)))
svint16x4_t svmin_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x4)))
svuint8x4_t svmin_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x4)))
svuint32x4_t svmin_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x4)))
svuint64x4_t svmin_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x4)))
svuint16x4_t svmin_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x2)))
svfloat64x2_t svmin_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x2)))
svfloat32x2_t svmin_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x2)))
svfloat16x2_t svmin_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x2)))
svint8x2_t svmin_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x2)))
svint32x2_t svmin_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x2)))
svint64x2_t svmin_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x2)))
svint16x2_t svmin_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x2)))
svuint8x2_t svmin_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x2)))
svuint32x2_t svmin_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x2)))
svuint64x2_t svmin_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x2)))
svuint16x2_t svmin_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x4)))
svfloat64x4_t svmin_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x4)))
svfloat32x4_t svmin_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x4)))
svfloat16x4_t svmin_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x4)))
svint8x4_t svmin_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x4)))
svint32x4_t svmin_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x4)))
svint64x4_t svmin_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x4)))
svint16x4_t svmin_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x4)))
svuint8x4_t svmin_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x4)))
svuint32x4_t svmin_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x4)))
svuint64x4_t svmin_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x4)))
svuint16x4_t svmin_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x2)))
svfloat64x2_t svminnm_single_f64_x2(svfloat64x2_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x2)))
svfloat32x2_t svminnm_single_f32_x2(svfloat32x2_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x2)))
svfloat16x2_t svminnm_single_f16_x2(svfloat16x2_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x4)))
svfloat64x4_t svminnm_single_f64_x4(svfloat64x4_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x4)))
svfloat32x4_t svminnm_single_f32_x4(svfloat32x4_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x4)))
svfloat16x4_t svminnm_single_f16_x4(svfloat16x4_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x2)))
svfloat64x2_t svminnm_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x2)))
svfloat32x2_t svminnm_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x2)))
svfloat16x2_t svminnm_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x4)))
svfloat64x4_t svminnm_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x4)))
svfloat32x4_t svminnm_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x4)))
svfloat16x4_t svminnm_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s32_x2)))
svint16_t svqcvt_s16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s64_x4)))
svint16_t svqcvt_s16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s8_s32_x4)))
svint8_t svqcvt_s8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s32_x2)))
svuint16_t svqcvt_u16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u32_x2)))
svuint16_t svqcvt_u16_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s64_x4)))
svuint16_t svqcvt_u16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u64_x4)))
svuint16_t svqcvt_u16_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_s32_x4)))
svuint8_t svqcvt_u8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_u32_x4)))
svuint8_t svqcvt_u8_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s64_x4)))
svint16_t svqcvtn_s16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s8_s32_x4)))
svint8_t svqcvtn_s8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s64_x4)))
svuint16_t svqcvtn_u16_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u64_x4)))
svuint16_t svqcvtn_u16_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_s32_x4)))
svuint8_t svqcvtn_u8_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_u32_x4)))
svuint8_t svqcvtn_u8_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x2)))
svint8x2_t svqdmulh_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x2)))
svint32x2_t svqdmulh_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x2)))
svint64x2_t svqdmulh_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x2)))
svint16x2_t svqdmulh_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x4)))
svint8x4_t svqdmulh_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x4)))
svint32x4_t svqdmulh_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x4)))
svint64x4_t svqdmulh_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x4)))
svint16x4_t svqdmulh_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x2)))
svint8x2_t svqdmulh_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x2)))
svint32x2_t svqdmulh_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x2)))
svint64x2_t svqdmulh_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x2)))
svint16x2_t svqdmulh_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x4)))
svint8x4_t svqdmulh_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x4)))
svint32x4_t svqdmulh_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x4)))
svint64x4_t svqdmulh_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x4)))
svint16x4_t svqdmulh_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s32_x2)))
svint16_t svqrshr_n_s16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u32_x2)))
svuint16_t svqrshr_n_u16_u32_x2(svuint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s8_s32_x4)))
svint8_t svqrshr_n_s8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s64_x4)))
svint16_t svqrshr_n_s16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u8_u32_x4)))
svuint8_t svqrshr_n_u8_u32_x4(svuint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u64_x4)))
svuint16_t svqrshr_n_u16_u64_x4(svuint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s8_s32_x4)))
svint8_t svqrshrn_n_s8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s64_x4)))
svint16_t svqrshrn_n_s16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u8_u32_x4)))
svuint8_t svqrshrn_n_u8_u32_x4(svuint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u64_x4)))
svuint16_t svqrshrn_n_u16_u64_x4(svuint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s32_x2)))
svuint16_t svqrshru_n_u16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u8_s32_x4)))
svuint8_t svqrshru_n_u8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s64_x4)))
svuint16_t svqrshru_n_u16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u8_s32_x4)))
svuint8_t svqrshrun_n_u8_s32_x4(svint32x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s64_x4)))
svuint16_t svqrshrun_n_u16_s64_x4(svint64x4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x2)))
svfloat32x2_t svrinta_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x4)))
svfloat32x4_t svrinta_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x2)))
svfloat32x2_t svrintm_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x4)))
svfloat32x4_t svrintm_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x2)))
svfloat32x2_t svrintn_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x4)))
svfloat32x4_t svrintn_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x2)))
svfloat32x2_t svrintp_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x4)))
svfloat32x4_t svrintp_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x2)))
svint8x2_t svrshl_single_s8_x2(svint8x2_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x2)))
svint32x2_t svrshl_single_s32_x2(svint32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x2)))
svint64x2_t svrshl_single_s64_x2(svint64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x2)))
svint16x2_t svrshl_single_s16_x2(svint16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x2)))
svuint8x2_t svrshl_single_u8_x2(svuint8x2_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x2)))
svuint32x2_t svrshl_single_u32_x2(svuint32x2_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x2)))
svuint64x2_t svrshl_single_u64_x2(svuint64x2_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x2)))
svuint16x2_t svrshl_single_u16_x2(svuint16x2_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x4)))
svint8x4_t svrshl_single_s8_x4(svint8x4_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x4)))
svint32x4_t svrshl_single_s32_x4(svint32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x4)))
svint64x4_t svrshl_single_s64_x4(svint64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x4)))
svint16x4_t svrshl_single_s16_x4(svint16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x4)))
svuint8x4_t svrshl_single_u8_x4(svuint8x4_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x4)))
svuint32x4_t svrshl_single_u32_x4(svuint32x4_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x4)))
svuint64x4_t svrshl_single_u64_x4(svuint64x4_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x4)))
svuint16x4_t svrshl_single_u16_x4(svuint16x4_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x2)))
svint8x2_t svrshl_s8_x2(svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x2)))
svint32x2_t svrshl_s32_x2(svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x2)))
svint64x2_t svrshl_s64_x2(svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x2)))
svint16x2_t svrshl_s16_x2(svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x2)))
svuint8x2_t svrshl_u8_x2(svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x2)))
svuint32x2_t svrshl_u32_x2(svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x2)))
svuint64x2_t svrshl_u64_x2(svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x2)))
svuint16x2_t svrshl_u16_x2(svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x4)))
svint8x4_t svrshl_s8_x4(svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x4)))
svint32x4_t svrshl_s32_x4(svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x4)))
svint64x4_t svrshl_s64_x4(svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x4)))
svint16x4_t svrshl_s16_x4(svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x4)))
svuint8x4_t svrshl_u8_x4(svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x4)))
svuint32x4_t svrshl_u32_x4(svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x4)))
svuint64x4_t svrshl_u64_x4(svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x4)))
svuint16x4_t svrshl_u16_x4(svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x2)))
svuint8x2_t svsel_u8_x2(svcount_t, svuint8x2_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x2)))
svuint32x2_t svsel_u32_x2(svcount_t, svuint32x2_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x2)))
svuint64x2_t svsel_u64_x2(svcount_t, svuint64x2_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x2)))
svuint16x2_t svsel_u16_x2(svcount_t, svuint16x2_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x2)))
svbfloat16x2_t svsel_bf16_x2(svcount_t, svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x2)))
svint8x2_t svsel_s8_x2(svcount_t, svint8x2_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x2)))
svfloat64x2_t svsel_f64_x2(svcount_t, svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x2)))
svfloat32x2_t svsel_f32_x2(svcount_t, svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x2)))
svfloat16x2_t svsel_f16_x2(svcount_t, svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x2)))
svint32x2_t svsel_s32_x2(svcount_t, svint32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x2)))
svint64x2_t svsel_s64_x2(svcount_t, svint64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_mf8_x2)))
svmfloat8x2_t svsel_mf8_x2(svcount_t, svmfloat8x2_t, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x2)))
svint16x2_t svsel_s16_x2(svcount_t, svint16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x4)))
svuint8x4_t svsel_u8_x4(svcount_t, svuint8x4_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x4)))
svuint32x4_t svsel_u32_x4(svcount_t, svuint32x4_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x4)))
svuint64x4_t svsel_u64_x4(svcount_t, svuint64x4_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x4)))
svuint16x4_t svsel_u16_x4(svcount_t, svuint16x4_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x4)))
svbfloat16x4_t svsel_bf16_x4(svcount_t, svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x4)))
svint8x4_t svsel_s8_x4(svcount_t, svint8x4_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x4)))
svfloat64x4_t svsel_f64_x4(svcount_t, svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x4)))
svfloat32x4_t svsel_f32_x4(svcount_t, svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x4)))
svfloat16x4_t svsel_f16_x4(svcount_t, svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x4)))
svint32x4_t svsel_s32_x4(svcount_t, svint32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x4)))
svint64x4_t svsel_s64_x4(svcount_t, svint64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_mf8_x4)))
svmfloat8x4_t svsel_mf8_x4(svcount_t, svmfloat8x4_t, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x4)))
svint16x4_t svsel_s16_x4(svcount_t, svint16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x2)))
svint32x2_t svunpk_s32_s16_x2(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x2)))
svint64x2_t svunpk_s64_s32_x2(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x2)))
svint16x2_t svunpk_s16_s8_x2(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x2)))
svuint32x2_t svunpk_u32_u16_x2(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x2)))
svuint64x2_t svunpk_u64_u32_x2(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x2)))
svuint16x2_t svunpk_u16_u8_x2(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x4)))
svint32x4_t svunpk_s32_s16_x4(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x4)))
svint64x4_t svunpk_s64_s32_x4(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x4)))
svint16x4_t svunpk_s16_s8_x4(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x4)))
svuint32x4_t svunpk_u32_u16_x4(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x4)))
svuint64x4_t svunpk_u64_u32_x4(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x4)))
svuint16x4_t svunpk_u16_u8_x4(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x2)))
svuint8x2_t svuzp_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x2)))
svuint32x2_t svuzp_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x2)))
svuint64x2_t svuzp_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x2)))
svuint16x2_t svuzp_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x2)))
svbfloat16x2_t svuzp_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x2)))
svint8x2_t svuzp_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x2)))
svfloat64x2_t svuzp_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x2)))
svfloat32x2_t svuzp_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x2)))
svfloat16x2_t svuzp_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x2)))
svint32x2_t svuzp_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x2)))
svint64x2_t svuzp_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_mf8_x2)))
svmfloat8x2_t svuzp_mf8_x2(svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x2)))
svint16x2_t svuzp_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x4)))
svuint8x4_t svuzp_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x4)))
svuint32x4_t svuzp_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x4)))
svuint64x4_t svuzp_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x4)))
svuint16x4_t svuzp_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x4)))
svbfloat16x4_t svuzp_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x4)))
svint8x4_t svuzp_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x4)))
svfloat64x4_t svuzp_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x4)))
svfloat32x4_t svuzp_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x4)))
svfloat16x4_t svuzp_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x4)))
svint32x4_t svuzp_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x4)))
svint64x4_t svuzp_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_mf8_x4)))
svmfloat8x4_t svuzp_mf8_x4(svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x4)))
svint16x4_t svuzp_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x2)))
svuint8x2_t svuzpq_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x2)))
svuint32x2_t svuzpq_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x2)))
svuint64x2_t svuzpq_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x2)))
svuint16x2_t svuzpq_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x2)))
svbfloat16x2_t svuzpq_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x2)))
svint8x2_t svuzpq_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x2)))
svfloat64x2_t svuzpq_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x2)))
svfloat32x2_t svuzpq_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x2)))
svfloat16x2_t svuzpq_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x2)))
svint32x2_t svuzpq_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x2)))
svint64x2_t svuzpq_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_mf8_x2)))
svmfloat8x2_t svuzpq_mf8_x2(svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x2)))
svint16x2_t svuzpq_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x4)))
svuint8x4_t svuzpq_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x4)))
svuint32x4_t svuzpq_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x4)))
svuint64x4_t svuzpq_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x4)))
svuint16x4_t svuzpq_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x4)))
svbfloat16x4_t svuzpq_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x4)))
svint8x4_t svuzpq_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x4)))
svfloat64x4_t svuzpq_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x4)))
svfloat32x4_t svuzpq_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x4)))
svfloat16x4_t svuzpq_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x4)))
svint32x4_t svuzpq_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x4)))
svint64x4_t svuzpq_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_mf8_x4)))
svmfloat8x4_t svuzpq_mf8_x4(svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x4)))
svint16x4_t svuzpq_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x2)))
svuint8x2_t svzip_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x2)))
svuint32x2_t svzip_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x2)))
svuint64x2_t svzip_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x2)))
svuint16x2_t svzip_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x2)))
svbfloat16x2_t svzip_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x2)))
svint8x2_t svzip_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x2)))
svfloat64x2_t svzip_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x2)))
svfloat32x2_t svzip_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x2)))
svfloat16x2_t svzip_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x2)))
svint32x2_t svzip_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x2)))
svint64x2_t svzip_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_mf8_x2)))
svmfloat8x2_t svzip_mf8_x2(svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x2)))
svint16x2_t svzip_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x4)))
svuint8x4_t svzip_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x4)))
svuint32x4_t svzip_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x4)))
svuint64x4_t svzip_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x4)))
svuint16x4_t svzip_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x4)))
svbfloat16x4_t svzip_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x4)))
svint8x4_t svzip_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x4)))
svfloat64x4_t svzip_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x4)))
svfloat32x4_t svzip_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x4)))
svfloat16x4_t svzip_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x4)))
svint32x4_t svzip_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x4)))
svint64x4_t svzip_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_mf8_x4)))
svmfloat8x4_t svzip_mf8_x4(svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x4)))
svint16x4_t svzip_s16_x4(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x2)))
svuint8x2_t svzipq_u8_x2(svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x2)))
svuint32x2_t svzipq_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x2)))
svuint64x2_t svzipq_u64_x2(svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x2)))
svuint16x2_t svzipq_u16_x2(svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x2)))
svbfloat16x2_t svzipq_bf16_x2(svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x2)))
svint8x2_t svzipq_s8_x2(svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x2)))
svfloat64x2_t svzipq_f64_x2(svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x2)))
svfloat32x2_t svzipq_f32_x2(svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x2)))
svfloat16x2_t svzipq_f16_x2(svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x2)))
svint32x2_t svzipq_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x2)))
svint64x2_t svzipq_s64_x2(svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_mf8_x2)))
svmfloat8x2_t svzipq_mf8_x2(svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x2)))
svint16x2_t svzipq_s16_x2(svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x4)))
svuint8x4_t svzipq_u8_x4(svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x4)))
svuint32x4_t svzipq_u32_x4(svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x4)))
svuint64x4_t svzipq_u64_x4(svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x4)))
svuint16x4_t svzipq_u16_x4(svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x4)))
svbfloat16x4_t svzipq_bf16_x4(svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x4)))
svint8x4_t svzipq_s8_x4(svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x4)))
svfloat64x4_t svzipq_f64_x4(svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x4)))
svfloat32x4_t svzipq_f32_x4(svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x4)))
svfloat16x4_t svzipq_f16_x4(svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x4)))
svint32x4_t svzipq_s32_x4(svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x4)))
svint64x4_t svzipq_s64_x4(svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_mf8_x4)))
svmfloat8x4_t svzipq_mf8_x4(svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x4)))
svint16x4_t svzipq_s16_x4(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x2)))
svuint8x2_t svadd(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x2)))
svuint32x2_t svadd(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x2)))
svuint64x2_t svadd(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x2)))
svuint16x2_t svadd(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x2)))
svint8x2_t svadd(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x2)))
svint32x2_t svadd(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x2)))
svint64x2_t svadd(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x2)))
svint16x2_t svadd(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u8_x4)))
svuint8x4_t svadd(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u32_x4)))
svuint32x4_t svadd(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u64_x4)))
svuint64x4_t svadd(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_u16_x4)))
svuint16x4_t svadd(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s8_x4)))
svint8x4_t svadd(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s32_x4)))
svint32x4_t svadd(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s64_x4)))
svint64x4_t svadd(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_single_s16_x4)))
svint16x4_t svadd(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x2)))
svfloat64x2_t svclamp(svfloat64x2_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x2)))
svfloat32x2_t svclamp(svfloat32x2_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x2)))
svfloat16x2_t svclamp(svfloat16x2_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x2)))
svint8x2_t svclamp(svint8x2_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x2)))
svint32x2_t svclamp(svint32x2_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x2)))
svint64x2_t svclamp(svint64x2_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x2)))
svint16x2_t svclamp(svint16x2_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x2)))
svuint8x2_t svclamp(svuint8x2_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x2)))
svuint32x2_t svclamp(svuint32x2_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x2)))
svuint64x2_t svclamp(svuint64x2_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x2)))
svuint16x2_t svclamp(svuint16x2_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f64_x4)))
svfloat64x4_t svclamp(svfloat64x4_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f32_x4)))
svfloat32x4_t svclamp(svfloat32x4_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_f16_x4)))
svfloat16x4_t svclamp(svfloat16x4_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s8_x4)))
svint8x4_t svclamp(svint8x4_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s32_x4)))
svint32x4_t svclamp(svint32x4_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s64_x4)))
svint64x4_t svclamp(svint64x4_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_s16_x4)))
svint16x4_t svclamp(svint16x4_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u8_x4)))
svuint8x4_t svclamp(svuint8x4_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u32_x4)))
svuint32x4_t svclamp(svuint32x4_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u64_x4)))
svuint64x4_t svclamp(svuint64x4_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_u16_x4)))
svuint16x4_t svclamp(svuint16x4_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x2)))
svbfloat16_t svcvt_bf16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f16_f32_x2)))
svfloat16_t svcvt_f16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x2)))
svint32x2_t svcvt_s32(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x2)))
svuint32x2_t svcvt_u32(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_s32_f32_x4)))
svint32x4_t svcvt_s32(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_u32_f32_x4)))
svuint32x4_t svcvt_u32(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x2)))
svfloat32x2_t svcvt_f32(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_s32_x4)))
svfloat32x4_t svcvt_f32(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x2)))
svfloat32x2_t svcvt_f32(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_f32_u32_x4)))
svfloat32x4_t svcvt_f32(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_bf16_f32_x2)))
svbfloat16_t svcvtn_bf16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_f16_f32_x2)))
svfloat16_t svcvtn_f16(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x2)))
svfloat64x2_t svmax(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x2)))
svfloat32x2_t svmax(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x2)))
svfloat16x2_t svmax(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x2)))
svint8x2_t svmax(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x2)))
svint32x2_t svmax(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x2)))
svint64x2_t svmax(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x2)))
svint16x2_t svmax(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x2)))
svuint8x2_t svmax(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x2)))
svuint32x2_t svmax(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x2)))
svuint64x2_t svmax(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x2)))
svuint16x2_t svmax(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f64_x4)))
svfloat64x4_t svmax(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f32_x4)))
svfloat32x4_t svmax(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_f16_x4)))
svfloat16x4_t svmax(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s8_x4)))
svint8x4_t svmax(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s32_x4)))
svint32x4_t svmax(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s64_x4)))
svint64x4_t svmax(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_s16_x4)))
svint16x4_t svmax(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u8_x4)))
svuint8x4_t svmax(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u32_x4)))
svuint32x4_t svmax(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u64_x4)))
svuint64x4_t svmax(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_u16_x4)))
svuint16x4_t svmax(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x2)))
svfloat64x2_t svmax(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x2)))
svfloat32x2_t svmax(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x2)))
svfloat16x2_t svmax(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x2)))
svint8x2_t svmax(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x2)))
svint32x2_t svmax(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x2)))
svint64x2_t svmax(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x2)))
svint16x2_t svmax(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x2)))
svuint8x2_t svmax(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x2)))
svuint32x2_t svmax(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x2)))
svuint64x2_t svmax(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x2)))
svuint16x2_t svmax(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f64_x4)))
svfloat64x4_t svmax(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f32_x4)))
svfloat32x4_t svmax(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_f16_x4)))
svfloat16x4_t svmax(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s8_x4)))
svint8x4_t svmax(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s32_x4)))
svint32x4_t svmax(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s64_x4)))
svint64x4_t svmax(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_s16_x4)))
svint16x4_t svmax(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u8_x4)))
svuint8x4_t svmax(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u32_x4)))
svuint32x4_t svmax(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u64_x4)))
svuint64x4_t svmax(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_u16_x4)))
svuint16x4_t svmax(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x2)))
svfloat64x2_t svmaxnm(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x2)))
svfloat32x2_t svmaxnm(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x2)))
svfloat16x2_t svmaxnm(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f64_x4)))
svfloat64x4_t svmaxnm(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f32_x4)))
svfloat32x4_t svmaxnm(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_f16_x4)))
svfloat16x4_t svmaxnm(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x2)))
svfloat64x2_t svmaxnm(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x2)))
svfloat32x2_t svmaxnm(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x2)))
svfloat16x2_t svmaxnm(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f64_x4)))
svfloat64x4_t svmaxnm(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f32_x4)))
svfloat32x4_t svmaxnm(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_f16_x4)))
svfloat16x4_t svmaxnm(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x2)))
svfloat64x2_t svmin(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x2)))
svfloat32x2_t svmin(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x2)))
svfloat16x2_t svmin(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x2)))
svint8x2_t svmin(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x2)))
svint32x2_t svmin(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x2)))
svint64x2_t svmin(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x2)))
svint16x2_t svmin(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x2)))
svuint8x2_t svmin(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x2)))
svuint32x2_t svmin(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x2)))
svuint64x2_t svmin(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x2)))
svuint16x2_t svmin(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f64_x4)))
svfloat64x4_t svmin(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f32_x4)))
svfloat32x4_t svmin(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_f16_x4)))
svfloat16x4_t svmin(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s8_x4)))
svint8x4_t svmin(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s32_x4)))
svint32x4_t svmin(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s64_x4)))
svint64x4_t svmin(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_s16_x4)))
svint16x4_t svmin(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u8_x4)))
svuint8x4_t svmin(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u32_x4)))
svuint32x4_t svmin(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u64_x4)))
svuint64x4_t svmin(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_u16_x4)))
svuint16x4_t svmin(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x2)))
svfloat64x2_t svmin(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x2)))
svfloat32x2_t svmin(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x2)))
svfloat16x2_t svmin(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x2)))
svint8x2_t svmin(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x2)))
svint32x2_t svmin(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x2)))
svint64x2_t svmin(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x2)))
svint16x2_t svmin(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x2)))
svuint8x2_t svmin(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x2)))
svuint32x2_t svmin(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x2)))
svuint64x2_t svmin(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x2)))
svuint16x2_t svmin(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f64_x4)))
svfloat64x4_t svmin(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f32_x4)))
svfloat32x4_t svmin(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_f16_x4)))
svfloat16x4_t svmin(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s8_x4)))
svint8x4_t svmin(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s32_x4)))
svint32x4_t svmin(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s64_x4)))
svint64x4_t svmin(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_s16_x4)))
svint16x4_t svmin(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u8_x4)))
svuint8x4_t svmin(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u32_x4)))
svuint32x4_t svmin(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u64_x4)))
svuint64x4_t svmin(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_u16_x4)))
svuint16x4_t svmin(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x2)))
svfloat64x2_t svminnm(svfloat64x2_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x2)))
svfloat32x2_t svminnm(svfloat32x2_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x2)))
svfloat16x2_t svminnm(svfloat16x2_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f64_x4)))
svfloat64x4_t svminnm(svfloat64x4_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f32_x4)))
svfloat32x4_t svminnm(svfloat32x4_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_f16_x4)))
svfloat16x4_t svminnm(svfloat16x4_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x2)))
svfloat64x2_t svminnm(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x2)))
svfloat32x2_t svminnm(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x2)))
svfloat16x2_t svminnm(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f64_x4)))
svfloat64x4_t svminnm(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f32_x4)))
svfloat32x4_t svminnm(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_f16_x4)))
svfloat16x4_t svminnm(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s32_x2)))
svint16_t svqcvt_s16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s16_s64_x4)))
svint16_t svqcvt_s16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_s8_s32_x4)))
svint8_t svqcvt_s8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s32_x2)))
svuint16_t svqcvt_u16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u32_x2)))
svuint16_t svqcvt_u16(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_s64_x4)))
svuint16_t svqcvt_u16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u16_u64_x4)))
svuint16_t svqcvt_u16(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_s32_x4)))
svuint8_t svqcvt_u8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvt_u8_u32_x4)))
svuint8_t svqcvt_u8(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s64_x4)))
svint16_t svqcvtn_s16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s8_s32_x4)))
svint8_t svqcvtn_s8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s64_x4)))
svuint16_t svqcvtn_u16(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u64_x4)))
svuint16_t svqcvtn_u16(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_s32_x4)))
svuint8_t svqcvtn_u8(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u8_u32_x4)))
svuint8_t svqcvtn_u8(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x2)))
svint8x2_t svqdmulh(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x2)))
svint32x2_t svqdmulh(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x2)))
svint64x2_t svqdmulh(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x2)))
svint16x2_t svqdmulh(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s8_x4)))
svint8x4_t svqdmulh(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s32_x4)))
svint32x4_t svqdmulh(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s64_x4)))
svint64x4_t svqdmulh(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_single_s16_x4)))
svint16x4_t svqdmulh(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x2)))
svint8x2_t svqdmulh(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x2)))
svint32x2_t svqdmulh(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x2)))
svint64x2_t svqdmulh(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x2)))
svint16x2_t svqdmulh(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8_x4)))
svint8x4_t svqdmulh(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32_x4)))
svint32x4_t svqdmulh(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64_x4)))
svint64x4_t svqdmulh(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16_x4)))
svint16x4_t svqdmulh(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s32_x2)))
svint16_t svqrshr_s16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u32_x2)))
svuint16_t svqrshr_u16(svuint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s8_s32_x4)))
svint8_t svqrshr_s8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_s16_s64_x4)))
svint16_t svqrshr_s16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u8_u32_x4)))
svuint8_t svqrshr_u8(svuint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshr_n_u16_u64_x4)))
svuint16_t svqrshr_u16(svuint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s8_s32_x4)))
svint8_t svqrshrn_s8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s64_x4)))
svint16_t svqrshrn_s16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u8_u32_x4)))
svuint8_t svqrshrn_u8(svuint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u64_x4)))
svuint16_t svqrshrn_u16(svuint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s32_x2)))
svuint16_t svqrshru_u16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u8_s32_x4)))
svuint8_t svqrshru_u8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshru_n_u16_s64_x4)))
svuint16_t svqrshru_u16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u8_s32_x4)))
svuint8_t svqrshrun_u8(svint32x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s64_x4)))
svuint16_t svqrshrun_u16(svint64x4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x2)))
svfloat32x2_t svrinta(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrinta_f32_x4)))
svfloat32x4_t svrinta(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x2)))
svfloat32x2_t svrintm(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintm_f32_x4)))
svfloat32x4_t svrintm(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x2)))
svfloat32x2_t svrintn(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintn_f32_x4)))
svfloat32x4_t svrintn(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x2)))
svfloat32x2_t svrintp(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrintp_f32_x4)))
svfloat32x4_t svrintp(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x2)))
svint8x2_t svrshl(svint8x2_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x2)))
svint32x2_t svrshl(svint32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x2)))
svint64x2_t svrshl(svint64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x2)))
svint16x2_t svrshl(svint16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x2)))
svuint8x2_t svrshl(svuint8x2_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x2)))
svuint32x2_t svrshl(svuint32x2_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x2)))
svuint64x2_t svrshl(svuint64x2_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x2)))
svuint16x2_t svrshl(svuint16x2_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s8_x4)))
svint8x4_t svrshl(svint8x4_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s32_x4)))
svint32x4_t svrshl(svint32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s64_x4)))
svint64x4_t svrshl(svint64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_s16_x4)))
svint16x4_t svrshl(svint16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u8_x4)))
svuint8x4_t svrshl(svuint8x4_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u32_x4)))
svuint32x4_t svrshl(svuint32x4_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u64_x4)))
svuint64x4_t svrshl(svuint64x4_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_single_u16_x4)))
svuint16x4_t svrshl(svuint16x4_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x2)))
svint8x2_t svrshl(svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x2)))
svint32x2_t svrshl(svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x2)))
svint64x2_t svrshl(svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x2)))
svint16x2_t svrshl(svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x2)))
svuint8x2_t svrshl(svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x2)))
svuint32x2_t svrshl(svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x2)))
svuint64x2_t svrshl(svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x2)))
svuint16x2_t svrshl(svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s8_x4)))
svint8x4_t svrshl(svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s32_x4)))
svint32x4_t svrshl(svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s64_x4)))
svint64x4_t svrshl(svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_s16_x4)))
svint16x4_t svrshl(svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u8_x4)))
svuint8x4_t svrshl(svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u32_x4)))
svuint32x4_t svrshl(svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u64_x4)))
svuint64x4_t svrshl(svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrshl_u16_x4)))
svuint16x4_t svrshl(svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x2)))
svuint8x2_t svsel(svcount_t, svuint8x2_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x2)))
svuint32x2_t svsel(svcount_t, svuint32x2_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x2)))
svuint64x2_t svsel(svcount_t, svuint64x2_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x2)))
svuint16x2_t svsel(svcount_t, svuint16x2_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x2)))
svbfloat16x2_t svsel(svcount_t, svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x2)))
svint8x2_t svsel(svcount_t, svint8x2_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x2)))
svfloat64x2_t svsel(svcount_t, svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x2)))
svfloat32x2_t svsel(svcount_t, svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x2)))
svfloat16x2_t svsel(svcount_t, svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x2)))
svint32x2_t svsel(svcount_t, svint32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x2)))
svint64x2_t svsel(svcount_t, svint64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_mf8_x2)))
svmfloat8x2_t svsel(svcount_t, svmfloat8x2_t, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x2)))
svint16x2_t svsel(svcount_t, svint16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u8_x4)))
svuint8x4_t svsel(svcount_t, svuint8x4_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u32_x4)))
svuint32x4_t svsel(svcount_t, svuint32x4_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u64_x4)))
svuint64x4_t svsel(svcount_t, svuint64x4_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_u16_x4)))
svuint16x4_t svsel(svcount_t, svuint16x4_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_bf16_x4)))
svbfloat16x4_t svsel(svcount_t, svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s8_x4)))
svint8x4_t svsel(svcount_t, svint8x4_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f64_x4)))
svfloat64x4_t svsel(svcount_t, svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f32_x4)))
svfloat32x4_t svsel(svcount_t, svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_f16_x4)))
svfloat16x4_t svsel(svcount_t, svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s32_x4)))
svint32x4_t svsel(svcount_t, svint32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s64_x4)))
svint64x4_t svsel(svcount_t, svint64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_mf8_x4)))
svmfloat8x4_t svsel(svcount_t, svmfloat8x4_t, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsel_s16_x4)))
svint16x4_t svsel(svcount_t, svint16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x2)))
svint32x2_t svunpk_s32(svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x2)))
svint64x2_t svunpk_s64(svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x2)))
svint16x2_t svunpk_s16(svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x2)))
svuint32x2_t svunpk_u32(svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x2)))
svuint64x2_t svunpk_u64(svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x2)))
svuint16x2_t svunpk_u16(svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s32_s16_x4)))
svint32x4_t svunpk_s32(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s64_s32_x4)))
svint64x4_t svunpk_s64(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_s16_s8_x4)))
svint16x4_t svunpk_s16(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u32_u16_x4)))
svuint32x4_t svunpk_u32(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u64_u32_x4)))
svuint64x4_t svunpk_u64(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svunpk_u16_u8_x4)))
svuint16x4_t svunpk_u16(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x2)))
svuint8x2_t svuzp(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x2)))
svuint32x2_t svuzp(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x2)))
svuint64x2_t svuzp(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x2)))
svuint16x2_t svuzp(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x2)))
svbfloat16x2_t svuzp(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x2)))
svint8x2_t svuzp(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x2)))
svfloat64x2_t svuzp(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x2)))
svfloat32x2_t svuzp(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x2)))
svfloat16x2_t svuzp(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x2)))
svint32x2_t svuzp(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x2)))
svint64x2_t svuzp(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_mf8_x2)))
svmfloat8x2_t svuzp(svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x2)))
svint16x2_t svuzp(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u8_x4)))
svuint8x4_t svuzp(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u32_x4)))
svuint32x4_t svuzp(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u64_x4)))
svuint64x4_t svuzp(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_u16_x4)))
svuint16x4_t svuzp(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_bf16_x4)))
svbfloat16x4_t svuzp(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s8_x4)))
svint8x4_t svuzp(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f64_x4)))
svfloat64x4_t svuzp(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f32_x4)))
svfloat32x4_t svuzp(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_f16_x4)))
svfloat16x4_t svuzp(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s32_x4)))
svint32x4_t svuzp(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s64_x4)))
svint64x4_t svuzp(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_mf8_x4)))
svmfloat8x4_t svuzp(svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp_s16_x4)))
svint16x4_t svuzp(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x2)))
svuint8x2_t svuzpq(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x2)))
svuint32x2_t svuzpq(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x2)))
svuint64x2_t svuzpq(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x2)))
svuint16x2_t svuzpq(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x2)))
svbfloat16x2_t svuzpq(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x2)))
svint8x2_t svuzpq(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x2)))
svfloat64x2_t svuzpq(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x2)))
svfloat32x2_t svuzpq(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x2)))
svfloat16x2_t svuzpq(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x2)))
svint32x2_t svuzpq(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x2)))
svint64x2_t svuzpq(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_mf8_x2)))
svmfloat8x2_t svuzpq(svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x2)))
svint16x2_t svuzpq(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u8_x4)))
svuint8x4_t svuzpq(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u32_x4)))
svuint32x4_t svuzpq(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u64_x4)))
svuint64x4_t svuzpq(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_u16_x4)))
svuint16x4_t svuzpq(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_bf16_x4)))
svbfloat16x4_t svuzpq(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s8_x4)))
svint8x4_t svuzpq(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f64_x4)))
svfloat64x4_t svuzpq(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f32_x4)))
svfloat32x4_t svuzpq(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_f16_x4)))
svfloat16x4_t svuzpq(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s32_x4)))
svint32x4_t svuzpq(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s64_x4)))
svint64x4_t svuzpq(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_mf8_x4)))
svmfloat8x4_t svuzpq(svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq_s16_x4)))
svint16x4_t svuzpq(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x2)))
svuint8x2_t svzip(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x2)))
svuint32x2_t svzip(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x2)))
svuint64x2_t svzip(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x2)))
svuint16x2_t svzip(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x2)))
svbfloat16x2_t svzip(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x2)))
svint8x2_t svzip(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x2)))
svfloat64x2_t svzip(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x2)))
svfloat32x2_t svzip(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x2)))
svfloat16x2_t svzip(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x2)))
svint32x2_t svzip(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x2)))
svint64x2_t svzip(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_mf8_x2)))
svmfloat8x2_t svzip(svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x2)))
svint16x2_t svzip(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u8_x4)))
svuint8x4_t svzip(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u32_x4)))
svuint32x4_t svzip(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u64_x4)))
svuint64x4_t svzip(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_u16_x4)))
svuint16x4_t svzip(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_bf16_x4)))
svbfloat16x4_t svzip(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s8_x4)))
svint8x4_t svzip(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f64_x4)))
svfloat64x4_t svzip(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f32_x4)))
svfloat32x4_t svzip(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_f16_x4)))
svfloat16x4_t svzip(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s32_x4)))
svint32x4_t svzip(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s64_x4)))
svint64x4_t svzip(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_mf8_x4)))
svmfloat8x4_t svzip(svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip_s16_x4)))
svint16x4_t svzip(svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x2)))
svuint8x2_t svzipq(svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x2)))
svuint32x2_t svzipq(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x2)))
svuint64x2_t svzipq(svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x2)))
svuint16x2_t svzipq(svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x2)))
svbfloat16x2_t svzipq(svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x2)))
svint8x2_t svzipq(svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x2)))
svfloat64x2_t svzipq(svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x2)))
svfloat32x2_t svzipq(svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x2)))
svfloat16x2_t svzipq(svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x2)))
svint32x2_t svzipq(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x2)))
svint64x2_t svzipq(svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_mf8_x2)))
svmfloat8x2_t svzipq(svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x2)))
svint16x2_t svzipq(svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u8_x4)))
svuint8x4_t svzipq(svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u32_x4)))
svuint32x4_t svzipq(svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u64_x4)))
svuint64x4_t svzipq(svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_u16_x4)))
svuint16x4_t svzipq(svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_bf16_x4)))
svbfloat16x4_t svzipq(svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s8_x4)))
svint8x4_t svzipq(svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f64_x4)))
svfloat64x4_t svzipq(svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f32_x4)))
svfloat32x4_t svzipq(svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_f16_x4)))
svfloat16x4_t svzipq(svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s32_x4)))
svint32x4_t svzipq(svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s64_x4)))
svint64x4_t svzipq(svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_mf8_x4)))
svmfloat8x4_t svzipq(svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq_s16_x4)))
svint16x4_t svzipq(svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x2)))
svfloat64x2_t svamax_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x2)))
svfloat32x2_t svamax_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x2)))
svfloat16x2_t svamax_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x4)))
svfloat64x4_t svamax_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x4)))
svfloat32x4_t svamax_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x4)))
svfloat16x4_t svamax_f16_x4(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x2)))
svfloat64x2_t svamin_f64_x2(svfloat64x2_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x2)))
svfloat32x2_t svamin_f32_x2(svfloat32x2_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x2)))
svfloat16x2_t svamin_f16_x2(svfloat16x2_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x4)))
svfloat64x4_t svamin_f64_x4(svfloat64x4_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x4)))
svfloat32x4_t svamin_f32_x4(svfloat32x4_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x4)))
svfloat16x4_t svamin_f16_x4(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x2)))
svfloat64x2_t svamax(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x2)))
svfloat32x2_t svamax(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x2)))
svfloat16x2_t svamax(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x4)))
svfloat64x4_t svamax(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x4)))
svfloat32x4_t svamax(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x4)))
svfloat16x4_t svamax(svfloat16x4_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x2)))
svfloat64x2_t svamin(svfloat64x2_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x2)))
svfloat32x2_t svamin(svfloat32x2_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x2)))
svfloat16x2_t svamin(svfloat16x2_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x4)))
svfloat64x4_t svamin(svfloat64x4_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x4)))
svfloat32x4_t svamin(svfloat32x4_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x4)))
svfloat16x4_t svamin(svfloat16x4_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvt1_bf16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_f16_mf8_x2_fpm)))
svfloat16x2_t svcvt1_f16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvt2_bf16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_f16_mf8_x2_fpm)))
svfloat16x2_t svcvt2_f16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_bf16_x2_fpm)))
svmfloat8_t svcvt_mf8_bf16_x2_fpm(svbfloat16x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_f16_x2_fpm)))
svmfloat8_t svcvt_mf8_f16_x2_fpm(svfloat16x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_f32_x4_fpm)))
svmfloat8_t svcvt_mf8_f32_x4_fpm(svfloat32x4_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl1_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvtl1_bf16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl1_f16_mf8_x2_fpm)))
svfloat16x2_t svcvtl1_f16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl2_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvtl2_bf16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl2_f16_mf8_x2_fpm)))
svfloat16x2_t svcvtl2_f16_mf8_x2_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_f32_x4_fpm)))
svmfloat8_t svcvtn_mf8_f32_x4_fpm(svfloat32x4_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f64_x2)))
svfloat64x2_t svscale_single_f64_x2(svfloat64x2_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f32_x2)))
svfloat32x2_t svscale_single_f32_x2(svfloat32x2_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f16_x2)))
svfloat16x2_t svscale_single_f16_x2(svfloat16x2_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f64_x4)))
svfloat64x4_t svscale_single_f64_x4(svfloat64x4_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f32_x4)))
svfloat32x4_t svscale_single_f32_x4(svfloat32x4_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f16_x4)))
svfloat16x4_t svscale_single_f16_x4(svfloat16x4_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_x2)))
svfloat64x2_t svscale_f64_x2(svfloat64x2_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_x2)))
svfloat32x2_t svscale_f32_x2(svfloat32x2_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_x2)))
svfloat16x2_t svscale_f16_x2(svfloat16x2_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_x4)))
svfloat64x4_t svscale_f64_x4(svfloat64x4_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_x4)))
svfloat32x4_t svscale_f32_x4(svfloat32x4_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_x4)))
svfloat16x4_t svscale_f16_x4(svfloat16x4_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvt1_bf16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_f16_mf8_x2_fpm)))
svfloat16x2_t svcvt1_f16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvt2_bf16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_f16_mf8_x2_fpm)))
svfloat16x2_t svcvt2_f16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_bf16_x2_fpm)))
svmfloat8_t svcvt_mf8_fpm(svbfloat16x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_f16_x2_fpm)))
svmfloat8_t svcvt_mf8_fpm(svfloat16x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_mf8_f32_x4_fpm)))
svmfloat8_t svcvt_mf8_fpm(svfloat32x4_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl1_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvtl1_bf16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl1_f16_mf8_x2_fpm)))
svfloat16x2_t svcvtl1_f16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl2_bf16_mf8_x2_fpm)))
svbfloat16x2_t svcvtl2_bf16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtl2_f16_mf8_x2_fpm)))
svfloat16x2_t svcvtl2_f16_x2_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_f32_x4_fpm)))
svmfloat8_t svcvtn_mf8_fpm(svfloat32x4_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f64_x2)))
svfloat64x2_t svscale(svfloat64x2_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f32_x2)))
svfloat32x2_t svscale(svfloat32x2_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f16_x2)))
svfloat16x2_t svscale(svfloat16x2_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f64_x4)))
svfloat64x4_t svscale(svfloat64x4_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f32_x4)))
svfloat32x4_t svscale(svfloat32x4_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_single_f16_x4)))
svfloat16x4_t svscale(svfloat16x4_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_x2)))
svfloat64x2_t svscale(svfloat64x2_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_x2)))
svfloat32x2_t svscale(svfloat32x2_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_x2)))
svfloat16x2_t svscale(svfloat16x2_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f64_x4)))
svfloat64x4_t svscale(svfloat64x4_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f32_x4)))
svfloat32x4_t svscale(svfloat32x4_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svscale_f16_x4)))
svfloat16x4_t svscale(svfloat16x4_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_bf16_x2)))
svbfloat16x2_t svclamp_single_bf16_x2(svbfloat16x2_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_bf16_x4)))
svbfloat16x4_t svclamp_single_bf16_x4(svbfloat16x4_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_bf16_x2)))
svbfloat16x2_t svmax_single_bf16_x2(svbfloat16x2_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_bf16_x4)))
svbfloat16x4_t svmax_single_bf16_x4(svbfloat16x4_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x2)))
svbfloat16x2_t svmax_bf16_x2(svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x4)))
svbfloat16x4_t svmax_bf16_x4(svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_bf16_x2)))
svbfloat16x2_t svmaxnm_single_bf16_x2(svbfloat16x2_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_bf16_x4)))
svbfloat16x4_t svmaxnm_single_bf16_x4(svbfloat16x4_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x2)))
svbfloat16x2_t svmaxnm_bf16_x2(svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x4)))
svbfloat16x4_t svmaxnm_bf16_x4(svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_bf16_x2)))
svbfloat16x2_t svmin_single_bf16_x2(svbfloat16x2_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_bf16_x4)))
svbfloat16x4_t svmin_single_bf16_x4(svbfloat16x4_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x2)))
svbfloat16x2_t svmin_bf16_x2(svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x4)))
svbfloat16x4_t svmin_bf16_x4(svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_bf16_x2)))
svbfloat16x2_t svminnm_single_bf16_x2(svbfloat16x2_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_bf16_x4)))
svbfloat16x4_t svminnm_single_bf16_x4(svbfloat16x4_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x2)))
svbfloat16x2_t svminnm_bf16_x2(svbfloat16x2_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x4)))
svbfloat16x4_t svminnm_bf16_x4(svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_bf16_x2)))
svbfloat16x2_t svclamp(svbfloat16x2_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_single_bf16_x4)))
svbfloat16x4_t svclamp(svbfloat16x4_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_bf16_x2)))
svbfloat16x2_t svmax(svbfloat16x2_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_single_bf16_x4)))
svbfloat16x4_t svmax(svbfloat16x4_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x2)))
svbfloat16x2_t svmax(svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x4)))
svbfloat16x4_t svmax(svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_bf16_x2)))
svbfloat16x2_t svmaxnm(svbfloat16x2_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_single_bf16_x4)))
svbfloat16x4_t svmaxnm(svbfloat16x4_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x2)))
svbfloat16x2_t svmaxnm(svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x4)))
svbfloat16x4_t svmaxnm(svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_bf16_x2)))
svbfloat16x2_t svmin(svbfloat16x2_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_single_bf16_x4)))
svbfloat16x4_t svmin(svbfloat16x4_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x2)))
svbfloat16x2_t svmin(svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x4)))
svbfloat16x4_t svmin(svbfloat16x4_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_bf16_x2)))
svbfloat16x2_t svminnm(svbfloat16x2_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_single_bf16_x4)))
svbfloat16x4_t svminnm(svbfloat16x4_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x2)))
svbfloat16x2_t svminnm(svbfloat16x2_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x4)))
svbfloat16x4_t svminnm(svbfloat16x4_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f64)))
float64_t svadda_f64(svbool_t, float64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f32)))
float32_t svadda_f32(svbool_t, float32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f16)))
float16_t svadda_f16(svbool_t, float16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_u32offset)))
svuint32_t svadrb_u32base_u32offset(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_u64offset)))
svuint64_t svadrb_u64base_u64offset(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_s32offset)))
svuint32_t svadrb_u32base_s32offset(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_s64offset)))
svuint64_t svadrb_u64base_s64offset(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_u32index)))
svuint32_t svadrd_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_u64index)))
svuint64_t svadrd_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_s32index)))
svuint32_t svadrd_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_s64index)))
svuint64_t svadrd_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_u32index)))
svuint32_t svadrh_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_u64index)))
svuint64_t svadrh_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_s32index)))
svuint32_t svadrh_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_s64index)))
svuint64_t svadrh_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_u32index)))
svuint32_t svadrw_u32base_u32index(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_u64index)))
svuint64_t svadrw_u64base_u64index(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_s32index)))
svuint32_t svadrw_u32base_s32index(svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_s64index)))
svuint64_t svadrw_u64base_s64index(svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u32)))
svuint32_t svcompact_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u64)))
svuint64_t svcompact_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f64)))
svfloat64_t svcompact_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f32)))
svfloat32_t svcompact_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s32)))
svint32_t svcompact_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s64)))
svint64_t svcompact_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_u32)))
svuint32_t svld1_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_u64)))
svuint64_t svld1_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_f64)))
svfloat64_t svld1_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_f32)))
svfloat32_t svld1_gather_u32base_index_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_s32)))
svint32_t svld1_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_s64)))
svint64_t svld1_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_u32)))
svuint32_t svld1_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_u64)))
svuint64_t svld1_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_f64)))
svfloat64_t svld1_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_f32)))
svfloat32_t svld1_gather_u32base_offset_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_s32)))
svint32_t svld1_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_s64)))
svint64_t svld1_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_u32)))
svuint32_t svld1_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_u64)))
svuint64_t svld1_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_f64)))
svfloat64_t svld1_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_f32)))
svfloat32_t svld1_gather_u32base_f32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_s32)))
svint32_t svld1_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_s64)))
svint64_t svld1_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_u32)))
svuint32_t svld1_gather_s32index_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_f32)))
svfloat32_t svld1_gather_s32index_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_s32)))
svint32_t svld1_gather_s32index_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_u32)))
svuint32_t svld1_gather_u32index_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_f32)))
svfloat32_t svld1_gather_u32index_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_s32)))
svint32_t svld1_gather_u32index_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_u64)))
svuint64_t svld1_gather_s64index_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_f64)))
svfloat64_t svld1_gather_s64index_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_s64)))
svint64_t svld1_gather_s64index_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_u64)))
svuint64_t svld1_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_f64)))
svfloat64_t svld1_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_s64)))
svint64_t svld1_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_u32)))
svuint32_t svld1_gather_s32offset_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_f32)))
svfloat32_t svld1_gather_s32offset_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_s32)))
svint32_t svld1_gather_s32offset_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_u32)))
svuint32_t svld1_gather_u32offset_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_f32)))
svfloat32_t svld1_gather_u32offset_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_s32)))
svint32_t svld1_gather_u32offset_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_u64)))
svuint64_t svld1_gather_s64offset_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_f64)))
svfloat64_t svld1_gather_s64offset_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_s64)))
svint64_t svld1_gather_s64offset_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_u64)))
svuint64_t svld1_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_f64)))
svfloat64_t svld1_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_s64)))
svint64_t svld1_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_u32)))
svuint32_t svld1sb_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_u64)))
svuint64_t svld1sb_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_s32)))
svint32_t svld1sb_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_s64)))
svint64_t svld1sb_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_u32)))
svuint32_t svld1sb_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_u64)))
svuint64_t svld1sb_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_s32)))
svint32_t svld1sb_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_s64)))
svint64_t svld1sb_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_u32)))
svuint32_t svld1sb_gather_s32offset_u32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_s32)))
svint32_t svld1sb_gather_s32offset_s32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_u32)))
svuint32_t svld1sb_gather_u32offset_u32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_s32)))
svint32_t svld1sb_gather_u32offset_s32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_u64)))
svuint64_t svld1sb_gather_s64offset_u64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_s64)))
svint64_t svld1sb_gather_s64offset_s64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_u64)))
svuint64_t svld1sb_gather_u64offset_u64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_s64)))
svint64_t svld1sb_gather_u64offset_s64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_u32)))
svuint32_t svld1sh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_u64)))
svuint64_t svld1sh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_s32)))
svint32_t svld1sh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_s64)))
svint64_t svld1sh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_u32)))
svuint32_t svld1sh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_u64)))
svuint64_t svld1sh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_s32)))
svint32_t svld1sh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_s64)))
svint64_t svld1sh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_u32)))
svuint32_t svld1sh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_u64)))
svuint64_t svld1sh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_s32)))
svint32_t svld1sh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_s64)))
svint64_t svld1sh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_u32)))
svuint32_t svld1sh_gather_s32index_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_s32)))
svint32_t svld1sh_gather_s32index_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_u32)))
svuint32_t svld1sh_gather_u32index_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_s32)))
svint32_t svld1sh_gather_u32index_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_u64)))
svuint64_t svld1sh_gather_s64index_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_s64)))
svint64_t svld1sh_gather_s64index_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_u64)))
svuint64_t svld1sh_gather_u64index_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_s64)))
svint64_t svld1sh_gather_u64index_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_u32)))
svuint32_t svld1sh_gather_s32offset_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_s32)))
svint32_t svld1sh_gather_s32offset_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_u32)))
svuint32_t svld1sh_gather_u32offset_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_s32)))
svint32_t svld1sh_gather_u32offset_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_u64)))
svuint64_t svld1sh_gather_s64offset_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_s64)))
svint64_t svld1sh_gather_s64offset_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_u64)))
svuint64_t svld1sh_gather_u64offset_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_s64)))
svint64_t svld1sh_gather_u64offset_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_u64)))
svuint64_t svld1sw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_s64)))
svint64_t svld1sw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_u64)))
svuint64_t svld1sw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_s64)))
svint64_t svld1sw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_u64)))
svuint64_t svld1sw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_s64)))
svint64_t svld1sw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_u64)))
svuint64_t svld1sw_gather_s64index_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_s64)))
svint64_t svld1sw_gather_s64index_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_u64)))
svuint64_t svld1sw_gather_u64index_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_s64)))
svint64_t svld1sw_gather_u64index_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_u64)))
svuint64_t svld1sw_gather_s64offset_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_s64)))
svint64_t svld1sw_gather_s64offset_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_u64)))
svuint64_t svld1sw_gather_u64offset_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_s64)))
svint64_t svld1sw_gather_u64offset_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_u32)))
svuint32_t svld1ub_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_u64)))
svuint64_t svld1ub_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_s32)))
svint32_t svld1ub_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_s64)))
svint64_t svld1ub_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_u32)))
svuint32_t svld1ub_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_u64)))
svuint64_t svld1ub_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_s32)))
svint32_t svld1ub_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_s64)))
svint64_t svld1ub_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_u32)))
svuint32_t svld1ub_gather_s32offset_u32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_s32)))
svint32_t svld1ub_gather_s32offset_s32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_u32)))
svuint32_t svld1ub_gather_u32offset_u32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_s32)))
svint32_t svld1ub_gather_u32offset_s32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_u64)))
svuint64_t svld1ub_gather_s64offset_u64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_s64)))
svint64_t svld1ub_gather_s64offset_s64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_u64)))
svuint64_t svld1ub_gather_u64offset_u64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_s64)))
svint64_t svld1ub_gather_u64offset_s64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_u32)))
svuint32_t svld1uh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_u64)))
svuint64_t svld1uh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_s32)))
svint32_t svld1uh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_s64)))
svint64_t svld1uh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_u32)))
svuint32_t svld1uh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_u64)))
svuint64_t svld1uh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_s32)))
svint32_t svld1uh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_s64)))
svint64_t svld1uh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_u32)))
svuint32_t svld1uh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_u64)))
svuint64_t svld1uh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_s32)))
svint32_t svld1uh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_s64)))
svint64_t svld1uh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_u32)))
svuint32_t svld1uh_gather_s32index_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_s32)))
svint32_t svld1uh_gather_s32index_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_u32)))
svuint32_t svld1uh_gather_u32index_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_s32)))
svint32_t svld1uh_gather_u32index_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_u64)))
svuint64_t svld1uh_gather_s64index_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_s64)))
svint64_t svld1uh_gather_s64index_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_u64)))
svuint64_t svld1uh_gather_u64index_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_s64)))
svint64_t svld1uh_gather_u64index_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_u32)))
svuint32_t svld1uh_gather_s32offset_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_s32)))
svint32_t svld1uh_gather_s32offset_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_u32)))
svuint32_t svld1uh_gather_u32offset_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_s32)))
svint32_t svld1uh_gather_u32offset_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_u64)))
svuint64_t svld1uh_gather_s64offset_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_s64)))
svint64_t svld1uh_gather_s64offset_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_u64)))
svuint64_t svld1uh_gather_u64offset_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_s64)))
svint64_t svld1uh_gather_u64offset_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_u64)))
svuint64_t svld1uw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_s64)))
svint64_t svld1uw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_u64)))
svuint64_t svld1uw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_s64)))
svint64_t svld1uw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_u64)))
svuint64_t svld1uw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_s64)))
svint64_t svld1uw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_u64)))
svuint64_t svld1uw_gather_s64index_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_s64)))
svint64_t svld1uw_gather_s64index_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_u64)))
svuint64_t svld1uw_gather_u64index_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_s64)))
svint64_t svld1uw_gather_u64index_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_u64)))
svuint64_t svld1uw_gather_s64offset_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_s64)))
svint64_t svld1uw_gather_s64offset_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_u64)))
svuint64_t svld1uw_gather_u64offset_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_s64)))
svint64_t svld1uw_gather_u64offset_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u8)))
svuint8_t svldff1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u32)))
svuint32_t svldff1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u64)))
svuint64_t svldff1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u16)))
svuint16_t svldff1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_bf16)))
svbfloat16_t svldff1_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s8)))
svint8_t svldff1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f64)))
svfloat64_t svldff1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f32)))
svfloat32_t svldff1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f16)))
svfloat16_t svldff1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s32)))
svint32_t svldff1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s64)))
svint64_t svldff1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_mf8)))
svmfloat8_t svldff1_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s16)))
svint16_t svldff1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_u32)))
svuint32_t svldff1_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_u64)))
svuint64_t svldff1_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_f64)))
svfloat64_t svldff1_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_f32)))
svfloat32_t svldff1_gather_u32base_index_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_s32)))
svint32_t svldff1_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_s64)))
svint64_t svldff1_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_u32)))
svuint32_t svldff1_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_u64)))
svuint64_t svldff1_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_f64)))
svfloat64_t svldff1_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_f32)))
svfloat32_t svldff1_gather_u32base_offset_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_s32)))
svint32_t svldff1_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_s64)))
svint64_t svldff1_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_u32)))
svuint32_t svldff1_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_u64)))
svuint64_t svldff1_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_f64)))
svfloat64_t svldff1_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_f32)))
svfloat32_t svldff1_gather_u32base_f32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_s32)))
svint32_t svldff1_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_s64)))
svint64_t svldff1_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_u32)))
svuint32_t svldff1_gather_s32index_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_f32)))
svfloat32_t svldff1_gather_s32index_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_s32)))
svint32_t svldff1_gather_s32index_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_u32)))
svuint32_t svldff1_gather_u32index_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_f32)))
svfloat32_t svldff1_gather_u32index_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_s32)))
svint32_t svldff1_gather_u32index_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_u64)))
svuint64_t svldff1_gather_s64index_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_f64)))
svfloat64_t svldff1_gather_s64index_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_s64)))
svint64_t svldff1_gather_s64index_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_u64)))
svuint64_t svldff1_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_f64)))
svfloat64_t svldff1_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_s64)))
svint64_t svldff1_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_u32)))
svuint32_t svldff1_gather_s32offset_u32(svbool_t, uint32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_f32)))
svfloat32_t svldff1_gather_s32offset_f32(svbool_t, float32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_s32)))
svint32_t svldff1_gather_s32offset_s32(svbool_t, int32_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_u32)))
svuint32_t svldff1_gather_u32offset_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_f32)))
svfloat32_t svldff1_gather_u32offset_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_s32)))
svint32_t svldff1_gather_u32offset_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_u64)))
svuint64_t svldff1_gather_s64offset_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_f64)))
svfloat64_t svldff1_gather_s64offset_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_s64)))
svint64_t svldff1_gather_s64offset_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_u64)))
svuint64_t svldff1_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_f64)))
svfloat64_t svldff1_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_s64)))
svint64_t svldff1_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u8)))
svuint8_t svldff1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u32)))
svuint32_t svldff1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u64)))
svuint64_t svldff1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u16)))
svuint16_t svldff1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_bf16)))
svbfloat16_t svldff1_vnum_bf16(svbool_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s8)))
svint8_t svldff1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f64)))
svfloat64_t svldff1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f32)))
svfloat32_t svldff1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f16)))
svfloat16_t svldff1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s32)))
svint32_t svldff1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s64)))
svint64_t svldff1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_mf8)))
svmfloat8_t svldff1_vnum_mf8(svbool_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s16)))
svint16_t svldff1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_u32)))
svuint32_t svldff1sb_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_u64)))
svuint64_t svldff1sb_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_s32)))
svint32_t svldff1sb_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_s64)))
svint64_t svldff1sb_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_u32)))
svuint32_t svldff1sb_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_u64)))
svuint64_t svldff1sb_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_s32)))
svint32_t svldff1sb_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_s64)))
svint64_t svldff1sb_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_u32)))
svuint32_t svldff1sb_gather_s32offset_u32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_s32)))
svint32_t svldff1sb_gather_s32offset_s32(svbool_t, int8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_u32)))
svuint32_t svldff1sb_gather_u32offset_u32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_s32)))
svint32_t svldff1sb_gather_u32offset_s32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_u64)))
svuint64_t svldff1sb_gather_s64offset_u64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_s64)))
svint64_t svldff1sb_gather_s64offset_s64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_u64)))
svuint64_t svldff1sb_gather_u64offset_u64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_s64)))
svint64_t svldff1sb_gather_u64offset_s64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u32)))
svuint32_t svldff1sb_vnum_u32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u64)))
svuint64_t svldff1sb_vnum_u64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_u16)))
svuint16_t svldff1sb_vnum_u16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s32)))
svint32_t svldff1sb_vnum_s32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s64)))
svint64_t svldff1sb_vnum_s64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_vnum_s16)))
svint16_t svldff1sb_vnum_s16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u32)))
svuint32_t svldff1sb_u32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u64)))
svuint64_t svldff1sb_u64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_u16)))
svuint16_t svldff1sb_u16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s32)))
svint32_t svldff1sb_s32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s64)))
svint64_t svldff1sb_s64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_s16)))
svint16_t svldff1sb_s16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_u32)))
svuint32_t svldff1sh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_u64)))
svuint64_t svldff1sh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_s32)))
svint32_t svldff1sh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_s64)))
svint64_t svldff1sh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_u32)))
svuint32_t svldff1sh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_u64)))
svuint64_t svldff1sh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_s32)))
svint32_t svldff1sh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_s64)))
svint64_t svldff1sh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_u32)))
svuint32_t svldff1sh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_u64)))
svuint64_t svldff1sh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_s32)))
svint32_t svldff1sh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_s64)))
svint64_t svldff1sh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_u32)))
svuint32_t svldff1sh_gather_s32index_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_s32)))
svint32_t svldff1sh_gather_s32index_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_u32)))
svuint32_t svldff1sh_gather_u32index_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_s32)))
svint32_t svldff1sh_gather_u32index_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_u64)))
svuint64_t svldff1sh_gather_s64index_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_s64)))
svint64_t svldff1sh_gather_s64index_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_u64)))
svuint64_t svldff1sh_gather_u64index_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_s64)))
svint64_t svldff1sh_gather_u64index_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_u32)))
svuint32_t svldff1sh_gather_s32offset_u32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_s32)))
svint32_t svldff1sh_gather_s32offset_s32(svbool_t, int16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_u32)))
svuint32_t svldff1sh_gather_u32offset_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_s32)))
svint32_t svldff1sh_gather_u32offset_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_u64)))
svuint64_t svldff1sh_gather_s64offset_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_s64)))
svint64_t svldff1sh_gather_s64offset_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_u64)))
svuint64_t svldff1sh_gather_u64offset_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_s64)))
svint64_t svldff1sh_gather_u64offset_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_u32)))
svuint32_t svldff1sh_vnum_u32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_u64)))
svuint64_t svldff1sh_vnum_u64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_s32)))
svint32_t svldff1sh_vnum_s32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_vnum_s64)))
svint64_t svldff1sh_vnum_s64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_u32)))
svuint32_t svldff1sh_u32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_u64)))
svuint64_t svldff1sh_u64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_s32)))
svint32_t svldff1sh_s32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_s64)))
svint64_t svldff1sh_s64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_u64)))
svuint64_t svldff1sw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_s64)))
svint64_t svldff1sw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_u64)))
svuint64_t svldff1sw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_s64)))
svint64_t svldff1sw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_u64)))
svuint64_t svldff1sw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_s64)))
svint64_t svldff1sw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_u64)))
svuint64_t svldff1sw_gather_s64index_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_s64)))
svint64_t svldff1sw_gather_s64index_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_u64)))
svuint64_t svldff1sw_gather_u64index_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_s64)))
svint64_t svldff1sw_gather_u64index_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_u64)))
svuint64_t svldff1sw_gather_s64offset_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_s64)))
svint64_t svldff1sw_gather_s64offset_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_u64)))
svuint64_t svldff1sw_gather_u64offset_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_s64)))
svint64_t svldff1sw_gather_u64offset_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_vnum_u64)))
svuint64_t svldff1sw_vnum_u64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_vnum_s64)))
svint64_t svldff1sw_vnum_s64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_u64)))
svuint64_t svldff1sw_u64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_s64)))
svint64_t svldff1sw_s64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_u32)))
svuint32_t svldff1ub_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_u64)))
svuint64_t svldff1ub_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_s32)))
svint32_t svldff1ub_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_s64)))
svint64_t svldff1ub_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_u32)))
svuint32_t svldff1ub_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_u64)))
svuint64_t svldff1ub_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_s32)))
svint32_t svldff1ub_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_s64)))
svint64_t svldff1ub_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_u32)))
svuint32_t svldff1ub_gather_s32offset_u32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_s32)))
svint32_t svldff1ub_gather_s32offset_s32(svbool_t, uint8_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_u32)))
svuint32_t svldff1ub_gather_u32offset_u32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_s32)))
svint32_t svldff1ub_gather_u32offset_s32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_u64)))
svuint64_t svldff1ub_gather_s64offset_u64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_s64)))
svint64_t svldff1ub_gather_s64offset_s64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_u64)))
svuint64_t svldff1ub_gather_u64offset_u64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_s64)))
svint64_t svldff1ub_gather_u64offset_s64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u32)))
svuint32_t svldff1ub_vnum_u32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u64)))
svuint64_t svldff1ub_vnum_u64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_u16)))
svuint16_t svldff1ub_vnum_u16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s32)))
svint32_t svldff1ub_vnum_s32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s64)))
svint64_t svldff1ub_vnum_s64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_vnum_s16)))
svint16_t svldff1ub_vnum_s16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u32)))
svuint32_t svldff1ub_u32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u64)))
svuint64_t svldff1ub_u64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_u16)))
svuint16_t svldff1ub_u16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s32)))
svint32_t svldff1ub_s32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s64)))
svint64_t svldff1ub_s64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_s16)))
svint16_t svldff1ub_s16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_u32)))
svuint32_t svldff1uh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_u64)))
svuint64_t svldff1uh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_s32)))
svint32_t svldff1uh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_s64)))
svint64_t svldff1uh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_u32)))
svuint32_t svldff1uh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_u64)))
svuint64_t svldff1uh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_s32)))
svint32_t svldff1uh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_s64)))
svint64_t svldff1uh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_u32)))
svuint32_t svldff1uh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_u64)))
svuint64_t svldff1uh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_s32)))
svint32_t svldff1uh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_s64)))
svint64_t svldff1uh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_u32)))
svuint32_t svldff1uh_gather_s32index_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_s32)))
svint32_t svldff1uh_gather_s32index_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_u32)))
svuint32_t svldff1uh_gather_u32index_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_s32)))
svint32_t svldff1uh_gather_u32index_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_u64)))
svuint64_t svldff1uh_gather_s64index_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_s64)))
svint64_t svldff1uh_gather_s64index_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_u64)))
svuint64_t svldff1uh_gather_u64index_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_s64)))
svint64_t svldff1uh_gather_u64index_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_u32)))
svuint32_t svldff1uh_gather_s32offset_u32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_s32)))
svint32_t svldff1uh_gather_s32offset_s32(svbool_t, uint16_t const *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_u32)))
svuint32_t svldff1uh_gather_u32offset_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_s32)))
svint32_t svldff1uh_gather_u32offset_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_u64)))
svuint64_t svldff1uh_gather_s64offset_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_s64)))
svint64_t svldff1uh_gather_s64offset_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_u64)))
svuint64_t svldff1uh_gather_u64offset_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_s64)))
svint64_t svldff1uh_gather_u64offset_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_u32)))
svuint32_t svldff1uh_vnum_u32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_u64)))
svuint64_t svldff1uh_vnum_u64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_s32)))
svint32_t svldff1uh_vnum_s32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_vnum_s64)))
svint64_t svldff1uh_vnum_s64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_u32)))
svuint32_t svldff1uh_u32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_u64)))
svuint64_t svldff1uh_u64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_s32)))
svint32_t svldff1uh_s32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_s64)))
svint64_t svldff1uh_s64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_u64)))
svuint64_t svldff1uw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_s64)))
svint64_t svldff1uw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_u64)))
svuint64_t svldff1uw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_s64)))
svint64_t svldff1uw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_u64)))
svuint64_t svldff1uw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_s64)))
svint64_t svldff1uw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_u64)))
svuint64_t svldff1uw_gather_s64index_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_s64)))
svint64_t svldff1uw_gather_s64index_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_u64)))
svuint64_t svldff1uw_gather_u64index_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_s64)))
svint64_t svldff1uw_gather_u64index_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_u64)))
svuint64_t svldff1uw_gather_s64offset_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_s64)))
svint64_t svldff1uw_gather_s64offset_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_u64)))
svuint64_t svldff1uw_gather_u64offset_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_s64)))
svint64_t svldff1uw_gather_u64offset_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_vnum_u64)))
svuint64_t svldff1uw_vnum_u64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_vnum_s64)))
svint64_t svldff1uw_vnum_s64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_u64)))
svuint64_t svldff1uw_u64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_s64)))
svint64_t svldff1uw_s64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u8)))
svuint8_t svldnf1_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u32)))
svuint32_t svldnf1_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u64)))
svuint64_t svldnf1_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u16)))
svuint16_t svldnf1_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_bf16)))
svbfloat16_t svldnf1_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s8)))
svint8_t svldnf1_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f64)))
svfloat64_t svldnf1_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f32)))
svfloat32_t svldnf1_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f16)))
svfloat16_t svldnf1_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s32)))
svint32_t svldnf1_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s64)))
svint64_t svldnf1_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_mf8)))
svmfloat8_t svldnf1_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s16)))
svint16_t svldnf1_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u8)))
svuint8_t svldnf1_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u32)))
svuint32_t svldnf1_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u64)))
svuint64_t svldnf1_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u16)))
svuint16_t svldnf1_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_bf16)))
svbfloat16_t svldnf1_vnum_bf16(svbool_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s8)))
svint8_t svldnf1_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f64)))
svfloat64_t svldnf1_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f32)))
svfloat32_t svldnf1_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f16)))
svfloat16_t svldnf1_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s32)))
svint32_t svldnf1_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s64)))
svint64_t svldnf1_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_mf8)))
svmfloat8_t svldnf1_vnum_mf8(svbool_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s16)))
svint16_t svldnf1_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u32)))
svuint32_t svldnf1sb_vnum_u32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u64)))
svuint64_t svldnf1sb_vnum_u64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_u16)))
svuint16_t svldnf1sb_vnum_u16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s32)))
svint32_t svldnf1sb_vnum_s32(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s64)))
svint64_t svldnf1sb_vnum_s64(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_vnum_s16)))
svint16_t svldnf1sb_vnum_s16(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u32)))
svuint32_t svldnf1sb_u32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u64)))
svuint64_t svldnf1sb_u64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_u16)))
svuint16_t svldnf1sb_u16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s32)))
svint32_t svldnf1sb_s32(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s64)))
svint64_t svldnf1sb_s64(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sb_s16)))
svint16_t svldnf1sb_s16(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_u32)))
svuint32_t svldnf1sh_vnum_u32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_u64)))
svuint64_t svldnf1sh_vnum_u64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_s32)))
svint32_t svldnf1sh_vnum_s32(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_vnum_s64)))
svint64_t svldnf1sh_vnum_s64(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_u32)))
svuint32_t svldnf1sh_u32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_u64)))
svuint64_t svldnf1sh_u64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_s32)))
svint32_t svldnf1sh_s32(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sh_s64)))
svint64_t svldnf1sh_s64(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_vnum_u64)))
svuint64_t svldnf1sw_vnum_u64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_vnum_s64)))
svint64_t svldnf1sw_vnum_s64(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_u64)))
svuint64_t svldnf1sw_u64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1sw_s64)))
svint64_t svldnf1sw_s64(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u32)))
svuint32_t svldnf1ub_vnum_u32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u64)))
svuint64_t svldnf1ub_vnum_u64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_u16)))
svuint16_t svldnf1ub_vnum_u16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s32)))
svint32_t svldnf1ub_vnum_s32(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s64)))
svint64_t svldnf1ub_vnum_s64(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_vnum_s16)))
svint16_t svldnf1ub_vnum_s16(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u32)))
svuint32_t svldnf1ub_u32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u64)))
svuint64_t svldnf1ub_u64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_u16)))
svuint16_t svldnf1ub_u16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s32)))
svint32_t svldnf1ub_s32(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s64)))
svint64_t svldnf1ub_s64(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1ub_s16)))
svint16_t svldnf1ub_s16(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_u32)))
svuint32_t svldnf1uh_vnum_u32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_u64)))
svuint64_t svldnf1uh_vnum_u64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_s32)))
svint32_t svldnf1uh_vnum_s32(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_vnum_s64)))
svint64_t svldnf1uh_vnum_s64(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_u32)))
svuint32_t svldnf1uh_u32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_u64)))
svuint64_t svldnf1uh_u64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_s32)))
svint32_t svldnf1uh_s32(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uh_s64)))
svint64_t svldnf1uh_s64(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_vnum_u64)))
svuint64_t svldnf1uw_vnum_u64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_vnum_s64)))
svint64_t svldnf1uw_vnum_s64(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_u64)))
svuint64_t svldnf1uw_u64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1uw_s64)))
svint64_t svldnf1uw_s64(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base)))
void svprfb_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base)))
void svprfb_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base_offset)))
void svprfb_gather_u32base_offset(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base_offset)))
void svprfb_gather_u64base_offset(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s32offset)))
void svprfb_gather_s32offset(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32offset)))
void svprfb_gather_u32offset(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s64offset)))
void svprfb_gather_s64offset(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64offset)))
void svprfb_gather_u64offset(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base)))
void svprfd_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base)))
void svprfd_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base_index)))
void svprfd_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base_index)))
void svprfd_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s32index)))
void svprfd_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32index)))
void svprfd_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s64index)))
void svprfd_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64index)))
void svprfd_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base)))
void svprfh_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base)))
void svprfh_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base_index)))
void svprfh_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base_index)))
void svprfh_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s32index)))
void svprfh_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32index)))
void svprfh_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s64index)))
void svprfh_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64index)))
void svprfh_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base)))
void svprfw_gather_u32base(svbool_t, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base)))
void svprfw_gather_u64base(svbool_t, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base_index)))
void svprfw_gather_u32base_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base_index)))
void svprfw_gather_u64base_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s32index)))
void svprfw_gather_s32index(svbool_t, void const *, svint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32index)))
void svprfw_gather_u32index(svbool_t, void const *, svuint32_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s64index)))
void svprfw_gather_s64index(svbool_t, void const *, svint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64index)))
void svprfw_gather_u64index(svbool_t, void const *, svuint64_t, enum svprfop);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrdffr)))
svbool_t svrdffr(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrdffr_z)))
svbool_t svrdffr_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsetffr)))
void svsetffr(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_u32)))
void svst1_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_u64)))
void svst1_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_f64)))
void svst1_scatter_u64base_index_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_f32)))
void svst1_scatter_u32base_index_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_s32)))
void svst1_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_s64)))
void svst1_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_u32)))
void svst1_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_u64)))
void svst1_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_f64)))
void svst1_scatter_u64base_offset_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_f32)))
void svst1_scatter_u32base_offset_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_s32)))
void svst1_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_s64)))
void svst1_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_u32)))
void svst1_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_u64)))
void svst1_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_f64)))
void svst1_scatter_u64base_f64(svbool_t, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_f32)))
void svst1_scatter_u32base_f32(svbool_t, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_s32)))
void svst1_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_s64)))
void svst1_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_u32)))
void svst1_scatter_s32index_u32(svbool_t, uint32_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_f32)))
void svst1_scatter_s32index_f32(svbool_t, float32_t *, svint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_s32)))
void svst1_scatter_s32index_s32(svbool_t, int32_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_u32)))
void svst1_scatter_u32index_u32(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_f32)))
void svst1_scatter_u32index_f32(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_s32)))
void svst1_scatter_u32index_s32(svbool_t, int32_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_u64)))
void svst1_scatter_s64index_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_f64)))
void svst1_scatter_s64index_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_s64)))
void svst1_scatter_s64index_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_u64)))
void svst1_scatter_u64index_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_f64)))
void svst1_scatter_u64index_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_s64)))
void svst1_scatter_u64index_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_u32)))
void svst1_scatter_s32offset_u32(svbool_t, uint32_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_f32)))
void svst1_scatter_s32offset_f32(svbool_t, float32_t *, svint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_s32)))
void svst1_scatter_s32offset_s32(svbool_t, int32_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_u32)))
void svst1_scatter_u32offset_u32(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_f32)))
void svst1_scatter_u32offset_f32(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_s32)))
void svst1_scatter_u32offset_s32(svbool_t, int32_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_u64)))
void svst1_scatter_s64offset_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_f64)))
void svst1_scatter_s64offset_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_s64)))
void svst1_scatter_s64offset_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_u64)))
void svst1_scatter_u64offset_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_f64)))
void svst1_scatter_u64offset_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_s64)))
void svst1_scatter_u64offset_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_u32)))
void svst1b_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_u64)))
void svst1b_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_s32)))
void svst1b_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_s64)))
void svst1b_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_u32)))
void svst1b_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_u64)))
void svst1b_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_s32)))
void svst1b_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_s64)))
void svst1b_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_s32)))
void svst1b_scatter_s32offset_s32(svbool_t, int8_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_u32)))
void svst1b_scatter_s32offset_u32(svbool_t, uint8_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_s32)))
void svst1b_scatter_u32offset_s32(svbool_t, int8_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_u32)))
void svst1b_scatter_u32offset_u32(svbool_t, uint8_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_s64)))
void svst1b_scatter_s64offset_s64(svbool_t, int8_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_u64)))
void svst1b_scatter_s64offset_u64(svbool_t, uint8_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_s64)))
void svst1b_scatter_u64offset_s64(svbool_t, int8_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_u64)))
void svst1b_scatter_u64offset_u64(svbool_t, uint8_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_u32)))
void svst1h_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_u64)))
void svst1h_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_s32)))
void svst1h_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_s64)))
void svst1h_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_u32)))
void svst1h_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_u64)))
void svst1h_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_s32)))
void svst1h_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_s64)))
void svst1h_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_u32)))
void svst1h_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_u64)))
void svst1h_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_s32)))
void svst1h_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_s64)))
void svst1h_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_s32)))
void svst1h_scatter_s32index_s32(svbool_t, int16_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_u32)))
void svst1h_scatter_s32index_u32(svbool_t, uint16_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_s32)))
void svst1h_scatter_u32index_s32(svbool_t, int16_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_u32)))
void svst1h_scatter_u32index_u32(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_s64)))
void svst1h_scatter_s64index_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_u64)))
void svst1h_scatter_s64index_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_s64)))
void svst1h_scatter_u64index_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_u64)))
void svst1h_scatter_u64index_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_s32)))
void svst1h_scatter_s32offset_s32(svbool_t, int16_t *, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_u32)))
void svst1h_scatter_s32offset_u32(svbool_t, uint16_t *, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_s32)))
void svst1h_scatter_u32offset_s32(svbool_t, int16_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_u32)))
void svst1h_scatter_u32offset_u32(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_s64)))
void svst1h_scatter_s64offset_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_u64)))
void svst1h_scatter_s64offset_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_s64)))
void svst1h_scatter_u64offset_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_u64)))
void svst1h_scatter_u64offset_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_u64)))
void svst1w_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_s64)))
void svst1w_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_u64)))
void svst1w_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_s64)))
void svst1w_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_u64)))
void svst1w_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_s64)))
void svst1w_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_s64)))
void svst1w_scatter_s64index_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_u64)))
void svst1w_scatter_s64index_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_s64)))
void svst1w_scatter_u64index_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_u64)))
void svst1w_scatter_u64index_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_s64)))
void svst1w_scatter_s64offset_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_u64)))
void svst1w_scatter_s64offset_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_s64)))
void svst1w_scatter_u64offset_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_u64)))
void svst1w_scatter_u64offset_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f64)))
svfloat64_t svtmad_f64(svfloat64_t, svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f32)))
svfloat32_t svtmad_f32(svfloat32_t, svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f16)))
svfloat16_t svtmad_f16(svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f64)))
svfloat64_t svtsmul_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f32)))
svfloat32_t svtsmul_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f16)))
svfloat16_t svtsmul_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f64)))
svfloat64_t svtssel_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f32)))
svfloat32_t svtssel_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f16)))
svfloat16_t svtssel_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwrffr)))
void svwrffr(svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f64)))
float64_t svadda(svbool_t, float64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f32)))
float32_t svadda(svbool_t, float32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadda_f16)))
float16_t svadda(svbool_t, float16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_u32offset)))
svuint32_t svadrb_offset(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_u64offset)))
svuint64_t svadrb_offset(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u32base_s32offset)))
svuint32_t svadrb_offset(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrb_u64base_s64offset)))
svuint64_t svadrb_offset(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_u32index)))
svuint32_t svadrd_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_u64index)))
svuint64_t svadrd_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u32base_s32index)))
svuint32_t svadrd_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrd_u64base_s64index)))
svuint64_t svadrd_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_u32index)))
svuint32_t svadrh_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_u64index)))
svuint64_t svadrh_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u32base_s32index)))
svuint32_t svadrh_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrh_u64base_s64index)))
svuint64_t svadrh_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_u32index)))
svuint32_t svadrw_index(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_u64index)))
svuint64_t svadrw_index(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u32base_s32index)))
svuint32_t svadrw_index(svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadrw_u64base_s64index)))
svuint64_t svadrw_index(svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u32)))
svuint32_t svcompact(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_u64)))
svuint64_t svcompact(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f64)))
svfloat64_t svcompact(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_f32)))
svfloat32_t svcompact(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s32)))
svint32_t svcompact(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcompact_s64)))
svint64_t svcompact(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_u32)))
svuint32_t svld1_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_u64)))
svuint64_t svld1_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_f64)))
svfloat64_t svld1_gather_index_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_f32)))
svfloat32_t svld1_gather_index_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_index_s32)))
svint32_t svld1_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_index_s64)))
svint64_t svld1_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_u32)))
svuint32_t svld1_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_u64)))
svuint64_t svld1_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_f64)))
svfloat64_t svld1_gather_offset_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_f32)))
svfloat32_t svld1_gather_offset_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_offset_s32)))
svint32_t svld1_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_offset_s64)))
svint64_t svld1_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_u32)))
svuint32_t svld1_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_u64)))
svuint64_t svld1_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_f64)))
svfloat64_t svld1_gather_f64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_f32)))
svfloat32_t svld1_gather_f32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32base_s32)))
svint32_t svld1_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64base_s64)))
svint64_t svld1_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_u32)))
svuint32_t svld1_gather_index(svbool_t, uint32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_f32)))
svfloat32_t svld1_gather_index(svbool_t, float32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32index_s32)))
svint32_t svld1_gather_index(svbool_t, int32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_u32)))
svuint32_t svld1_gather_index(svbool_t, uint32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_f32)))
svfloat32_t svld1_gather_index(svbool_t, float32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32index_s32)))
svint32_t svld1_gather_index(svbool_t, int32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_u64)))
svuint64_t svld1_gather_index(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_f64)))
svfloat64_t svld1_gather_index(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64index_s64)))
svint64_t svld1_gather_index(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_u64)))
svuint64_t svld1_gather_index(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_f64)))
svfloat64_t svld1_gather_index(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64index_s64)))
svint64_t svld1_gather_index(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_u32)))
svuint32_t svld1_gather_offset(svbool_t, uint32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_f32)))
svfloat32_t svld1_gather_offset(svbool_t, float32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s32offset_s32)))
svint32_t svld1_gather_offset(svbool_t, int32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_u32)))
svuint32_t svld1_gather_offset(svbool_t, uint32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_f32)))
svfloat32_t svld1_gather_offset(svbool_t, float32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u32offset_s32)))
svint32_t svld1_gather_offset(svbool_t, int32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_u64)))
svuint64_t svld1_gather_offset(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_f64)))
svfloat64_t svld1_gather_offset(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_s64offset_s64)))
svint64_t svld1_gather_offset(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_u64)))
svuint64_t svld1_gather_offset(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_f64)))
svfloat64_t svld1_gather_offset(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_gather_u64offset_s64)))
svint64_t svld1_gather_offset(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_u32)))
svuint32_t svld1sb_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_u64)))
svuint64_t svld1sb_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_offset_s32)))
svint32_t svld1sb_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_offset_s64)))
svint64_t svld1sb_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_u32)))
svuint32_t svld1sb_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_u64)))
svuint64_t svld1sb_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32base_s32)))
svint32_t svld1sb_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64base_s64)))
svint64_t svld1sb_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_u32)))
svuint32_t svld1sb_gather_offset_u32(svbool_t, int8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s32offset_s32)))
svint32_t svld1sb_gather_offset_s32(svbool_t, int8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_u32)))
svuint32_t svld1sb_gather_offset_u32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u32offset_s32)))
svint32_t svld1sb_gather_offset_s32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_u64)))
svuint64_t svld1sb_gather_offset_u64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_s64offset_s64)))
svint64_t svld1sb_gather_offset_s64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_u64)))
svuint64_t svld1sb_gather_offset_u64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sb_gather_u64offset_s64)))
svint64_t svld1sb_gather_offset_s64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_u32)))
svuint32_t svld1sh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_u64)))
svuint64_t svld1sh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_index_s32)))
svint32_t svld1sh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_index_s64)))
svint64_t svld1sh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_u32)))
svuint32_t svld1sh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_u64)))
svuint64_t svld1sh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_offset_s32)))
svint32_t svld1sh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_offset_s64)))
svint64_t svld1sh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_u32)))
svuint32_t svld1sh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_u64)))
svuint64_t svld1sh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32base_s32)))
svint32_t svld1sh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64base_s64)))
svint64_t svld1sh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_u32)))
svuint32_t svld1sh_gather_index_u32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32index_s32)))
svint32_t svld1sh_gather_index_s32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_u32)))
svuint32_t svld1sh_gather_index_u32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32index_s32)))
svint32_t svld1sh_gather_index_s32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_u64)))
svuint64_t svld1sh_gather_index_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64index_s64)))
svint64_t svld1sh_gather_index_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_u64)))
svuint64_t svld1sh_gather_index_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64index_s64)))
svint64_t svld1sh_gather_index_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_u32)))
svuint32_t svld1sh_gather_offset_u32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s32offset_s32)))
svint32_t svld1sh_gather_offset_s32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_u32)))
svuint32_t svld1sh_gather_offset_u32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u32offset_s32)))
svint32_t svld1sh_gather_offset_s32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_u64)))
svuint64_t svld1sh_gather_offset_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_s64offset_s64)))
svint64_t svld1sh_gather_offset_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_u64)))
svuint64_t svld1sh_gather_offset_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sh_gather_u64offset_s64)))
svint64_t svld1sh_gather_offset_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_u64)))
svuint64_t svld1sw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_index_s64)))
svint64_t svld1sw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_u64)))
svuint64_t svld1sw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_offset_s64)))
svint64_t svld1sw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_u64)))
svuint64_t svld1sw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64base_s64)))
svint64_t svld1sw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_u64)))
svuint64_t svld1sw_gather_index_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64index_s64)))
svint64_t svld1sw_gather_index_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_u64)))
svuint64_t svld1sw_gather_index_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64index_s64)))
svint64_t svld1sw_gather_index_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_u64)))
svuint64_t svld1sw_gather_offset_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_s64offset_s64)))
svint64_t svld1sw_gather_offset_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_u64)))
svuint64_t svld1sw_gather_offset_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1sw_gather_u64offset_s64)))
svint64_t svld1sw_gather_offset_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_u32)))
svuint32_t svld1ub_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_u64)))
svuint64_t svld1ub_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_offset_s32)))
svint32_t svld1ub_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_offset_s64)))
svint64_t svld1ub_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_u32)))
svuint32_t svld1ub_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_u64)))
svuint64_t svld1ub_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32base_s32)))
svint32_t svld1ub_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64base_s64)))
svint64_t svld1ub_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_u32)))
svuint32_t svld1ub_gather_offset_u32(svbool_t, uint8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s32offset_s32)))
svint32_t svld1ub_gather_offset_s32(svbool_t, uint8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_u32)))
svuint32_t svld1ub_gather_offset_u32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u32offset_s32)))
svint32_t svld1ub_gather_offset_s32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_u64)))
svuint64_t svld1ub_gather_offset_u64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_s64offset_s64)))
svint64_t svld1ub_gather_offset_s64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_u64)))
svuint64_t svld1ub_gather_offset_u64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ub_gather_u64offset_s64)))
svint64_t svld1ub_gather_offset_s64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_u32)))
svuint32_t svld1uh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_u64)))
svuint64_t svld1uh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_index_s32)))
svint32_t svld1uh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_index_s64)))
svint64_t svld1uh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_u32)))
svuint32_t svld1uh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_u64)))
svuint64_t svld1uh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_offset_s32)))
svint32_t svld1uh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_offset_s64)))
svint64_t svld1uh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_u32)))
svuint32_t svld1uh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_u64)))
svuint64_t svld1uh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32base_s32)))
svint32_t svld1uh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64base_s64)))
svint64_t svld1uh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_u32)))
svuint32_t svld1uh_gather_index_u32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32index_s32)))
svint32_t svld1uh_gather_index_s32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_u32)))
svuint32_t svld1uh_gather_index_u32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32index_s32)))
svint32_t svld1uh_gather_index_s32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_u64)))
svuint64_t svld1uh_gather_index_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64index_s64)))
svint64_t svld1uh_gather_index_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_u64)))
svuint64_t svld1uh_gather_index_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64index_s64)))
svint64_t svld1uh_gather_index_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_u32)))
svuint32_t svld1uh_gather_offset_u32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s32offset_s32)))
svint32_t svld1uh_gather_offset_s32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_u32)))
svuint32_t svld1uh_gather_offset_u32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u32offset_s32)))
svint32_t svld1uh_gather_offset_s32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_u64)))
svuint64_t svld1uh_gather_offset_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_s64offset_s64)))
svint64_t svld1uh_gather_offset_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_u64)))
svuint64_t svld1uh_gather_offset_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uh_gather_u64offset_s64)))
svint64_t svld1uh_gather_offset_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_u64)))
svuint64_t svld1uw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_index_s64)))
svint64_t svld1uw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_u64)))
svuint64_t svld1uw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_offset_s64)))
svint64_t svld1uw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_u64)))
svuint64_t svld1uw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64base_s64)))
svint64_t svld1uw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_u64)))
svuint64_t svld1uw_gather_index_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64index_s64)))
svint64_t svld1uw_gather_index_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_u64)))
svuint64_t svld1uw_gather_index_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64index_s64)))
svint64_t svld1uw_gather_index_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_u64)))
svuint64_t svld1uw_gather_offset_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_s64offset_s64)))
svint64_t svld1uw_gather_offset_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_u64)))
svuint64_t svld1uw_gather_offset_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uw_gather_u64offset_s64)))
svint64_t svld1uw_gather_offset_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u8)))
svuint8_t svldff1(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u32)))
svuint32_t svldff1(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u64)))
svuint64_t svldff1(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_u16)))
svuint16_t svldff1(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_bf16)))
svbfloat16_t svldff1(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s8)))
svint8_t svldff1(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f64)))
svfloat64_t svldff1(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f32)))
svfloat32_t svldff1(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_f16)))
svfloat16_t svldff1(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s32)))
svint32_t svldff1(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s64)))
svint64_t svldff1(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_mf8)))
svmfloat8_t svldff1(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_s16)))
svint16_t svldff1(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_u32)))
svuint32_t svldff1_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_u64)))
svuint64_t svldff1_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_f64)))
svfloat64_t svldff1_gather_index_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_f32)))
svfloat32_t svldff1_gather_index_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_index_s32)))
svint32_t svldff1_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_index_s64)))
svint64_t svldff1_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_u32)))
svuint32_t svldff1_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_u64)))
svuint64_t svldff1_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_f64)))
svfloat64_t svldff1_gather_offset_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_f32)))
svfloat32_t svldff1_gather_offset_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_offset_s32)))
svint32_t svldff1_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_offset_s64)))
svint64_t svldff1_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_u32)))
svuint32_t svldff1_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_u64)))
svuint64_t svldff1_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_f64)))
svfloat64_t svldff1_gather_f64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_f32)))
svfloat32_t svldff1_gather_f32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32base_s32)))
svint32_t svldff1_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64base_s64)))
svint64_t svldff1_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_u32)))
svuint32_t svldff1_gather_index(svbool_t, uint32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_f32)))
svfloat32_t svldff1_gather_index(svbool_t, float32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32index_s32)))
svint32_t svldff1_gather_index(svbool_t, int32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_u32)))
svuint32_t svldff1_gather_index(svbool_t, uint32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_f32)))
svfloat32_t svldff1_gather_index(svbool_t, float32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32index_s32)))
svint32_t svldff1_gather_index(svbool_t, int32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_u64)))
svuint64_t svldff1_gather_index(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_f64)))
svfloat64_t svldff1_gather_index(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64index_s64)))
svint64_t svldff1_gather_index(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_u64)))
svuint64_t svldff1_gather_index(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_f64)))
svfloat64_t svldff1_gather_index(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64index_s64)))
svint64_t svldff1_gather_index(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_u32)))
svuint32_t svldff1_gather_offset(svbool_t, uint32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_f32)))
svfloat32_t svldff1_gather_offset(svbool_t, float32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s32offset_s32)))
svint32_t svldff1_gather_offset(svbool_t, int32_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_u32)))
svuint32_t svldff1_gather_offset(svbool_t, uint32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_f32)))
svfloat32_t svldff1_gather_offset(svbool_t, float32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u32offset_s32)))
svint32_t svldff1_gather_offset(svbool_t, int32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_u64)))
svuint64_t svldff1_gather_offset(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_f64)))
svfloat64_t svldff1_gather_offset(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_s64offset_s64)))
svint64_t svldff1_gather_offset(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_u64)))
svuint64_t svldff1_gather_offset(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_f64)))
svfloat64_t svldff1_gather_offset(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_gather_u64offset_s64)))
svint64_t svldff1_gather_offset(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u8)))
svuint8_t svldff1_vnum(svbool_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u32)))
svuint32_t svldff1_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u64)))
svuint64_t svldff1_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_u16)))
svuint16_t svldff1_vnum(svbool_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_bf16)))
svbfloat16_t svldff1_vnum(svbool_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s8)))
svint8_t svldff1_vnum(svbool_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f64)))
svfloat64_t svldff1_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f32)))
svfloat32_t svldff1_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_f16)))
svfloat16_t svldff1_vnum(svbool_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s32)))
svint32_t svldff1_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s64)))
svint64_t svldff1_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_mf8)))
svmfloat8_t svldff1_vnum(svbool_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1_vnum_s16)))
svint16_t svldff1_vnum(svbool_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_u32)))
svuint32_t svldff1sb_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_u64)))
svuint64_t svldff1sb_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_offset_s32)))
svint32_t svldff1sb_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_offset_s64)))
svint64_t svldff1sb_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_u32)))
svuint32_t svldff1sb_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_u64)))
svuint64_t svldff1sb_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32base_s32)))
svint32_t svldff1sb_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64base_s64)))
svint64_t svldff1sb_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_u32)))
svuint32_t svldff1sb_gather_offset_u32(svbool_t, int8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s32offset_s32)))
svint32_t svldff1sb_gather_offset_s32(svbool_t, int8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_u32)))
svuint32_t svldff1sb_gather_offset_u32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u32offset_s32)))
svint32_t svldff1sb_gather_offset_s32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_u64)))
svuint64_t svldff1sb_gather_offset_u64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_s64offset_s64)))
svint64_t svldff1sb_gather_offset_s64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_u64)))
svuint64_t svldff1sb_gather_offset_u64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sb_gather_u64offset_s64)))
svint64_t svldff1sb_gather_offset_s64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_u32)))
svuint32_t svldff1sh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_u64)))
svuint64_t svldff1sh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_index_s32)))
svint32_t svldff1sh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_index_s64)))
svint64_t svldff1sh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_u32)))
svuint32_t svldff1sh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_u64)))
svuint64_t svldff1sh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_offset_s32)))
svint32_t svldff1sh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_offset_s64)))
svint64_t svldff1sh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_u32)))
svuint32_t svldff1sh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_u64)))
svuint64_t svldff1sh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32base_s32)))
svint32_t svldff1sh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64base_s64)))
svint64_t svldff1sh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_u32)))
svuint32_t svldff1sh_gather_index_u32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32index_s32)))
svint32_t svldff1sh_gather_index_s32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_u32)))
svuint32_t svldff1sh_gather_index_u32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32index_s32)))
svint32_t svldff1sh_gather_index_s32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_u64)))
svuint64_t svldff1sh_gather_index_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64index_s64)))
svint64_t svldff1sh_gather_index_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_u64)))
svuint64_t svldff1sh_gather_index_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64index_s64)))
svint64_t svldff1sh_gather_index_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_u32)))
svuint32_t svldff1sh_gather_offset_u32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s32offset_s32)))
svint32_t svldff1sh_gather_offset_s32(svbool_t, int16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_u32)))
svuint32_t svldff1sh_gather_offset_u32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u32offset_s32)))
svint32_t svldff1sh_gather_offset_s32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_u64)))
svuint64_t svldff1sh_gather_offset_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_s64offset_s64)))
svint64_t svldff1sh_gather_offset_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_u64)))
svuint64_t svldff1sh_gather_offset_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sh_gather_u64offset_s64)))
svint64_t svldff1sh_gather_offset_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_u64)))
svuint64_t svldff1sw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_index_s64)))
svint64_t svldff1sw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_u64)))
svuint64_t svldff1sw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_offset_s64)))
svint64_t svldff1sw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_u64)))
svuint64_t svldff1sw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64base_s64)))
svint64_t svldff1sw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_u64)))
svuint64_t svldff1sw_gather_index_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64index_s64)))
svint64_t svldff1sw_gather_index_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_u64)))
svuint64_t svldff1sw_gather_index_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64index_s64)))
svint64_t svldff1sw_gather_index_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_u64)))
svuint64_t svldff1sw_gather_offset_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_s64offset_s64)))
svint64_t svldff1sw_gather_offset_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_u64)))
svuint64_t svldff1sw_gather_offset_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1sw_gather_u64offset_s64)))
svint64_t svldff1sw_gather_offset_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_u32)))
svuint32_t svldff1ub_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_u64)))
svuint64_t svldff1ub_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_offset_s32)))
svint32_t svldff1ub_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_offset_s64)))
svint64_t svldff1ub_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_u32)))
svuint32_t svldff1ub_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_u64)))
svuint64_t svldff1ub_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32base_s32)))
svint32_t svldff1ub_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64base_s64)))
svint64_t svldff1ub_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_u32)))
svuint32_t svldff1ub_gather_offset_u32(svbool_t, uint8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s32offset_s32)))
svint32_t svldff1ub_gather_offset_s32(svbool_t, uint8_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_u32)))
svuint32_t svldff1ub_gather_offset_u32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u32offset_s32)))
svint32_t svldff1ub_gather_offset_s32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_u64)))
svuint64_t svldff1ub_gather_offset_u64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_s64offset_s64)))
svint64_t svldff1ub_gather_offset_s64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_u64)))
svuint64_t svldff1ub_gather_offset_u64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1ub_gather_u64offset_s64)))
svint64_t svldff1ub_gather_offset_s64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_u32)))
svuint32_t svldff1uh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_u64)))
svuint64_t svldff1uh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_index_s32)))
svint32_t svldff1uh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_index_s64)))
svint64_t svldff1uh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_u32)))
svuint32_t svldff1uh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_u64)))
svuint64_t svldff1uh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_offset_s32)))
svint32_t svldff1uh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_offset_s64)))
svint64_t svldff1uh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_u32)))
svuint32_t svldff1uh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_u64)))
svuint64_t svldff1uh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32base_s32)))
svint32_t svldff1uh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64base_s64)))
svint64_t svldff1uh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_u32)))
svuint32_t svldff1uh_gather_index_u32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32index_s32)))
svint32_t svldff1uh_gather_index_s32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_u32)))
svuint32_t svldff1uh_gather_index_u32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32index_s32)))
svint32_t svldff1uh_gather_index_s32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_u64)))
svuint64_t svldff1uh_gather_index_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64index_s64)))
svint64_t svldff1uh_gather_index_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_u64)))
svuint64_t svldff1uh_gather_index_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64index_s64)))
svint64_t svldff1uh_gather_index_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_u32)))
svuint32_t svldff1uh_gather_offset_u32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s32offset_s32)))
svint32_t svldff1uh_gather_offset_s32(svbool_t, uint16_t const *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_u32)))
svuint32_t svldff1uh_gather_offset_u32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u32offset_s32)))
svint32_t svldff1uh_gather_offset_s32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_u64)))
svuint64_t svldff1uh_gather_offset_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_s64offset_s64)))
svint64_t svldff1uh_gather_offset_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_u64)))
svuint64_t svldff1uh_gather_offset_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uh_gather_u64offset_s64)))
svint64_t svldff1uh_gather_offset_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_u64)))
svuint64_t svldff1uw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_index_s64)))
svint64_t svldff1uw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_u64)))
svuint64_t svldff1uw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_offset_s64)))
svint64_t svldff1uw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_u64)))
svuint64_t svldff1uw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64base_s64)))
svint64_t svldff1uw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_u64)))
svuint64_t svldff1uw_gather_index_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64index_s64)))
svint64_t svldff1uw_gather_index_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_u64)))
svuint64_t svldff1uw_gather_index_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64index_s64)))
svint64_t svldff1uw_gather_index_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_u64)))
svuint64_t svldff1uw_gather_offset_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_s64offset_s64)))
svint64_t svldff1uw_gather_offset_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_u64)))
svuint64_t svldff1uw_gather_offset_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldff1uw_gather_u64offset_s64)))
svint64_t svldff1uw_gather_offset_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u8)))
svuint8_t svldnf1(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u32)))
svuint32_t svldnf1(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u64)))
svuint64_t svldnf1(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_u16)))
svuint16_t svldnf1(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_bf16)))
svbfloat16_t svldnf1(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s8)))
svint8_t svldnf1(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f64)))
svfloat64_t svldnf1(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f32)))
svfloat32_t svldnf1(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_f16)))
svfloat16_t svldnf1(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s32)))
svint32_t svldnf1(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s64)))
svint64_t svldnf1(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_mf8)))
svmfloat8_t svldnf1(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_s16)))
svint16_t svldnf1(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u8)))
svuint8_t svldnf1_vnum(svbool_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u32)))
svuint32_t svldnf1_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u64)))
svuint64_t svldnf1_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_u16)))
svuint16_t svldnf1_vnum(svbool_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_bf16)))
svbfloat16_t svldnf1_vnum(svbool_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s8)))
svint8_t svldnf1_vnum(svbool_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f64)))
svfloat64_t svldnf1_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f32)))
svfloat32_t svldnf1_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_f16)))
svfloat16_t svldnf1_vnum(svbool_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s32)))
svint32_t svldnf1_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s64)))
svint64_t svldnf1_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_mf8)))
svmfloat8_t svldnf1_vnum(svbool_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnf1_vnum_s16)))
svint16_t svldnf1_vnum(svbool_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base)))
void svprfb_gather(svbool_t, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base)))
void svprfb_gather(svbool_t, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32base_offset)))
void svprfb_gather_offset(svbool_t, svuint32_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64base_offset)))
void svprfb_gather_offset(svbool_t, svuint64_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s32offset)))
void svprfb_gather_offset(svbool_t, void const *, svint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u32offset)))
void svprfb_gather_offset(svbool_t, void const *, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_s64offset)))
void svprfb_gather_offset(svbool_t, void const *, svint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfb_gather_u64offset)))
void svprfb_gather_offset(svbool_t, void const *, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base)))
void svprfd_gather(svbool_t, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base)))
void svprfd_gather(svbool_t, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32base_index)))
void svprfd_gather_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64base_index)))
void svprfd_gather_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s32index)))
void svprfd_gather_index(svbool_t, void const *, svint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u32index)))
void svprfd_gather_index(svbool_t, void const *, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_s64index)))
void svprfd_gather_index(svbool_t, void const *, svint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfd_gather_u64index)))
void svprfd_gather_index(svbool_t, void const *, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base)))
void svprfh_gather(svbool_t, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base)))
void svprfh_gather(svbool_t, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32base_index)))
void svprfh_gather_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64base_index)))
void svprfh_gather_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s32index)))
void svprfh_gather_index(svbool_t, void const *, svint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u32index)))
void svprfh_gather_index(svbool_t, void const *, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_s64index)))
void svprfh_gather_index(svbool_t, void const *, svint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfh_gather_u64index)))
void svprfh_gather_index(svbool_t, void const *, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base)))
void svprfw_gather(svbool_t, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base)))
void svprfw_gather(svbool_t, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32base_index)))
void svprfw_gather_index(svbool_t, svuint32_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64base_index)))
void svprfw_gather_index(svbool_t, svuint64_t, int64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s32index)))
void svprfw_gather_index(svbool_t, void const *, svint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u32index)))
void svprfw_gather_index(svbool_t, void const *, svuint32_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_s64index)))
void svprfw_gather_index(svbool_t, void const *, svint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svprfw_gather_u64index)))
void svprfw_gather_index(svbool_t, void const *, svuint64_t, enum svprfop);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_u32)))
void svst1_scatter_index(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_u64)))
void svst1_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_f64)))
void svst1_scatter_index(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_f32)))
void svst1_scatter_index(svbool_t, svuint32_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_index_s32)))
void svst1_scatter_index(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_index_s64)))
void svst1_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_u32)))
void svst1_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_u64)))
void svst1_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_f64)))
void svst1_scatter_offset(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_f32)))
void svst1_scatter_offset(svbool_t, svuint32_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_offset_s32)))
void svst1_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_offset_s64)))
void svst1_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_u32)))
void svst1_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_u64)))
void svst1_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_f64)))
void svst1_scatter(svbool_t, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_f32)))
void svst1_scatter(svbool_t, svuint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32base_s32)))
void svst1_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64base_s64)))
void svst1_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_u32)))
void svst1_scatter_index(svbool_t, uint32_t *, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_f32)))
void svst1_scatter_index(svbool_t, float32_t *, svint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32index_s32)))
void svst1_scatter_index(svbool_t, int32_t *, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_u32)))
void svst1_scatter_index(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_f32)))
void svst1_scatter_index(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32index_s32)))
void svst1_scatter_index(svbool_t, int32_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_u64)))
void svst1_scatter_index(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_f64)))
void svst1_scatter_index(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64index_s64)))
void svst1_scatter_index(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_u64)))
void svst1_scatter_index(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_f64)))
void svst1_scatter_index(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64index_s64)))
void svst1_scatter_index(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_u32)))
void svst1_scatter_offset(svbool_t, uint32_t *, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_f32)))
void svst1_scatter_offset(svbool_t, float32_t *, svint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s32offset_s32)))
void svst1_scatter_offset(svbool_t, int32_t *, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_u32)))
void svst1_scatter_offset(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_f32)))
void svst1_scatter_offset(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u32offset_s32)))
void svst1_scatter_offset(svbool_t, int32_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_u64)))
void svst1_scatter_offset(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_f64)))
void svst1_scatter_offset(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_s64offset_s64)))
void svst1_scatter_offset(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_u64)))
void svst1_scatter_offset(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_f64)))
void svst1_scatter_offset(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_scatter_u64offset_s64)))
void svst1_scatter_offset(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_u32)))
void svst1b_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_u64)))
void svst1b_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_offset_s32)))
void svst1b_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_offset_s64)))
void svst1b_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_u32)))
void svst1b_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_u64)))
void svst1b_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32base_s32)))
void svst1b_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64base_s64)))
void svst1b_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_s32)))
void svst1b_scatter_offset(svbool_t, int8_t *, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s32offset_u32)))
void svst1b_scatter_offset(svbool_t, uint8_t *, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_s32)))
void svst1b_scatter_offset(svbool_t, int8_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u32offset_u32)))
void svst1b_scatter_offset(svbool_t, uint8_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_s64)))
void svst1b_scatter_offset(svbool_t, int8_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_s64offset_u64)))
void svst1b_scatter_offset(svbool_t, uint8_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_s64)))
void svst1b_scatter_offset(svbool_t, int8_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1b_scatter_u64offset_u64)))
void svst1b_scatter_offset(svbool_t, uint8_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_u32)))
void svst1h_scatter_index(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_u64)))
void svst1h_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_index_s32)))
void svst1h_scatter_index(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_index_s64)))
void svst1h_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_u32)))
void svst1h_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_u64)))
void svst1h_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_offset_s32)))
void svst1h_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_offset_s64)))
void svst1h_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_u32)))
void svst1h_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_u64)))
void svst1h_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32base_s32)))
void svst1h_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64base_s64)))
void svst1h_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_s32)))
void svst1h_scatter_index(svbool_t, int16_t *, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32index_u32)))
void svst1h_scatter_index(svbool_t, uint16_t *, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_s32)))
void svst1h_scatter_index(svbool_t, int16_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32index_u32)))
void svst1h_scatter_index(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_s64)))
void svst1h_scatter_index(svbool_t, int16_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64index_u64)))
void svst1h_scatter_index(svbool_t, uint16_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_s64)))
void svst1h_scatter_index(svbool_t, int16_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64index_u64)))
void svst1h_scatter_index(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_s32)))
void svst1h_scatter_offset(svbool_t, int16_t *, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s32offset_u32)))
void svst1h_scatter_offset(svbool_t, uint16_t *, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_s32)))
void svst1h_scatter_offset(svbool_t, int16_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u32offset_u32)))
void svst1h_scatter_offset(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_s64)))
void svst1h_scatter_offset(svbool_t, int16_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_s64offset_u64)))
void svst1h_scatter_offset(svbool_t, uint16_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_s64)))
void svst1h_scatter_offset(svbool_t, int16_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1h_scatter_u64offset_u64)))
void svst1h_scatter_offset(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_u64)))
void svst1w_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_index_s64)))
void svst1w_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_u64)))
void svst1w_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_offset_s64)))
void svst1w_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_u64)))
void svst1w_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64base_s64)))
void svst1w_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_s64)))
void svst1w_scatter_index(svbool_t, int32_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64index_u64)))
void svst1w_scatter_index(svbool_t, uint32_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_s64)))
void svst1w_scatter_index(svbool_t, int32_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64index_u64)))
void svst1w_scatter_index(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_s64)))
void svst1w_scatter_offset(svbool_t, int32_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_s64offset_u64)))
void svst1w_scatter_offset(svbool_t, uint32_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_s64)))
void svst1w_scatter_offset(svbool_t, int32_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1w_scatter_u64offset_u64)))
void svst1w_scatter_offset(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f64)))
svfloat64_t svtmad(svfloat64_t, svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f32)))
svfloat32_t svtmad(svfloat32_t, svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtmad_f16)))
svfloat16_t svtmad(svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f64)))
svfloat64_t svtsmul(svfloat64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f32)))
svfloat32_t svtsmul(svfloat32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtsmul_f16)))
svfloat16_t svtsmul(svfloat16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f64)))
svfloat64_t svtssel(svfloat64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f32)))
svfloat32_t svtssel(svfloat32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtssel_f16)))
svfloat16_t svtssel(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s8)))
svint8_t svclamp_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s32)))
svint32_t svclamp_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s64)))
svint64_t svclamp_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s16)))
svint16_t svclamp_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u8)))
svuint8_t svclamp_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u32)))
svuint32_t svclamp_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u64)))
svuint64_t svclamp_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u16)))
svuint16_t svclamp_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_b16)))
svbool_t svpsel_lane_b16(svbool_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_b32)))
svbool_t svpsel_lane_b32(svbool_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_b64)))
svbool_t svpsel_lane_b64(svbool_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_b8)))
svbool_t svpsel_lane_b8(svbool_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_m)))
svuint8_t svrevd_u8_m(svuint8_t, svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_m)))
svuint32_t svrevd_u32_m(svuint32_t, svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_m)))
svuint64_t svrevd_u64_m(svuint64_t, svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_m)))
svuint16_t svrevd_u16_m(svuint16_t, svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_m)))
svbfloat16_t svrevd_bf16_m(svbfloat16_t, svbool_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_m)))
svint8_t svrevd_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_m)))
svfloat64_t svrevd_f64_m(svfloat64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_m)))
svfloat32_t svrevd_f32_m(svfloat32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_m)))
svfloat16_t svrevd_f16_m(svfloat16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_m)))
svint32_t svrevd_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_m)))
svint64_t svrevd_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_m)))
svmfloat8_t svrevd_mf8_m(svmfloat8_t, svbool_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_m)))
svint16_t svrevd_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_x)))
svuint8_t svrevd_u8_x(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_x)))
svuint32_t svrevd_u32_x(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_x)))
svuint64_t svrevd_u64_x(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_x)))
svuint16_t svrevd_u16_x(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_x)))
svbfloat16_t svrevd_bf16_x(svbool_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_x)))
svint8_t svrevd_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_x)))
svfloat64_t svrevd_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_x)))
svfloat32_t svrevd_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_x)))
svfloat16_t svrevd_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_x)))
svint32_t svrevd_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_x)))
svint64_t svrevd_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_x)))
svmfloat8_t svrevd_mf8_x(svbool_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_x)))
svint16_t svrevd_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_z)))
svuint8_t svrevd_u8_z(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_z)))
svuint32_t svrevd_u32_z(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_z)))
svuint64_t svrevd_u64_z(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_z)))
svuint16_t svrevd_u16_z(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_z)))
svbfloat16_t svrevd_bf16_z(svbool_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_z)))
svint8_t svrevd_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_z)))
svfloat64_t svrevd_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_z)))
svfloat32_t svrevd_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_z)))
svfloat16_t svrevd_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_z)))
svint32_t svrevd_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_z)))
svint64_t svrevd_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_z)))
svmfloat8_t svrevd_mf8_z(svbool_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_z)))
svint16_t svrevd_s16_z(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s8)))
svint8_t svclamp(svint8_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s32)))
svint32_t svclamp(svint32_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s64)))
svint64_t svclamp(svint64_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_s16)))
svint16_t svclamp(svint16_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u8)))
svuint8_t svclamp(svuint8_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u32)))
svuint32_t svclamp(svuint32_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u64)))
svuint64_t svclamp(svuint64_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_u16)))
svuint16_t svclamp(svuint16_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_m)))
svuint8_t svrevd_m(svuint8_t, svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_m)))
svuint32_t svrevd_m(svuint32_t, svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_m)))
svuint64_t svrevd_m(svuint64_t, svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_m)))
svuint16_t svrevd_m(svuint16_t, svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_m)))
svbfloat16_t svrevd_m(svbfloat16_t, svbool_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_m)))
svint8_t svrevd_m(svint8_t, svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_m)))
svfloat64_t svrevd_m(svfloat64_t, svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_m)))
svfloat32_t svrevd_m(svfloat32_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_m)))
svfloat16_t svrevd_m(svfloat16_t, svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_m)))
svint32_t svrevd_m(svint32_t, svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_m)))
svint64_t svrevd_m(svint64_t, svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_m)))
svmfloat8_t svrevd_m(svmfloat8_t, svbool_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_m)))
svint16_t svrevd_m(svint16_t, svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_x)))
svuint8_t svrevd_x(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_x)))
svuint32_t svrevd_x(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_x)))
svuint64_t svrevd_x(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_x)))
svuint16_t svrevd_x(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_x)))
svbfloat16_t svrevd_x(svbool_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_x)))
svint8_t svrevd_x(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_x)))
svfloat64_t svrevd_x(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_x)))
svfloat32_t svrevd_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_x)))
svfloat16_t svrevd_x(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_x)))
svint32_t svrevd_x(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_x)))
svint64_t svrevd_x(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_x)))
svmfloat8_t svrevd_x(svbool_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_x)))
svint16_t svrevd_x(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u8_z)))
svuint8_t svrevd_z(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u32_z)))
svuint32_t svrevd_z(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u64_z)))
svuint64_t svrevd_z(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_u16_z)))
svuint16_t svrevd_z(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_bf16_z)))
svbfloat16_t svrevd_z(svbool_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s8_z)))
svint8_t svrevd_z(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f64_z)))
svfloat64_t svrevd_z(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f32_z)))
svfloat32_t svrevd_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_f16_z)))
svfloat16_t svrevd_z(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s32_z)))
svint32_t svrevd_z(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s64_z)))
svint64_t svrevd_z(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_mf8_z)))
svmfloat8_t svrevd_z(svbool_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrevd_s16_z)))
svint16_t svrevd_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslb_f32)))
svfloat32_t svbfmlslb_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslb_lane_f32)))
svfloat32_t svbfmlslb_lane_f32(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslt_f32)))
svfloat32_t svbfmlslt_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslt_lane_f32)))
svfloat32_t svbfmlslt_lane_f32(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f64)))
svfloat64_t svclamp_f64(svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f32)))
svfloat32_t svclamp_f32(svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f16)))
svfloat16_t svclamp_f16(svfloat16_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_b)))
svboolx2_t svcreate2_b(svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_b)))
svboolx4_t svcreate4_b(svbool_t, svbool_t, svbool_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f32_f16)))
svfloat32_t svdot_f32_f16(svfloat32_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_s32_s16)))
svint32_t svdot_s32_s16(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_u32_u16)))
svuint32_t svdot_u32_u16(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f32_f16)))
svfloat32_t svdot_lane_f32_f16(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_s32_s16)))
svint32_t svdot_lane_s32_s16(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_u32_u16)))
svuint32_t svdot_lane_u32_u16(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_b)))
svbool_t svget2_b(svboolx2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_b)))
svbool_t svget4_b(svboolx4_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s32_x2)))
svint16_t svqcvtn_s16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s32_x2)))
svuint16_t svqcvtn_u16_s32_x2(svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u32_x2)))
svuint16_t svqcvtn_u16_u32_x2(svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s32_x2)))
svint16_t svqrshrn_n_s16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u32_x2)))
svuint16_t svqrshrn_n_u16_u32_x2(svuint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s32_x2)))
svuint16_t svqrshrun_n_u16_s32_x2(svint32x2_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_b)))
svboolx2_t svset2_b(svboolx2_t, uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_b)))
svboolx4_t svset4_b(svboolx4_t, uint64_t, svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef2_b)))
svboolx2_t svundef2_b();
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svundef4_b)))
svboolx4_t svundef4_b();
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b8_s64_x2)))
svboolx2_t svwhilege_b8_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b32_s64_x2)))
svboolx2_t svwhilege_b32_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b64_s64_x2)))
svboolx2_t svwhilege_b64_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b16_s64_x2)))
svboolx2_t svwhilege_b16_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b8_u64_x2)))
svboolx2_t svwhilege_b8_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b32_u64_x2)))
svboolx2_t svwhilege_b32_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b64_u64_x2)))
svboolx2_t svwhilege_b64_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b16_u64_x2)))
svboolx2_t svwhilege_b16_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b8_s64_x2)))
svboolx2_t svwhilegt_b8_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b32_s64_x2)))
svboolx2_t svwhilegt_b32_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b64_s64_x2)))
svboolx2_t svwhilegt_b64_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b16_s64_x2)))
svboolx2_t svwhilegt_b16_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b8_u64_x2)))
svboolx2_t svwhilegt_b8_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b32_u64_x2)))
svboolx2_t svwhilegt_b32_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b64_u64_x2)))
svboolx2_t svwhilegt_b64_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b16_u64_x2)))
svboolx2_t svwhilegt_b16_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_s64_x2)))
svboolx2_t svwhilele_b8_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_s64_x2)))
svboolx2_t svwhilele_b32_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_s64_x2)))
svboolx2_t svwhilele_b64_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_s64_x2)))
svboolx2_t svwhilele_b16_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_u64_x2)))
svboolx2_t svwhilele_b8_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_u64_x2)))
svboolx2_t svwhilele_b32_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_u64_x2)))
svboolx2_t svwhilele_b64_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_u64_x2)))
svboolx2_t svwhilele_b16_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_u64_x2)))
svboolx2_t svwhilelt_b8_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_u64_x2)))
svboolx2_t svwhilelt_b32_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_u64_x2)))
svboolx2_t svwhilelt_b64_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_u64_x2)))
svboolx2_t svwhilelt_b16_u64_x2(uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_s64_x2)))
svboolx2_t svwhilelt_b8_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_s64_x2)))
svboolx2_t svwhilelt_b32_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_s64_x2)))
svboolx2_t svwhilelt_b64_s64_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_s64_x2)))
svboolx2_t svwhilelt_b16_s64_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslb_f32)))
svfloat32_t svbfmlslb(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslb_lane_f32)))
svfloat32_t svbfmlslb_lane(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslt_f32)))
svfloat32_t svbfmlslt(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlslt_lane_f32)))
svfloat32_t svbfmlslt_lane(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f64)))
svfloat64_t svclamp(svfloat64_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f32)))
svfloat32_t svclamp(svfloat32_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_f16)))
svfloat16_t svclamp(svfloat16_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate2_b)))
svboolx2_t svcreate2(svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcreate4_b)))
svboolx4_t svcreate4(svbool_t, svbool_t, svbool_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f32_f16)))
svfloat32_t svdot(svfloat32_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_s32_s16)))
svint32_t svdot(svint32_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_u32_u16)))
svuint32_t svdot(svuint32_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f32_f16)))
svfloat32_t svdot_lane(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_s32_s16)))
svint32_t svdot_lane(svint32_t, svint16_t, svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_u32_u16)))
svuint32_t svdot_lane(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget2_b)))
svbool_t svget2(svboolx2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svget4_b)))
svbool_t svget4(svboolx4_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_s16_s32_x2)))
svint16_t svqcvtn_s16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_s32_x2)))
svuint16_t svqcvtn_u16(svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcvtn_u16_u32_x2)))
svuint16_t svqcvtn_u16(svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_s16_s32_x2)))
svint16_t svqrshrn_s16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrn_n_u16_u32_x2)))
svuint16_t svqrshrn_u16(svuint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqrshrun_n_u16_s32_x2)))
svuint16_t svqrshrun_u16(svint32x2_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset2_b)))
svboolx2_t svset2(svboolx2_t, uint64_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svset4_b)))
svboolx4_t svset4(svboolx4_t, uint64_t, svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b8_s64_x2)))
svboolx2_t svwhilege_b8_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b32_s64_x2)))
svboolx2_t svwhilege_b32_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b64_s64_x2)))
svboolx2_t svwhilege_b64_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b16_s64_x2)))
svboolx2_t svwhilege_b16_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b8_u64_x2)))
svboolx2_t svwhilege_b8_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b32_u64_x2)))
svboolx2_t svwhilege_b32_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b64_u64_x2)))
svboolx2_t svwhilege_b64_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_b16_u64_x2)))
svboolx2_t svwhilege_b16_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b8_s64_x2)))
svboolx2_t svwhilegt_b8_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b32_s64_x2)))
svboolx2_t svwhilegt_b32_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b64_s64_x2)))
svboolx2_t svwhilegt_b64_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b16_s64_x2)))
svboolx2_t svwhilegt_b16_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b8_u64_x2)))
svboolx2_t svwhilegt_b8_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b32_u64_x2)))
svboolx2_t svwhilegt_b32_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b64_u64_x2)))
svboolx2_t svwhilegt_b64_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_b16_u64_x2)))
svboolx2_t svwhilegt_b16_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_s64_x2)))
svboolx2_t svwhilele_b8_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_s64_x2)))
svboolx2_t svwhilele_b32_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_s64_x2)))
svboolx2_t svwhilele_b64_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_s64_x2)))
svboolx2_t svwhilele_b16_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b8_u64_x2)))
svboolx2_t svwhilele_b8_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b32_u64_x2)))
svboolx2_t svwhilele_b32_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b64_u64_x2)))
svboolx2_t svwhilele_b64_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_b16_u64_x2)))
svboolx2_t svwhilele_b16_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_u64_x2)))
svboolx2_t svwhilelt_b8_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_u64_x2)))
svboolx2_t svwhilelt_b32_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_u64_x2)))
svboolx2_t svwhilelt_b64_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_u64_x2)))
svboolx2_t svwhilelt_b16_x2(uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b8_s64_x2)))
svboolx2_t svwhilelt_b8_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b32_s64_x2)))
svboolx2_t svwhilelt_b32_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b64_s64_x2)))
svboolx2_t svwhilelt_b64_x2(int64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_b16_s64_x2)))
svboolx2_t svwhilelt_b16_x2(int64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u8)))
uint8x16_t svaddqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u32)))
uint32x4_t svaddqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u64)))
uint64x2_t svaddqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u16)))
uint16x8_t svaddqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s8)))
int8x16_t svaddqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s32)))
int32x4_t svaddqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s64)))
int64x2_t svaddqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s16)))
int16x8_t svaddqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f64)))
float64x2_t svaddqv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f32)))
float32x4_t svaddqv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f16)))
float16x8_t svaddqv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u8)))
uint8x16_t svandqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u32)))
uint32x4_t svandqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u64)))
uint64x2_t svandqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u16)))
uint16x8_t svandqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s8)))
int8x16_t svandqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s32)))
int32x4_t svandqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s64)))
int64x2_t svandqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s16)))
int16x8_t svandqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u8)))
svuint8_t svdup_laneq_u8(svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s8)))
svint8_t svdup_laneq_s8(svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_mf8)))
svmfloat8_t svdup_laneq_mf8(svmfloat8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u64)))
svuint64_t svdup_laneq_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f64)))
svfloat64_t svdup_laneq_f64(svfloat64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s64)))
svint64_t svdup_laneq_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u16)))
svuint16_t svdup_laneq_u16(svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_bf16)))
svbfloat16_t svdup_laneq_bf16(svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f16)))
svfloat16_t svdup_laneq_f16(svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s16)))
svint16_t svdup_laneq_s16(svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u32)))
svuint32_t svdup_laneq_u32(svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f32)))
svfloat32_t svdup_laneq_f32(svfloat32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s32)))
svint32_t svdup_laneq_s32(svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u8)))
uint8x16_t sveorqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u32)))
uint32x4_t sveorqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u64)))
uint64x2_t sveorqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u16)))
uint16x8_t sveorqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s8)))
int8x16_t sveorqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s32)))
int32x4_t sveorqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s64)))
int64x2_t sveorqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s16)))
int16x8_t sveorqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u8)))
svuint8_t svextq_u8(svuint8_t, svuint8_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u32)))
svuint32_t svextq_u32(svuint32_t, svuint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u64)))
svuint64_t svextq_u64(svuint64_t, svuint64_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u16)))
svuint16_t svextq_u16(svuint16_t, svuint16_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_bf16)))
svbfloat16_t svextq_bf16(svbfloat16_t, svbfloat16_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s8)))
svint8_t svextq_s8(svint8_t, svint8_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f64)))
svfloat64_t svextq_f64(svfloat64_t, svfloat64_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f32)))
svfloat32_t svextq_f32(svfloat32_t, svfloat32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f16)))
svfloat16_t svextq_f16(svfloat16_t, svfloat16_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s32)))
svint32_t svextq_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s64)))
svint64_t svextq_s64(svint64_t, svint64_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_mf8)))
svmfloat8_t svextq_mf8(svmfloat8_t, svmfloat8_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s16)))
svint16_t svextq_s16(svint16_t, svint16_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u8)))
svuint8x2_t svld2q_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u32)))
svuint32x2_t svld2q_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u64)))
svuint64x2_t svld2q_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u16)))
svuint16x2_t svld2q_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_bf16)))
svbfloat16x2_t svld2q_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s8)))
svint8x2_t svld2q_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f64)))
svfloat64x2_t svld2q_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f32)))
svfloat32x2_t svld2q_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f16)))
svfloat16x2_t svld2q_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s32)))
svint32x2_t svld2q_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s64)))
svint64x2_t svld2q_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_mf8)))
svmfloat8x2_t svld2q_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s16)))
svint16x2_t svld2q_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u8)))
svuint8x2_t svld2q_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u32)))
svuint32x2_t svld2q_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u64)))
svuint64x2_t svld2q_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u16)))
svuint16x2_t svld2q_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_bf16)))
svbfloat16x2_t svld2q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s8)))
svint8x2_t svld2q_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f64)))
svfloat64x2_t svld2q_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f32)))
svfloat32x2_t svld2q_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f16)))
svfloat16x2_t svld2q_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s32)))
svint32x2_t svld2q_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s64)))
svint64x2_t svld2q_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_mf8)))
svmfloat8x2_t svld2q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s16)))
svint16x2_t svld2q_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u8)))
svuint8x3_t svld3q_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u32)))
svuint32x3_t svld3q_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u64)))
svuint64x3_t svld3q_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u16)))
svuint16x3_t svld3q_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_bf16)))
svbfloat16x3_t svld3q_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s8)))
svint8x3_t svld3q_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f64)))
svfloat64x3_t svld3q_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f32)))
svfloat32x3_t svld3q_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f16)))
svfloat16x3_t svld3q_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s32)))
svint32x3_t svld3q_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s64)))
svint64x3_t svld3q_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_mf8)))
svmfloat8x3_t svld3q_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s16)))
svint16x3_t svld3q_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u8)))
svuint8x3_t svld3q_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u32)))
svuint32x3_t svld3q_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u64)))
svuint64x3_t svld3q_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u16)))
svuint16x3_t svld3q_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_bf16)))
svbfloat16x3_t svld3q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s8)))
svint8x3_t svld3q_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f64)))
svfloat64x3_t svld3q_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f32)))
svfloat32x3_t svld3q_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f16)))
svfloat16x3_t svld3q_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s32)))
svint32x3_t svld3q_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s64)))
svint64x3_t svld3q_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_mf8)))
svmfloat8x3_t svld3q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s16)))
svint16x3_t svld3q_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u8)))
svuint8x4_t svld4q_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u32)))
svuint32x4_t svld4q_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u64)))
svuint64x4_t svld4q_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u16)))
svuint16x4_t svld4q_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_bf16)))
svbfloat16x4_t svld4q_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s8)))
svint8x4_t svld4q_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f64)))
svfloat64x4_t svld4q_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f32)))
svfloat32x4_t svld4q_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f16)))
svfloat16x4_t svld4q_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s32)))
svint32x4_t svld4q_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s64)))
svint64x4_t svld4q_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_mf8)))
svmfloat8x4_t svld4q_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s16)))
svint16x4_t svld4q_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u8)))
svuint8x4_t svld4q_vnum_u8(svbool_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u32)))
svuint32x4_t svld4q_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u64)))
svuint64x4_t svld4q_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u16)))
svuint16x4_t svld4q_vnum_u16(svbool_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_bf16)))
svbfloat16x4_t svld4q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s8)))
svint8x4_t svld4q_vnum_s8(svbool_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f64)))
svfloat64x4_t svld4q_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f32)))
svfloat32x4_t svld4q_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f16)))
svfloat16x4_t svld4q_vnum_f16(svbool_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s32)))
svint32x4_t svld4q_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s64)))
svint64x4_t svld4q_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_mf8)))
svmfloat8x4_t svld4q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s16)))
svint16x4_t svld4q_vnum_s16(svbool_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f64)))
float64x2_t svmaxnmqv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f32)))
float32x4_t svmaxnmqv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f16)))
float16x8_t svmaxnmqv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f64)))
float64x2_t svmaxqv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f32)))
float32x4_t svmaxqv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f16)))
float16x8_t svmaxqv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s8)))
int8x16_t svmaxqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s32)))
int32x4_t svmaxqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s64)))
int64x2_t svmaxqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s16)))
int16x8_t svmaxqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u8)))
uint8x16_t svmaxqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u32)))
uint32x4_t svmaxqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u64)))
uint64x2_t svmaxqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u16)))
uint16x8_t svmaxqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f64)))
float64x2_t svminnmqv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f32)))
float32x4_t svminnmqv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f16)))
float16x8_t svminnmqv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f64)))
float64x2_t svminqv_f64(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f32)))
float32x4_t svminqv_f32(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f16)))
float16x8_t svminqv_f16(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s8)))
int8x16_t svminqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s32)))
int32x4_t svminqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s64)))
int64x2_t svminqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s16)))
int16x8_t svminqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u8)))
uint8x16_t svminqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u32)))
uint32x4_t svminqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u64)))
uint64x2_t svminqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u16)))
uint16x8_t svminqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u8)))
uint8x16_t svorqv_u8(svbool_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u32)))
uint32x4_t svorqv_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u64)))
uint64x2_t svorqv_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u16)))
uint16x8_t svorqv_u16(svbool_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s8)))
int8x16_t svorqv_s8(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s32)))
int32x4_t svorqv_s32(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s64)))
int64x2_t svorqv_s64(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s16)))
int16x8_t svorqv_s16(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u8)))
svbool_t svpmov_u8(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s8)))
svbool_t svpmov_s8(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u64)))
svbool_t svpmov_u64(svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s64)))
svbool_t svpmov_s64(svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u16)))
svbool_t svpmov_u16(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s16)))
svbool_t svpmov_s16(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u32)))
svbool_t svpmov_u32(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s32)))
svbool_t svpmov_s32(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u8)))
svbool_t svpmov_lane_u8(svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s8)))
svbool_t svpmov_lane_s8(svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u64)))
svbool_t svpmov_lane_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s64)))
svbool_t svpmov_lane_s64(svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u16)))
svbool_t svpmov_lane_u16(svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s16)))
svbool_t svpmov_lane_s16(svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u32)))
svbool_t svpmov_lane_u32(svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s32)))
svbool_t svpmov_lane_s32(svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u64_m)))
svuint64_t svpmov_lane_u64_m(svuint64_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s64_m)))
svint64_t svpmov_lane_s64_m(svint64_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u16_m)))
svuint16_t svpmov_lane_u16_m(svuint16_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s16_m)))
svint16_t svpmov_lane_s16_m(svint16_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u32_m)))
svuint32_t svpmov_lane_u32_m(svuint32_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s32_m)))
svint32_t svpmov_lane_s32_m(svint32_t, svbool_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u8_z)))
svuint8_t svpmov_u8_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s8_z)))
svint8_t svpmov_s8_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u64_z)))
svuint64_t svpmov_u64_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s64_z)))
svint64_t svpmov_s64_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u16_z)))
svuint16_t svpmov_u16_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s16_z)))
svint16_t svpmov_s16_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u32_z)))
svuint32_t svpmov_u32_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s32_z)))
svint32_t svpmov_s32_z(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u8)))
void svst2q_u8(svbool_t, uint8_t const *, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u32)))
void svst2q_u32(svbool_t, uint32_t const *, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u64)))
void svst2q_u64(svbool_t, uint64_t const *, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u16)))
void svst2q_u16(svbool_t, uint16_t const *, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_bf16)))
void svst2q_bf16(svbool_t, bfloat16_t const *, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s8)))
void svst2q_s8(svbool_t, int8_t const *, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f64)))
void svst2q_f64(svbool_t, float64_t const *, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f32)))
void svst2q_f32(svbool_t, float32_t const *, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f16)))
void svst2q_f16(svbool_t, float16_t const *, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s32)))
void svst2q_s32(svbool_t, int32_t const *, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s64)))
void svst2q_s64(svbool_t, int64_t const *, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_mf8)))
void svst2q_mf8(svbool_t, mfloat8_t const *, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s16)))
void svst2q_s16(svbool_t, int16_t const *, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u8)))
void svst2q_vnum_u8(svbool_t, uint8_t const *, int64_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u32)))
void svst2q_vnum_u32(svbool_t, uint32_t const *, int64_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u64)))
void svst2q_vnum_u64(svbool_t, uint64_t const *, int64_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u16)))
void svst2q_vnum_u16(svbool_t, uint16_t const *, int64_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_bf16)))
void svst2q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s8)))
void svst2q_vnum_s8(svbool_t, int8_t const *, int64_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f64)))
void svst2q_vnum_f64(svbool_t, float64_t const *, int64_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f32)))
void svst2q_vnum_f32(svbool_t, float32_t const *, int64_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f16)))
void svst2q_vnum_f16(svbool_t, float16_t const *, int64_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s32)))
void svst2q_vnum_s32(svbool_t, int32_t const *, int64_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s64)))
void svst2q_vnum_s64(svbool_t, int64_t const *, int64_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_mf8)))
void svst2q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s16)))
void svst2q_vnum_s16(svbool_t, int16_t const *, int64_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u8)))
void svst3q_u8(svbool_t, uint8_t const *, svuint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u32)))
void svst3q_u32(svbool_t, uint32_t const *, svuint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u64)))
void svst3q_u64(svbool_t, uint64_t const *, svuint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u16)))
void svst3q_u16(svbool_t, uint16_t const *, svuint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_bf16)))
void svst3q_bf16(svbool_t, bfloat16_t const *, svbfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s8)))
void svst3q_s8(svbool_t, int8_t const *, svint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f64)))
void svst3q_f64(svbool_t, float64_t const *, svfloat64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f32)))
void svst3q_f32(svbool_t, float32_t const *, svfloat32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f16)))
void svst3q_f16(svbool_t, float16_t const *, svfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s32)))
void svst3q_s32(svbool_t, int32_t const *, svint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s64)))
void svst3q_s64(svbool_t, int64_t const *, svint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_mf8)))
void svst3q_mf8(svbool_t, mfloat8_t const *, svmfloat8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s16)))
void svst3q_s16(svbool_t, int16_t const *, svint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u8)))
void svst3q_vnum_u8(svbool_t, uint8_t const *, int64_t, svuint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u32)))
void svst3q_vnum_u32(svbool_t, uint32_t const *, int64_t, svuint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u64)))
void svst3q_vnum_u64(svbool_t, uint64_t const *, int64_t, svuint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u16)))
void svst3q_vnum_u16(svbool_t, uint16_t const *, int64_t, svuint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_bf16)))
void svst3q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t, svbfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s8)))
void svst3q_vnum_s8(svbool_t, int8_t const *, int64_t, svint8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f64)))
void svst3q_vnum_f64(svbool_t, float64_t const *, int64_t, svfloat64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f32)))
void svst3q_vnum_f32(svbool_t, float32_t const *, int64_t, svfloat32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f16)))
void svst3q_vnum_f16(svbool_t, float16_t const *, int64_t, svfloat16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s32)))
void svst3q_vnum_s32(svbool_t, int32_t const *, int64_t, svint32x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s64)))
void svst3q_vnum_s64(svbool_t, int64_t const *, int64_t, svint64x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_mf8)))
void svst3q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t, svmfloat8x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s16)))
void svst3q_vnum_s16(svbool_t, int16_t const *, int64_t, svint16x3_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u8)))
void svst4q_u8(svbool_t, uint8_t const *, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u32)))
void svst4q_u32(svbool_t, uint32_t const *, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u64)))
void svst4q_u64(svbool_t, uint64_t const *, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u16)))
void svst4q_u16(svbool_t, uint16_t const *, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_bf16)))
void svst4q_bf16(svbool_t, bfloat16_t const *, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s8)))
void svst4q_s8(svbool_t, int8_t const *, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f64)))
void svst4q_f64(svbool_t, float64_t const *, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f32)))
void svst4q_f32(svbool_t, float32_t const *, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f16)))
void svst4q_f16(svbool_t, float16_t const *, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s32)))
void svst4q_s32(svbool_t, int32_t const *, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s64)))
void svst4q_s64(svbool_t, int64_t const *, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_mf8)))
void svst4q_mf8(svbool_t, mfloat8_t const *, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s16)))
void svst4q_s16(svbool_t, int16_t const *, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u8)))
void svst4q_vnum_u8(svbool_t, uint8_t const *, int64_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u32)))
void svst4q_vnum_u32(svbool_t, uint32_t const *, int64_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u64)))
void svst4q_vnum_u64(svbool_t, uint64_t const *, int64_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u16)))
void svst4q_vnum_u16(svbool_t, uint16_t const *, int64_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_bf16)))
void svst4q_vnum_bf16(svbool_t, bfloat16_t const *, int64_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s8)))
void svst4q_vnum_s8(svbool_t, int8_t const *, int64_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f64)))
void svst4q_vnum_f64(svbool_t, float64_t const *, int64_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f32)))
void svst4q_vnum_f32(svbool_t, float32_t const *, int64_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f16)))
void svst4q_vnum_f16(svbool_t, float16_t const *, int64_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s32)))
void svst4q_vnum_s32(svbool_t, int32_t const *, int64_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s64)))
void svst4q_vnum_s64(svbool_t, int64_t const *, int64_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_mf8)))
void svst4q_vnum_mf8(svbool_t, mfloat8_t const *, int64_t, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s16)))
void svst4q_vnum_s16(svbool_t, int16_t const *, int64_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u8)))
svuint8_t svtblq_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u32)))
svuint32_t svtblq_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u64)))
svuint64_t svtblq_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u16)))
svuint16_t svtblq_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_bf16)))
svbfloat16_t svtblq_bf16(svbfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s8)))
svint8_t svtblq_s8(svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f64)))
svfloat64_t svtblq_f64(svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f32)))
svfloat32_t svtblq_f32(svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f16)))
svfloat16_t svtblq_f16(svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s32)))
svint32_t svtblq_s32(svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s64)))
svint64_t svtblq_s64(svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_mf8)))
svmfloat8_t svtblq_mf8(svmfloat8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s16)))
svint16_t svtblq_s16(svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u8)))
svuint8_t svtbxq_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u32)))
svuint32_t svtbxq_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u64)))
svuint64_t svtbxq_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u16)))
svuint16_t svtbxq_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_bf16)))
svbfloat16_t svtbxq_bf16(svbfloat16_t, svbfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s8)))
svint8_t svtbxq_s8(svint8_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f64)))
svfloat64_t svtbxq_f64(svfloat64_t, svfloat64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f32)))
svfloat32_t svtbxq_f32(svfloat32_t, svfloat32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f16)))
svfloat16_t svtbxq_f16(svfloat16_t, svfloat16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s32)))
svint32_t svtbxq_s32(svint32_t, svint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s64)))
svint64_t svtbxq_s64(svint64_t, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_mf8)))
svmfloat8_t svtbxq_mf8(svmfloat8_t, svmfloat8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s16)))
svint16_t svtbxq_s16(svint16_t, svint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u8)))
svuint8_t svuzpq1_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u32)))
svuint32_t svuzpq1_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u64)))
svuint64_t svuzpq1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u16)))
svuint16_t svuzpq1_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_bf16)))
svbfloat16_t svuzpq1_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s8)))
svint8_t svuzpq1_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f64)))
svfloat64_t svuzpq1_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f32)))
svfloat32_t svuzpq1_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f16)))
svfloat16_t svuzpq1_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s32)))
svint32_t svuzpq1_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s64)))
svint64_t svuzpq1_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_mf8)))
svmfloat8_t svuzpq1_mf8(svmfloat8_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s16)))
svint16_t svuzpq1_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u8)))
svuint8_t svuzpq2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u32)))
svuint32_t svuzpq2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u64)))
svuint64_t svuzpq2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u16)))
svuint16_t svuzpq2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_bf16)))
svbfloat16_t svuzpq2_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s8)))
svint8_t svuzpq2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f64)))
svfloat64_t svuzpq2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f32)))
svfloat32_t svuzpq2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f16)))
svfloat16_t svuzpq2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s32)))
svint32_t svuzpq2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s64)))
svint64_t svuzpq2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_mf8)))
svmfloat8_t svuzpq2_mf8(svmfloat8_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s16)))
svint16_t svuzpq2_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u8)))
svuint8_t svzipq1_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u32)))
svuint32_t svzipq1_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u64)))
svuint64_t svzipq1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u16)))
svuint16_t svzipq1_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_bf16)))
svbfloat16_t svzipq1_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s8)))
svint8_t svzipq1_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f64)))
svfloat64_t svzipq1_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f32)))
svfloat32_t svzipq1_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f16)))
svfloat16_t svzipq1_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s32)))
svint32_t svzipq1_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s64)))
svint64_t svzipq1_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_mf8)))
svmfloat8_t svzipq1_mf8(svmfloat8_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s16)))
svint16_t svzipq1_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u8)))
svuint8_t svzipq2_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u32)))
svuint32_t svzipq2_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u64)))
svuint64_t svzipq2_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u16)))
svuint16_t svzipq2_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_bf16)))
svbfloat16_t svzipq2_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s8)))
svint8_t svzipq2_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f64)))
svfloat64_t svzipq2_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f32)))
svfloat32_t svzipq2_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f16)))
svfloat16_t svzipq2_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s32)))
svint32_t svzipq2_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s64)))
svint64_t svzipq2_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_mf8)))
svmfloat8_t svzipq2_mf8(svmfloat8_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s16)))
svint16_t svzipq2_s16(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u8)))
uint8x16_t svaddqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u32)))
uint32x4_t svaddqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u64)))
uint64x2_t svaddqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_u16)))
uint16x8_t svaddqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s8)))
int8x16_t svaddqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s32)))
int32x4_t svaddqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s64)))
int64x2_t svaddqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_s16)))
int16x8_t svaddqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f64)))
float64x2_t svaddqv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f32)))
float32x4_t svaddqv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddqv_f16)))
float16x8_t svaddqv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u8)))
uint8x16_t svandqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u32)))
uint32x4_t svandqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u64)))
uint64x2_t svandqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_u16)))
uint16x8_t svandqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s8)))
int8x16_t svandqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s32)))
int32x4_t svandqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s64)))
int64x2_t svandqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svandqv_s16)))
int16x8_t svandqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u8)))
svuint8_t svdup_laneq(svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s8)))
svint8_t svdup_laneq(svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_mf8)))
svmfloat8_t svdup_laneq(svmfloat8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u64)))
svuint64_t svdup_laneq(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f64)))
svfloat64_t svdup_laneq(svfloat64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s64)))
svint64_t svdup_laneq(svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u16)))
svuint16_t svdup_laneq(svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_bf16)))
svbfloat16_t svdup_laneq(svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f16)))
svfloat16_t svdup_laneq(svfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s16)))
svint16_t svdup_laneq(svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_u32)))
svuint32_t svdup_laneq(svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_f32)))
svfloat32_t svdup_laneq(svfloat32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdup_laneq_s32)))
svint32_t svdup_laneq(svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u8)))
uint8x16_t sveorqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u32)))
uint32x4_t sveorqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u64)))
uint64x2_t sveorqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_u16)))
uint16x8_t sveorqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s8)))
int8x16_t sveorqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s32)))
int32x4_t sveorqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s64)))
int64x2_t sveorqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorqv_s16)))
int16x8_t sveorqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u8)))
svuint8_t svextq(svuint8_t, svuint8_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u32)))
svuint32_t svextq(svuint32_t, svuint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u64)))
svuint64_t svextq(svuint64_t, svuint64_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_u16)))
svuint16_t svextq(svuint16_t, svuint16_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_bf16)))
svbfloat16_t svextq(svbfloat16_t, svbfloat16_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s8)))
svint8_t svextq(svint8_t, svint8_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f64)))
svfloat64_t svextq(svfloat64_t, svfloat64_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f32)))
svfloat32_t svextq(svfloat32_t, svfloat32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_f16)))
svfloat16_t svextq(svfloat16_t, svfloat16_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s32)))
svint32_t svextq(svint32_t, svint32_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s64)))
svint64_t svextq(svint64_t, svint64_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_mf8)))
svmfloat8_t svextq(svmfloat8_t, svmfloat8_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svextq_s16)))
svint16_t svextq(svint16_t, svint16_t, int32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u8)))
svuint8x2_t svld2q(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u32)))
svuint32x2_t svld2q(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u64)))
svuint64x2_t svld2q(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_u16)))
svuint16x2_t svld2q(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_bf16)))
svbfloat16x2_t svld2q(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s8)))
svint8x2_t svld2q(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f64)))
svfloat64x2_t svld2q(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f32)))
svfloat32x2_t svld2q(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_f16)))
svfloat16x2_t svld2q(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s32)))
svint32x2_t svld2q(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s64)))
svint64x2_t svld2q(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_mf8)))
svmfloat8x2_t svld2q(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_s16)))
svint16x2_t svld2q(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u8)))
svuint8x2_t svld2q_vnum(svbool_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u32)))
svuint32x2_t svld2q_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u64)))
svuint64x2_t svld2q_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_u16)))
svuint16x2_t svld2q_vnum(svbool_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_bf16)))
svbfloat16x2_t svld2q_vnum(svbool_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s8)))
svint8x2_t svld2q_vnum(svbool_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f64)))
svfloat64x2_t svld2q_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f32)))
svfloat32x2_t svld2q_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_f16)))
svfloat16x2_t svld2q_vnum(svbool_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s32)))
svint32x2_t svld2q_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s64)))
svint64x2_t svld2q_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_mf8)))
svmfloat8x2_t svld2q_vnum(svbool_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld2q_vnum_s16)))
svint16x2_t svld2q_vnum(svbool_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u8)))
svuint8x3_t svld3q(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u32)))
svuint32x3_t svld3q(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u64)))
svuint64x3_t svld3q(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_u16)))
svuint16x3_t svld3q(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_bf16)))
svbfloat16x3_t svld3q(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s8)))
svint8x3_t svld3q(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f64)))
svfloat64x3_t svld3q(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f32)))
svfloat32x3_t svld3q(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_f16)))
svfloat16x3_t svld3q(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s32)))
svint32x3_t svld3q(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s64)))
svint64x3_t svld3q(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_mf8)))
svmfloat8x3_t svld3q(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_s16)))
svint16x3_t svld3q(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u8)))
svuint8x3_t svld3q_vnum(svbool_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u32)))
svuint32x3_t svld3q_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u64)))
svuint64x3_t svld3q_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_u16)))
svuint16x3_t svld3q_vnum(svbool_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_bf16)))
svbfloat16x3_t svld3q_vnum(svbool_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s8)))
svint8x3_t svld3q_vnum(svbool_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f64)))
svfloat64x3_t svld3q_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f32)))
svfloat32x3_t svld3q_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_f16)))
svfloat16x3_t svld3q_vnum(svbool_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s32)))
svint32x3_t svld3q_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s64)))
svint64x3_t svld3q_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_mf8)))
svmfloat8x3_t svld3q_vnum(svbool_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld3q_vnum_s16)))
svint16x3_t svld3q_vnum(svbool_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u8)))
svuint8x4_t svld4q(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u32)))
svuint32x4_t svld4q(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u64)))
svuint64x4_t svld4q(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_u16)))
svuint16x4_t svld4q(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_bf16)))
svbfloat16x4_t svld4q(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s8)))
svint8x4_t svld4q(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f64)))
svfloat64x4_t svld4q(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f32)))
svfloat32x4_t svld4q(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_f16)))
svfloat16x4_t svld4q(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s32)))
svint32x4_t svld4q(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s64)))
svint64x4_t svld4q(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_mf8)))
svmfloat8x4_t svld4q(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_s16)))
svint16x4_t svld4q(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u8)))
svuint8x4_t svld4q_vnum(svbool_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u32)))
svuint32x4_t svld4q_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u64)))
svuint64x4_t svld4q_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_u16)))
svuint16x4_t svld4q_vnum(svbool_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_bf16)))
svbfloat16x4_t svld4q_vnum(svbool_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s8)))
svint8x4_t svld4q_vnum(svbool_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f64)))
svfloat64x4_t svld4q_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f32)))
svfloat32x4_t svld4q_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_f16)))
svfloat16x4_t svld4q_vnum(svbool_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s32)))
svint32x4_t svld4q_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s64)))
svint64x4_t svld4q_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_mf8)))
svmfloat8x4_t svld4q_vnum(svbool_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld4q_vnum_s16)))
svint16x4_t svld4q_vnum(svbool_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f64)))
float64x2_t svmaxnmqv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f32)))
float32x4_t svmaxnmqv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmqv_f16)))
float16x8_t svmaxnmqv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f64)))
float64x2_t svmaxqv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f32)))
float32x4_t svmaxqv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_f16)))
float16x8_t svmaxqv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s8)))
int8x16_t svmaxqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s32)))
int32x4_t svmaxqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s64)))
int64x2_t svmaxqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_s16)))
int16x8_t svmaxqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u8)))
uint8x16_t svmaxqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u32)))
uint32x4_t svmaxqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u64)))
uint64x2_t svmaxqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxqv_u16)))
uint16x8_t svmaxqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f64)))
float64x2_t svminnmqv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f32)))
float32x4_t svminnmqv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmqv_f16)))
float16x8_t svminnmqv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f64)))
float64x2_t svminqv(svbool_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f32)))
float32x4_t svminqv(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_f16)))
float16x8_t svminqv(svbool_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s8)))
int8x16_t svminqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s32)))
int32x4_t svminqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s64)))
int64x2_t svminqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_s16)))
int16x8_t svminqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u8)))
uint8x16_t svminqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u32)))
uint32x4_t svminqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u64)))
uint64x2_t svminqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminqv_u16)))
uint16x8_t svminqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u8)))
uint8x16_t svorqv(svbool_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u32)))
uint32x4_t svorqv(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u64)))
uint64x2_t svorqv(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_u16)))
uint16x8_t svorqv(svbool_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s8)))
int8x16_t svorqv(svbool_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s32)))
int32x4_t svorqv(svbool_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s64)))
int64x2_t svorqv(svbool_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svorqv_s16)))
int16x8_t svorqv(svbool_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u8)))
svbool_t svpmov(svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s8)))
svbool_t svpmov(svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u64)))
svbool_t svpmov(svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s64)))
svbool_t svpmov(svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u16)))
svbool_t svpmov(svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s16)))
svbool_t svpmov(svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_u32)))
svbool_t svpmov(svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_s32)))
svbool_t svpmov(svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u8)))
svbool_t svpmov_lane(svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s8)))
svbool_t svpmov_lane(svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u64)))
svbool_t svpmov_lane(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s64)))
svbool_t svpmov_lane(svint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u16)))
svbool_t svpmov_lane(svuint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s16)))
svbool_t svpmov_lane(svint16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u32)))
svbool_t svpmov_lane(svuint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s32)))
svbool_t svpmov_lane(svint32_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u64_m)))
svuint64_t svpmov_lane_m(svuint64_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s64_m)))
svint64_t svpmov_lane_m(svint64_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u16_m)))
svuint16_t svpmov_lane_m(svuint16_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s16_m)))
svint16_t svpmov_lane_m(svint16_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_u32_m)))
svuint32_t svpmov_lane_m(svuint32_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmov_lane_s32_m)))
svint32_t svpmov_lane_m(svint32_t, svbool_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u8)))
void svst2q(svbool_t, uint8_t const *, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u32)))
void svst2q(svbool_t, uint32_t const *, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u64)))
void svst2q(svbool_t, uint64_t const *, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_u16)))
void svst2q(svbool_t, uint16_t const *, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_bf16)))
void svst2q(svbool_t, bfloat16_t const *, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s8)))
void svst2q(svbool_t, int8_t const *, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f64)))
void svst2q(svbool_t, float64_t const *, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f32)))
void svst2q(svbool_t, float32_t const *, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_f16)))
void svst2q(svbool_t, float16_t const *, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s32)))
void svst2q(svbool_t, int32_t const *, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s64)))
void svst2q(svbool_t, int64_t const *, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_mf8)))
void svst2q(svbool_t, mfloat8_t const *, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_s16)))
void svst2q(svbool_t, int16_t const *, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u8)))
void svst2q_vnum(svbool_t, uint8_t const *, int64_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u32)))
void svst2q_vnum(svbool_t, uint32_t const *, int64_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u64)))
void svst2q_vnum(svbool_t, uint64_t const *, int64_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_u16)))
void svst2q_vnum(svbool_t, uint16_t const *, int64_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_bf16)))
void svst2q_vnum(svbool_t, bfloat16_t const *, int64_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s8)))
void svst2q_vnum(svbool_t, int8_t const *, int64_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f64)))
void svst2q_vnum(svbool_t, float64_t const *, int64_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f32)))
void svst2q_vnum(svbool_t, float32_t const *, int64_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_f16)))
void svst2q_vnum(svbool_t, float16_t const *, int64_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s32)))
void svst2q_vnum(svbool_t, int32_t const *, int64_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s64)))
void svst2q_vnum(svbool_t, int64_t const *, int64_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_mf8)))
void svst2q_vnum(svbool_t, mfloat8_t const *, int64_t, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst2q_vnum_s16)))
void svst2q_vnum(svbool_t, int16_t const *, int64_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u8)))
void svst3q(svbool_t, uint8_t const *, svuint8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u32)))
void svst3q(svbool_t, uint32_t const *, svuint32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u64)))
void svst3q(svbool_t, uint64_t const *, svuint64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_u16)))
void svst3q(svbool_t, uint16_t const *, svuint16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_bf16)))
void svst3q(svbool_t, bfloat16_t const *, svbfloat16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s8)))
void svst3q(svbool_t, int8_t const *, svint8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f64)))
void svst3q(svbool_t, float64_t const *, svfloat64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f32)))
void svst3q(svbool_t, float32_t const *, svfloat32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_f16)))
void svst3q(svbool_t, float16_t const *, svfloat16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s32)))
void svst3q(svbool_t, int32_t const *, svint32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s64)))
void svst3q(svbool_t, int64_t const *, svint64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_mf8)))
void svst3q(svbool_t, mfloat8_t const *, svmfloat8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_s16)))
void svst3q(svbool_t, int16_t const *, svint16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u8)))
void svst3q_vnum(svbool_t, uint8_t const *, int64_t, svuint8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u32)))
void svst3q_vnum(svbool_t, uint32_t const *, int64_t, svuint32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u64)))
void svst3q_vnum(svbool_t, uint64_t const *, int64_t, svuint64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_u16)))
void svst3q_vnum(svbool_t, uint16_t const *, int64_t, svuint16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_bf16)))
void svst3q_vnum(svbool_t, bfloat16_t const *, int64_t, svbfloat16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s8)))
void svst3q_vnum(svbool_t, int8_t const *, int64_t, svint8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f64)))
void svst3q_vnum(svbool_t, float64_t const *, int64_t, svfloat64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f32)))
void svst3q_vnum(svbool_t, float32_t const *, int64_t, svfloat32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_f16)))
void svst3q_vnum(svbool_t, float16_t const *, int64_t, svfloat16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s32)))
void svst3q_vnum(svbool_t, int32_t const *, int64_t, svint32x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s64)))
void svst3q_vnum(svbool_t, int64_t const *, int64_t, svint64x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_mf8)))
void svst3q_vnum(svbool_t, mfloat8_t const *, int64_t, svmfloat8x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst3q_vnum_s16)))
void svst3q_vnum(svbool_t, int16_t const *, int64_t, svint16x3_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u8)))
void svst4q(svbool_t, uint8_t const *, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u32)))
void svst4q(svbool_t, uint32_t const *, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u64)))
void svst4q(svbool_t, uint64_t const *, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_u16)))
void svst4q(svbool_t, uint16_t const *, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_bf16)))
void svst4q(svbool_t, bfloat16_t const *, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s8)))
void svst4q(svbool_t, int8_t const *, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f64)))
void svst4q(svbool_t, float64_t const *, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f32)))
void svst4q(svbool_t, float32_t const *, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_f16)))
void svst4q(svbool_t, float16_t const *, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s32)))
void svst4q(svbool_t, int32_t const *, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s64)))
void svst4q(svbool_t, int64_t const *, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_mf8)))
void svst4q(svbool_t, mfloat8_t const *, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_s16)))
void svst4q(svbool_t, int16_t const *, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u8)))
void svst4q_vnum(svbool_t, uint8_t const *, int64_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u32)))
void svst4q_vnum(svbool_t, uint32_t const *, int64_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u64)))
void svst4q_vnum(svbool_t, uint64_t const *, int64_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_u16)))
void svst4q_vnum(svbool_t, uint16_t const *, int64_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_bf16)))
void svst4q_vnum(svbool_t, bfloat16_t const *, int64_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s8)))
void svst4q_vnum(svbool_t, int8_t const *, int64_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f64)))
void svst4q_vnum(svbool_t, float64_t const *, int64_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f32)))
void svst4q_vnum(svbool_t, float32_t const *, int64_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_f16)))
void svst4q_vnum(svbool_t, float16_t const *, int64_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s32)))
void svst4q_vnum(svbool_t, int32_t const *, int64_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s64)))
void svst4q_vnum(svbool_t, int64_t const *, int64_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_mf8)))
void svst4q_vnum(svbool_t, mfloat8_t const *, int64_t, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst4q_vnum_s16)))
void svst4q_vnum(svbool_t, int16_t const *, int64_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u8)))
svuint8_t svtblq(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u32)))
svuint32_t svtblq(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u64)))
svuint64_t svtblq(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_u16)))
svuint16_t svtblq(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_bf16)))
svbfloat16_t svtblq(svbfloat16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s8)))
svint8_t svtblq(svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f64)))
svfloat64_t svtblq(svfloat64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f32)))
svfloat32_t svtblq(svfloat32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_f16)))
svfloat16_t svtblq(svfloat16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s32)))
svint32_t svtblq(svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s64)))
svint64_t svtblq(svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_mf8)))
svmfloat8_t svtblq(svmfloat8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtblq_s16)))
svint16_t svtblq(svint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u8)))
svuint8_t svtbxq(svuint8_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u32)))
svuint32_t svtbxq(svuint32_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u64)))
svuint64_t svtbxq(svuint64_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_u16)))
svuint16_t svtbxq(svuint16_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_bf16)))
svbfloat16_t svtbxq(svbfloat16_t, svbfloat16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s8)))
svint8_t svtbxq(svint8_t, svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f64)))
svfloat64_t svtbxq(svfloat64_t, svfloat64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f32)))
svfloat32_t svtbxq(svfloat32_t, svfloat32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_f16)))
svfloat16_t svtbxq(svfloat16_t, svfloat16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s32)))
svint32_t svtbxq(svint32_t, svint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s64)))
svint64_t svtbxq(svint64_t, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_mf8)))
svmfloat8_t svtbxq(svmfloat8_t, svmfloat8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtbxq_s16)))
svint16_t svtbxq(svint16_t, svint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u8)))
svuint8_t svuzpq1(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u32)))
svuint32_t svuzpq1(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u64)))
svuint64_t svuzpq1(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_u16)))
svuint16_t svuzpq1(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_bf16)))
svbfloat16_t svuzpq1(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s8)))
svint8_t svuzpq1(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f64)))
svfloat64_t svuzpq1(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f32)))
svfloat32_t svuzpq1(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_f16)))
svfloat16_t svuzpq1(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s32)))
svint32_t svuzpq1(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s64)))
svint64_t svuzpq1(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_mf8)))
svmfloat8_t svuzpq1(svmfloat8_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq1_s16)))
svint16_t svuzpq1(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u8)))
svuint8_t svuzpq2(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u32)))
svuint32_t svuzpq2(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u64)))
svuint64_t svuzpq2(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_u16)))
svuint16_t svuzpq2(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_bf16)))
svbfloat16_t svuzpq2(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s8)))
svint8_t svuzpq2(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f64)))
svfloat64_t svuzpq2(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f32)))
svfloat32_t svuzpq2(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_f16)))
svfloat16_t svuzpq2(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s32)))
svint32_t svuzpq2(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s64)))
svint64_t svuzpq2(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_mf8)))
svmfloat8_t svuzpq2(svmfloat8_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzpq2_s16)))
svint16_t svuzpq2(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u8)))
svuint8_t svzipq1(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u32)))
svuint32_t svzipq1(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u64)))
svuint64_t svzipq1(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_u16)))
svuint16_t svzipq1(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_bf16)))
svbfloat16_t svzipq1(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s8)))
svint8_t svzipq1(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f64)))
svfloat64_t svzipq1(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f32)))
svfloat32_t svzipq1(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_f16)))
svfloat16_t svzipq1(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s32)))
svint32_t svzipq1(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s64)))
svint64_t svzipq1(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_mf8)))
svmfloat8_t svzipq1(svmfloat8_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq1_s16)))
svint16_t svzipq1(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u8)))
svuint8_t svzipq2(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u32)))
svuint32_t svzipq2(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u64)))
svuint64_t svzipq2(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_u16)))
svuint16_t svzipq2(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_bf16)))
svbfloat16_t svzipq2(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s8)))
svint8_t svzipq2(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f64)))
svfloat64_t svzipq2(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f32)))
svfloat32_t svzipq2(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_f16)))
svfloat16_t svzipq2(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s32)))
svint32_t svzipq2(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s64)))
svint64_t svzipq2(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_mf8)))
svmfloat8_t svzipq2(svmfloat8_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzipq2_s16)))
svint16_t svzipq2(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmmla_f32)))
svfloat32_t svbfmmla_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmmla_f32)))
svfloat32_t svbfmmla(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_n_f32)))
svfloat32_t svbfdot_n_f32(svfloat32_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_f32)))
svfloat32_t svbfdot_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_lane_f32)))
svfloat32_t svbfdot_lane_f32(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_n_f32)))
svfloat32_t svbfmlalb_n_f32(svfloat32_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_f32)))
svfloat32_t svbfmlalb_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_lane_f32)))
svfloat32_t svbfmlalb_lane_f32(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_n_f32)))
svfloat32_t svbfmlalt_n_f32(svfloat32_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_f32)))
svfloat32_t svbfmlalt_f32(svfloat32_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_lane_f32)))
svfloat32_t svbfmlalt_lane_f32(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_m)))
svbfloat16_t svcvt_bf16_f32_m(svbfloat16_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x)))
svbfloat16_t svcvt_bf16_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_z)))
svbfloat16_t svcvt_bf16_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_bf16_f32_m)))
svbfloat16_t svcvtnt_bf16_f32_m(svbfloat16_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_n_f32)))
svfloat32_t svbfdot(svfloat32_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_f32)))
svfloat32_t svbfdot(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfdot_lane_f32)))
svfloat32_t svbfdot_lane(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_n_f32)))
svfloat32_t svbfmlalb(svfloat32_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_f32)))
svfloat32_t svbfmlalb(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalb_lane_f32)))
svfloat32_t svbfmlalb_lane(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_n_f32)))
svfloat32_t svbfmlalt(svfloat32_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_f32)))
svfloat32_t svbfmlalt(svfloat32_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbfmlalt_lane_f32)))
svfloat32_t svbfmlalt_lane(svfloat32_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_m)))
svbfloat16_t svcvt_bf16_m(svbfloat16_t, svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_x)))
svbfloat16_t svcvt_bf16_x(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt_bf16_f32_z)))
svbfloat16_t svcvt_bf16_z(svbool_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_bf16_f32_m)))
svbfloat16_t svcvtnt_bf16_m(svbfloat16_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_f32)))
svfloat32_t svmmla_f32(svfloat32_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_f32)))
svfloat32_t svmmla(svfloat32_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u8)))
svuint8_t svld1ro_u8(svbool_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u32)))
svuint32_t svld1ro_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u64)))
svuint64_t svld1ro_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u16)))
svuint16_t svld1ro_u16(svbool_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_bf16)))
svbfloat16_t svld1ro_bf16(svbool_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s8)))
svint8_t svld1ro_s8(svbool_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f64)))
svfloat64_t svld1ro_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f32)))
svfloat32_t svld1ro_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f16)))
svfloat16_t svld1ro_f16(svbool_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s32)))
svint32_t svld1ro_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s64)))
svint64_t svld1ro_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_mf8)))
svmfloat8_t svld1ro_mf8(svbool_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s16)))
svint16_t svld1ro_s16(svbool_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_f64)))
svfloat64_t svmmla_f64(svfloat64_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u8)))
svuint8_t svtrn1q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u32)))
svuint32_t svtrn1q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u64)))
svuint64_t svtrn1q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u16)))
svuint16_t svtrn1q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_bf16)))
svbfloat16_t svtrn1q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s8)))
svint8_t svtrn1q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f64)))
svfloat64_t svtrn1q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f32)))
svfloat32_t svtrn1q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f16)))
svfloat16_t svtrn1q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s32)))
svint32_t svtrn1q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s64)))
svint64_t svtrn1q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s16)))
svint16_t svtrn1q_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u8)))
svuint8_t svtrn2q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u32)))
svuint32_t svtrn2q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u64)))
svuint64_t svtrn2q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u16)))
svuint16_t svtrn2q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_bf16)))
svbfloat16_t svtrn2q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s8)))
svint8_t svtrn2q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f64)))
svfloat64_t svtrn2q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f32)))
svfloat32_t svtrn2q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f16)))
svfloat16_t svtrn2q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s32)))
svint32_t svtrn2q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s64)))
svint64_t svtrn2q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s16)))
svint16_t svtrn2q_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u8)))
svuint8_t svuzp1q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u32)))
svuint32_t svuzp1q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u64)))
svuint64_t svuzp1q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u16)))
svuint16_t svuzp1q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_bf16)))
svbfloat16_t svuzp1q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s8)))
svint8_t svuzp1q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f64)))
svfloat64_t svuzp1q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f32)))
svfloat32_t svuzp1q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f16)))
svfloat16_t svuzp1q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s32)))
svint32_t svuzp1q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s64)))
svint64_t svuzp1q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s16)))
svint16_t svuzp1q_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u8)))
svuint8_t svuzp2q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u32)))
svuint32_t svuzp2q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u64)))
svuint64_t svuzp2q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u16)))
svuint16_t svuzp2q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_bf16)))
svbfloat16_t svuzp2q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s8)))
svint8_t svuzp2q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f64)))
svfloat64_t svuzp2q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f32)))
svfloat32_t svuzp2q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f16)))
svfloat16_t svuzp2q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s32)))
svint32_t svuzp2q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s64)))
svint64_t svuzp2q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s16)))
svint16_t svuzp2q_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u8)))
svuint8_t svzip1q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u32)))
svuint32_t svzip1q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u64)))
svuint64_t svzip1q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u16)))
svuint16_t svzip1q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_bf16)))
svbfloat16_t svzip1q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s8)))
svint8_t svzip1q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f64)))
svfloat64_t svzip1q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f32)))
svfloat32_t svzip1q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f16)))
svfloat16_t svzip1q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s32)))
svint32_t svzip1q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s64)))
svint64_t svzip1q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s16)))
svint16_t svzip1q_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u8)))
svuint8_t svzip2q_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u32)))
svuint32_t svzip2q_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u64)))
svuint64_t svzip2q_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u16)))
svuint16_t svzip2q_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_bf16)))
svbfloat16_t svzip2q_bf16(svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s8)))
svint8_t svzip2q_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f64)))
svfloat64_t svzip2q_f64(svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f32)))
svfloat32_t svzip2q_f32(svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f16)))
svfloat16_t svzip2q_f16(svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s32)))
svint32_t svzip2q_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s64)))
svint64_t svzip2q_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s16)))
svint16_t svzip2q_s16(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u8)))
svuint8_t svld1ro(svbool_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u32)))
svuint32_t svld1ro(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u64)))
svuint64_t svld1ro(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_u16)))
svuint16_t svld1ro(svbool_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_bf16)))
svbfloat16_t svld1ro(svbool_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s8)))
svint8_t svld1ro(svbool_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f64)))
svfloat64_t svld1ro(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f32)))
svfloat32_t svld1ro(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_f16)))
svfloat16_t svld1ro(svbool_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s32)))
svint32_t svld1ro(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s64)))
svint64_t svld1ro(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_mf8)))
svmfloat8_t svld1ro(svbool_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1ro_s16)))
svint16_t svld1ro(svbool_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_f64)))
svfloat64_t svmmla(svfloat64_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u8)))
svuint8_t svtrn1q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u32)))
svuint32_t svtrn1q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u64)))
svuint64_t svtrn1q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_u16)))
svuint16_t svtrn1q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_bf16)))
svbfloat16_t svtrn1q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s8)))
svint8_t svtrn1q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f64)))
svfloat64_t svtrn1q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f32)))
svfloat32_t svtrn1q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_f16)))
svfloat16_t svtrn1q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s32)))
svint32_t svtrn1q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s64)))
svint64_t svtrn1q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn1q_s16)))
svint16_t svtrn1q(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u8)))
svuint8_t svtrn2q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u32)))
svuint32_t svtrn2q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u64)))
svuint64_t svtrn2q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_u16)))
svuint16_t svtrn2q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_bf16)))
svbfloat16_t svtrn2q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s8)))
svint8_t svtrn2q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f64)))
svfloat64_t svtrn2q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f32)))
svfloat32_t svtrn2q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_f16)))
svfloat16_t svtrn2q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s32)))
svint32_t svtrn2q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s64)))
svint64_t svtrn2q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svtrn2q_s16)))
svint16_t svtrn2q(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u8)))
svuint8_t svuzp1q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u32)))
svuint32_t svuzp1q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u64)))
svuint64_t svuzp1q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_u16)))
svuint16_t svuzp1q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_bf16)))
svbfloat16_t svuzp1q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s8)))
svint8_t svuzp1q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f64)))
svfloat64_t svuzp1q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f32)))
svfloat32_t svuzp1q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_f16)))
svfloat16_t svuzp1q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s32)))
svint32_t svuzp1q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s64)))
svint64_t svuzp1q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp1q_s16)))
svint16_t svuzp1q(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u8)))
svuint8_t svuzp2q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u32)))
svuint32_t svuzp2q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u64)))
svuint64_t svuzp2q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_u16)))
svuint16_t svuzp2q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_bf16)))
svbfloat16_t svuzp2q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s8)))
svint8_t svuzp2q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f64)))
svfloat64_t svuzp2q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f32)))
svfloat32_t svuzp2q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_f16)))
svfloat16_t svuzp2q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s32)))
svint32_t svuzp2q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s64)))
svint64_t svuzp2q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svuzp2q_s16)))
svint16_t svuzp2q(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u8)))
svuint8_t svzip1q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u32)))
svuint32_t svzip1q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u64)))
svuint64_t svzip1q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_u16)))
svuint16_t svzip1q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_bf16)))
svbfloat16_t svzip1q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s8)))
svint8_t svzip1q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f64)))
svfloat64_t svzip1q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f32)))
svfloat32_t svzip1q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_f16)))
svfloat16_t svzip1q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s32)))
svint32_t svzip1q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s64)))
svint64_t svzip1q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip1q_s16)))
svint16_t svzip1q(svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u8)))
svuint8_t svzip2q(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u32)))
svuint32_t svzip2q(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u64)))
svuint64_t svzip2q(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_u16)))
svuint16_t svzip2q(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_bf16)))
svbfloat16_t svzip2q(svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s8)))
svint8_t svzip2q(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f64)))
svfloat64_t svzip2q(svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f32)))
svfloat32_t svzip2q(svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_f16)))
svfloat16_t svzip2q(svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s32)))
svint32_t svzip2q(svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s64)))
svint64_t svzip2q(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svzip2q_s16)))
svint16_t svzip2q(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_s32)))
svint32_t svmmla_s32(svint32_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_u32)))
svuint32_t svmmla_u32(svuint32_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusmmla_s32)))
svint32_t svusmmla_s32(svint32_t, svuint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_s32)))
svint32_t svmmla(svint32_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmmla_u32)))
svuint32_t svmmla(svuint32_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusmmla_s32)))
svint32_t svusmmla(svint32_t, svuint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_n_s32)))
svint32_t svsudot_n_s32(svint32_t, svint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_s32)))
svint32_t svsudot_s32(svint32_t, svint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_lane_s32)))
svint32_t svsudot_lane_s32(svint32_t, svint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_n_s32)))
svint32_t svusdot_n_s32(svint32_t, svuint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_s32)))
svint32_t svusdot_s32(svint32_t, svuint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_lane_s32)))
svint32_t svusdot_lane_s32(svint32_t, svuint8_t, svint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_n_s32)))
svint32_t svsudot(svint32_t, svint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_s32)))
svint32_t svsudot(svint32_t, svint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsudot_lane_s32)))
svint32_t svsudot_lane(svint32_t, svint8_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_n_s32)))
svint32_t svusdot(svint32_t, svuint8_t, int8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_s32)))
svint32_t svusdot(svint32_t, svuint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svusdot_lane_s32)))
svint32_t svusdot_lane(svint32_t, svuint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrax1_u64)))
svuint64_t svrax1_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrax1_s64)))
svint64_t svrax1_s64(svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrax1_u64)))
svuint64_t svrax1(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svrax1_s64)))
svint64_t svrax1(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_u32_z)))
svuint32_t svhistcnt_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_u64_z)))
svuint64_t svhistcnt_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_s32_z)))
svuint32_t svhistcnt_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_s64_z)))
svuint64_t svhistcnt_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistseg_u8)))
svuint8_t svhistseg_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistseg_s8)))
svuint8_t svhistseg_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_u32)))
svuint32_t svldnt1_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_u64)))
svuint64_t svldnt1_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_f64)))
svfloat64_t svldnt1_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_f32)))
svfloat32_t svldnt1_gather_u32base_index_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_s32)))
svint32_t svldnt1_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_s64)))
svint64_t svldnt1_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_u32)))
svuint32_t svldnt1_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_u64)))
svuint64_t svldnt1_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_f64)))
svfloat64_t svldnt1_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_f32)))
svfloat32_t svldnt1_gather_u32base_offset_f32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_s32)))
svint32_t svldnt1_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_s64)))
svint64_t svldnt1_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_u32)))
svuint32_t svldnt1_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_u64)))
svuint64_t svldnt1_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_f64)))
svfloat64_t svldnt1_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_f32)))
svfloat32_t svldnt1_gather_u32base_f32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_s32)))
svint32_t svldnt1_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_s64)))
svint64_t svldnt1_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_u64)))
svuint64_t svldnt1_gather_s64index_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_f64)))
svfloat64_t svldnt1_gather_s64index_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_s64)))
svint64_t svldnt1_gather_s64index_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_u64)))
svuint64_t svldnt1_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_f64)))
svfloat64_t svldnt1_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_s64)))
svint64_t svldnt1_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_u32)))
svuint32_t svldnt1_gather_u32offset_u32(svbool_t, uint32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_f32)))
svfloat32_t svldnt1_gather_u32offset_f32(svbool_t, float32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_s32)))
svint32_t svldnt1_gather_u32offset_s32(svbool_t, int32_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_u64)))
svuint64_t svldnt1_gather_s64offset_u64(svbool_t, uint64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_f64)))
svfloat64_t svldnt1_gather_s64offset_f64(svbool_t, float64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_s64)))
svint64_t svldnt1_gather_s64offset_s64(svbool_t, int64_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_u64)))
svuint64_t svldnt1_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_f64)))
svfloat64_t svldnt1_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_s64)))
svint64_t svldnt1_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_offset_u32)))
svuint32_t svldnt1sb_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_offset_u64)))
svuint64_t svldnt1sb_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_offset_s32)))
svint32_t svldnt1sb_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_offset_s64)))
svint64_t svldnt1sb_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_u32)))
svuint32_t svldnt1sb_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_u64)))
svuint64_t svldnt1sb_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_s32)))
svint32_t svldnt1sb_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_s64)))
svint64_t svldnt1sb_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32offset_u32)))
svuint32_t svldnt1sb_gather_u32offset_u32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32offset_s32)))
svint32_t svldnt1sb_gather_u32offset_s32(svbool_t, int8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_s64offset_u64)))
svuint64_t svldnt1sb_gather_s64offset_u64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_s64offset_s64)))
svint64_t svldnt1sb_gather_s64offset_s64(svbool_t, int8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64offset_u64)))
svuint64_t svldnt1sb_gather_u64offset_u64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64offset_s64)))
svint64_t svldnt1sb_gather_u64offset_s64(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_index_u32)))
svuint32_t svldnt1sh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_index_u64)))
svuint64_t svldnt1sh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_index_s32)))
svint32_t svldnt1sh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_index_s64)))
svint64_t svldnt1sh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_offset_u32)))
svuint32_t svldnt1sh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_offset_u64)))
svuint64_t svldnt1sh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_offset_s32)))
svint32_t svldnt1sh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_offset_s64)))
svint64_t svldnt1sh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_u32)))
svuint32_t svldnt1sh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_u64)))
svuint64_t svldnt1sh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_s32)))
svint32_t svldnt1sh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_s64)))
svint64_t svldnt1sh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64index_u64)))
svuint64_t svldnt1sh_gather_s64index_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64index_s64)))
svint64_t svldnt1sh_gather_s64index_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64index_u64)))
svuint64_t svldnt1sh_gather_u64index_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64index_s64)))
svint64_t svldnt1sh_gather_u64index_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32offset_u32)))
svuint32_t svldnt1sh_gather_u32offset_u32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32offset_s32)))
svint32_t svldnt1sh_gather_u32offset_s32(svbool_t, int16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64offset_u64)))
svuint64_t svldnt1sh_gather_s64offset_u64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64offset_s64)))
svint64_t svldnt1sh_gather_s64offset_s64(svbool_t, int16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64offset_u64)))
svuint64_t svldnt1sh_gather_u64offset_u64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64offset_s64)))
svint64_t svldnt1sh_gather_u64offset_s64(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_index_u64)))
svuint64_t svldnt1sw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_index_s64)))
svint64_t svldnt1sw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_offset_u64)))
svuint64_t svldnt1sw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_offset_s64)))
svint64_t svldnt1sw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_u64)))
svuint64_t svldnt1sw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_s64)))
svint64_t svldnt1sw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64index_u64)))
svuint64_t svldnt1sw_gather_s64index_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64index_s64)))
svint64_t svldnt1sw_gather_s64index_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64index_u64)))
svuint64_t svldnt1sw_gather_u64index_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64index_s64)))
svint64_t svldnt1sw_gather_u64index_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64offset_u64)))
svuint64_t svldnt1sw_gather_s64offset_u64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64offset_s64)))
svint64_t svldnt1sw_gather_s64offset_s64(svbool_t, int32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64offset_u64)))
svuint64_t svldnt1sw_gather_u64offset_u64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64offset_s64)))
svint64_t svldnt1sw_gather_u64offset_s64(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_offset_u32)))
svuint32_t svldnt1ub_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_offset_u64)))
svuint64_t svldnt1ub_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_offset_s32)))
svint32_t svldnt1ub_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_offset_s64)))
svint64_t svldnt1ub_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_u32)))
svuint32_t svldnt1ub_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_u64)))
svuint64_t svldnt1ub_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_s32)))
svint32_t svldnt1ub_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_s64)))
svint64_t svldnt1ub_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32offset_u32)))
svuint32_t svldnt1ub_gather_u32offset_u32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32offset_s32)))
svint32_t svldnt1ub_gather_u32offset_s32(svbool_t, uint8_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_s64offset_u64)))
svuint64_t svldnt1ub_gather_s64offset_u64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_s64offset_s64)))
svint64_t svldnt1ub_gather_s64offset_s64(svbool_t, uint8_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64offset_u64)))
svuint64_t svldnt1ub_gather_u64offset_u64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64offset_s64)))
svint64_t svldnt1ub_gather_u64offset_s64(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_index_u32)))
svuint32_t svldnt1uh_gather_u32base_index_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_index_u64)))
svuint64_t svldnt1uh_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_index_s32)))
svint32_t svldnt1uh_gather_u32base_index_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_index_s64)))
svint64_t svldnt1uh_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_offset_u32)))
svuint32_t svldnt1uh_gather_u32base_offset_u32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_offset_u64)))
svuint64_t svldnt1uh_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_offset_s32)))
svint32_t svldnt1uh_gather_u32base_offset_s32(svbool_t, svuint32_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_offset_s64)))
svint64_t svldnt1uh_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_u32)))
svuint32_t svldnt1uh_gather_u32base_u32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_u64)))
svuint64_t svldnt1uh_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_s32)))
svint32_t svldnt1uh_gather_u32base_s32(svbool_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_s64)))
svint64_t svldnt1uh_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64index_u64)))
svuint64_t svldnt1uh_gather_s64index_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64index_s64)))
svint64_t svldnt1uh_gather_s64index_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64index_u64)))
svuint64_t svldnt1uh_gather_u64index_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64index_s64)))
svint64_t svldnt1uh_gather_u64index_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32offset_u32)))
svuint32_t svldnt1uh_gather_u32offset_u32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32offset_s32)))
svint32_t svldnt1uh_gather_u32offset_s32(svbool_t, uint16_t const *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64offset_u64)))
svuint64_t svldnt1uh_gather_s64offset_u64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64offset_s64)))
svint64_t svldnt1uh_gather_s64offset_s64(svbool_t, uint16_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64offset_u64)))
svuint64_t svldnt1uh_gather_u64offset_u64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64offset_s64)))
svint64_t svldnt1uh_gather_u64offset_s64(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_index_u64)))
svuint64_t svldnt1uw_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_index_s64)))
svint64_t svldnt1uw_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_offset_u64)))
svuint64_t svldnt1uw_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_offset_s64)))
svint64_t svldnt1uw_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_u64)))
svuint64_t svldnt1uw_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_s64)))
svint64_t svldnt1uw_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64index_u64)))
svuint64_t svldnt1uw_gather_s64index_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64index_s64)))
svint64_t svldnt1uw_gather_s64index_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64index_u64)))
svuint64_t svldnt1uw_gather_u64index_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64index_s64)))
svint64_t svldnt1uw_gather_u64index_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64offset_u64)))
svuint64_t svldnt1uw_gather_s64offset_u64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64offset_s64)))
svint64_t svldnt1uw_gather_s64offset_s64(svbool_t, uint32_t const *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64offset_u64)))
svuint64_t svldnt1uw_gather_u64offset_u64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64offset_s64)))
svint64_t svldnt1uw_gather_u64offset_s64(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_u8)))
svbool_t svmatch_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_u16)))
svbool_t svmatch_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_s8)))
svbool_t svmatch_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_s16)))
svbool_t svmatch_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_u8)))
svbool_t svnmatch_u8(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_u16)))
svbool_t svnmatch_u16(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_s8)))
svbool_t svnmatch_s8(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_s16)))
svbool_t svnmatch_s16(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_u32)))
void svstnt1_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_u64)))
void svstnt1_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_f64)))
void svstnt1_scatter_u64base_index_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_f32)))
void svstnt1_scatter_u32base_index_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_s32)))
void svstnt1_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_s64)))
void svstnt1_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_u32)))
void svstnt1_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_u64)))
void svstnt1_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_f64)))
void svstnt1_scatter_u64base_offset_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_f32)))
void svstnt1_scatter_u32base_offset_f32(svbool_t, svuint32_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_s32)))
void svstnt1_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_s64)))
void svstnt1_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_u32)))
void svstnt1_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_u64)))
void svstnt1_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_f64)))
void svstnt1_scatter_u64base_f64(svbool_t, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_f32)))
void svstnt1_scatter_u32base_f32(svbool_t, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_s32)))
void svstnt1_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_s64)))
void svstnt1_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_u64)))
void svstnt1_scatter_s64index_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_f64)))
void svstnt1_scatter_s64index_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_s64)))
void svstnt1_scatter_s64index_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_u64)))
void svstnt1_scatter_u64index_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_f64)))
void svstnt1_scatter_u64index_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_s64)))
void svstnt1_scatter_u64index_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_u32)))
void svstnt1_scatter_u32offset_u32(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_f32)))
void svstnt1_scatter_u32offset_f32(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_s32)))
void svstnt1_scatter_u32offset_s32(svbool_t, int32_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_u64)))
void svstnt1_scatter_s64offset_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_f64)))
void svstnt1_scatter_s64offset_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_s64)))
void svstnt1_scatter_s64offset_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_u64)))
void svstnt1_scatter_u64offset_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_f64)))
void svstnt1_scatter_u64offset_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_s64)))
void svstnt1_scatter_u64offset_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_offset_u32)))
void svstnt1b_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_offset_u64)))
void svstnt1b_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_offset_s32)))
void svstnt1b_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_offset_s64)))
void svstnt1b_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_u32)))
void svstnt1b_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_u64)))
void svstnt1b_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_s32)))
void svstnt1b_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_s64)))
void svstnt1b_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32offset_s32)))
void svstnt1b_scatter_u32offset_s32(svbool_t, int8_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32offset_u32)))
void svstnt1b_scatter_u32offset_u32(svbool_t, uint8_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_s64offset_s64)))
void svstnt1b_scatter_s64offset_s64(svbool_t, int8_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_s64offset_u64)))
void svstnt1b_scatter_s64offset_u64(svbool_t, uint8_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64offset_s64)))
void svstnt1b_scatter_u64offset_s64(svbool_t, int8_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64offset_u64)))
void svstnt1b_scatter_u64offset_u64(svbool_t, uint8_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_index_u32)))
void svstnt1h_scatter_u32base_index_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_index_u64)))
void svstnt1h_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_index_s32)))
void svstnt1h_scatter_u32base_index_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_index_s64)))
void svstnt1h_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_offset_u32)))
void svstnt1h_scatter_u32base_offset_u32(svbool_t, svuint32_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_offset_u64)))
void svstnt1h_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_offset_s32)))
void svstnt1h_scatter_u32base_offset_s32(svbool_t, svuint32_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_offset_s64)))
void svstnt1h_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_u32)))
void svstnt1h_scatter_u32base_u32(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_u64)))
void svstnt1h_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_s32)))
void svstnt1h_scatter_u32base_s32(svbool_t, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_s64)))
void svstnt1h_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64index_s64)))
void svstnt1h_scatter_s64index_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64index_u64)))
void svstnt1h_scatter_s64index_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64index_s64)))
void svstnt1h_scatter_u64index_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64index_u64)))
void svstnt1h_scatter_u64index_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32offset_s32)))
void svstnt1h_scatter_u32offset_s32(svbool_t, int16_t *, svuint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32offset_u32)))
void svstnt1h_scatter_u32offset_u32(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64offset_s64)))
void svstnt1h_scatter_s64offset_s64(svbool_t, int16_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64offset_u64)))
void svstnt1h_scatter_s64offset_u64(svbool_t, uint16_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64offset_s64)))
void svstnt1h_scatter_u64offset_s64(svbool_t, int16_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64offset_u64)))
void svstnt1h_scatter_u64offset_u64(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_index_u64)))
void svstnt1w_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_index_s64)))
void svstnt1w_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_offset_u64)))
void svstnt1w_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_offset_s64)))
void svstnt1w_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_u64)))
void svstnt1w_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_s64)))
void svstnt1w_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64index_s64)))
void svstnt1w_scatter_s64index_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64index_u64)))
void svstnt1w_scatter_s64index_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64index_s64)))
void svstnt1w_scatter_u64index_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64index_u64)))
void svstnt1w_scatter_u64index_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64offset_s64)))
void svstnt1w_scatter_s64offset_s64(svbool_t, int32_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64offset_u64)))
void svstnt1w_scatter_s64offset_u64(svbool_t, uint32_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64offset_s64)))
void svstnt1w_scatter_u64offset_s64(svbool_t, int32_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64offset_u64)))
void svstnt1w_scatter_u64offset_u64(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_u32_z)))
svuint32_t svhistcnt_z(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_u64_z)))
svuint64_t svhistcnt_z(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_s32_z)))
svuint32_t svhistcnt_z(svbool_t, svint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistcnt_s64_z)))
svuint64_t svhistcnt_z(svbool_t, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistseg_u8)))
svuint8_t svhistseg(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhistseg_s8)))
svuint8_t svhistseg(svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_u32)))
svuint32_t svldnt1_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_u64)))
svuint64_t svldnt1_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_f64)))
svfloat64_t svldnt1_gather_index_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_f32)))
svfloat32_t svldnt1_gather_index_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_index_s32)))
svint32_t svldnt1_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_index_s64)))
svint64_t svldnt1_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_u32)))
svuint32_t svldnt1_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_u64)))
svuint64_t svldnt1_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_f64)))
svfloat64_t svldnt1_gather_offset_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_f32)))
svfloat32_t svldnt1_gather_offset_f32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_offset_s32)))
svint32_t svldnt1_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_offset_s64)))
svint64_t svldnt1_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_u32)))
svuint32_t svldnt1_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_u64)))
svuint64_t svldnt1_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_f64)))
svfloat64_t svldnt1_gather_f64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_f32)))
svfloat32_t svldnt1_gather_f32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32base_s32)))
svint32_t svldnt1_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64base_s64)))
svint64_t svldnt1_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_u64)))
svuint64_t svldnt1_gather_index(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_f64)))
svfloat64_t svldnt1_gather_index(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64index_s64)))
svint64_t svldnt1_gather_index(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_u64)))
svuint64_t svldnt1_gather_index(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_f64)))
svfloat64_t svldnt1_gather_index(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64index_s64)))
svint64_t svldnt1_gather_index(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_u32)))
svuint32_t svldnt1_gather_offset(svbool_t, uint32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_f32)))
svfloat32_t svldnt1_gather_offset(svbool_t, float32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u32offset_s32)))
svint32_t svldnt1_gather_offset(svbool_t, int32_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_u64)))
svuint64_t svldnt1_gather_offset(svbool_t, uint64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_f64)))
svfloat64_t svldnt1_gather_offset(svbool_t, float64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_s64offset_s64)))
svint64_t svldnt1_gather_offset(svbool_t, int64_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_u64)))
svuint64_t svldnt1_gather_offset(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_f64)))
svfloat64_t svldnt1_gather_offset(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_gather_u64offset_s64)))
svint64_t svldnt1_gather_offset(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_offset_u32)))
svuint32_t svldnt1sb_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_offset_u64)))
svuint64_t svldnt1sb_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_offset_s32)))
svint32_t svldnt1sb_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_offset_s64)))
svint64_t svldnt1sb_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_u32)))
svuint32_t svldnt1sb_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_u64)))
svuint64_t svldnt1sb_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32base_s32)))
svint32_t svldnt1sb_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64base_s64)))
svint64_t svldnt1sb_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32offset_u32)))
svuint32_t svldnt1sb_gather_offset_u32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u32offset_s32)))
svint32_t svldnt1sb_gather_offset_s32(svbool_t, int8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_s64offset_u64)))
svuint64_t svldnt1sb_gather_offset_u64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_s64offset_s64)))
svint64_t svldnt1sb_gather_offset_s64(svbool_t, int8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64offset_u64)))
svuint64_t svldnt1sb_gather_offset_u64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sb_gather_u64offset_s64)))
svint64_t svldnt1sb_gather_offset_s64(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_index_u32)))
svuint32_t svldnt1sh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_index_u64)))
svuint64_t svldnt1sh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_index_s32)))
svint32_t svldnt1sh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_index_s64)))
svint64_t svldnt1sh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_offset_u32)))
svuint32_t svldnt1sh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_offset_u64)))
svuint64_t svldnt1sh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_offset_s32)))
svint32_t svldnt1sh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_offset_s64)))
svint64_t svldnt1sh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_u32)))
svuint32_t svldnt1sh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_u64)))
svuint64_t svldnt1sh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32base_s32)))
svint32_t svldnt1sh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64base_s64)))
svint64_t svldnt1sh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64index_u64)))
svuint64_t svldnt1sh_gather_index_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64index_s64)))
svint64_t svldnt1sh_gather_index_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64index_u64)))
svuint64_t svldnt1sh_gather_index_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64index_s64)))
svint64_t svldnt1sh_gather_index_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32offset_u32)))
svuint32_t svldnt1sh_gather_offset_u32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u32offset_s32)))
svint32_t svldnt1sh_gather_offset_s32(svbool_t, int16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64offset_u64)))
svuint64_t svldnt1sh_gather_offset_u64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_s64offset_s64)))
svint64_t svldnt1sh_gather_offset_s64(svbool_t, int16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64offset_u64)))
svuint64_t svldnt1sh_gather_offset_u64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sh_gather_u64offset_s64)))
svint64_t svldnt1sh_gather_offset_s64(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_index_u64)))
svuint64_t svldnt1sw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_index_s64)))
svint64_t svldnt1sw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_offset_u64)))
svuint64_t svldnt1sw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_offset_s64)))
svint64_t svldnt1sw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_u64)))
svuint64_t svldnt1sw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64base_s64)))
svint64_t svldnt1sw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64index_u64)))
svuint64_t svldnt1sw_gather_index_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64index_s64)))
svint64_t svldnt1sw_gather_index_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64index_u64)))
svuint64_t svldnt1sw_gather_index_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64index_s64)))
svint64_t svldnt1sw_gather_index_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64offset_u64)))
svuint64_t svldnt1sw_gather_offset_u64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_s64offset_s64)))
svint64_t svldnt1sw_gather_offset_s64(svbool_t, int32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64offset_u64)))
svuint64_t svldnt1sw_gather_offset_u64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1sw_gather_u64offset_s64)))
svint64_t svldnt1sw_gather_offset_s64(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_offset_u32)))
svuint32_t svldnt1ub_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_offset_u64)))
svuint64_t svldnt1ub_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_offset_s32)))
svint32_t svldnt1ub_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_offset_s64)))
svint64_t svldnt1ub_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_u32)))
svuint32_t svldnt1ub_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_u64)))
svuint64_t svldnt1ub_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32base_s32)))
svint32_t svldnt1ub_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64base_s64)))
svint64_t svldnt1ub_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32offset_u32)))
svuint32_t svldnt1ub_gather_offset_u32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u32offset_s32)))
svint32_t svldnt1ub_gather_offset_s32(svbool_t, uint8_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_s64offset_u64)))
svuint64_t svldnt1ub_gather_offset_u64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_s64offset_s64)))
svint64_t svldnt1ub_gather_offset_s64(svbool_t, uint8_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64offset_u64)))
svuint64_t svldnt1ub_gather_offset_u64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1ub_gather_u64offset_s64)))
svint64_t svldnt1ub_gather_offset_s64(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_index_u32)))
svuint32_t svldnt1uh_gather_index_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_index_u64)))
svuint64_t svldnt1uh_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_index_s32)))
svint32_t svldnt1uh_gather_index_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_index_s64)))
svint64_t svldnt1uh_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_offset_u32)))
svuint32_t svldnt1uh_gather_offset_u32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_offset_u64)))
svuint64_t svldnt1uh_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_offset_s32)))
svint32_t svldnt1uh_gather_offset_s32(svbool_t, svuint32_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_offset_s64)))
svint64_t svldnt1uh_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_u32)))
svuint32_t svldnt1uh_gather_u32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_u64)))
svuint64_t svldnt1uh_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32base_s32)))
svint32_t svldnt1uh_gather_s32(svbool_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64base_s64)))
svint64_t svldnt1uh_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64index_u64)))
svuint64_t svldnt1uh_gather_index_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64index_s64)))
svint64_t svldnt1uh_gather_index_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64index_u64)))
svuint64_t svldnt1uh_gather_index_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64index_s64)))
svint64_t svldnt1uh_gather_index_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32offset_u32)))
svuint32_t svldnt1uh_gather_offset_u32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u32offset_s32)))
svint32_t svldnt1uh_gather_offset_s32(svbool_t, uint16_t const *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64offset_u64)))
svuint64_t svldnt1uh_gather_offset_u64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_s64offset_s64)))
svint64_t svldnt1uh_gather_offset_s64(svbool_t, uint16_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64offset_u64)))
svuint64_t svldnt1uh_gather_offset_u64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uh_gather_u64offset_s64)))
svint64_t svldnt1uh_gather_offset_s64(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_index_u64)))
svuint64_t svldnt1uw_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_index_s64)))
svint64_t svldnt1uw_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_offset_u64)))
svuint64_t svldnt1uw_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_offset_s64)))
svint64_t svldnt1uw_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_u64)))
svuint64_t svldnt1uw_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64base_s64)))
svint64_t svldnt1uw_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64index_u64)))
svuint64_t svldnt1uw_gather_index_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64index_s64)))
svint64_t svldnt1uw_gather_index_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64index_u64)))
svuint64_t svldnt1uw_gather_index_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64index_s64)))
svint64_t svldnt1uw_gather_index_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64offset_u64)))
svuint64_t svldnt1uw_gather_offset_u64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_s64offset_s64)))
svint64_t svldnt1uw_gather_offset_s64(svbool_t, uint32_t const *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64offset_u64)))
svuint64_t svldnt1uw_gather_offset_u64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1uw_gather_u64offset_s64)))
svint64_t svldnt1uw_gather_offset_s64(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_u8)))
svbool_t svmatch(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_u16)))
svbool_t svmatch(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_s8)))
svbool_t svmatch(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmatch_s16)))
svbool_t svmatch(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_u8)))
svbool_t svnmatch(svbool_t, svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_u16)))
svbool_t svnmatch(svbool_t, svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_s8)))
svbool_t svnmatch(svbool_t, svint8_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnmatch_s16)))
svbool_t svnmatch(svbool_t, svint16_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_u32)))
void svstnt1_scatter_index(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_u64)))
void svstnt1_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_f64)))
void svstnt1_scatter_index(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_f32)))
void svstnt1_scatter_index(svbool_t, svuint32_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_index_s32)))
void svstnt1_scatter_index(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_index_s64)))
void svstnt1_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_u32)))
void svstnt1_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_u64)))
void svstnt1_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_f64)))
void svstnt1_scatter_offset(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_f32)))
void svstnt1_scatter_offset(svbool_t, svuint32_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_offset_s32)))
void svstnt1_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_offset_s64)))
void svstnt1_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_u32)))
void svstnt1_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_u64)))
void svstnt1_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_f64)))
void svstnt1_scatter(svbool_t, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_f32)))
void svstnt1_scatter(svbool_t, svuint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32base_s32)))
void svstnt1_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64base_s64)))
void svstnt1_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_u64)))
void svstnt1_scatter_index(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_f64)))
void svstnt1_scatter_index(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64index_s64)))
void svstnt1_scatter_index(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_u64)))
void svstnt1_scatter_index(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_f64)))
void svstnt1_scatter_index(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64index_s64)))
void svstnt1_scatter_index(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_u32)))
void svstnt1_scatter_offset(svbool_t, uint32_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_f32)))
void svstnt1_scatter_offset(svbool_t, float32_t *, svuint32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u32offset_s32)))
void svstnt1_scatter_offset(svbool_t, int32_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_u64)))
void svstnt1_scatter_offset(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_f64)))
void svstnt1_scatter_offset(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_s64offset_s64)))
void svstnt1_scatter_offset(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_u64)))
void svstnt1_scatter_offset(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_f64)))
void svstnt1_scatter_offset(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_scatter_u64offset_s64)))
void svstnt1_scatter_offset(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_offset_u32)))
void svstnt1b_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_offset_u64)))
void svstnt1b_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_offset_s32)))
void svstnt1b_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_offset_s64)))
void svstnt1b_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_u32)))
void svstnt1b_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_u64)))
void svstnt1b_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32base_s32)))
void svstnt1b_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64base_s64)))
void svstnt1b_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32offset_s32)))
void svstnt1b_scatter_offset(svbool_t, int8_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u32offset_u32)))
void svstnt1b_scatter_offset(svbool_t, uint8_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_s64offset_s64)))
void svstnt1b_scatter_offset(svbool_t, int8_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_s64offset_u64)))
void svstnt1b_scatter_offset(svbool_t, uint8_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64offset_s64)))
void svstnt1b_scatter_offset(svbool_t, int8_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1b_scatter_u64offset_u64)))
void svstnt1b_scatter_offset(svbool_t, uint8_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_index_u32)))
void svstnt1h_scatter_index(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_index_u64)))
void svstnt1h_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_index_s32)))
void svstnt1h_scatter_index(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_index_s64)))
void svstnt1h_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_offset_u32)))
void svstnt1h_scatter_offset(svbool_t, svuint32_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_offset_u64)))
void svstnt1h_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_offset_s32)))
void svstnt1h_scatter_offset(svbool_t, svuint32_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_offset_s64)))
void svstnt1h_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_u32)))
void svstnt1h_scatter(svbool_t, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_u64)))
void svstnt1h_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32base_s32)))
void svstnt1h_scatter(svbool_t, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64base_s64)))
void svstnt1h_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64index_s64)))
void svstnt1h_scatter_index(svbool_t, int16_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64index_u64)))
void svstnt1h_scatter_index(svbool_t, uint16_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64index_s64)))
void svstnt1h_scatter_index(svbool_t, int16_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64index_u64)))
void svstnt1h_scatter_index(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32offset_s32)))
void svstnt1h_scatter_offset(svbool_t, int16_t *, svuint32_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u32offset_u32)))
void svstnt1h_scatter_offset(svbool_t, uint16_t *, svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64offset_s64)))
void svstnt1h_scatter_offset(svbool_t, int16_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_s64offset_u64)))
void svstnt1h_scatter_offset(svbool_t, uint16_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64offset_s64)))
void svstnt1h_scatter_offset(svbool_t, int16_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1h_scatter_u64offset_u64)))
void svstnt1h_scatter_offset(svbool_t, uint16_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_index_u64)))
void svstnt1w_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_index_s64)))
void svstnt1w_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_offset_u64)))
void svstnt1w_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_offset_s64)))
void svstnt1w_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_u64)))
void svstnt1w_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64base_s64)))
void svstnt1w_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64index_s64)))
void svstnt1w_scatter_index(svbool_t, int32_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64index_u64)))
void svstnt1w_scatter_index(svbool_t, uint32_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64index_s64)))
void svstnt1w_scatter_index(svbool_t, int32_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64index_u64)))
void svstnt1w_scatter_index(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64offset_s64)))
void svstnt1w_scatter_offset(svbool_t, int32_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_s64offset_u64)))
void svstnt1w_scatter_offset(svbool_t, uint32_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64offset_s64)))
void svstnt1w_scatter_offset(svbool_t, int32_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1w_scatter_u64offset_u64)))
void svstnt1w_scatter_offset(svbool_t, uint32_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_m)))
svfloat64_t svamax_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_m)))
svfloat32_t svamax_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_m)))
svfloat16_t svamax_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_x)))
svfloat64_t svamax_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_x)))
svfloat32_t svamax_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_x)))
svfloat16_t svamax_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_z)))
svfloat64_t svamax_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_z)))
svfloat32_t svamax_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_z)))
svfloat16_t svamax_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_m)))
svfloat64_t svamax_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_m)))
svfloat32_t svamax_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_m)))
svfloat16_t svamax_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x)))
svfloat64_t svamax_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x)))
svfloat32_t svamax_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x)))
svfloat16_t svamax_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_z)))
svfloat64_t svamax_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_z)))
svfloat32_t svamax_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_z)))
svfloat16_t svamax_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_m)))
svfloat64_t svamin_n_f64_m(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_m)))
svfloat32_t svamin_n_f32_m(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_m)))
svfloat16_t svamin_n_f16_m(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_x)))
svfloat64_t svamin_n_f64_x(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_x)))
svfloat32_t svamin_n_f32_x(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_x)))
svfloat16_t svamin_n_f16_x(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_z)))
svfloat64_t svamin_n_f64_z(svbool_t, svfloat64_t, float64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_z)))
svfloat32_t svamin_n_f32_z(svbool_t, svfloat32_t, float32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_z)))
svfloat16_t svamin_n_f16_z(svbool_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_m)))
svfloat64_t svamin_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_m)))
svfloat32_t svamin_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_m)))
svfloat16_t svamin_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x)))
svfloat64_t svamin_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x)))
svfloat32_t svamin_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x)))
svfloat16_t svamin_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_z)))
svfloat64_t svamin_f64_z(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_z)))
svfloat32_t svamin_f32_z(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_z)))
svfloat16_t svamin_f16_z(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_m)))
svfloat64_t svamax_m(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_m)))
svfloat32_t svamax_m(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_m)))
svfloat16_t svamax_m(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_x)))
svfloat64_t svamax_x(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_x)))
svfloat32_t svamax_x(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_x)))
svfloat16_t svamax_x(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f64_z)))
svfloat64_t svamax_z(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f32_z)))
svfloat32_t svamax_z(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_n_f16_z)))
svfloat16_t svamax_z(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_m)))
svfloat64_t svamax_m(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_m)))
svfloat32_t svamax_m(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_m)))
svfloat16_t svamax_m(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_x)))
svfloat64_t svamax_x(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_x)))
svfloat32_t svamax_x(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_x)))
svfloat16_t svamax_x(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f64_z)))
svfloat64_t svamax_z(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f32_z)))
svfloat32_t svamax_z(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamax_f16_z)))
svfloat16_t svamax_z(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_m)))
svfloat64_t svamin_m(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_m)))
svfloat32_t svamin_m(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_m)))
svfloat16_t svamin_m(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_x)))
svfloat64_t svamin_x(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_x)))
svfloat32_t svamin_x(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_x)))
svfloat16_t svamin_x(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f64_z)))
svfloat64_t svamin_z(svbool_t, svfloat64_t, float64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f32_z)))
svfloat32_t svamin_z(svbool_t, svfloat32_t, float32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_n_f16_z)))
svfloat16_t svamin_z(svbool_t, svfloat16_t, float16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_m)))
svfloat64_t svamin_m(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_m)))
svfloat32_t svamin_m(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_m)))
svfloat16_t svamin_m(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_x)))
svfloat64_t svamin_x(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_x)))
svfloat32_t svamin_x(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_x)))
svfloat16_t svamin_x(svbool_t, svfloat16_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f64_z)))
svfloat64_t svamin_z(svbool_t, svfloat64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f32_z)))
svfloat32_t svamin_z(svbool_t, svfloat32_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svamin_f16_z)))
svfloat16_t svamin_z(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f16_mf8_fpm)))
svfloat16_t svdot_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_f16_mf8_fpm)))
svfloat16_t svdot_n_f16_mf8_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f16_mf8_fpm)))
svfloat16_t svdot_lane_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f16_mf8_fpm)))
svfloat16_t svdot_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_f16_mf8_fpm)))
svfloat16_t svdot_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f16_mf8_fpm)))
svfloat16_t svdot_lane_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f32_mf8_fpm)))
svfloat32_t svdot_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_f32_mf8_fpm)))
svfloat32_t svdot_n_f32_mf8_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f32_mf8_fpm)))
svfloat32_t svdot_lane_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_f32_mf8_fpm)))
svfloat32_t svdot_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_n_f32_mf8_fpm)))
svfloat32_t svdot_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svdot_lane_f32_mf8_fpm)))
svfloat32_t svdot_lane_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_f16_mf8_fpm)))
svfloat16_t svmlalb_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_f16_mf8_fpm)))
svfloat16_t svmlalb_n_f16_mf8_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_f16_mf8_fpm)))
svfloat16_t svmlalb_lane_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_f32_mf8_fpm)))
svfloat32_t svmlallbb_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_n_f32_mf8_fpm)))
svfloat32_t svmlallbb_n_f32_mf8_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_lane_f32_mf8_fpm)))
svfloat32_t svmlallbb_lane_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_f32_mf8_fpm)))
svfloat32_t svmlallbt_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_n_f32_mf8_fpm)))
svfloat32_t svmlallbt_n_f32_mf8_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_lane_f32_mf8_fpm)))
svfloat32_t svmlallbt_lane_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_f32_mf8_fpm)))
svfloat32_t svmlalltb_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_n_f32_mf8_fpm)))
svfloat32_t svmlalltb_n_f32_mf8_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_lane_f32_mf8_fpm)))
svfloat32_t svmlalltb_lane_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_f32_mf8_fpm)))
svfloat32_t svmlalltt_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_n_f32_mf8_fpm)))
svfloat32_t svmlalltt_n_f32_mf8_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_lane_f32_mf8_fpm)))
svfloat32_t svmlalltt_lane_f32_mf8_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_f16_mf8_fpm)))
svfloat16_t svmlalt_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_f16_mf8_fpm)))
svfloat16_t svmlalt_n_f16_mf8_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_f16_mf8_fpm)))
svfloat16_t svmlalt_lane_f16_mf8_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_f16_mf8_fpm)))
svfloat16_t svmlalb_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_f16_mf8_fpm)))
svfloat16_t svmlalb_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_f16_mf8_fpm)))
svfloat16_t svmlalb_lane_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_f32_mf8_fpm)))
svfloat32_t svmlallbb_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_n_f32_mf8_fpm)))
svfloat32_t svmlallbb_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbb_lane_f32_mf8_fpm)))
svfloat32_t svmlallbb_lane_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_f32_mf8_fpm)))
svfloat32_t svmlallbt_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_n_f32_mf8_fpm)))
svfloat32_t svmlallbt_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlallbt_lane_f32_mf8_fpm)))
svfloat32_t svmlallbt_lane_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_f32_mf8_fpm)))
svfloat32_t svmlalltb_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_n_f32_mf8_fpm)))
svfloat32_t svmlalltb_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltb_lane_f32_mf8_fpm)))
svfloat32_t svmlalltb_lane_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_f32_mf8_fpm)))
svfloat32_t svmlalltt_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_n_f32_mf8_fpm)))
svfloat32_t svmlalltt_fpm(svfloat32_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalltt_lane_f32_mf8_fpm)))
svfloat32_t svmlalltt_lane_fpm(svfloat32_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_f16_mf8_fpm)))
svfloat16_t svmlalt_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_f16_mf8_fpm)))
svfloat16_t svmlalt_fpm(svfloat16_t, svmfloat8_t, mfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_f16_mf8_fpm)))
svfloat16_t svmlalt_lane_fpm(svfloat16_t, svmfloat8_t, svmfloat8_t, uint64_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_bf16_mf8_fpm)))
svbfloat16_t svcvt1_bf16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_f16_mf8_fpm)))
svfloat16_t svcvt1_f16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_bf16_mf8_fpm)))
svbfloat16_t svcvt2_bf16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_f16_mf8_fpm)))
svfloat16_t svcvt2_f16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt1_bf16_mf8_fpm)))
svbfloat16_t svcvtlt1_bf16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt1_f16_mf8_fpm)))
svfloat16_t svcvtlt1_f16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt2_bf16_mf8_fpm)))
svbfloat16_t svcvtlt2_bf16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt2_f16_mf8_fpm)))
svfloat16_t svcvtlt2_f16_mf8_fpm(svmfloat8_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_bf16_x2_fpm)))
svmfloat8_t svcvtn_mf8_bf16_x2_fpm(svbfloat16x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_f16_x2_fpm)))
svmfloat8_t svcvtn_mf8_f16_x2_fpm(svfloat16x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnb_mf8_f32_x2_fpm)))
svmfloat8_t svcvtnb_mf8_f32_x2_fpm(svfloat32x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_mf8_f32_x2_fpm)))
svmfloat8_t svcvtnt_mf8_f32_x2_fpm(svmfloat8_t, svfloat32x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_bf16_mf8_fpm)))
svbfloat16_t svcvt1_bf16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt1_f16_mf8_fpm)))
svfloat16_t svcvt1_f16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_bf16_mf8_fpm)))
svbfloat16_t svcvt2_bf16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvt2_f16_mf8_fpm)))
svfloat16_t svcvt2_f16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt1_bf16_mf8_fpm)))
svbfloat16_t svcvtlt1_bf16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt1_f16_mf8_fpm)))
svfloat16_t svcvtlt1_f16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt2_bf16_mf8_fpm)))
svbfloat16_t svcvtlt2_bf16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt2_f16_mf8_fpm)))
svfloat16_t svcvtlt2_f16_fpm(svmfloat8_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_bf16_x2_fpm)))
svmfloat8_t svcvtn_mf8_fpm(svbfloat16x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtn_mf8_f16_x2_fpm)))
svmfloat8_t svcvtn_mf8_fpm(svfloat16x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnb_mf8_f32_x2_fpm)))
svmfloat8_t svcvtnb_mf8_fpm(svfloat32x2_t, fpm_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_mf8_f32_x2_fpm)))
svmfloat8_t svcvtnt_mf8_fpm(svmfloat8_t, svfloat32x2_t, fpm_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_u8)))
svuint8_t svluti2_lane_u8(svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_s8)))
svint8_t svluti2_lane_s8(svint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_u16)))
svuint16_t svluti2_lane_u16(svuint16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_bf16)))
svbfloat16_t svluti2_lane_bf16(svbfloat16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_f16)))
svfloat16_t svluti2_lane_f16(svfloat16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_s16)))
svint16_t svluti2_lane_s16(svint16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u8)))
svuint8_t svluti4_lane_u8(svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s8)))
svint8_t svluti4_lane_s8(svint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u16)))
svuint16_t svluti4_lane_u16(svuint16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_bf16)))
svbfloat16_t svluti4_lane_bf16(svbfloat16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_f16)))
svfloat16_t svluti4_lane_f16(svfloat16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s16)))
svint16_t svluti4_lane_s16(svint16_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u16_x2)))
svuint16_t svluti4_lane_u16_x2(svuint16x2_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_bf16_x2)))
svbfloat16_t svluti4_lane_bf16_x2(svbfloat16x2_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_f16_x2)))
svfloat16_t svluti4_lane_f16_x2(svfloat16x2_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s16_x2)))
svint16_t svluti4_lane_s16_x2(svint16x2_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_u8)))
svuint8_t svluti2_lane(svuint8_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_s8)))
svint8_t svluti2_lane(svint8_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_u16)))
svuint16_t svluti2_lane(svuint16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_bf16)))
svbfloat16_t svluti2_lane(svbfloat16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_f16)))
svfloat16_t svluti2_lane(svfloat16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti2_lane_s16)))
svint16_t svluti2_lane(svint16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u8)))
svuint8_t svluti4_lane(svuint8_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s8)))
svint8_t svluti4_lane(svint8_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u16)))
svuint16_t svluti4_lane(svuint16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_bf16)))
svbfloat16_t svluti4_lane(svbfloat16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_f16)))
svfloat16_t svluti4_lane(svfloat16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s16)))
svint16_t svluti4_lane(svint16_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_u16_x2)))
svuint16_t svluti4_lane(svuint16x2_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_bf16_x2)))
svbfloat16_t svluti4_lane(svbfloat16x2_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_f16_x2)))
svfloat16_t svluti4_lane(svfloat16x2_t, svuint8_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svluti4_lane_s16_x2)))
svint16_t svluti4_lane(svint16x2_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesd_u8)))
svuint8_t svaesd_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaese_u8)))
svuint8_t svaese_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesimc_u8)))
svuint8_t svaesimc_u8(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesmc_u8)))
svuint8_t svaesmc_u8(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_n_u64)))
svuint64_t svpmullb_pair_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_u64)))
svuint64_t svpmullb_pair_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_n_u64)))
svuint64_t svpmullt_pair_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_u64)))
svuint64_t svpmullt_pair_u64(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesd_u8)))
svuint8_t svaesd(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaese_u8)))
svuint8_t svaese(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesimc_u8)))
svuint8_t svaesimc(svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaesmc_u8)))
svuint8_t svaesmc(svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_n_u64)))
svuint64_t svpmullb_pair(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_u64)))
svuint64_t svpmullb_pair(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_n_u64)))
svuint64_t svpmullt_pair(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_u64)))
svuint64_t svpmullt_pair(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_m)))
svbfloat16_t svadd_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_x)))
svbfloat16_t svadd_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_z)))
svbfloat16_t svadd_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_m)))
svbfloat16_t svadd_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_x)))
svbfloat16_t svadd_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_z)))
svbfloat16_t svadd_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_bf16)))
svbfloat16_t svclamp_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_m)))
svbfloat16_t svmax_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_x)))
svbfloat16_t svmax_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_z)))
svbfloat16_t svmax_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_m)))
svbfloat16_t svmax_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x)))
svbfloat16_t svmax_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_z)))
svbfloat16_t svmax_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_m)))
svbfloat16_t svmaxnm_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_x)))
svbfloat16_t svmaxnm_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_z)))
svbfloat16_t svmaxnm_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_m)))
svbfloat16_t svmaxnm_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x)))
svbfloat16_t svmaxnm_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_z)))
svbfloat16_t svmaxnm_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_m)))
svbfloat16_t svmin_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_x)))
svbfloat16_t svmin_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_z)))
svbfloat16_t svmin_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_m)))
svbfloat16_t svmin_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x)))
svbfloat16_t svmin_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_z)))
svbfloat16_t svmin_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_m)))
svbfloat16_t svminnm_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_x)))
svbfloat16_t svminnm_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_z)))
svbfloat16_t svminnm_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_m)))
svbfloat16_t svminnm_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x)))
svbfloat16_t svminnm_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_z)))
svbfloat16_t svminnm_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_m)))
svbfloat16_t svmla_n_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_x)))
svbfloat16_t svmla_n_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_z)))
svbfloat16_t svmla_n_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_m)))
svbfloat16_t svmla_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_x)))
svbfloat16_t svmla_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_z)))
svbfloat16_t svmla_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_bf16)))
svbfloat16_t svmla_lane_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_m)))
svbfloat16_t svmls_n_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_x)))
svbfloat16_t svmls_n_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_z)))
svbfloat16_t svmls_n_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_m)))
svbfloat16_t svmls_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_x)))
svbfloat16_t svmls_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_z)))
svbfloat16_t svmls_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_bf16)))
svbfloat16_t svmls_lane_bf16(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_m)))
svbfloat16_t svmul_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_x)))
svbfloat16_t svmul_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_z)))
svbfloat16_t svmul_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_m)))
svbfloat16_t svmul_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_x)))
svbfloat16_t svmul_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_z)))
svbfloat16_t svmul_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_bf16)))
svbfloat16_t svmul_lane_bf16(svbfloat16_t, svbfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_m)))
svbfloat16_t svsub_n_bf16_m(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_x)))
svbfloat16_t svsub_n_bf16_x(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_z)))
svbfloat16_t svsub_n_bf16_z(svbool_t, svbfloat16_t, bfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_m)))
svbfloat16_t svsub_bf16_m(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_x)))
svbfloat16_t svsub_bf16_x(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_z)))
svbfloat16_t svsub_bf16_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_m)))
svbfloat16_t svadd_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_x)))
svbfloat16_t svadd_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_n_bf16_z)))
svbfloat16_t svadd_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_m)))
svbfloat16_t svadd_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_x)))
svbfloat16_t svadd_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadd_bf16_z)))
svbfloat16_t svadd_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svclamp_bf16)))
svbfloat16_t svclamp(svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_m)))
svbfloat16_t svmax_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_x)))
svbfloat16_t svmax_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_n_bf16_z)))
svbfloat16_t svmax_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_m)))
svbfloat16_t svmax_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_x)))
svbfloat16_t svmax_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmax_bf16_z)))
svbfloat16_t svmax_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_m)))
svbfloat16_t svmaxnm_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_x)))
svbfloat16_t svmaxnm_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_n_bf16_z)))
svbfloat16_t svmaxnm_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_m)))
svbfloat16_t svmaxnm_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_x)))
svbfloat16_t svmaxnm_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnm_bf16_z)))
svbfloat16_t svmaxnm_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_m)))
svbfloat16_t svmin_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_x)))
svbfloat16_t svmin_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_n_bf16_z)))
svbfloat16_t svmin_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_m)))
svbfloat16_t svmin_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_x)))
svbfloat16_t svmin_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmin_bf16_z)))
svbfloat16_t svmin_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_m)))
svbfloat16_t svminnm_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_x)))
svbfloat16_t svminnm_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_n_bf16_z)))
svbfloat16_t svminnm_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_m)))
svbfloat16_t svminnm_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_x)))
svbfloat16_t svminnm_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnm_bf16_z)))
svbfloat16_t svminnm_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_m)))
svbfloat16_t svmla_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_x)))
svbfloat16_t svmla_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_n_bf16_z)))
svbfloat16_t svmla_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_m)))
svbfloat16_t svmla_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_x)))
svbfloat16_t svmla_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_bf16_z)))
svbfloat16_t svmla_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_bf16)))
svbfloat16_t svmla_lane(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_m)))
svbfloat16_t svmls_m(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_x)))
svbfloat16_t svmls_x(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_n_bf16_z)))
svbfloat16_t svmls_z(svbool_t, svbfloat16_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_m)))
svbfloat16_t svmls_m(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_x)))
svbfloat16_t svmls_x(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_bf16_z)))
svbfloat16_t svmls_z(svbool_t, svbfloat16_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_bf16)))
svbfloat16_t svmls_lane(svbfloat16_t, svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_m)))
svbfloat16_t svmul_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_x)))
svbfloat16_t svmul_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_n_bf16_z)))
svbfloat16_t svmul_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_m)))
svbfloat16_t svmul_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_x)))
svbfloat16_t svmul_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_bf16_z)))
svbfloat16_t svmul_z(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_bf16)))
svbfloat16_t svmul_lane(svbfloat16_t, svbfloat16_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_m)))
svbfloat16_t svsub_m(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_x)))
svbfloat16_t svsub_x(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_n_bf16_z)))
svbfloat16_t svsub_z(svbool_t, svbfloat16_t, bfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_m)))
svbfloat16_t svsub_m(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_x)))
svbfloat16_t svsub_x(svbool_t, svbfloat16_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsub_bf16_z)))
svbfloat16_t svsub_z(svbool_t, svbfloat16_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u8)))
svuint8_t svbdep_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u32)))
svuint32_t svbdep_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u64)))
svuint64_t svbdep_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u16)))
svuint16_t svbdep_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u8)))
svuint8_t svbdep_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u32)))
svuint32_t svbdep_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u64)))
svuint64_t svbdep_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u16)))
svuint16_t svbdep_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u8)))
svuint8_t svbext_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u32)))
svuint32_t svbext_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u64)))
svuint64_t svbext_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u16)))
svuint16_t svbext_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u8)))
svuint8_t svbext_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u32)))
svuint32_t svbext_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u64)))
svuint64_t svbext_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u16)))
svuint16_t svbext_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u8)))
svuint8_t svbgrp_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u32)))
svuint32_t svbgrp_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u64)))
svuint64_t svbgrp_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u16)))
svuint16_t svbgrp_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u8)))
svuint8_t svbgrp_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u32)))
svuint32_t svbgrp_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u64)))
svuint64_t svbgrp_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u16)))
svuint16_t svbgrp_u16(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u8)))
svuint8_t svbdep(svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u32)))
svuint32_t svbdep(svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u64)))
svuint64_t svbdep(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_n_u16)))
svuint16_t svbdep(svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u8)))
svuint8_t svbdep(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u32)))
svuint32_t svbdep(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u64)))
svuint64_t svbdep(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbdep_u16)))
svuint16_t svbdep(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u8)))
svuint8_t svbext(svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u32)))
svuint32_t svbext(svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u64)))
svuint64_t svbext(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_n_u16)))
svuint16_t svbext(svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u8)))
svuint8_t svbext(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u32)))
svuint32_t svbext(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u64)))
svuint64_t svbext(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbext_u16)))
svuint16_t svbext(svuint16_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u8)))
svuint8_t svbgrp(svuint8_t, uint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u32)))
svuint32_t svbgrp(svuint32_t, uint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u64)))
svuint64_t svbgrp(svuint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_n_u16)))
svuint16_t svbgrp(svuint16_t, uint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u8)))
svuint8_t svbgrp(svuint8_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u32)))
svuint32_t svbgrp(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u64)))
svuint64_t svbgrp(svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbgrp_u16)))
svuint16_t svbgrp(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsm4e_u32)))
svuint32_t svsm4e_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsm4ekey_u32)))
svuint32_t svsm4ekey_u32(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsm4e_u32)))
svuint32_t svsm4e(svuint32_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svsm4ekey_u32)))
svuint32_t svsm4ekey(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u32)))
svuint32_t svld1q_gather_u64base_index_u32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u64)))
svuint64_t svld1q_gather_u64base_index_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u16)))
svuint16_t svld1q_gather_u64base_index_u16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_bf16)))
svbfloat16_t svld1q_gather_u64base_index_bf16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f64)))
svfloat64_t svld1q_gather_u64base_index_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f32)))
svfloat32_t svld1q_gather_u64base_index_f32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f16)))
svfloat16_t svld1q_gather_u64base_index_f16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s32)))
svint32_t svld1q_gather_u64base_index_s32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s64)))
svint64_t svld1q_gather_u64base_index_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s16)))
svint16_t svld1q_gather_u64base_index_s16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u8)))
svuint8_t svld1q_gather_u64base_offset_u8(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u32)))
svuint32_t svld1q_gather_u64base_offset_u32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u64)))
svuint64_t svld1q_gather_u64base_offset_u64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u16)))
svuint16_t svld1q_gather_u64base_offset_u16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_bf16)))
svbfloat16_t svld1q_gather_u64base_offset_bf16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s8)))
svint8_t svld1q_gather_u64base_offset_s8(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f64)))
svfloat64_t svld1q_gather_u64base_offset_f64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f32)))
svfloat32_t svld1q_gather_u64base_offset_f32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f16)))
svfloat16_t svld1q_gather_u64base_offset_f16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s32)))
svint32_t svld1q_gather_u64base_offset_s32(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s64)))
svint64_t svld1q_gather_u64base_offset_s64(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_mf8)))
svmfloat8_t svld1q_gather_u64base_offset_mf8(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s16)))
svint16_t svld1q_gather_u64base_offset_s16(svbool_t, svuint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u8)))
svuint8_t svld1q_gather_u64base_u8(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u32)))
svuint32_t svld1q_gather_u64base_u32(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u64)))
svuint64_t svld1q_gather_u64base_u64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u16)))
svuint16_t svld1q_gather_u64base_u16(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_bf16)))
svbfloat16_t svld1q_gather_u64base_bf16(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s8)))
svint8_t svld1q_gather_u64base_s8(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f64)))
svfloat64_t svld1q_gather_u64base_f64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f32)))
svfloat32_t svld1q_gather_u64base_f32(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f16)))
svfloat16_t svld1q_gather_u64base_f16(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s32)))
svint32_t svld1q_gather_u64base_s32(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s64)))
svint64_t svld1q_gather_u64base_s64(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_mf8)))
svmfloat8_t svld1q_gather_u64base_mf8(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s16)))
svint16_t svld1q_gather_u64base_s16(svbool_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u32)))
svuint32_t svld1q_gather_u64index_u32(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u64)))
svuint64_t svld1q_gather_u64index_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u16)))
svuint16_t svld1q_gather_u64index_u16(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_bf16)))
svbfloat16_t svld1q_gather_u64index_bf16(svbool_t, bfloat16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f64)))
svfloat64_t svld1q_gather_u64index_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f32)))
svfloat32_t svld1q_gather_u64index_f32(svbool_t, float32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f16)))
svfloat16_t svld1q_gather_u64index_f16(svbool_t, float16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s32)))
svint32_t svld1q_gather_u64index_s32(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s64)))
svint64_t svld1q_gather_u64index_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s16)))
svint16_t svld1q_gather_u64index_s16(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u8)))
svuint8_t svld1q_gather_u64offset_u8(svbool_t, uint8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u32)))
svuint32_t svld1q_gather_u64offset_u32(svbool_t, uint32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u64)))
svuint64_t svld1q_gather_u64offset_u64(svbool_t, uint64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u16)))
svuint16_t svld1q_gather_u64offset_u16(svbool_t, uint16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_bf16)))
svbfloat16_t svld1q_gather_u64offset_bf16(svbool_t, bfloat16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s8)))
svint8_t svld1q_gather_u64offset_s8(svbool_t, int8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f64)))
svfloat64_t svld1q_gather_u64offset_f64(svbool_t, float64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f32)))
svfloat32_t svld1q_gather_u64offset_f32(svbool_t, float32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f16)))
svfloat16_t svld1q_gather_u64offset_f16(svbool_t, float16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s32)))
svint32_t svld1q_gather_u64offset_s32(svbool_t, int32_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s64)))
svint64_t svld1q_gather_u64offset_s64(svbool_t, int64_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_mf8)))
svmfloat8_t svld1q_gather_u64offset_mf8(svbool_t, mfloat8_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s16)))
svint16_t svld1q_gather_u64offset_s16(svbool_t, int16_t const *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_u64)))
svuint64_t svld1udq_u64(svbool_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_f64)))
svfloat64_t svld1udq_f64(svbool_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_s64)))
svint64_t svld1udq_s64(svbool_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_u64)))
svuint64_t svld1udq_vnum_u64(svbool_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_f64)))
svfloat64_t svld1udq_vnum_f64(svbool_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_s64)))
svint64_t svld1udq_vnum_s64(svbool_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_u32)))
svuint32_t svld1uwq_u32(svbool_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_f32)))
svfloat32_t svld1uwq_f32(svbool_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_s32)))
svint32_t svld1uwq_s32(svbool_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_u32)))
svuint32_t svld1uwq_vnum_u32(svbool_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_f32)))
svfloat32_t svld1uwq_vnum_f32(svbool_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_s32)))
svint32_t svld1uwq_vnum_s32(svbool_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_u64)))
void svst1dq_u64(svbool_t, uint64_t *, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_f64)))
void svst1dq_f64(svbool_t, float64_t *, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_s64)))
void svst1dq_s64(svbool_t, int64_t *, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_u64)))
void svst1dq_vnum_u64(svbool_t, uint64_t *, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_f64)))
void svst1dq_vnum_f64(svbool_t, float64_t *, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_s64)))
void svst1dq_vnum_s64(svbool_t, int64_t *, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u8)))
void svst1q_scatter_u64base_u8(svbool_t, svuint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u32)))
void svst1q_scatter_u64base_u32(svbool_t, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u64)))
void svst1q_scatter_u64base_u64(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u16)))
void svst1q_scatter_u64base_u16(svbool_t, svuint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_bf16)))
void svst1q_scatter_u64base_bf16(svbool_t, svuint64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s8)))
void svst1q_scatter_u64base_s8(svbool_t, svuint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f64)))
void svst1q_scatter_u64base_f64(svbool_t, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f32)))
void svst1q_scatter_u64base_f32(svbool_t, svuint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f16)))
void svst1q_scatter_u64base_f16(svbool_t, svuint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s32)))
void svst1q_scatter_u64base_s32(svbool_t, svuint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s64)))
void svst1q_scatter_u64base_s64(svbool_t, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_mf8)))
void svst1q_scatter_u64base_mf8(svbool_t, svuint64_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s16)))
void svst1q_scatter_u64base_s16(svbool_t, svuint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u32)))
void svst1q_scatter_u64base_index_u32(svbool_t, svuint64_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u64)))
void svst1q_scatter_u64base_index_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u16)))
void svst1q_scatter_u64base_index_u16(svbool_t, svuint64_t, int64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_bf16)))
void svst1q_scatter_u64base_index_bf16(svbool_t, svuint64_t, int64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f64)))
void svst1q_scatter_u64base_index_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f32)))
void svst1q_scatter_u64base_index_f32(svbool_t, svuint64_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f16)))
void svst1q_scatter_u64base_index_f16(svbool_t, svuint64_t, int64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s32)))
void svst1q_scatter_u64base_index_s32(svbool_t, svuint64_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s64)))
void svst1q_scatter_u64base_index_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s16)))
void svst1q_scatter_u64base_index_s16(svbool_t, svuint64_t, int64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u8)))
void svst1q_scatter_u64base_offset_u8(svbool_t, svuint64_t, int64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u32)))
void svst1q_scatter_u64base_offset_u32(svbool_t, svuint64_t, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u64)))
void svst1q_scatter_u64base_offset_u64(svbool_t, svuint64_t, int64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u16)))
void svst1q_scatter_u64base_offset_u16(svbool_t, svuint64_t, int64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_bf16)))
void svst1q_scatter_u64base_offset_bf16(svbool_t, svuint64_t, int64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s8)))
void svst1q_scatter_u64base_offset_s8(svbool_t, svuint64_t, int64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f64)))
void svst1q_scatter_u64base_offset_f64(svbool_t, svuint64_t, int64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f32)))
void svst1q_scatter_u64base_offset_f32(svbool_t, svuint64_t, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f16)))
void svst1q_scatter_u64base_offset_f16(svbool_t, svuint64_t, int64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s32)))
void svst1q_scatter_u64base_offset_s32(svbool_t, svuint64_t, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s64)))
void svst1q_scatter_u64base_offset_s64(svbool_t, svuint64_t, int64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_mf8)))
void svst1q_scatter_u64base_offset_mf8(svbool_t, svuint64_t, int64_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s16)))
void svst1q_scatter_u64base_offset_s16(svbool_t, svuint64_t, int64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u32)))
void svst1q_scatter_s64index_u32(svbool_t, uint32_t *, svint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u64)))
void svst1q_scatter_s64index_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u16)))
void svst1q_scatter_s64index_u16(svbool_t, uint16_t *, svint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_bf16)))
void svst1q_scatter_s64index_bf16(svbool_t, bfloat16_t *, svint64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f64)))
void svst1q_scatter_s64index_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f32)))
void svst1q_scatter_s64index_f32(svbool_t, float32_t *, svint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f16)))
void svst1q_scatter_s64index_f16(svbool_t, float16_t *, svint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s32)))
void svst1q_scatter_s64index_s32(svbool_t, int32_t *, svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s64)))
void svst1q_scatter_s64index_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s16)))
void svst1q_scatter_s64index_s16(svbool_t, int16_t *, svint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u32)))
void svst1q_scatter_u64index_u32(svbool_t, uint32_t *, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u64)))
void svst1q_scatter_u64index_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u16)))
void svst1q_scatter_u64index_u16(svbool_t, uint16_t *, svuint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_bf16)))
void svst1q_scatter_u64index_bf16(svbool_t, bfloat16_t *, svuint64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f64)))
void svst1q_scatter_u64index_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f32)))
void svst1q_scatter_u64index_f32(svbool_t, float32_t *, svuint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f16)))
void svst1q_scatter_u64index_f16(svbool_t, float16_t *, svuint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s32)))
void svst1q_scatter_u64index_s32(svbool_t, int32_t *, svuint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s64)))
void svst1q_scatter_u64index_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s16)))
void svst1q_scatter_u64index_s16(svbool_t, int16_t *, svuint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u8)))
void svst1q_scatter_s64offset_u8(svbool_t, uint8_t *, svint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u32)))
void svst1q_scatter_s64offset_u32(svbool_t, uint32_t *, svint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u64)))
void svst1q_scatter_s64offset_u64(svbool_t, uint64_t *, svint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u16)))
void svst1q_scatter_s64offset_u16(svbool_t, uint16_t *, svint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_bf16)))
void svst1q_scatter_s64offset_bf16(svbool_t, bfloat16_t *, svint64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s8)))
void svst1q_scatter_s64offset_s8(svbool_t, int8_t *, svint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f64)))
void svst1q_scatter_s64offset_f64(svbool_t, float64_t *, svint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f32)))
void svst1q_scatter_s64offset_f32(svbool_t, float32_t *, svint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f16)))
void svst1q_scatter_s64offset_f16(svbool_t, float16_t *, svint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s32)))
void svst1q_scatter_s64offset_s32(svbool_t, int32_t *, svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s64)))
void svst1q_scatter_s64offset_s64(svbool_t, int64_t *, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_mf8)))
void svst1q_scatter_s64offset_mf8(svbool_t, mfloat8_t *, svint64_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s16)))
void svst1q_scatter_s64offset_s16(svbool_t, int16_t *, svint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u8)))
void svst1q_scatter_u64offset_u8(svbool_t, uint8_t *, svuint64_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u32)))
void svst1q_scatter_u64offset_u32(svbool_t, uint32_t *, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u64)))
void svst1q_scatter_u64offset_u64(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u16)))
void svst1q_scatter_u64offset_u16(svbool_t, uint16_t *, svuint64_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_bf16)))
void svst1q_scatter_u64offset_bf16(svbool_t, bfloat16_t *, svuint64_t, svbfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s8)))
void svst1q_scatter_u64offset_s8(svbool_t, int8_t *, svuint64_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f64)))
void svst1q_scatter_u64offset_f64(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f32)))
void svst1q_scatter_u64offset_f32(svbool_t, float32_t *, svuint64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f16)))
void svst1q_scatter_u64offset_f16(svbool_t, float16_t *, svuint64_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s32)))
void svst1q_scatter_u64offset_s32(svbool_t, int32_t *, svuint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s64)))
void svst1q_scatter_u64offset_s64(svbool_t, int64_t *, svuint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_mf8)))
void svst1q_scatter_u64offset_mf8(svbool_t, mfloat8_t *, svuint64_t, svmfloat8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s16)))
void svst1q_scatter_u64offset_s16(svbool_t, int16_t *, svuint64_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_u32)))
void svst1wq_u32(svbool_t, uint32_t *, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_f32)))
void svst1wq_f32(svbool_t, float32_t *, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_s32)))
void svst1wq_s32(svbool_t, int32_t *, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_u32)))
void svst1wq_vnum_u32(svbool_t, uint32_t *, int64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_f32)))
void svst1wq_vnum_f32(svbool_t, float32_t *, int64_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_s32)))
void svst1wq_vnum_s32(svbool_t, int32_t *, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u32)))
svuint32_t svld1q_gather_index_u32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u64)))
svuint64_t svld1q_gather_index_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_u16)))
svuint16_t svld1q_gather_index_u16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_bf16)))
svbfloat16_t svld1q_gather_index_bf16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f64)))
svfloat64_t svld1q_gather_index_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f32)))
svfloat32_t svld1q_gather_index_f32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_f16)))
svfloat16_t svld1q_gather_index_f16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s32)))
svint32_t svld1q_gather_index_s32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s64)))
svint64_t svld1q_gather_index_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_index_s16)))
svint16_t svld1q_gather_index_s16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u8)))
svuint8_t svld1q_gather_offset_u8(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u32)))
svuint32_t svld1q_gather_offset_u32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u64)))
svuint64_t svld1q_gather_offset_u64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_u16)))
svuint16_t svld1q_gather_offset_u16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_bf16)))
svbfloat16_t svld1q_gather_offset_bf16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s8)))
svint8_t svld1q_gather_offset_s8(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f64)))
svfloat64_t svld1q_gather_offset_f64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f32)))
svfloat32_t svld1q_gather_offset_f32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_f16)))
svfloat16_t svld1q_gather_offset_f16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s32)))
svint32_t svld1q_gather_offset_s32(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s64)))
svint64_t svld1q_gather_offset_s64(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_mf8)))
svmfloat8_t svld1q_gather_offset_mf8(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_offset_s16)))
svint16_t svld1q_gather_offset_s16(svbool_t, svuint64_t, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u8)))
svuint8_t svld1q_gather_u8(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u32)))
svuint32_t svld1q_gather_u32(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u64)))
svuint64_t svld1q_gather_u64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_u16)))
svuint16_t svld1q_gather_u16(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_bf16)))
svbfloat16_t svld1q_gather_bf16(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s8)))
svint8_t svld1q_gather_s8(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f64)))
svfloat64_t svld1q_gather_f64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f32)))
svfloat32_t svld1q_gather_f32(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_f16)))
svfloat16_t svld1q_gather_f16(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s32)))
svint32_t svld1q_gather_s32(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s64)))
svint64_t svld1q_gather_s64(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_mf8)))
svmfloat8_t svld1q_gather_mf8(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64base_s16)))
svint16_t svld1q_gather_s16(svbool_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u32)))
svuint32_t svld1q_gather_index(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u64)))
svuint64_t svld1q_gather_index(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_u16)))
svuint16_t svld1q_gather_index(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_bf16)))
svbfloat16_t svld1q_gather_index(svbool_t, bfloat16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f64)))
svfloat64_t svld1q_gather_index(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f32)))
svfloat32_t svld1q_gather_index(svbool_t, float32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_f16)))
svfloat16_t svld1q_gather_index(svbool_t, float16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s32)))
svint32_t svld1q_gather_index(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s64)))
svint64_t svld1q_gather_index(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64index_s16)))
svint16_t svld1q_gather_index(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u8)))
svuint8_t svld1q_gather_offset(svbool_t, uint8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u32)))
svuint32_t svld1q_gather_offset(svbool_t, uint32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u64)))
svuint64_t svld1q_gather_offset(svbool_t, uint64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_u16)))
svuint16_t svld1q_gather_offset(svbool_t, uint16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_bf16)))
svbfloat16_t svld1q_gather_offset(svbool_t, bfloat16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s8)))
svint8_t svld1q_gather_offset(svbool_t, int8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f64)))
svfloat64_t svld1q_gather_offset(svbool_t, float64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f32)))
svfloat32_t svld1q_gather_offset(svbool_t, float32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_f16)))
svfloat16_t svld1q_gather_offset(svbool_t, float16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s32)))
svint32_t svld1q_gather_offset(svbool_t, int32_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s64)))
svint64_t svld1q_gather_offset(svbool_t, int64_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_mf8)))
svmfloat8_t svld1q_gather_offset(svbool_t, mfloat8_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1q_gather_u64offset_s16)))
svint16_t svld1q_gather_offset(svbool_t, int16_t const *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_u64)))
svuint64_t svld1udq(svbool_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_f64)))
svfloat64_t svld1udq(svbool_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_s64)))
svint64_t svld1udq(svbool_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_u64)))
svuint64_t svld1udq_vnum(svbool_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_f64)))
svfloat64_t svld1udq_vnum(svbool_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1udq_vnum_s64)))
svint64_t svld1udq_vnum(svbool_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_u32)))
svuint32_t svld1uwq(svbool_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_f32)))
svfloat32_t svld1uwq(svbool_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_s32)))
svint32_t svld1uwq(svbool_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_u32)))
svuint32_t svld1uwq_vnum(svbool_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_f32)))
svfloat32_t svld1uwq_vnum(svbool_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1uwq_vnum_s32)))
svint32_t svld1uwq_vnum(svbool_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_u64)))
void svst1dq(svbool_t, uint64_t *, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_f64)))
void svst1dq(svbool_t, float64_t *, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_s64)))
void svst1dq(svbool_t, int64_t *, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_u64)))
void svst1dq_vnum(svbool_t, uint64_t *, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_f64)))
void svst1dq_vnum(svbool_t, float64_t *, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1dq_vnum_s64)))
void svst1dq_vnum(svbool_t, int64_t *, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u8)))
void svst1q_scatter(svbool_t, svuint64_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u32)))
void svst1q_scatter(svbool_t, svuint64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u64)))
void svst1q_scatter(svbool_t, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_u16)))
void svst1q_scatter(svbool_t, svuint64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_bf16)))
void svst1q_scatter(svbool_t, svuint64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s8)))
void svst1q_scatter(svbool_t, svuint64_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f64)))
void svst1q_scatter(svbool_t, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f32)))
void svst1q_scatter(svbool_t, svuint64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_f16)))
void svst1q_scatter(svbool_t, svuint64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s32)))
void svst1q_scatter(svbool_t, svuint64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s64)))
void svst1q_scatter(svbool_t, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_mf8)))
void svst1q_scatter(svbool_t, svuint64_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_s16)))
void svst1q_scatter(svbool_t, svuint64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u32)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u64)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_u16)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_bf16)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f64)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f32)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_f16)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s32)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s64)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_index_s16)))
void svst1q_scatter_index(svbool_t, svuint64_t, int64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u8)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u32)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u64)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_u16)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_bf16)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s8)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f64)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f32)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_f16)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s32)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s64)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_mf8)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64base_offset_s16)))
void svst1q_scatter_offset(svbool_t, svuint64_t, int64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u32)))
void svst1q_scatter_index(svbool_t, uint32_t *, svint64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u64)))
void svst1q_scatter_index(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_u16)))
void svst1q_scatter_index(svbool_t, uint16_t *, svint64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_bf16)))
void svst1q_scatter_index(svbool_t, bfloat16_t *, svint64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f64)))
void svst1q_scatter_index(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f32)))
void svst1q_scatter_index(svbool_t, float32_t *, svint64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_f16)))
void svst1q_scatter_index(svbool_t, float16_t *, svint64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s32)))
void svst1q_scatter_index(svbool_t, int32_t *, svint64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s64)))
void svst1q_scatter_index(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64index_s16)))
void svst1q_scatter_index(svbool_t, int16_t *, svint64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u32)))
void svst1q_scatter_index(svbool_t, uint32_t *, svuint64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u64)))
void svst1q_scatter_index(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_u16)))
void svst1q_scatter_index(svbool_t, uint16_t *, svuint64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_bf16)))
void svst1q_scatter_index(svbool_t, bfloat16_t *, svuint64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f64)))
void svst1q_scatter_index(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f32)))
void svst1q_scatter_index(svbool_t, float32_t *, svuint64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_f16)))
void svst1q_scatter_index(svbool_t, float16_t *, svuint64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s32)))
void svst1q_scatter_index(svbool_t, int32_t *, svuint64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s64)))
void svst1q_scatter_index(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64index_s16)))
void svst1q_scatter_index(svbool_t, int16_t *, svuint64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u8)))
void svst1q_scatter_offset(svbool_t, uint8_t *, svint64_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u32)))
void svst1q_scatter_offset(svbool_t, uint32_t *, svint64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u64)))
void svst1q_scatter_offset(svbool_t, uint64_t *, svint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_u16)))
void svst1q_scatter_offset(svbool_t, uint16_t *, svint64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_bf16)))
void svst1q_scatter_offset(svbool_t, bfloat16_t *, svint64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s8)))
void svst1q_scatter_offset(svbool_t, int8_t *, svint64_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f64)))
void svst1q_scatter_offset(svbool_t, float64_t *, svint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f32)))
void svst1q_scatter_offset(svbool_t, float32_t *, svint64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_f16)))
void svst1q_scatter_offset(svbool_t, float16_t *, svint64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s32)))
void svst1q_scatter_offset(svbool_t, int32_t *, svint64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s64)))
void svst1q_scatter_offset(svbool_t, int64_t *, svint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_mf8)))
void svst1q_scatter_offset(svbool_t, mfloat8_t *, svint64_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_s64offset_s16)))
void svst1q_scatter_offset(svbool_t, int16_t *, svint64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u8)))
void svst1q_scatter_offset(svbool_t, uint8_t *, svuint64_t, svuint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u32)))
void svst1q_scatter_offset(svbool_t, uint32_t *, svuint64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u64)))
void svst1q_scatter_offset(svbool_t, uint64_t *, svuint64_t, svuint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_u16)))
void svst1q_scatter_offset(svbool_t, uint16_t *, svuint64_t, svuint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_bf16)))
void svst1q_scatter_offset(svbool_t, bfloat16_t *, svuint64_t, svbfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s8)))
void svst1q_scatter_offset(svbool_t, int8_t *, svuint64_t, svint8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f64)))
void svst1q_scatter_offset(svbool_t, float64_t *, svuint64_t, svfloat64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f32)))
void svst1q_scatter_offset(svbool_t, float32_t *, svuint64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_f16)))
void svst1q_scatter_offset(svbool_t, float16_t *, svuint64_t, svfloat16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s32)))
void svst1q_scatter_offset(svbool_t, int32_t *, svuint64_t, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s64)))
void svst1q_scatter_offset(svbool_t, int64_t *, svuint64_t, svint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_mf8)))
void svst1q_scatter_offset(svbool_t, mfloat8_t *, svuint64_t, svmfloat8_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1q_scatter_u64offset_s16)))
void svst1q_scatter_offset(svbool_t, int16_t *, svuint64_t, svint16_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_u32)))
void svst1wq(svbool_t, uint32_t *, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_f32)))
void svst1wq(svbool_t, float32_t *, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_s32)))
void svst1wq(svbool_t, int32_t *, svint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_u32)))
void svst1wq_vnum(svbool_t, uint32_t *, int64_t, svuint32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_f32)))
void svst1wq_vnum(svbool_t, float32_t *, int64_t, svfloat32_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1wq_vnum_s32)))
void svst1wq_vnum(svbool_t, int32_t *, int64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_c8)))
uint64_t svcntp_c8(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_c32)))
uint64_t svcntp_c32(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_c64)))
uint64_t svcntp_c64(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcntp_c16)))
uint64_t svcntp_c16(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u8_x2)))
svuint8x2_t svld1_u8_x2(svcount_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s8_x2)))
svint8x2_t svld1_s8_x2(svcount_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_mf8_x2)))
svmfloat8x2_t svld1_mf8_x2(svcount_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u64_x2)))
svuint64x2_t svld1_u64_x2(svcount_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f64_x2)))
svfloat64x2_t svld1_f64_x2(svcount_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s64_x2)))
svint64x2_t svld1_s64_x2(svcount_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u16_x2)))
svuint16x2_t svld1_u16_x2(svcount_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_bf16_x2)))
svbfloat16x2_t svld1_bf16_x2(svcount_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f16_x2)))
svfloat16x2_t svld1_f16_x2(svcount_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s16_x2)))
svint16x2_t svld1_s16_x2(svcount_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u32_x2)))
svuint32x2_t svld1_u32_x2(svcount_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f32_x2)))
svfloat32x2_t svld1_f32_x2(svcount_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s32_x2)))
svint32x2_t svld1_s32_x2(svcount_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u8_x4)))
svuint8x4_t svld1_u8_x4(svcount_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s8_x4)))
svint8x4_t svld1_s8_x4(svcount_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_mf8_x4)))
svmfloat8x4_t svld1_mf8_x4(svcount_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u64_x4)))
svuint64x4_t svld1_u64_x4(svcount_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f64_x4)))
svfloat64x4_t svld1_f64_x4(svcount_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s64_x4)))
svint64x4_t svld1_s64_x4(svcount_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u16_x4)))
svuint16x4_t svld1_u16_x4(svcount_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_bf16_x4)))
svbfloat16x4_t svld1_bf16_x4(svcount_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f16_x4)))
svfloat16x4_t svld1_f16_x4(svcount_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s16_x4)))
svint16x4_t svld1_s16_x4(svcount_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u32_x4)))
svuint32x4_t svld1_u32_x4(svcount_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f32_x4)))
svfloat32x4_t svld1_f32_x4(svcount_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s32_x4)))
svint32x4_t svld1_s32_x4(svcount_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u8_x2)))
svuint8x2_t svld1_vnum_u8_x2(svcount_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s8_x2)))
svint8x2_t svld1_vnum_s8_x2(svcount_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_mf8_x2)))
svmfloat8x2_t svld1_vnum_mf8_x2(svcount_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u64_x2)))
svuint64x2_t svld1_vnum_u64_x2(svcount_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f64_x2)))
svfloat64x2_t svld1_vnum_f64_x2(svcount_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s64_x2)))
svint64x2_t svld1_vnum_s64_x2(svcount_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u16_x2)))
svuint16x2_t svld1_vnum_u16_x2(svcount_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_bf16_x2)))
svbfloat16x2_t svld1_vnum_bf16_x2(svcount_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f16_x2)))
svfloat16x2_t svld1_vnum_f16_x2(svcount_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s16_x2)))
svint16x2_t svld1_vnum_s16_x2(svcount_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u32_x2)))
svuint32x2_t svld1_vnum_u32_x2(svcount_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f32_x2)))
svfloat32x2_t svld1_vnum_f32_x2(svcount_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s32_x2)))
svint32x2_t svld1_vnum_s32_x2(svcount_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u8_x4)))
svuint8x4_t svld1_vnum_u8_x4(svcount_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s8_x4)))
svint8x4_t svld1_vnum_s8_x4(svcount_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_mf8_x4)))
svmfloat8x4_t svld1_vnum_mf8_x4(svcount_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u64_x4)))
svuint64x4_t svld1_vnum_u64_x4(svcount_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f64_x4)))
svfloat64x4_t svld1_vnum_f64_x4(svcount_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s64_x4)))
svint64x4_t svld1_vnum_s64_x4(svcount_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u16_x4)))
svuint16x4_t svld1_vnum_u16_x4(svcount_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_bf16_x4)))
svbfloat16x4_t svld1_vnum_bf16_x4(svcount_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f16_x4)))
svfloat16x4_t svld1_vnum_f16_x4(svcount_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s16_x4)))
svint16x4_t svld1_vnum_s16_x4(svcount_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u32_x4)))
svuint32x4_t svld1_vnum_u32_x4(svcount_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f32_x4)))
svfloat32x4_t svld1_vnum_f32_x4(svcount_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s32_x4)))
svint32x4_t svld1_vnum_s32_x4(svcount_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u8_x2)))
svuint8x2_t svldnt1_u8_x2(svcount_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s8_x2)))
svint8x2_t svldnt1_s8_x2(svcount_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_mf8_x2)))
svmfloat8x2_t svldnt1_mf8_x2(svcount_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u64_x2)))
svuint64x2_t svldnt1_u64_x2(svcount_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f64_x2)))
svfloat64x2_t svldnt1_f64_x2(svcount_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s64_x2)))
svint64x2_t svldnt1_s64_x2(svcount_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u16_x2)))
svuint16x2_t svldnt1_u16_x2(svcount_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_bf16_x2)))
svbfloat16x2_t svldnt1_bf16_x2(svcount_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f16_x2)))
svfloat16x2_t svldnt1_f16_x2(svcount_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s16_x2)))
svint16x2_t svldnt1_s16_x2(svcount_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u32_x2)))
svuint32x2_t svldnt1_u32_x2(svcount_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f32_x2)))
svfloat32x2_t svldnt1_f32_x2(svcount_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s32_x2)))
svint32x2_t svldnt1_s32_x2(svcount_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u8_x4)))
svuint8x4_t svldnt1_u8_x4(svcount_t, uint8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s8_x4)))
svint8x4_t svldnt1_s8_x4(svcount_t, int8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_mf8_x4)))
svmfloat8x4_t svldnt1_mf8_x4(svcount_t, mfloat8_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u64_x4)))
svuint64x4_t svldnt1_u64_x4(svcount_t, uint64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f64_x4)))
svfloat64x4_t svldnt1_f64_x4(svcount_t, float64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s64_x4)))
svint64x4_t svldnt1_s64_x4(svcount_t, int64_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u16_x4)))
svuint16x4_t svldnt1_u16_x4(svcount_t, uint16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_bf16_x4)))
svbfloat16x4_t svldnt1_bf16_x4(svcount_t, bfloat16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f16_x4)))
svfloat16x4_t svldnt1_f16_x4(svcount_t, float16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s16_x4)))
svint16x4_t svldnt1_s16_x4(svcount_t, int16_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u32_x4)))
svuint32x4_t svldnt1_u32_x4(svcount_t, uint32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f32_x4)))
svfloat32x4_t svldnt1_f32_x4(svcount_t, float32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s32_x4)))
svint32x4_t svldnt1_s32_x4(svcount_t, int32_t const *);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u8_x2)))
svuint8x2_t svldnt1_vnum_u8_x2(svcount_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s8_x2)))
svint8x2_t svldnt1_vnum_s8_x2(svcount_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_mf8_x2)))
svmfloat8x2_t svldnt1_vnum_mf8_x2(svcount_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u64_x2)))
svuint64x2_t svldnt1_vnum_u64_x2(svcount_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f64_x2)))
svfloat64x2_t svldnt1_vnum_f64_x2(svcount_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s64_x2)))
svint64x2_t svldnt1_vnum_s64_x2(svcount_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u16_x2)))
svuint16x2_t svldnt1_vnum_u16_x2(svcount_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_bf16_x2)))
svbfloat16x2_t svldnt1_vnum_bf16_x2(svcount_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f16_x2)))
svfloat16x2_t svldnt1_vnum_f16_x2(svcount_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s16_x2)))
svint16x2_t svldnt1_vnum_s16_x2(svcount_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u32_x2)))
svuint32x2_t svldnt1_vnum_u32_x2(svcount_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f32_x2)))
svfloat32x2_t svldnt1_vnum_f32_x2(svcount_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s32_x2)))
svint32x2_t svldnt1_vnum_s32_x2(svcount_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u8_x4)))
svuint8x4_t svldnt1_vnum_u8_x4(svcount_t, uint8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s8_x4)))
svint8x4_t svldnt1_vnum_s8_x4(svcount_t, int8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_mf8_x4)))
svmfloat8x4_t svldnt1_vnum_mf8_x4(svcount_t, mfloat8_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u64_x4)))
svuint64x4_t svldnt1_vnum_u64_x4(svcount_t, uint64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f64_x4)))
svfloat64x4_t svldnt1_vnum_f64_x4(svcount_t, float64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s64_x4)))
svint64x4_t svldnt1_vnum_s64_x4(svcount_t, int64_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u16_x4)))
svuint16x4_t svldnt1_vnum_u16_x4(svcount_t, uint16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_bf16_x4)))
svbfloat16x4_t svldnt1_vnum_bf16_x4(svcount_t, bfloat16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f16_x4)))
svfloat16x4_t svldnt1_vnum_f16_x4(svcount_t, float16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s16_x4)))
svint16x4_t svldnt1_vnum_s16_x4(svcount_t, int16_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u32_x4)))
svuint32x4_t svldnt1_vnum_u32_x4(svcount_t, uint32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f32_x4)))
svfloat32x4_t svldnt1_vnum_f32_x4(svcount_t, float32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s32_x4)))
svint32x4_t svldnt1_vnum_s32_x4(svcount_t, int32_t const *, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c8)))
svbool_t svpext_lane_c8(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c32)))
svbool_t svpext_lane_c32(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c64)))
svbool_t svpext_lane_c64(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c16)))
svbool_t svpext_lane_c16(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c8_x2)))
svboolx2_t svpext_lane_c8_x2(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c32_x2)))
svboolx2_t svpext_lane_c32_x2(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c64_x2)))
svboolx2_t svpext_lane_c64_x2(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpext_lane_c16_x2)))
svboolx2_t svpext_lane_c16_x2(svcount_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpfalse_c)))
svcount_t svpfalse_c(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_c16)))
svcount_t svpsel_lane_c16(svcount_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_c32)))
svcount_t svpsel_lane_c32(svcount_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_c64)))
svcount_t svpsel_lane_c64(svcount_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpsel_lane_c8)))
svcount_t svpsel_lane_c8(svcount_t, svbool_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_c8)))
svcount_t svptrue_c8(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_c32)))
svcount_t svptrue_c32(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_c64)))
svcount_t svptrue_c64(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svptrue_c16)))
svcount_t svptrue_c16(void);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_b)))
svbool_t svreinterpret_b(svcount_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_c)))
svcount_t svreinterpret_c(svbool_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u8_x2)))
void svst1_u8_x2(svcount_t, uint8_t *, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s8_x2)))
void svst1_s8_x2(svcount_t, int8_t *, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_mf8_x2)))
void svst1_mf8_x2(svcount_t, mfloat8_t *, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u64_x2)))
void svst1_u64_x2(svcount_t, uint64_t *, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f64_x2)))
void svst1_f64_x2(svcount_t, float64_t *, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s64_x2)))
void svst1_s64_x2(svcount_t, int64_t *, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u16_x2)))
void svst1_u16_x2(svcount_t, uint16_t *, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_bf16_x2)))
void svst1_bf16_x2(svcount_t, bfloat16_t *, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f16_x2)))
void svst1_f16_x2(svcount_t, float16_t *, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s16_x2)))
void svst1_s16_x2(svcount_t, int16_t *, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u32_x2)))
void svst1_u32_x2(svcount_t, uint32_t *, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f32_x2)))
void svst1_f32_x2(svcount_t, float32_t *, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s32_x2)))
void svst1_s32_x2(svcount_t, int32_t *, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u8_x4)))
void svst1_u8_x4(svcount_t, uint8_t *, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s8_x4)))
void svst1_s8_x4(svcount_t, int8_t *, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_mf8_x4)))
void svst1_mf8_x4(svcount_t, mfloat8_t *, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u64_x4)))
void svst1_u64_x4(svcount_t, uint64_t *, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f64_x4)))
void svst1_f64_x4(svcount_t, float64_t *, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s64_x4)))
void svst1_s64_x4(svcount_t, int64_t *, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u16_x4)))
void svst1_u16_x4(svcount_t, uint16_t *, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_bf16_x4)))
void svst1_bf16_x4(svcount_t, bfloat16_t *, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f16_x4)))
void svst1_f16_x4(svcount_t, float16_t *, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s16_x4)))
void svst1_s16_x4(svcount_t, int16_t *, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u32_x4)))
void svst1_u32_x4(svcount_t, uint32_t *, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f32_x4)))
void svst1_f32_x4(svcount_t, float32_t *, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s32_x4)))
void svst1_s32_x4(svcount_t, int32_t *, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u8_x2)))
void svst1_vnum_u8_x2(svcount_t, uint8_t *, int64_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s8_x2)))
void svst1_vnum_s8_x2(svcount_t, int8_t *, int64_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_mf8_x2)))
void svst1_vnum_mf8_x2(svcount_t, mfloat8_t *, int64_t, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u64_x2)))
void svst1_vnum_u64_x2(svcount_t, uint64_t *, int64_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f64_x2)))
void svst1_vnum_f64_x2(svcount_t, float64_t *, int64_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s64_x2)))
void svst1_vnum_s64_x2(svcount_t, int64_t *, int64_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u16_x2)))
void svst1_vnum_u16_x2(svcount_t, uint16_t *, int64_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_bf16_x2)))
void svst1_vnum_bf16_x2(svcount_t, bfloat16_t *, int64_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f16_x2)))
void svst1_vnum_f16_x2(svcount_t, float16_t *, int64_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s16_x2)))
void svst1_vnum_s16_x2(svcount_t, int16_t *, int64_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u32_x2)))
void svst1_vnum_u32_x2(svcount_t, uint32_t *, int64_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f32_x2)))
void svst1_vnum_f32_x2(svcount_t, float32_t *, int64_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s32_x2)))
void svst1_vnum_s32_x2(svcount_t, int32_t *, int64_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u8_x4)))
void svst1_vnum_u8_x4(svcount_t, uint8_t *, int64_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s8_x4)))
void svst1_vnum_s8_x4(svcount_t, int8_t *, int64_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_mf8_x4)))
void svst1_vnum_mf8_x4(svcount_t, mfloat8_t *, int64_t, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u64_x4)))
void svst1_vnum_u64_x4(svcount_t, uint64_t *, int64_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f64_x4)))
void svst1_vnum_f64_x4(svcount_t, float64_t *, int64_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s64_x4)))
void svst1_vnum_s64_x4(svcount_t, int64_t *, int64_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u16_x4)))
void svst1_vnum_u16_x4(svcount_t, uint16_t *, int64_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_bf16_x4)))
void svst1_vnum_bf16_x4(svcount_t, bfloat16_t *, int64_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f16_x4)))
void svst1_vnum_f16_x4(svcount_t, float16_t *, int64_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s16_x4)))
void svst1_vnum_s16_x4(svcount_t, int16_t *, int64_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u32_x4)))
void svst1_vnum_u32_x4(svcount_t, uint32_t *, int64_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f32_x4)))
void svst1_vnum_f32_x4(svcount_t, float32_t *, int64_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s32_x4)))
void svst1_vnum_s32_x4(svcount_t, int32_t *, int64_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u8_x2)))
void svstnt1_u8_x2(svcount_t, uint8_t *, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s8_x2)))
void svstnt1_s8_x2(svcount_t, int8_t *, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_mf8_x2)))
void svstnt1_mf8_x2(svcount_t, mfloat8_t *, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u64_x2)))
void svstnt1_u64_x2(svcount_t, uint64_t *, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f64_x2)))
void svstnt1_f64_x2(svcount_t, float64_t *, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s64_x2)))
void svstnt1_s64_x2(svcount_t, int64_t *, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u16_x2)))
void svstnt1_u16_x2(svcount_t, uint16_t *, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_bf16_x2)))
void svstnt1_bf16_x2(svcount_t, bfloat16_t *, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f16_x2)))
void svstnt1_f16_x2(svcount_t, float16_t *, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s16_x2)))
void svstnt1_s16_x2(svcount_t, int16_t *, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u32_x2)))
void svstnt1_u32_x2(svcount_t, uint32_t *, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f32_x2)))
void svstnt1_f32_x2(svcount_t, float32_t *, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s32_x2)))
void svstnt1_s32_x2(svcount_t, int32_t *, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u8_x4)))
void svstnt1_u8_x4(svcount_t, uint8_t *, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s8_x4)))
void svstnt1_s8_x4(svcount_t, int8_t *, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_mf8_x4)))
void svstnt1_mf8_x4(svcount_t, mfloat8_t *, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u64_x4)))
void svstnt1_u64_x4(svcount_t, uint64_t *, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f64_x4)))
void svstnt1_f64_x4(svcount_t, float64_t *, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s64_x4)))
void svstnt1_s64_x4(svcount_t, int64_t *, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u16_x4)))
void svstnt1_u16_x4(svcount_t, uint16_t *, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_bf16_x4)))
void svstnt1_bf16_x4(svcount_t, bfloat16_t *, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f16_x4)))
void svstnt1_f16_x4(svcount_t, float16_t *, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s16_x4)))
void svstnt1_s16_x4(svcount_t, int16_t *, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u32_x4)))
void svstnt1_u32_x4(svcount_t, uint32_t *, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f32_x4)))
void svstnt1_f32_x4(svcount_t, float32_t *, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s32_x4)))
void svstnt1_s32_x4(svcount_t, int32_t *, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u8_x2)))
void svstnt1_vnum_u8_x2(svcount_t, uint8_t *, int64_t, svuint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s8_x2)))
void svstnt1_vnum_s8_x2(svcount_t, int8_t *, int64_t, svint8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_mf8_x2)))
void svstnt1_vnum_mf8_x2(svcount_t, mfloat8_t *, int64_t, svmfloat8x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u64_x2)))
void svstnt1_vnum_u64_x2(svcount_t, uint64_t *, int64_t, svuint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f64_x2)))
void svstnt1_vnum_f64_x2(svcount_t, float64_t *, int64_t, svfloat64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s64_x2)))
void svstnt1_vnum_s64_x2(svcount_t, int64_t *, int64_t, svint64x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u16_x2)))
void svstnt1_vnum_u16_x2(svcount_t, uint16_t *, int64_t, svuint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_bf16_x2)))
void svstnt1_vnum_bf16_x2(svcount_t, bfloat16_t *, int64_t, svbfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f16_x2)))
void svstnt1_vnum_f16_x2(svcount_t, float16_t *, int64_t, svfloat16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s16_x2)))
void svstnt1_vnum_s16_x2(svcount_t, int16_t *, int64_t, svint16x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u32_x2)))
void svstnt1_vnum_u32_x2(svcount_t, uint32_t *, int64_t, svuint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f32_x2)))
void svstnt1_vnum_f32_x2(svcount_t, float32_t *, int64_t, svfloat32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s32_x2)))
void svstnt1_vnum_s32_x2(svcount_t, int32_t *, int64_t, svint32x2_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u8_x4)))
void svstnt1_vnum_u8_x4(svcount_t, uint8_t *, int64_t, svuint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s8_x4)))
void svstnt1_vnum_s8_x4(svcount_t, int8_t *, int64_t, svint8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_mf8_x4)))
void svstnt1_vnum_mf8_x4(svcount_t, mfloat8_t *, int64_t, svmfloat8x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u64_x4)))
void svstnt1_vnum_u64_x4(svcount_t, uint64_t *, int64_t, svuint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f64_x4)))
void svstnt1_vnum_f64_x4(svcount_t, float64_t *, int64_t, svfloat64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s64_x4)))
void svstnt1_vnum_s64_x4(svcount_t, int64_t *, int64_t, svint64x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u16_x4)))
void svstnt1_vnum_u16_x4(svcount_t, uint16_t *, int64_t, svuint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_bf16_x4)))
void svstnt1_vnum_bf16_x4(svcount_t, bfloat16_t *, int64_t, svbfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f16_x4)))
void svstnt1_vnum_f16_x4(svcount_t, float16_t *, int64_t, svfloat16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s16_x4)))
void svstnt1_vnum_s16_x4(svcount_t, int16_t *, int64_t, svint16x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u32_x4)))
void svstnt1_vnum_u32_x4(svcount_t, uint32_t *, int64_t, svuint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f32_x4)))
void svstnt1_vnum_f32_x4(svcount_t, float32_t *, int64_t, svfloat32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s32_x4)))
void svstnt1_vnum_s32_x4(svcount_t, int32_t *, int64_t, svint32x4_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c8_s64)))
svcount_t svwhilege_c8_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c32_s64)))
svcount_t svwhilege_c32_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c64_s64)))
svcount_t svwhilege_c64_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c16_s64)))
svcount_t svwhilege_c16_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c8_u64)))
svcount_t svwhilege_c8_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c32_u64)))
svcount_t svwhilege_c32_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c64_u64)))
svcount_t svwhilege_c64_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c16_u64)))
svcount_t svwhilege_c16_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c8_s64)))
svcount_t svwhilegt_c8_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c32_s64)))
svcount_t svwhilegt_c32_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c64_s64)))
svcount_t svwhilegt_c64_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c16_s64)))
svcount_t svwhilegt_c16_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c8_u64)))
svcount_t svwhilegt_c8_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c32_u64)))
svcount_t svwhilegt_c32_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c64_u64)))
svcount_t svwhilegt_c64_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c16_u64)))
svcount_t svwhilegt_c16_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c8_s64)))
svcount_t svwhilele_c8_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c32_s64)))
svcount_t svwhilele_c32_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c64_s64)))
svcount_t svwhilele_c64_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c16_s64)))
svcount_t svwhilele_c16_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c8_u64)))
svcount_t svwhilele_c8_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c32_u64)))
svcount_t svwhilele_c32_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c64_u64)))
svcount_t svwhilele_c64_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c16_u64)))
svcount_t svwhilele_c16_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c8_u64)))
svcount_t svwhilelt_c8_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c32_u64)))
svcount_t svwhilelt_c32_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c64_u64)))
svcount_t svwhilelt_c64_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c16_u64)))
svcount_t svwhilelt_c16_u64(uint64_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c8_s64)))
svcount_t svwhilelt_c8_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c32_s64)))
svcount_t svwhilelt_c32_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c64_s64)))
svcount_t svwhilelt_c64_s64(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c16_s64)))
svcount_t svwhilelt_c16_s64(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u8_x2)))
svuint8x2_t svld1_x2(svcount_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s8_x2)))
svint8x2_t svld1_x2(svcount_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_mf8_x2)))
svmfloat8x2_t svld1_x2(svcount_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u64_x2)))
svuint64x2_t svld1_x2(svcount_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f64_x2)))
svfloat64x2_t svld1_x2(svcount_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s64_x2)))
svint64x2_t svld1_x2(svcount_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u16_x2)))
svuint16x2_t svld1_x2(svcount_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_bf16_x2)))
svbfloat16x2_t svld1_x2(svcount_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f16_x2)))
svfloat16x2_t svld1_x2(svcount_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s16_x2)))
svint16x2_t svld1_x2(svcount_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u32_x2)))
svuint32x2_t svld1_x2(svcount_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f32_x2)))
svfloat32x2_t svld1_x2(svcount_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s32_x2)))
svint32x2_t svld1_x2(svcount_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u8_x4)))
svuint8x4_t svld1_x4(svcount_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s8_x4)))
svint8x4_t svld1_x4(svcount_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_mf8_x4)))
svmfloat8x4_t svld1_x4(svcount_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u64_x4)))
svuint64x4_t svld1_x4(svcount_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f64_x4)))
svfloat64x4_t svld1_x4(svcount_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s64_x4)))
svint64x4_t svld1_x4(svcount_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u16_x4)))
svuint16x4_t svld1_x4(svcount_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_bf16_x4)))
svbfloat16x4_t svld1_x4(svcount_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f16_x4)))
svfloat16x4_t svld1_x4(svcount_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s16_x4)))
svint16x4_t svld1_x4(svcount_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_u32_x4)))
svuint32x4_t svld1_x4(svcount_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_f32_x4)))
svfloat32x4_t svld1_x4(svcount_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_s32_x4)))
svint32x4_t svld1_x4(svcount_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u8_x2)))
svuint8x2_t svld1_vnum_x2(svcount_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s8_x2)))
svint8x2_t svld1_vnum_x2(svcount_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_mf8_x2)))
svmfloat8x2_t svld1_vnum_x2(svcount_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u64_x2)))
svuint64x2_t svld1_vnum_x2(svcount_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f64_x2)))
svfloat64x2_t svld1_vnum_x2(svcount_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s64_x2)))
svint64x2_t svld1_vnum_x2(svcount_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u16_x2)))
svuint16x2_t svld1_vnum_x2(svcount_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_bf16_x2)))
svbfloat16x2_t svld1_vnum_x2(svcount_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f16_x2)))
svfloat16x2_t svld1_vnum_x2(svcount_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s16_x2)))
svint16x2_t svld1_vnum_x2(svcount_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u32_x2)))
svuint32x2_t svld1_vnum_x2(svcount_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f32_x2)))
svfloat32x2_t svld1_vnum_x2(svcount_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s32_x2)))
svint32x2_t svld1_vnum_x2(svcount_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u8_x4)))
svuint8x4_t svld1_vnum_x4(svcount_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s8_x4)))
svint8x4_t svld1_vnum_x4(svcount_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_mf8_x4)))
svmfloat8x4_t svld1_vnum_x4(svcount_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u64_x4)))
svuint64x4_t svld1_vnum_x4(svcount_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f64_x4)))
svfloat64x4_t svld1_vnum_x4(svcount_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s64_x4)))
svint64x4_t svld1_vnum_x4(svcount_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u16_x4)))
svuint16x4_t svld1_vnum_x4(svcount_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_bf16_x4)))
svbfloat16x4_t svld1_vnum_x4(svcount_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f16_x4)))
svfloat16x4_t svld1_vnum_x4(svcount_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s16_x4)))
svint16x4_t svld1_vnum_x4(svcount_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_u32_x4)))
svuint32x4_t svld1_vnum_x4(svcount_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_f32_x4)))
svfloat32x4_t svld1_vnum_x4(svcount_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svld1_vnum_s32_x4)))
svint32x4_t svld1_vnum_x4(svcount_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u8_x2)))
svuint8x2_t svldnt1_x2(svcount_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s8_x2)))
svint8x2_t svldnt1_x2(svcount_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_mf8_x2)))
svmfloat8x2_t svldnt1_x2(svcount_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u64_x2)))
svuint64x2_t svldnt1_x2(svcount_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f64_x2)))
svfloat64x2_t svldnt1_x2(svcount_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s64_x2)))
svint64x2_t svldnt1_x2(svcount_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u16_x2)))
svuint16x2_t svldnt1_x2(svcount_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_bf16_x2)))
svbfloat16x2_t svldnt1_x2(svcount_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f16_x2)))
svfloat16x2_t svldnt1_x2(svcount_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s16_x2)))
svint16x2_t svldnt1_x2(svcount_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u32_x2)))
svuint32x2_t svldnt1_x2(svcount_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f32_x2)))
svfloat32x2_t svldnt1_x2(svcount_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s32_x2)))
svint32x2_t svldnt1_x2(svcount_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u8_x4)))
svuint8x4_t svldnt1_x4(svcount_t, uint8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s8_x4)))
svint8x4_t svldnt1_x4(svcount_t, int8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_mf8_x4)))
svmfloat8x4_t svldnt1_x4(svcount_t, mfloat8_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u64_x4)))
svuint64x4_t svldnt1_x4(svcount_t, uint64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f64_x4)))
svfloat64x4_t svldnt1_x4(svcount_t, float64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s64_x4)))
svint64x4_t svldnt1_x4(svcount_t, int64_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u16_x4)))
svuint16x4_t svldnt1_x4(svcount_t, uint16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_bf16_x4)))
svbfloat16x4_t svldnt1_x4(svcount_t, bfloat16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f16_x4)))
svfloat16x4_t svldnt1_x4(svcount_t, float16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s16_x4)))
svint16x4_t svldnt1_x4(svcount_t, int16_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_u32_x4)))
svuint32x4_t svldnt1_x4(svcount_t, uint32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_f32_x4)))
svfloat32x4_t svldnt1_x4(svcount_t, float32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_s32_x4)))
svint32x4_t svldnt1_x4(svcount_t, int32_t const *);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u8_x2)))
svuint8x2_t svldnt1_vnum_x2(svcount_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s8_x2)))
svint8x2_t svldnt1_vnum_x2(svcount_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_mf8_x2)))
svmfloat8x2_t svldnt1_vnum_x2(svcount_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u64_x2)))
svuint64x2_t svldnt1_vnum_x2(svcount_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f64_x2)))
svfloat64x2_t svldnt1_vnum_x2(svcount_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s64_x2)))
svint64x2_t svldnt1_vnum_x2(svcount_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u16_x2)))
svuint16x2_t svldnt1_vnum_x2(svcount_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_bf16_x2)))
svbfloat16x2_t svldnt1_vnum_x2(svcount_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f16_x2)))
svfloat16x2_t svldnt1_vnum_x2(svcount_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s16_x2)))
svint16x2_t svldnt1_vnum_x2(svcount_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u32_x2)))
svuint32x2_t svldnt1_vnum_x2(svcount_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f32_x2)))
svfloat32x2_t svldnt1_vnum_x2(svcount_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s32_x2)))
svint32x2_t svldnt1_vnum_x2(svcount_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u8_x4)))
svuint8x4_t svldnt1_vnum_x4(svcount_t, uint8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s8_x4)))
svint8x4_t svldnt1_vnum_x4(svcount_t, int8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_mf8_x4)))
svmfloat8x4_t svldnt1_vnum_x4(svcount_t, mfloat8_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u64_x4)))
svuint64x4_t svldnt1_vnum_x4(svcount_t, uint64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f64_x4)))
svfloat64x4_t svldnt1_vnum_x4(svcount_t, float64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s64_x4)))
svint64x4_t svldnt1_vnum_x4(svcount_t, int64_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u16_x4)))
svuint16x4_t svldnt1_vnum_x4(svcount_t, uint16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_bf16_x4)))
svbfloat16x4_t svldnt1_vnum_x4(svcount_t, bfloat16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f16_x4)))
svfloat16x4_t svldnt1_vnum_x4(svcount_t, float16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s16_x4)))
svint16x4_t svldnt1_vnum_x4(svcount_t, int16_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_u32_x4)))
svuint32x4_t svldnt1_vnum_x4(svcount_t, uint32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_f32_x4)))
svfloat32x4_t svldnt1_vnum_x4(svcount_t, float32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svldnt1_vnum_s32_x4)))
svint32x4_t svldnt1_vnum_x4(svcount_t, int32_t const *, int64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_b)))
svbool_t svreinterpret(svcount_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svreinterpret_c)))
svcount_t svreinterpret(svbool_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u8_x2)))
void svst1(svcount_t, uint8_t *, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s8_x2)))
void svst1(svcount_t, int8_t *, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_mf8_x2)))
void svst1(svcount_t, mfloat8_t *, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u64_x2)))
void svst1(svcount_t, uint64_t *, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f64_x2)))
void svst1(svcount_t, float64_t *, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s64_x2)))
void svst1(svcount_t, int64_t *, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u16_x2)))
void svst1(svcount_t, uint16_t *, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_bf16_x2)))
void svst1(svcount_t, bfloat16_t *, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f16_x2)))
void svst1(svcount_t, float16_t *, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s16_x2)))
void svst1(svcount_t, int16_t *, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u32_x2)))
void svst1(svcount_t, uint32_t *, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f32_x2)))
void svst1(svcount_t, float32_t *, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s32_x2)))
void svst1(svcount_t, int32_t *, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u8_x4)))
void svst1(svcount_t, uint8_t *, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s8_x4)))
void svst1(svcount_t, int8_t *, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_mf8_x4)))
void svst1(svcount_t, mfloat8_t *, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u64_x4)))
void svst1(svcount_t, uint64_t *, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f64_x4)))
void svst1(svcount_t, float64_t *, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s64_x4)))
void svst1(svcount_t, int64_t *, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u16_x4)))
void svst1(svcount_t, uint16_t *, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_bf16_x4)))
void svst1(svcount_t, bfloat16_t *, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f16_x4)))
void svst1(svcount_t, float16_t *, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s16_x4)))
void svst1(svcount_t, int16_t *, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_u32_x4)))
void svst1(svcount_t, uint32_t *, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_f32_x4)))
void svst1(svcount_t, float32_t *, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_s32_x4)))
void svst1(svcount_t, int32_t *, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u8_x2)))
void svst1_vnum(svcount_t, uint8_t *, int64_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s8_x2)))
void svst1_vnum(svcount_t, int8_t *, int64_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_mf8_x2)))
void svst1_vnum(svcount_t, mfloat8_t *, int64_t, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u64_x2)))
void svst1_vnum(svcount_t, uint64_t *, int64_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f64_x2)))
void svst1_vnum(svcount_t, float64_t *, int64_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s64_x2)))
void svst1_vnum(svcount_t, int64_t *, int64_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u16_x2)))
void svst1_vnum(svcount_t, uint16_t *, int64_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_bf16_x2)))
void svst1_vnum(svcount_t, bfloat16_t *, int64_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f16_x2)))
void svst1_vnum(svcount_t, float16_t *, int64_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s16_x2)))
void svst1_vnum(svcount_t, int16_t *, int64_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u32_x2)))
void svst1_vnum(svcount_t, uint32_t *, int64_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f32_x2)))
void svst1_vnum(svcount_t, float32_t *, int64_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s32_x2)))
void svst1_vnum(svcount_t, int32_t *, int64_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u8_x4)))
void svst1_vnum(svcount_t, uint8_t *, int64_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s8_x4)))
void svst1_vnum(svcount_t, int8_t *, int64_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_mf8_x4)))
void svst1_vnum(svcount_t, mfloat8_t *, int64_t, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u64_x4)))
void svst1_vnum(svcount_t, uint64_t *, int64_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f64_x4)))
void svst1_vnum(svcount_t, float64_t *, int64_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s64_x4)))
void svst1_vnum(svcount_t, int64_t *, int64_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u16_x4)))
void svst1_vnum(svcount_t, uint16_t *, int64_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_bf16_x4)))
void svst1_vnum(svcount_t, bfloat16_t *, int64_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f16_x4)))
void svst1_vnum(svcount_t, float16_t *, int64_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s16_x4)))
void svst1_vnum(svcount_t, int16_t *, int64_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_u32_x4)))
void svst1_vnum(svcount_t, uint32_t *, int64_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_f32_x4)))
void svst1_vnum(svcount_t, float32_t *, int64_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svst1_vnum_s32_x4)))
void svst1_vnum(svcount_t, int32_t *, int64_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u8_x2)))
void svstnt1(svcount_t, uint8_t *, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s8_x2)))
void svstnt1(svcount_t, int8_t *, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_mf8_x2)))
void svstnt1(svcount_t, mfloat8_t *, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u64_x2)))
void svstnt1(svcount_t, uint64_t *, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f64_x2)))
void svstnt1(svcount_t, float64_t *, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s64_x2)))
void svstnt1(svcount_t, int64_t *, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u16_x2)))
void svstnt1(svcount_t, uint16_t *, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_bf16_x2)))
void svstnt1(svcount_t, bfloat16_t *, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f16_x2)))
void svstnt1(svcount_t, float16_t *, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s16_x2)))
void svstnt1(svcount_t, int16_t *, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u32_x2)))
void svstnt1(svcount_t, uint32_t *, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f32_x2)))
void svstnt1(svcount_t, float32_t *, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s32_x2)))
void svstnt1(svcount_t, int32_t *, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u8_x4)))
void svstnt1(svcount_t, uint8_t *, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s8_x4)))
void svstnt1(svcount_t, int8_t *, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_mf8_x4)))
void svstnt1(svcount_t, mfloat8_t *, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u64_x4)))
void svstnt1(svcount_t, uint64_t *, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f64_x4)))
void svstnt1(svcount_t, float64_t *, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s64_x4)))
void svstnt1(svcount_t, int64_t *, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u16_x4)))
void svstnt1(svcount_t, uint16_t *, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_bf16_x4)))
void svstnt1(svcount_t, bfloat16_t *, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f16_x4)))
void svstnt1(svcount_t, float16_t *, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s16_x4)))
void svstnt1(svcount_t, int16_t *, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_u32_x4)))
void svstnt1(svcount_t, uint32_t *, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_f32_x4)))
void svstnt1(svcount_t, float32_t *, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_s32_x4)))
void svstnt1(svcount_t, int32_t *, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u8_x2)))
void svstnt1_vnum(svcount_t, uint8_t *, int64_t, svuint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s8_x2)))
void svstnt1_vnum(svcount_t, int8_t *, int64_t, svint8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_mf8_x2)))
void svstnt1_vnum(svcount_t, mfloat8_t *, int64_t, svmfloat8x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u64_x2)))
void svstnt1_vnum(svcount_t, uint64_t *, int64_t, svuint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f64_x2)))
void svstnt1_vnum(svcount_t, float64_t *, int64_t, svfloat64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s64_x2)))
void svstnt1_vnum(svcount_t, int64_t *, int64_t, svint64x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u16_x2)))
void svstnt1_vnum(svcount_t, uint16_t *, int64_t, svuint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_bf16_x2)))
void svstnt1_vnum(svcount_t, bfloat16_t *, int64_t, svbfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f16_x2)))
void svstnt1_vnum(svcount_t, float16_t *, int64_t, svfloat16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s16_x2)))
void svstnt1_vnum(svcount_t, int16_t *, int64_t, svint16x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u32_x2)))
void svstnt1_vnum(svcount_t, uint32_t *, int64_t, svuint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f32_x2)))
void svstnt1_vnum(svcount_t, float32_t *, int64_t, svfloat32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s32_x2)))
void svstnt1_vnum(svcount_t, int32_t *, int64_t, svint32x2_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u8_x4)))
void svstnt1_vnum(svcount_t, uint8_t *, int64_t, svuint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s8_x4)))
void svstnt1_vnum(svcount_t, int8_t *, int64_t, svint8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_mf8_x4)))
void svstnt1_vnum(svcount_t, mfloat8_t *, int64_t, svmfloat8x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u64_x4)))
void svstnt1_vnum(svcount_t, uint64_t *, int64_t, svuint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f64_x4)))
void svstnt1_vnum(svcount_t, float64_t *, int64_t, svfloat64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s64_x4)))
void svstnt1_vnum(svcount_t, int64_t *, int64_t, svint64x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u16_x4)))
void svstnt1_vnum(svcount_t, uint16_t *, int64_t, svuint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_bf16_x4)))
void svstnt1_vnum(svcount_t, bfloat16_t *, int64_t, svbfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f16_x4)))
void svstnt1_vnum(svcount_t, float16_t *, int64_t, svfloat16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s16_x4)))
void svstnt1_vnum(svcount_t, int16_t *, int64_t, svint16x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_u32_x4)))
void svstnt1_vnum(svcount_t, uint32_t *, int64_t, svuint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_f32_x4)))
void svstnt1_vnum(svcount_t, float32_t *, int64_t, svfloat32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svstnt1_vnum_s32_x4)))
void svstnt1_vnum(svcount_t, int32_t *, int64_t, svint32x4_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c8_s64)))
svcount_t svwhilege_c8(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c32_s64)))
svcount_t svwhilege_c32(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c64_s64)))
svcount_t svwhilege_c64(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c16_s64)))
svcount_t svwhilege_c16(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c8_u64)))
svcount_t svwhilege_c8(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c32_u64)))
svcount_t svwhilege_c32(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c64_u64)))
svcount_t svwhilege_c64(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilege_c16_u64)))
svcount_t svwhilege_c16(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c8_s64)))
svcount_t svwhilegt_c8(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c32_s64)))
svcount_t svwhilegt_c32(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c64_s64)))
svcount_t svwhilegt_c64(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c16_s64)))
svcount_t svwhilegt_c16(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c8_u64)))
svcount_t svwhilegt_c8(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c32_u64)))
svcount_t svwhilegt_c32(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c64_u64)))
svcount_t svwhilegt_c64(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilegt_c16_u64)))
svcount_t svwhilegt_c16(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c8_s64)))
svcount_t svwhilele_c8(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c32_s64)))
svcount_t svwhilele_c32(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c64_s64)))
svcount_t svwhilele_c64(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c16_s64)))
svcount_t svwhilele_c16(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c8_u64)))
svcount_t svwhilele_c8(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c32_u64)))
svcount_t svwhilele_c32(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c64_u64)))
svcount_t svwhilele_c64(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilele_c16_u64)))
svcount_t svwhilele_c16(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c8_u64)))
svcount_t svwhilelt_c8(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c32_u64)))
svcount_t svwhilelt_c32(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c64_u64)))
svcount_t svwhilelt_c64(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c16_u64)))
svcount_t svwhilelt_c16(uint64_t, uint64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c8_s64)))
svcount_t svwhilelt_c8(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c32_s64)))
svcount_t svwhilelt_c32(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c64_s64)))
svcount_t svwhilelt_c64(int64_t, int64_t, uint64_t);
__aio __attribute__((__clang_arm_builtin_alias(__builtin_sve_svwhilelt_c16_s64)))
svcount_t svwhilelt_c16(int64_t, int64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_s8)))
svint8_t svaba_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_s32)))
svint32_t svaba_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_s64)))
svint64_t svaba_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_s16)))
svint16_t svaba_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_u8)))
svuint8_t svaba_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_u32)))
svuint32_t svaba_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_u64)))
svuint64_t svaba_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_n_u16)))
svuint16_t svaba_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_s8)))
svint8_t svaba_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_s32)))
svint32_t svaba_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_s64)))
svint64_t svaba_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_s16)))
svint16_t svaba_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_u8)))
svuint8_t svaba_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_u32)))
svuint32_t svaba_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_u64)))
svuint64_t svaba_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaba_u16)))
svuint16_t svaba_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_s32)))
svint32_t svabalb_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_s64)))
svint64_t svabalb_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_s16)))
svint16_t svabalb_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_u32)))
svuint32_t svabalb_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_u64)))
svuint64_t svabalb_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_n_u16)))
svuint16_t svabalb_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_s32)))
svint32_t svabalb_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_s64)))
svint64_t svabalb_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_s16)))
svint16_t svabalb_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_u32)))
svuint32_t svabalb_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_u64)))
svuint64_t svabalb_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalb_u16)))
svuint16_t svabalb_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_s32)))
svint32_t svabalt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_s64)))
svint64_t svabalt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_s16)))
svint16_t svabalt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_u32)))
svuint32_t svabalt_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_u64)))
svuint64_t svabalt_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_n_u16)))
svuint16_t svabalt_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_s32)))
svint32_t svabalt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_s64)))
svint64_t svabalt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_s16)))
svint16_t svabalt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_u32)))
svuint32_t svabalt_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_u64)))
svuint64_t svabalt_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabalt_u16)))
svuint16_t svabalt_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_s32)))
svint32_t svabdlb_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_s64)))
svint64_t svabdlb_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_s16)))
svint16_t svabdlb_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_u32)))
svuint32_t svabdlb_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_u64)))
svuint64_t svabdlb_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_n_u16)))
svuint16_t svabdlb_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_s32)))
svint32_t svabdlb_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_s64)))
svint64_t svabdlb_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_s16)))
svint16_t svabdlb_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_u32)))
svuint32_t svabdlb_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_u64)))
svuint64_t svabdlb_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlb_u16)))
svuint16_t svabdlb_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_s32)))
svint32_t svabdlt_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_s64)))
svint64_t svabdlt_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_s16)))
svint16_t svabdlt_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_u32)))
svuint32_t svabdlt_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_u64)))
svuint64_t svabdlt_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_n_u16)))
svuint16_t svabdlt_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_s32)))
svint32_t svabdlt_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_s64)))
svint64_t svabdlt_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_s16)))
svint16_t svabdlt_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_u32)))
svuint32_t svabdlt_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_u64)))
svuint64_t svabdlt_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svabdlt_u16)))
svuint16_t svabdlt_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s32_m)))
svint32_t svadalp_s32_m(svbool_t, svint32_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s64_m)))
svint64_t svadalp_s64_m(svbool_t, svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s16_m)))
svint16_t svadalp_s16_m(svbool_t, svint16_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s32_x)))
svint32_t svadalp_s32_x(svbool_t, svint32_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s64_x)))
svint64_t svadalp_s64_x(svbool_t, svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s16_x)))
svint16_t svadalp_s16_x(svbool_t, svint16_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s32_z)))
svint32_t svadalp_s32_z(svbool_t, svint32_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s64_z)))
svint64_t svadalp_s64_z(svbool_t, svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_s16_z)))
svint16_t svadalp_s16_z(svbool_t, svint16_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u32_m)))
svuint32_t svadalp_u32_m(svbool_t, svuint32_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u64_m)))
svuint64_t svadalp_u64_m(svbool_t, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u16_m)))
svuint16_t svadalp_u16_m(svbool_t, svuint16_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u32_x)))
svuint32_t svadalp_u32_x(svbool_t, svuint32_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u64_x)))
svuint64_t svadalp_u64_x(svbool_t, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u16_x)))
svuint16_t svadalp_u16_x(svbool_t, svuint16_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u32_z)))
svuint32_t svadalp_u32_z(svbool_t, svuint32_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u64_z)))
svuint64_t svadalp_u64_z(svbool_t, svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadalp_u16_z)))
svuint16_t svadalp_u16_z(svbool_t, svuint16_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclb_n_u32)))
svuint32_t svadclb_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclb_n_u64)))
svuint64_t svadclb_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclb_u32)))
svuint32_t svadclb_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclb_u64)))
svuint64_t svadclb_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclt_n_u32)))
svuint32_t svadclt_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclt_n_u64)))
svuint64_t svadclt_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclt_u32)))
svuint32_t svadclt_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svadclt_u64)))
svuint64_t svadclt_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_u32)))
svuint16_t svaddhnb_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_u64)))
svuint32_t svaddhnb_n_u64(svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_u16)))
svuint8_t svaddhnb_n_u16(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_s32)))
svint16_t svaddhnb_n_s32(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_s64)))
svint32_t svaddhnb_n_s64(svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_n_s16)))
svint8_t svaddhnb_n_s16(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_u32)))
svuint16_t svaddhnb_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_u64)))
svuint32_t svaddhnb_u64(svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_u16)))
svuint8_t svaddhnb_u16(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_s32)))
svint16_t svaddhnb_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_s64)))
svint32_t svaddhnb_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnb_s16)))
svint8_t svaddhnb_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_u32)))
svuint16_t svaddhnt_n_u32(svuint16_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_u64)))
svuint32_t svaddhnt_n_u64(svuint32_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_u16)))
svuint8_t svaddhnt_n_u16(svuint8_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_s32)))
svint16_t svaddhnt_n_s32(svint16_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_s64)))
svint32_t svaddhnt_n_s64(svint32_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_n_s16)))
svint8_t svaddhnt_n_s16(svint8_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_u32)))
svuint16_t svaddhnt_u32(svuint16_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_u64)))
svuint32_t svaddhnt_u64(svuint32_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_u16)))
svuint8_t svaddhnt_u16(svuint8_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_s32)))
svint16_t svaddhnt_s32(svint16_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_s64)))
svint32_t svaddhnt_s64(svint32_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddhnt_s16)))
svint8_t svaddhnt_s16(svint8_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_s32)))
svint32_t svaddlb_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_s64)))
svint64_t svaddlb_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_s16)))
svint16_t svaddlb_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_u32)))
svuint32_t svaddlb_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_u64)))
svuint64_t svaddlb_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_n_u16)))
svuint16_t svaddlb_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_s32)))
svint32_t svaddlb_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_s64)))
svint64_t svaddlb_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_s16)))
svint16_t svaddlb_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_u32)))
svuint32_t svaddlb_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_u64)))
svuint64_t svaddlb_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlb_u16)))
svuint16_t svaddlb_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_n_s32)))
svint32_t svaddlbt_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_n_s64)))
svint64_t svaddlbt_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_n_s16)))
svint16_t svaddlbt_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_s32)))
svint32_t svaddlbt_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_s64)))
svint64_t svaddlbt_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlbt_s16)))
svint16_t svaddlbt_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_s32)))
svint32_t svaddlt_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_s64)))
svint64_t svaddlt_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_s16)))
svint16_t svaddlt_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_u32)))
svuint32_t svaddlt_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_u64)))
svuint64_t svaddlt_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_n_u16)))
svuint16_t svaddlt_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_s32)))
svint32_t svaddlt_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_s64)))
svint64_t svaddlt_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_s16)))
svint16_t svaddlt_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_u32)))
svuint32_t svaddlt_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_u64)))
svuint64_t svaddlt_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddlt_u16)))
svuint16_t svaddlt_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f64_m)))
svfloat64_t svaddp_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f32_m)))
svfloat32_t svaddp_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f16_m)))
svfloat16_t svaddp_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f64_x)))
svfloat64_t svaddp_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f32_x)))
svfloat32_t svaddp_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_f16_x)))
svfloat16_t svaddp_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u8_m)))
svuint8_t svaddp_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u32_m)))
svuint32_t svaddp_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u64_m)))
svuint64_t svaddp_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u16_m)))
svuint16_t svaddp_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s8_m)))
svint8_t svaddp_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s32_m)))
svint32_t svaddp_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s64_m)))
svint64_t svaddp_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s16_m)))
svint16_t svaddp_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u8_x)))
svuint8_t svaddp_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u32_x)))
svuint32_t svaddp_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u64_x)))
svuint64_t svaddp_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_u16_x)))
svuint16_t svaddp_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s8_x)))
svint8_t svaddp_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s32_x)))
svint32_t svaddp_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s64_x)))
svint64_t svaddp_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddp_s16_x)))
svint16_t svaddp_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_s32)))
svint32_t svaddwb_n_s32(svint32_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_s64)))
svint64_t svaddwb_n_s64(svint64_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_s16)))
svint16_t svaddwb_n_s16(svint16_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_u32)))
svuint32_t svaddwb_n_u32(svuint32_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_u64)))
svuint64_t svaddwb_n_u64(svuint64_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_n_u16)))
svuint16_t svaddwb_n_u16(svuint16_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_s32)))
svint32_t svaddwb_s32(svint32_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_s64)))
svint64_t svaddwb_s64(svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_s16)))
svint16_t svaddwb_s16(svint16_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_u32)))
svuint32_t svaddwb_u32(svuint32_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_u64)))
svuint64_t svaddwb_u64(svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwb_u16)))
svuint16_t svaddwb_u16(svuint16_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_s32)))
svint32_t svaddwt_n_s32(svint32_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_s64)))
svint64_t svaddwt_n_s64(svint64_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_s16)))
svint16_t svaddwt_n_s16(svint16_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_u32)))
svuint32_t svaddwt_n_u32(svuint32_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_u64)))
svuint64_t svaddwt_n_u64(svuint64_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_n_u16)))
svuint16_t svaddwt_n_u16(svuint16_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_s32)))
svint32_t svaddwt_s32(svint32_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_s64)))
svint64_t svaddwt_s64(svint64_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_s16)))
svint16_t svaddwt_s16(svint16_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_u32)))
svuint32_t svaddwt_u32(svuint32_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_u64)))
svuint64_t svaddwt_u64(svuint64_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svaddwt_u16)))
svuint16_t svaddwt_u16(svuint16_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_u8)))
svuint8_t svbcax_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_u32)))
svuint32_t svbcax_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_u64)))
svuint64_t svbcax_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_u16)))
svuint16_t svbcax_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_s8)))
svint8_t svbcax_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_s32)))
svint32_t svbcax_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_s64)))
svint64_t svbcax_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_n_s16)))
svint16_t svbcax_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_u8)))
svuint8_t svbcax_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_u32)))
svuint32_t svbcax_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_u64)))
svuint64_t svbcax_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_u16)))
svuint16_t svbcax_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_s8)))
svint8_t svbcax_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_s32)))
svint32_t svbcax_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_s64)))
svint64_t svbcax_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbcax_s16)))
svint16_t svbcax_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_u8)))
svuint8_t svbsl1n_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_u32)))
svuint32_t svbsl1n_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_u64)))
svuint64_t svbsl1n_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_u16)))
svuint16_t svbsl1n_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_s8)))
svint8_t svbsl1n_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_s32)))
svint32_t svbsl1n_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_s64)))
svint64_t svbsl1n_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_n_s16)))
svint16_t svbsl1n_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_u8)))
svuint8_t svbsl1n_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_u32)))
svuint32_t svbsl1n_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_u64)))
svuint64_t svbsl1n_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_u16)))
svuint16_t svbsl1n_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_s8)))
svint8_t svbsl1n_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_s32)))
svint32_t svbsl1n_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_s64)))
svint64_t svbsl1n_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl1n_s16)))
svint16_t svbsl1n_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_u8)))
svuint8_t svbsl2n_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_u32)))
svuint32_t svbsl2n_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_u64)))
svuint64_t svbsl2n_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_u16)))
svuint16_t svbsl2n_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_s8)))
svint8_t svbsl2n_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_s32)))
svint32_t svbsl2n_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_s64)))
svint64_t svbsl2n_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_n_s16)))
svint16_t svbsl2n_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_u8)))
svuint8_t svbsl2n_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_u32)))
svuint32_t svbsl2n_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_u64)))
svuint64_t svbsl2n_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_u16)))
svuint16_t svbsl2n_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_s8)))
svint8_t svbsl2n_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_s32)))
svint32_t svbsl2n_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_s64)))
svint64_t svbsl2n_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl2n_s16)))
svint16_t svbsl2n_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_u8)))
svuint8_t svbsl_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_u32)))
svuint32_t svbsl_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_u64)))
svuint64_t svbsl_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_u16)))
svuint16_t svbsl_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_s8)))
svint8_t svbsl_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_s32)))
svint32_t svbsl_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_s64)))
svint64_t svbsl_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_n_s16)))
svint16_t svbsl_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_u8)))
svuint8_t svbsl_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_u32)))
svuint32_t svbsl_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_u64)))
svuint64_t svbsl_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_u16)))
svuint16_t svbsl_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_s8)))
svint8_t svbsl_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_s32)))
svint32_t svbsl_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_s64)))
svint64_t svbsl_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svbsl_s16)))
svint16_t svbsl_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_u8)))
svuint8_t svcadd_u8(svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_u32)))
svuint32_t svcadd_u32(svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_u64)))
svuint64_t svcadd_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_u16)))
svuint16_t svcadd_u16(svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_s8)))
svint8_t svcadd_s8(svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_s32)))
svint32_t svcadd_s32(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_s64)))
svint64_t svcadd_s64(svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcadd_s16)))
svint16_t svcadd_s16(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcdot_s32)))
svint32_t svcdot_s32(svint32_t, svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcdot_s64)))
svint64_t svcdot_s64(svint64_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcdot_lane_s32)))
svint32_t svcdot_lane_s32(svint32_t, svint8_t, svint8_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcdot_lane_s64)))
svint64_t svcdot_lane_s64(svint64_t, svint16_t, svint16_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_u8)))
svuint8_t svcmla_u8(svuint8_t, svuint8_t, svuint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_u32)))
svuint32_t svcmla_u32(svuint32_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_u64)))
svuint64_t svcmla_u64(svuint64_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_u16)))
svuint16_t svcmla_u16(svuint16_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_s8)))
svint8_t svcmla_s8(svint8_t, svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_s32)))
svint32_t svcmla_s32(svint32_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_s64)))
svint64_t svcmla_s64(svint64_t, svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_s16)))
svint16_t svcmla_s16(svint16_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_u32)))
svuint32_t svcmla_lane_u32(svuint32_t, svuint32_t, svuint32_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_u16)))
svuint16_t svcmla_lane_u16(svuint16_t, svuint16_t, svuint16_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_s32)))
svint32_t svcmla_lane_s32(svint32_t, svint32_t, svint32_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcmla_lane_s16)))
svint16_t svcmla_lane_s16(svint16_t, svint16_t, svint16_t, uint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt_f32_f16_m)))
svfloat32_t svcvtlt_f32_f16_m(svfloat32_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt_f32_f16_x)))
svfloat32_t svcvtlt_f32_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt_f64_f32_m)))
svfloat64_t svcvtlt_f64_f32_m(svfloat64_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtlt_f64_f32_x)))
svfloat64_t svcvtlt_f64_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_f16_f32_m)))
svfloat16_t svcvtnt_f16_f32_m(svfloat16_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtnt_f32_f64_m)))
svfloat32_t svcvtnt_f32_f64_m(svfloat32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtx_f32_f64_m)))
svfloat32_t svcvtx_f32_f64_m(svfloat32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtx_f32_f64_x)))
svfloat32_t svcvtx_f32_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtx_f32_f64_z)))
svfloat32_t svcvtx_f32_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svcvtxnt_f32_f64_m)))
svfloat32_t svcvtxnt_f32_f64_m(svfloat32_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_u8)))
svuint8_t sveor3_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_u32)))
svuint32_t sveor3_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_u64)))
svuint64_t sveor3_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_u16)))
svuint16_t sveor3_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_s8)))
svint8_t sveor3_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_s32)))
svint32_t sveor3_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_s64)))
svint64_t sveor3_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_n_s16)))
svint16_t sveor3_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_u8)))
svuint8_t sveor3_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_u32)))
svuint32_t sveor3_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_u64)))
svuint64_t sveor3_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_u16)))
svuint16_t sveor3_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_s8)))
svint8_t sveor3_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_s32)))
svint32_t sveor3_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_s64)))
svint64_t sveor3_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveor3_s16)))
svint16_t sveor3_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_u8)))
svuint8_t sveorbt_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_u32)))
svuint32_t sveorbt_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_u64)))
svuint64_t sveorbt_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_u16)))
svuint16_t sveorbt_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_s8)))
svint8_t sveorbt_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_s32)))
svint32_t sveorbt_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_s64)))
svint64_t sveorbt_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_n_s16)))
svint16_t sveorbt_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_u8)))
svuint8_t sveorbt_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_u32)))
svuint32_t sveorbt_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_u64)))
svuint64_t sveorbt_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_u16)))
svuint16_t sveorbt_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_s8)))
svint8_t sveorbt_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_s32)))
svint32_t sveorbt_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_s64)))
svint64_t sveorbt_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveorbt_s16)))
svint16_t sveorbt_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_u8)))
svuint8_t sveortb_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_u32)))
svuint32_t sveortb_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_u64)))
svuint64_t sveortb_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_u16)))
svuint16_t sveortb_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_s8)))
svint8_t sveortb_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_s32)))
svint32_t sveortb_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_s64)))
svint64_t sveortb_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_n_s16)))
svint16_t sveortb_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_u8)))
svuint8_t sveortb_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_u32)))
svuint32_t sveortb_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_u64)))
svuint64_t sveortb_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_u16)))
svuint16_t sveortb_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_s8)))
svint8_t sveortb_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_s32)))
svint32_t sveortb_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_s64)))
svint64_t sveortb_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_sveortb_s16)))
svint16_t sveortb_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s8_m)))
svint8_t svhadd_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s32_m)))
svint32_t svhadd_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s64_m)))
svint64_t svhadd_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s16_m)))
svint16_t svhadd_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s8_x)))
svint8_t svhadd_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s32_x)))
svint32_t svhadd_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s64_x)))
svint64_t svhadd_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s16_x)))
svint16_t svhadd_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s8_z)))
svint8_t svhadd_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s32_z)))
svint32_t svhadd_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s64_z)))
svint64_t svhadd_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_s16_z)))
svint16_t svhadd_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u8_m)))
svuint8_t svhadd_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u32_m)))
svuint32_t svhadd_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u64_m)))
svuint64_t svhadd_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u16_m)))
svuint16_t svhadd_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u8_x)))
svuint8_t svhadd_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u32_x)))
svuint32_t svhadd_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u64_x)))
svuint64_t svhadd_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u16_x)))
svuint16_t svhadd_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u8_z)))
svuint8_t svhadd_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u32_z)))
svuint32_t svhadd_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u64_z)))
svuint64_t svhadd_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_n_u16_z)))
svuint16_t svhadd_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s8_m)))
svint8_t svhadd_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s32_m)))
svint32_t svhadd_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s64_m)))
svint64_t svhadd_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s16_m)))
svint16_t svhadd_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s8_x)))
svint8_t svhadd_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s32_x)))
svint32_t svhadd_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s64_x)))
svint64_t svhadd_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s16_x)))
svint16_t svhadd_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s8_z)))
svint8_t svhadd_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s32_z)))
svint32_t svhadd_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s64_z)))
svint64_t svhadd_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_s16_z)))
svint16_t svhadd_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u8_m)))
svuint8_t svhadd_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u32_m)))
svuint32_t svhadd_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u64_m)))
svuint64_t svhadd_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u16_m)))
svuint16_t svhadd_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u8_x)))
svuint8_t svhadd_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u32_x)))
svuint32_t svhadd_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u64_x)))
svuint64_t svhadd_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u16_x)))
svuint16_t svhadd_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u8_z)))
svuint8_t svhadd_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u32_z)))
svuint32_t svhadd_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u64_z)))
svuint64_t svhadd_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhadd_u16_z)))
svuint16_t svhadd_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s8_m)))
svint8_t svhsub_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s32_m)))
svint32_t svhsub_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s64_m)))
svint64_t svhsub_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s16_m)))
svint16_t svhsub_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s8_x)))
svint8_t svhsub_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s32_x)))
svint32_t svhsub_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s64_x)))
svint64_t svhsub_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s16_x)))
svint16_t svhsub_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s8_z)))
svint8_t svhsub_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s32_z)))
svint32_t svhsub_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s64_z)))
svint64_t svhsub_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_s16_z)))
svint16_t svhsub_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u8_m)))
svuint8_t svhsub_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u32_m)))
svuint32_t svhsub_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u64_m)))
svuint64_t svhsub_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u16_m)))
svuint16_t svhsub_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u8_x)))
svuint8_t svhsub_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u32_x)))
svuint32_t svhsub_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u64_x)))
svuint64_t svhsub_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u16_x)))
svuint16_t svhsub_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u8_z)))
svuint8_t svhsub_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u32_z)))
svuint32_t svhsub_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u64_z)))
svuint64_t svhsub_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_n_u16_z)))
svuint16_t svhsub_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s8_m)))
svint8_t svhsub_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s32_m)))
svint32_t svhsub_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s64_m)))
svint64_t svhsub_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s16_m)))
svint16_t svhsub_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s8_x)))
svint8_t svhsub_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s32_x)))
svint32_t svhsub_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s64_x)))
svint64_t svhsub_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s16_x)))
svint16_t svhsub_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s8_z)))
svint8_t svhsub_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s32_z)))
svint32_t svhsub_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s64_z)))
svint64_t svhsub_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_s16_z)))
svint16_t svhsub_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u8_m)))
svuint8_t svhsub_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u32_m)))
svuint32_t svhsub_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u64_m)))
svuint64_t svhsub_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u16_m)))
svuint16_t svhsub_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u8_x)))
svuint8_t svhsub_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u32_x)))
svuint32_t svhsub_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u64_x)))
svuint64_t svhsub_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u16_x)))
svuint16_t svhsub_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u8_z)))
svuint8_t svhsub_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u32_z)))
svuint32_t svhsub_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u64_z)))
svuint64_t svhsub_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsub_u16_z)))
svuint16_t svhsub_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s8_m)))
svint8_t svhsubr_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s32_m)))
svint32_t svhsubr_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s64_m)))
svint64_t svhsubr_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s16_m)))
svint16_t svhsubr_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s8_x)))
svint8_t svhsubr_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s32_x)))
svint32_t svhsubr_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s64_x)))
svint64_t svhsubr_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s16_x)))
svint16_t svhsubr_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s8_z)))
svint8_t svhsubr_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s32_z)))
svint32_t svhsubr_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s64_z)))
svint64_t svhsubr_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_s16_z)))
svint16_t svhsubr_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u8_m)))
svuint8_t svhsubr_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u32_m)))
svuint32_t svhsubr_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u64_m)))
svuint64_t svhsubr_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u16_m)))
svuint16_t svhsubr_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u8_x)))
svuint8_t svhsubr_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u32_x)))
svuint32_t svhsubr_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u64_x)))
svuint64_t svhsubr_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u16_x)))
svuint16_t svhsubr_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u8_z)))
svuint8_t svhsubr_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u32_z)))
svuint32_t svhsubr_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u64_z)))
svuint64_t svhsubr_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_n_u16_z)))
svuint16_t svhsubr_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s8_m)))
svint8_t svhsubr_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s32_m)))
svint32_t svhsubr_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s64_m)))
svint64_t svhsubr_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s16_m)))
svint16_t svhsubr_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s8_x)))
svint8_t svhsubr_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s32_x)))
svint32_t svhsubr_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s64_x)))
svint64_t svhsubr_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s16_x)))
svint16_t svhsubr_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s8_z)))
svint8_t svhsubr_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s32_z)))
svint32_t svhsubr_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s64_z)))
svint64_t svhsubr_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_s16_z)))
svint16_t svhsubr_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u8_m)))
svuint8_t svhsubr_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u32_m)))
svuint32_t svhsubr_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u64_m)))
svuint64_t svhsubr_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u16_m)))
svuint16_t svhsubr_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u8_x)))
svuint8_t svhsubr_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u32_x)))
svuint32_t svhsubr_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u64_x)))
svuint64_t svhsubr_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u16_x)))
svuint16_t svhsubr_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u8_z)))
svuint8_t svhsubr_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u32_z)))
svuint32_t svhsubr_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u64_z)))
svuint64_t svhsubr_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svhsubr_u16_z)))
svuint16_t svhsubr_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f64_m)))
svint64_t svlogb_f64_m(svint64_t, svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f32_m)))
svint32_t svlogb_f32_m(svint32_t, svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f16_m)))
svint16_t svlogb_f16_m(svint16_t, svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f64_x)))
svint64_t svlogb_f64_x(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f32_x)))
svint32_t svlogb_f32_x(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f16_x)))
svint16_t svlogb_f16_x(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f64_z)))
svint64_t svlogb_f64_z(svbool_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f32_z)))
svint32_t svlogb_f32_z(svbool_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svlogb_f16_z)))
svint16_t svlogb_f16_z(svbool_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f64_m)))
svfloat64_t svmaxnmp_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f32_m)))
svfloat32_t svmaxnmp_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f16_m)))
svfloat16_t svmaxnmp_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f64_x)))
svfloat64_t svmaxnmp_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f32_x)))
svfloat32_t svmaxnmp_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxnmp_f16_x)))
svfloat16_t svmaxnmp_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f64_m)))
svfloat64_t svmaxp_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f32_m)))
svfloat32_t svmaxp_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f16_m)))
svfloat16_t svmaxp_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f64_x)))
svfloat64_t svmaxp_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f32_x)))
svfloat32_t svmaxp_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_f16_x)))
svfloat16_t svmaxp_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s8_m)))
svint8_t svmaxp_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s32_m)))
svint32_t svmaxp_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s64_m)))
svint64_t svmaxp_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s16_m)))
svint16_t svmaxp_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s8_x)))
svint8_t svmaxp_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s32_x)))
svint32_t svmaxp_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s64_x)))
svint64_t svmaxp_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_s16_x)))
svint16_t svmaxp_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u8_m)))
svuint8_t svmaxp_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u32_m)))
svuint32_t svmaxp_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u64_m)))
svuint64_t svmaxp_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u16_m)))
svuint16_t svmaxp_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u8_x)))
svuint8_t svmaxp_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u32_x)))
svuint32_t svmaxp_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u64_x)))
svuint64_t svmaxp_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmaxp_u16_x)))
svuint16_t svmaxp_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f64_m)))
svfloat64_t svminnmp_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f32_m)))
svfloat32_t svminnmp_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f16_m)))
svfloat16_t svminnmp_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f64_x)))
svfloat64_t svminnmp_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f32_x)))
svfloat32_t svminnmp_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminnmp_f16_x)))
svfloat16_t svminnmp_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f64_m)))
svfloat64_t svminp_f64_m(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f32_m)))
svfloat32_t svminp_f32_m(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f16_m)))
svfloat16_t svminp_f16_m(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f64_x)))
svfloat64_t svminp_f64_x(svbool_t, svfloat64_t, svfloat64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f32_x)))
svfloat32_t svminp_f32_x(svbool_t, svfloat32_t, svfloat32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_f16_x)))
svfloat16_t svminp_f16_x(svbool_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s8_m)))
svint8_t svminp_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s32_m)))
svint32_t svminp_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s64_m)))
svint64_t svminp_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s16_m)))
svint16_t svminp_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s8_x)))
svint8_t svminp_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s32_x)))
svint32_t svminp_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s64_x)))
svint64_t svminp_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_s16_x)))
svint16_t svminp_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u8_m)))
svuint8_t svminp_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u32_m)))
svuint32_t svminp_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u64_m)))
svuint64_t svminp_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u16_m)))
svuint16_t svminp_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u8_x)))
svuint8_t svminp_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u32_x)))
svuint32_t svminp_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u64_x)))
svuint64_t svminp_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svminp_u16_x)))
svuint16_t svminp_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_u32)))
svuint32_t svmla_lane_u32(svuint32_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_u64)))
svuint64_t svmla_lane_u64(svuint64_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_u16)))
svuint16_t svmla_lane_u16(svuint16_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_s32)))
svint32_t svmla_lane_s32(svint32_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_s64)))
svint64_t svmla_lane_s64(svint64_t, svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmla_lane_s16)))
svint16_t svmla_lane_s16(svint16_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_f32)))
svfloat32_t svmlalb_n_f32(svfloat32_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_s32)))
svint32_t svmlalb_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_s64)))
svint64_t svmlalb_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_s16)))
svint16_t svmlalb_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_u32)))
svuint32_t svmlalb_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_u64)))
svuint64_t svmlalb_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_n_u16)))
svuint16_t svmlalb_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_f32)))
svfloat32_t svmlalb_f32(svfloat32_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_s32)))
svint32_t svmlalb_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_s64)))
svint64_t svmlalb_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_s16)))
svint16_t svmlalb_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_u32)))
svuint32_t svmlalb_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_u64)))
svuint64_t svmlalb_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_u16)))
svuint16_t svmlalb_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_f32)))
svfloat32_t svmlalb_lane_f32(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_s32)))
svint32_t svmlalb_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_s64)))
svint64_t svmlalb_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_u32)))
svuint32_t svmlalb_lane_u32(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalb_lane_u64)))
svuint64_t svmlalb_lane_u64(svuint64_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_f32)))
svfloat32_t svmlalt_n_f32(svfloat32_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_s32)))
svint32_t svmlalt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_s64)))
svint64_t svmlalt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_s16)))
svint16_t svmlalt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_u32)))
svuint32_t svmlalt_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_u64)))
svuint64_t svmlalt_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_n_u16)))
svuint16_t svmlalt_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_f32)))
svfloat32_t svmlalt_f32(svfloat32_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_s32)))
svint32_t svmlalt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_s64)))
svint64_t svmlalt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_s16)))
svint16_t svmlalt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_u32)))
svuint32_t svmlalt_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_u64)))
svuint64_t svmlalt_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_u16)))
svuint16_t svmlalt_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_f32)))
svfloat32_t svmlalt_lane_f32(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_s32)))
svint32_t svmlalt_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_s64)))
svint64_t svmlalt_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_u32)))
svuint32_t svmlalt_lane_u32(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlalt_lane_u64)))
svuint64_t svmlalt_lane_u64(svuint64_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_u32)))
svuint32_t svmls_lane_u32(svuint32_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_u64)))
svuint64_t svmls_lane_u64(svuint64_t, svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_u16)))
svuint16_t svmls_lane_u16(svuint16_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_s32)))
svint32_t svmls_lane_s32(svint32_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_s64)))
svint64_t svmls_lane_s64(svint64_t, svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmls_lane_s16)))
svint16_t svmls_lane_s16(svint16_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_f32)))
svfloat32_t svmlslb_n_f32(svfloat32_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_s32)))
svint32_t svmlslb_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_s64)))
svint64_t svmlslb_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_s16)))
svint16_t svmlslb_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_u32)))
svuint32_t svmlslb_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_u64)))
svuint64_t svmlslb_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_n_u16)))
svuint16_t svmlslb_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_f32)))
svfloat32_t svmlslb_f32(svfloat32_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_s32)))
svint32_t svmlslb_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_s64)))
svint64_t svmlslb_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_s16)))
svint16_t svmlslb_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_u32)))
svuint32_t svmlslb_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_u64)))
svuint64_t svmlslb_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_u16)))
svuint16_t svmlslb_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_lane_f32)))
svfloat32_t svmlslb_lane_f32(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_lane_s32)))
svint32_t svmlslb_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_lane_s64)))
svint64_t svmlslb_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_lane_u32)))
svuint32_t svmlslb_lane_u32(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslb_lane_u64)))
svuint64_t svmlslb_lane_u64(svuint64_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_f32)))
svfloat32_t svmlslt_n_f32(svfloat32_t, svfloat16_t, float16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_s32)))
svint32_t svmlslt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_s64)))
svint64_t svmlslt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_s16)))
svint16_t svmlslt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_u32)))
svuint32_t svmlslt_n_u32(svuint32_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_u64)))
svuint64_t svmlslt_n_u64(svuint64_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_n_u16)))
svuint16_t svmlslt_n_u16(svuint16_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_f32)))
svfloat32_t svmlslt_f32(svfloat32_t, svfloat16_t, svfloat16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_s32)))
svint32_t svmlslt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_s64)))
svint64_t svmlslt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_s16)))
svint16_t svmlslt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_u32)))
svuint32_t svmlslt_u32(svuint32_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_u64)))
svuint64_t svmlslt_u64(svuint64_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_u16)))
svuint16_t svmlslt_u16(svuint16_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_lane_f32)))
svfloat32_t svmlslt_lane_f32(svfloat32_t, svfloat16_t, svfloat16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_lane_s32)))
svint32_t svmlslt_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_lane_s64)))
svint64_t svmlslt_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_lane_u32)))
svuint32_t svmlslt_lane_u32(svuint32_t, svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmlslt_lane_u64)))
svuint64_t svmlslt_lane_u64(svuint64_t, svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_s32)))
svint32_t svmovlb_s32(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_s64)))
svint64_t svmovlb_s64(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_s16)))
svint16_t svmovlb_s16(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_u32)))
svuint32_t svmovlb_u32(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_u64)))
svuint64_t svmovlb_u64(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlb_u16)))
svuint16_t svmovlb_u16(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_s32)))
svint32_t svmovlt_s32(svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_s64)))
svint64_t svmovlt_s64(svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_s16)))
svint16_t svmovlt_s16(svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_u32)))
svuint32_t svmovlt_u32(svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_u64)))
svuint64_t svmovlt_u64(svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmovlt_u16)))
svuint16_t svmovlt_u16(svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_u32)))
svuint32_t svmul_lane_u32(svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_u64)))
svuint64_t svmul_lane_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_u16)))
svuint16_t svmul_lane_u16(svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_s32)))
svint32_t svmul_lane_s32(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_s64)))
svint64_t svmul_lane_s64(svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmul_lane_s16)))
svint16_t svmul_lane_s16(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_s32)))
svint32_t svmullb_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_s64)))
svint64_t svmullb_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_s16)))
svint16_t svmullb_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_u32)))
svuint32_t svmullb_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_u64)))
svuint64_t svmullb_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_n_u16)))
svuint16_t svmullb_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_s32)))
svint32_t svmullb_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_s64)))
svint64_t svmullb_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_s16)))
svint16_t svmullb_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_u32)))
svuint32_t svmullb_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_u64)))
svuint64_t svmullb_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_u16)))
svuint16_t svmullb_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_lane_s32)))
svint32_t svmullb_lane_s32(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_lane_s64)))
svint64_t svmullb_lane_s64(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_lane_u32)))
svuint32_t svmullb_lane_u32(svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullb_lane_u64)))
svuint64_t svmullb_lane_u64(svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_s32)))
svint32_t svmullt_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_s64)))
svint64_t svmullt_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_s16)))
svint16_t svmullt_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_u32)))
svuint32_t svmullt_n_u32(svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_u64)))
svuint64_t svmullt_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_n_u16)))
svuint16_t svmullt_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_s32)))
svint32_t svmullt_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_s64)))
svint64_t svmullt_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_s16)))
svint16_t svmullt_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_u32)))
svuint32_t svmullt_u32(svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_u64)))
svuint64_t svmullt_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_u16)))
svuint16_t svmullt_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_lane_s32)))
svint32_t svmullt_lane_s32(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_lane_s64)))
svint64_t svmullt_lane_s64(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_lane_u32)))
svuint32_t svmullt_lane_u32(svuint16_t, svuint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svmullt_lane_u64)))
svuint64_t svmullt_lane_u64(svuint32_t, svuint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_u8)))
svuint8_t svnbsl_n_u8(svuint8_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_u32)))
svuint32_t svnbsl_n_u32(svuint32_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_u64)))
svuint64_t svnbsl_n_u64(svuint64_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_u16)))
svuint16_t svnbsl_n_u16(svuint16_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_s8)))
svint8_t svnbsl_n_s8(svint8_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_s32)))
svint32_t svnbsl_n_s32(svint32_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_s64)))
svint64_t svnbsl_n_s64(svint64_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_n_s16)))
svint16_t svnbsl_n_s16(svint16_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_u8)))
svuint8_t svnbsl_u8(svuint8_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_u32)))
svuint32_t svnbsl_u32(svuint32_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_u64)))
svuint64_t svnbsl_u64(svuint64_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_u16)))
svuint16_t svnbsl_u16(svuint16_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_s8)))
svint8_t svnbsl_s8(svint8_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_s32)))
svint32_t svnbsl_s32(svint32_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_s64)))
svint64_t svnbsl_s64(svint64_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svnbsl_s16)))
svint16_t svnbsl_s16(svint16_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmul_n_u8)))
svuint8_t svpmul_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmul_u8)))
svuint8_t svpmul_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_n_u64)))
svuint64_t svpmullb_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_n_u16)))
svuint16_t svpmullb_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_u64)))
svuint64_t svpmullb_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_u16)))
svuint16_t svpmullb_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_n_u8)))
svuint8_t svpmullb_pair_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_n_u32)))
svuint32_t svpmullb_pair_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_u8)))
svuint8_t svpmullb_pair_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullb_pair_u32)))
svuint32_t svpmullb_pair_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_n_u64)))
svuint64_t svpmullt_n_u64(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_n_u16)))
svuint16_t svpmullt_n_u16(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_u64)))
svuint64_t svpmullt_u64(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_u16)))
svuint16_t svpmullt_u16(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_n_u8)))
svuint8_t svpmullt_pair_n_u8(svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_n_u32)))
svuint32_t svpmullt_pair_n_u32(svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_u8)))
svuint8_t svpmullt_pair_u8(svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svpmullt_pair_u32)))
svuint32_t svpmullt_pair_u32(svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s8_m)))
svint8_t svqabs_s8_m(svint8_t, svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s32_m)))
svint32_t svqabs_s32_m(svint32_t, svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s64_m)))
svint64_t svqabs_s64_m(svint64_t, svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s16_m)))
svint16_t svqabs_s16_m(svint16_t, svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s8_x)))
svint8_t svqabs_s8_x(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s32_x)))
svint32_t svqabs_s32_x(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s64_x)))
svint64_t svqabs_s64_x(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s16_x)))
svint16_t svqabs_s16_x(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s8_z)))
svint8_t svqabs_s8_z(svbool_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s32_z)))
svint32_t svqabs_s32_z(svbool_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s64_z)))
svint64_t svqabs_s64_z(svbool_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqabs_s16_z)))
svint16_t svqabs_s16_z(svbool_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s8_m)))
svint8_t svqadd_n_s8_m(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s32_m)))
svint32_t svqadd_n_s32_m(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s64_m)))
svint64_t svqadd_n_s64_m(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s16_m)))
svint16_t svqadd_n_s16_m(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s8_x)))
svint8_t svqadd_n_s8_x(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s32_x)))
svint32_t svqadd_n_s32_x(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s64_x)))
svint64_t svqadd_n_s64_x(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s16_x)))
svint16_t svqadd_n_s16_x(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s8_z)))
svint8_t svqadd_n_s8_z(svbool_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s32_z)))
svint32_t svqadd_n_s32_z(svbool_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s64_z)))
svint64_t svqadd_n_s64_z(svbool_t, svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_s16_z)))
svint16_t svqadd_n_s16_z(svbool_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u8_m)))
svuint8_t svqadd_n_u8_m(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u32_m)))
svuint32_t svqadd_n_u32_m(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u64_m)))
svuint64_t svqadd_n_u64_m(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u16_m)))
svuint16_t svqadd_n_u16_m(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u8_x)))
svuint8_t svqadd_n_u8_x(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u32_x)))
svuint32_t svqadd_n_u32_x(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u64_x)))
svuint64_t svqadd_n_u64_x(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u16_x)))
svuint16_t svqadd_n_u16_x(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u8_z)))
svuint8_t svqadd_n_u8_z(svbool_t, svuint8_t, uint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u32_z)))
svuint32_t svqadd_n_u32_z(svbool_t, svuint32_t, uint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u64_z)))
svuint64_t svqadd_n_u64_z(svbool_t, svuint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_n_u16_z)))
svuint16_t svqadd_n_u16_z(svbool_t, svuint16_t, uint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s8_m)))
svint8_t svqadd_s8_m(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s32_m)))
svint32_t svqadd_s32_m(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s64_m)))
svint64_t svqadd_s64_m(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s16_m)))
svint16_t svqadd_s16_m(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s8_x)))
svint8_t svqadd_s8_x(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s32_x)))
svint32_t svqadd_s32_x(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s64_x)))
svint64_t svqadd_s64_x(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s16_x)))
svint16_t svqadd_s16_x(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s8_z)))
svint8_t svqadd_s8_z(svbool_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s32_z)))
svint32_t svqadd_s32_z(svbool_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s64_z)))
svint64_t svqadd_s64_z(svbool_t, svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_s16_z)))
svint16_t svqadd_s16_z(svbool_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u8_m)))
svuint8_t svqadd_u8_m(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u32_m)))
svuint32_t svqadd_u32_m(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u64_m)))
svuint64_t svqadd_u64_m(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u16_m)))
svuint16_t svqadd_u16_m(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u8_x)))
svuint8_t svqadd_u8_x(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u32_x)))
svuint32_t svqadd_u32_x(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u64_x)))
svuint64_t svqadd_u64_x(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u16_x)))
svuint16_t svqadd_u16_x(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u8_z)))
svuint8_t svqadd_u8_z(svbool_t, svuint8_t, svuint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u32_z)))
svuint32_t svqadd_u32_z(svbool_t, svuint32_t, svuint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u64_z)))
svuint64_t svqadd_u64_z(svbool_t, svuint64_t, svuint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqadd_u16_z)))
svuint16_t svqadd_u16_z(svbool_t, svuint16_t, svuint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcadd_s8)))
svint8_t svqcadd_s8(svint8_t, svint8_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcadd_s32)))
svint32_t svqcadd_s32(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcadd_s64)))
svint64_t svqcadd_s64(svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqcadd_s16)))
svint16_t svqcadd_s16(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_n_s32)))
svint32_t svqdmlalb_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_n_s64)))
svint64_t svqdmlalb_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_n_s16)))
svint16_t svqdmlalb_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_s32)))
svint32_t svqdmlalb_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_s64)))
svint64_t svqdmlalb_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_s16)))
svint16_t svqdmlalb_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_lane_s32)))
svint32_t svqdmlalb_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalb_lane_s64)))
svint64_t svqdmlalb_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_n_s32)))
svint32_t svqdmlalbt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_n_s64)))
svint64_t svqdmlalbt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_n_s16)))
svint16_t svqdmlalbt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_s32)))
svint32_t svqdmlalbt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_s64)))
svint64_t svqdmlalbt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalbt_s16)))
svint16_t svqdmlalbt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_n_s32)))
svint32_t svqdmlalt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_n_s64)))
svint64_t svqdmlalt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_n_s16)))
svint16_t svqdmlalt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_s32)))
svint32_t svqdmlalt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_s64)))
svint64_t svqdmlalt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_s16)))
svint16_t svqdmlalt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_lane_s32)))
svint32_t svqdmlalt_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlalt_lane_s64)))
svint64_t svqdmlalt_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_n_s32)))
svint32_t svqdmlslb_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_n_s64)))
svint64_t svqdmlslb_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_n_s16)))
svint16_t svqdmlslb_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_s32)))
svint32_t svqdmlslb_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_s64)))
svint64_t svqdmlslb_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_s16)))
svint16_t svqdmlslb_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_lane_s32)))
svint32_t svqdmlslb_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslb_lane_s64)))
svint64_t svqdmlslb_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_n_s32)))
svint32_t svqdmlslbt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_n_s64)))
svint64_t svqdmlslbt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_n_s16)))
svint16_t svqdmlslbt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_s32)))
svint32_t svqdmlslbt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_s64)))
svint64_t svqdmlslbt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslbt_s16)))
svint16_t svqdmlslbt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_n_s32)))
svint32_t svqdmlslt_n_s32(svint32_t, svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_n_s64)))
svint64_t svqdmlslt_n_s64(svint64_t, svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_n_s16)))
svint16_t svqdmlslt_n_s16(svint16_t, svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_s32)))
svint32_t svqdmlslt_s32(svint32_t, svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_s64)))
svint64_t svqdmlslt_s64(svint64_t, svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_s16)))
svint16_t svqdmlslt_s16(svint16_t, svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_lane_s32)))
svint32_t svqdmlslt_lane_s32(svint32_t, svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmlslt_lane_s64)))
svint64_t svqdmlslt_lane_s64(svint64_t, svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_n_s8)))
svint8_t svqdmulh_n_s8(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_n_s32)))
svint32_t svqdmulh_n_s32(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_n_s64)))
svint64_t svqdmulh_n_s64(svint64_t, int64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_n_s16)))
svint16_t svqdmulh_n_s16(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s8)))
svint8_t svqdmulh_s8(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s32)))
svint32_t svqdmulh_s32(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s64)))
svint64_t svqdmulh_s64(svint64_t, svint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_s16)))
svint16_t svqdmulh_s16(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_lane_s32)))
svint32_t svqdmulh_lane_s32(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_lane_s64)))
svint64_t svqdmulh_lane_s64(svint64_t, svint64_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmulh_lane_s16)))
svint16_t svqdmulh_lane_s16(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_n_s32)))
svint32_t svqdmullb_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_n_s64)))
svint64_t svqdmullb_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_n_s16)))
svint16_t svqdmullb_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_s32)))
svint32_t svqdmullb_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_s64)))
svint64_t svqdmullb_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_s16)))
svint16_t svqdmullb_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_lane_s32)))
svint32_t svqdmullb_lane_s32(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullb_lane_s64)))
svint64_t svqdmullb_lane_s64(svint32_t, svint32_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_n_s32)))
svint32_t svqdmullt_n_s32(svint16_t, int16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_n_s64)))
svint64_t svqdmullt_n_s64(svint32_t, int32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_n_s16)))
svint16_t svqdmullt_n_s16(svint8_t, int8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_s32)))
svint32_t svqdmullt_s32(svint16_t, svint16_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_s64)))
svint64_t svqdmullt_s64(svint32_t, svint32_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_s16)))
svint16_t svqdmullt_s16(svint8_t, svint8_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_lane_s32)))
svint32_t svqdmullt_lane_s32(svint16_t, svint16_t, uint64_t);
__ai __attribute__((__clang_arm_builtin_alias(__builtin_sve_svqdmullt_lane_s64)